/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;

public interface ConcurrentMap<K, V>
extends Map<K, V> {
    @Override
    default public V getOrDefault(Object key, V defaultValue) {
        Object v = this.get(key);
        return v != null ? v : defaultValue;
    }

    @Override
    default public void forEach(BiConsumer<? super K, ? super V> action) {
        Objects.requireNonNull(action);
        for (Map.Entry entry : this.entrySet()) {
            Object v;
            Object k;
            try {
                k = entry.getKey();
                v = entry.getValue();
            }
            catch (IllegalStateException ise) {
                continue;
            }
            action.accept(k, v);
        }
    }

    @Override
    public V putIfAbsent(K var1, V var2);

    @Override
    public boolean remove(Object var1, Object var2);

    @Override
    public boolean replace(K var1, V var2, V var3);

    @Override
    public V replace(K var1, V var2);

    @Override
    default public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        Objects.requireNonNull(function);
        this.forEach((k, v) -> {
            while (!this.replace(k, v, function.apply((K)k, (V)v)) && (v = this.get(k)) != null) {
            }
        });
    }

    @Override
    default public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        V newValue;
        Objects.requireNonNull(mappingFunction);
        Object oldValue = this.get(key);
        return oldValue == null && (newValue = mappingFunction.apply(key)) != null && (oldValue = this.putIfAbsent(key, newValue)) == null ? newValue : oldValue;
    }

    @Override
    default public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        Object oldValue;
        Objects.requireNonNull(remappingFunction);
        while ((oldValue = this.get(key)) != null) {
            V newValue = remappingFunction.apply(key, oldValue);
            if (!(newValue == null ? this.remove(key, oldValue) : this.replace(key, oldValue, newValue))) continue;
            return newValue;
        }
        return null;
    }

    @Override
    default public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        block0: while (true) {
            V newValue;
            Object oldValue = this.get(key);
            while ((newValue = remappingFunction.apply(key, oldValue)) != null) {
                if (oldValue != null) {
                    if (!this.replace(key, oldValue, newValue)) continue block0;
                    return newValue;
                }
                oldValue = this.putIfAbsent(key, newValue);
                if (oldValue != null) continue;
                return newValue;
            }
            if (oldValue == null || this.remove(key, oldValue)) break;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    default public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        Objects.requireNonNull(remappingFunction);
        Objects.requireNonNull(value);
        block0: while (true) {
            Object oldValue = this.get(key);
            do {
                if (oldValue == null) continue;
                V newValue = remappingFunction.apply(oldValue, value);
                if (newValue != null) {
                    if (!this.replace(key, oldValue, newValue)) continue block0;
                    return newValue;
                }
                if (this.remove(key, oldValue)) return null;
                continue block0;
            } while ((oldValue = this.putIfAbsent(key, value)) != null);
            break;
        }
        return value;
    }
}

