/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractQueue;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Queue;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.concurrent.Helpers;
import java.util.function.Consumer;
import sun.misc.Unsafe;

public class ConcurrentLinkedQueue<E>
extends AbstractQueue<E>
implements Queue<E>,
Serializable {
    private static final long serialVersionUID = 196745693267521676L;
    volatile transient Node<E> head;
    private volatile transient Node<E> tail;
    private static final Unsafe U = Unsafe.getUnsafe();
    private static final long HEAD;
    private static final long TAIL;
    private static final long ITEM;
    private static final long NEXT;

    static <E> Node<E> newNode(E item) {
        Node node = new Node();
        U.putObject(node, ITEM, item);
        return node;
    }

    static <E> boolean casItem(Node<E> node, E cmp, E val) {
        return U.compareAndSwapObject(node, ITEM, cmp, val);
    }

    static <E> void lazySetNext(Node<E> node, Node<E> val) {
        U.putOrderedObject(node, NEXT, val);
    }

    static <E> boolean casNext(Node<E> node, Node<E> cmp, Node<E> val) {
        return U.compareAndSwapObject(node, NEXT, cmp, val);
    }

    public ConcurrentLinkedQueue() {
        this.tail = ConcurrentLinkedQueue.newNode(null);
        this.head = this.tail;
    }

    public ConcurrentLinkedQueue(Collection<? extends E> c) {
        Node<Object> h = null;
        Node<Object> t = null;
        for (E e : c) {
            Node<E> newNode = ConcurrentLinkedQueue.newNode(Objects.requireNonNull(e));
            if (h == null) {
                h = t = newNode;
                continue;
            }
            ConcurrentLinkedQueue.lazySetNext(t, newNode);
            t = newNode;
        }
        if (h == null) {
            h = t = ConcurrentLinkedQueue.newNode(null);
        }
        this.head = h;
        this.tail = t;
    }

    @Override
    public boolean add(E e) {
        return this.offer(e);
    }

    final void updateHead(Node<E> h, Node<E> p) {
        if (h != p && this.casHead(h, p)) {
            ConcurrentLinkedQueue.lazySetNext(h, h);
        }
    }

    final Node<E> succ(Node<E> p) {
        Node next = p.next;
        return p == next ? this.head : next;
    }

    @Override
    public boolean offer(E e) {
        Node<E> t;
        Node<E> newNode = ConcurrentLinkedQueue.newNode(Objects.requireNonNull(e));
        Node<E> p = t = this.tail;
        while (true) {
            Node q;
            if ((q = p.next) == null) {
                if (!ConcurrentLinkedQueue.casNext(p, null, newNode)) continue;
                if (p != t) {
                    this.casTail(t, newNode);
                }
                return true;
            }
            if (p == q) {
                p = t != (t = this.tail) ? t : this.head;
                continue;
            }
            p = p != t && t != (t = this.tail) ? t : q;
        }
    }

    @Override
    public E poll() {
        block0: while (true) {
            Node<E> h;
            Node<E> p = h = this.head;
            while (true) {
                Node q;
                Object item;
                if ((item = p.item) != null && ConcurrentLinkedQueue.casItem(p, item, null)) {
                    if (p != h) {
                        q = p.next;
                        this.updateHead(h, q != null ? q : p);
                    }
                    return item;
                }
                q = p.next;
                if (q == null) {
                    this.updateHead(h, p);
                    return null;
                }
                if (p == q) continue block0;
                p = q;
            }
            break;
        }
    }

    @Override
    public E peek() {
        block0: while (true) {
            Node<E> h;
            Node<E> p = h = this.head;
            while (true) {
                Node q;
                Object item;
                if ((item = p.item) != null || (q = p.next) == null) {
                    this.updateHead(h, p);
                    return item;
                }
                if (p == q) continue block0;
                p = q;
            }
            break;
        }
    }

    Node<E> first() {
        block0: while (true) {
            Node<E> h;
            Node<E> p = h = this.head;
            while (true) {
                Node q;
                boolean hasItem;
                boolean bl = hasItem = p.item != null;
                if (hasItem || (q = p.next) == null) {
                    this.updateHead(h, p);
                    return hasItem ? p : null;
                }
                if (p == q) continue block0;
                p = q;
            }
            break;
        }
    }

    @Override
    public boolean isEmpty() {
        return this.first() == null;
    }

    @Override
    public int size() {
        int count;
        block0: while (true) {
            count = 0;
            Node<E> p = this.first();
            while (p != null && (p.item == null || ++count != Integer.MAX_VALUE)) {
                if (p != (p = p.next)) continue;
                continue block0;
            }
            break;
        }
        return count;
    }

    @Override
    public boolean contains(Object o) {
        if (o != null) {
            Node<E> p = this.first();
            while (p != null) {
                Object item = p.item;
                if (item != null && o.equals(item)) {
                    return true;
                }
                p = this.succ(p);
            }
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean remove(Object o) {
        block5: {
            if (o == null) break block5;
            pred = null;
            p = this.first();
            while (p != null) {
                removed = false;
                item = p.item;
                if (item == null) ** GOTO lbl12
                if (!o.equals(item)) {
                    next = this.succ(p);
                } else {
                    removed = ConcurrentLinkedQueue.casItem(p, item, null);
lbl12:
                    // 2 sources

                    next = this.succ(p);
                    if (pred != null && next != null) {
                        ConcurrentLinkedQueue.casNext(pred, p, next);
                    }
                    if (removed) {
                        return true;
                    }
                }
                pred = p;
                p = next;
            }
        }
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        Node<E> t;
        if (c == this) {
            throw new IllegalArgumentException();
        }
        Node<E> beginningOfTheEnd = null;
        Node<E> last = null;
        for (E e : c) {
            Node<E> newNode = ConcurrentLinkedQueue.newNode(Objects.requireNonNull(e));
            if (beginningOfTheEnd == null) {
                beginningOfTheEnd = last = newNode;
                continue;
            }
            ConcurrentLinkedQueue.lazySetNext(last, newNode);
            last = newNode;
        }
        if (beginningOfTheEnd == null) {
            return false;
        }
        Node<E> p = t = this.tail;
        while (true) {
            Node q;
            if ((q = p.next) == null) {
                if (!ConcurrentLinkedQueue.casNext(p, null, beginningOfTheEnd)) continue;
                if (!this.casTail(t, last)) {
                    t = this.tail;
                    if (last.next == null) {
                        this.casTail(t, last);
                    }
                }
                return true;
            }
            if (p == q) {
                p = t != (t = this.tail) ? t : this.head;
                continue;
            }
            p = p != t && t != (t = this.tail) ? t : q;
        }
    }

    @Override
    public String toString() {
        int size;
        int charLength;
        String[] a = null;
        block0: while (true) {
            charLength = 0;
            size = 0;
            Node<E> p = this.first();
            while (p != null) {
                Object item = p.item;
                if (item != null) {
                    if (a == null) {
                        a = new String[4];
                    } else if (size == a.length) {
                        a = Arrays.copyOf(a, 2 * size);
                    }
                    String s = item.toString();
                    a[size++] = s;
                    charLength += s.length();
                }
                if (p != (p = p.next)) continue;
                continue block0;
            }
            break;
        }
        if (size == 0) {
            return "[]";
        }
        return Helpers.toString(a, size, charLength);
    }

    private Object[] toArrayInternal(Object[] a) {
        int size;
        Object[] x = a;
        block0: while (true) {
            size = 0;
            Node<E> p = this.first();
            while (p != null) {
                Object item = p.item;
                if (item != null) {
                    if (x == null) {
                        x = new Object[4];
                    } else if (size == x.length) {
                        x = Arrays.copyOf(x, 2 * (size + 4));
                    }
                    x[size++] = item;
                }
                if (p != (p = p.next)) continue;
                continue block0;
            }
            break;
        }
        if (x == null) {
            return new Object[0];
        }
        if (a != null && size <= a.length) {
            if (a != x) {
                System.arraycopy(x, 0, a, 0, size);
            }
            if (size < a.length) {
                a[size] = null;
            }
            return a;
        }
        return size == x.length ? x : Arrays.copyOf(x, size);
    }

    @Override
    public Object[] toArray() {
        return this.toArrayInternal(null);
    }

    @Override
    public <T> T[] toArray(T[] a) {
        if (a == null) {
            throw new NullPointerException();
        }
        return this.toArrayInternal(a);
    }

    @Override
    public Iterator<E> iterator() {
        return new Itr();
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        Node<E> p = this.first();
        while (p != null) {
            Object item = p.item;
            if (item != null) {
                s.writeObject(item);
            }
            p = this.succ(p);
        }
        s.writeObject(null);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        Object item;
        s.defaultReadObject();
        Node<Object> h = null;
        Node<Object> t = null;
        while ((item = s.readObject()) != null) {
            Node<Object> newNode = ConcurrentLinkedQueue.newNode(item);
            if (h == null) {
                h = t = newNode;
                continue;
            }
            ConcurrentLinkedQueue.lazySetNext(t, newNode);
            t = newNode;
        }
        if (h == null) {
            h = t = ConcurrentLinkedQueue.newNode(null);
        }
        this.head = h;
        this.tail = t;
    }

    @Override
    public Spliterator<E> spliterator() {
        return new CLQSpliterator(this);
    }

    private boolean casTail(Node<E> cmp, Node<E> val) {
        return U.compareAndSwapObject(this, TAIL, cmp, val);
    }

    private boolean casHead(Node<E> cmp, Node<E> val) {
        return U.compareAndSwapObject(this, HEAD, cmp, val);
    }

    static {
        try {
            HEAD = U.objectFieldOffset(ConcurrentLinkedQueue.class.getDeclaredField("head"));
            TAIL = U.objectFieldOffset(ConcurrentLinkedQueue.class.getDeclaredField("tail"));
            ITEM = U.objectFieldOffset(Node.class.getDeclaredField("item"));
            NEXT = U.objectFieldOffset(Node.class.getDeclaredField("next"));
        }
        catch (ReflectiveOperationException e) {
            throw new Error(e);
        }
    }

    static final class CLQSpliterator<E>
    implements Spliterator<E> {
        static final int MAX_BATCH = 0x2000000;
        final ConcurrentLinkedQueue<E> queue;
        Node<E> current;
        int batch;
        boolean exhausted;

        CLQSpliterator(ConcurrentLinkedQueue<E> queue) {
            this.queue = queue;
        }

        @Override
        public Spliterator<E> trySplit() {
            Node<E> p;
            int n;
            ConcurrentLinkedQueue<E> q = this.queue;
            int b = this.batch;
            int n2 = b <= 0 ? 1 : (n = b >= 0x2000000 ? 0x2000000 : b + 1);
            if (!(this.exhausted || (p = this.current) == null && (p = q.first()) == null || p.next == null)) {
                Object[] a = new Object[n];
                int i = 0;
                do {
                    if ((a[i] = p.item) != null) {
                        ++i;
                    }
                    if (p != (p = p.next)) continue;
                    p = q.first();
                } while (p != null && i < n);
                this.current = p;
                if (this.current == null) {
                    this.exhausted = true;
                }
                if (i > 0) {
                    this.batch = i;
                    return Spliterators.spliterator(a, 0, i, 4368);
                }
            }
            return null;
        }

        @Override
        public void forEachRemaining(Consumer<? super E> action) {
            Node<E> p;
            if (action == null) {
                throw new NullPointerException();
            }
            ConcurrentLinkedQueue<E> q = this.queue;
            if (!(this.exhausted || (p = this.current) == null && (p = q.first()) == null)) {
                this.exhausted = true;
                do {
                    Object e = p.item;
                    if (p == (p = p.next)) {
                        p = q.first();
                    }
                    if (e == null) continue;
                    action.accept(e);
                } while (p != null);
            }
        }

        @Override
        public boolean tryAdvance(Consumer<? super E> action) {
            Node<E> p;
            if (action == null) {
                throw new NullPointerException();
            }
            ConcurrentLinkedQueue<E> q = this.queue;
            if (!(this.exhausted || (p = this.current) == null && (p = q.first()) == null)) {
                Object e;
                do {
                    e = p.item;
                    if (p != (p = p.next)) continue;
                    p = q.first();
                } while (e == null && p != null);
                this.current = p;
                if (this.current == null) {
                    this.exhausted = true;
                }
                if (e != null) {
                    action.accept(e);
                    return true;
                }
            }
            return false;
        }

        @Override
        public long estimateSize() {
            return Long.MAX_VALUE;
        }

        @Override
        public int characteristics() {
            return 4368;
        }
    }

    private class Itr
    implements Iterator<E> {
        private Node<E> nextNode;
        private E nextItem;
        private Node<E> lastRet;

        Itr() {
            Node p;
            Node h;
            block0: while (true) {
                p = h = ConcurrentLinkedQueue.this.head;
                while (true) {
                    Object item;
                    if ((item = p.item) != null) {
                        this.nextNode = p;
                        this.nextItem = item;
                        break block0;
                    }
                    Node q = p.next;
                    if (q == null) break block0;
                    if (p == q) continue block0;
                    p = q;
                }
                break;
            }
            ConcurrentLinkedQueue.this.updateHead(h, p);
        }

        @Override
        public boolean hasNext() {
            return this.nextItem != null;
        }

        @Override
        public E next() {
            Node pred = this.nextNode;
            if (pred == null) {
                throw new NoSuchElementException();
            }
            this.lastRet = pred;
            Object item = null;
            Node p = ConcurrentLinkedQueue.this.succ(pred);
            while (true) {
                block7: {
                    block6: {
                        if (p == null) break block6;
                        Object e = p.item;
                        item = e;
                        if (e == null) break block7;
                    }
                    this.nextNode = p;
                    Object x = this.nextItem;
                    this.nextItem = item;
                    return x;
                }
                Node q = ConcurrentLinkedQueue.this.succ(p);
                if (q != null) {
                    ConcurrentLinkedQueue.casNext(pred, p, q);
                }
                p = q;
            }
        }

        @Override
        public void remove() {
            Node l = this.lastRet;
            if (l == null) {
                throw new IllegalStateException();
            }
            l.item = null;
            this.lastRet = null;
        }
    }

    private static class Node<E> {
        volatile E item;
        volatile Node<E> next;

        private Node() {
        }
    }
}

