/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.Spliterator;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;

public class TreeMap<K, V>
extends AbstractMap<K, V>
implements NavigableMap<K, V>,
Cloneable,
Serializable {
    private final Comparator<? super K> comparator;
    private transient TreeMapEntry<K, V> root;
    private transient int size = 0;
    private transient int modCount = 0;
    private transient EntrySet entrySet;
    private transient KeySet<K> navigableKeySet;
    private transient NavigableMap<K, V> descendingMap;
    private static final Object UNBOUNDED = new Object();
    private static final boolean RED = false;
    private static final boolean BLACK = true;
    private static final long serialVersionUID = 919286545866124006L;

    public TreeMap() {
        this.comparator = null;
    }

    public TreeMap(Comparator<? super K> comparator) {
        this.comparator = comparator;
    }

    public TreeMap(Map<? extends K, ? extends V> m) {
        this.comparator = null;
        this.putAll(m);
    }

    public TreeMap(SortedMap<K, ? extends V> m) {
        this.comparator = m.comparator();
        try {
            this.buildFromSorted(m.size(), m.entrySet().iterator(), null, null);
        }
        catch (IOException iOException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getEntry(key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        TreeMapEntry<K, V> e = this.getFirstEntry();
        while (e != null) {
            if (TreeMap.valEquals(value, e.value)) {
                return true;
            }
            e = TreeMap.successor(e);
        }
        return false;
    }

    @Override
    public V get(Object key) {
        TreeMapEntry<K, V> p = this.getEntry(key);
        return p == null ? null : (V)p.value;
    }

    @Override
    public Comparator<? super K> comparator() {
        return this.comparator;
    }

    @Override
    public K firstKey() {
        return TreeMap.key(this.getFirstEntry());
    }

    @Override
    public K lastKey() {
        return TreeMap.key(this.getLastEntry());
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        Comparator c;
        int mapSize = map.size();
        if (this.size == 0 && mapSize != 0 && map instanceof SortedMap && ((c = ((SortedMap)map).comparator()) == this.comparator || c != null && c.equals(this.comparator))) {
            ++this.modCount;
            try {
                this.buildFromSorted(mapSize, map.entrySet().iterator(), null, null);
            }
            catch (IOException iOException) {
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            return;
        }
        super.putAll(map);
    }

    final TreeMapEntry<K, V> getEntry(Object key) {
        if (this.comparator != null) {
            return this.getEntryUsingComparator(key);
        }
        if (key == null) {
            throw new NullPointerException();
        }
        Comparable k = (Comparable)key;
        TreeMapEntry<K, V> p = this.root;
        while (p != null) {
            int cmp = k.compareTo(p.key);
            if (cmp < 0) {
                p = p.left;
                continue;
            }
            if (cmp > 0) {
                p = p.right;
                continue;
            }
            return p;
        }
        return null;
    }

    final TreeMapEntry<K, V> getEntryUsingComparator(Object key) {
        Object k = key;
        Comparator<K> cpr = this.comparator;
        if (cpr != null) {
            TreeMapEntry<K, V> p = this.root;
            while (p != null) {
                int cmp = cpr.compare(k, p.key);
                if (cmp < 0) {
                    p = p.left;
                    continue;
                }
                if (cmp > 0) {
                    p = p.right;
                    continue;
                }
                return p;
            }
        }
        return null;
    }

    final TreeMapEntry<K, V> getCeilingEntry(K key) {
        TreeMapEntry<K, V> p = this.root;
        while (p != null) {
            int cmp = this.compare(key, p.key);
            if (cmp < 0) {
                if (p.left != null) {
                    p = p.left;
                    continue;
                }
                return p;
            }
            if (cmp > 0) {
                if (p.right != null) {
                    p = p.right;
                    continue;
                }
                TreeMapEntry parent = p.parent;
                TreeMapEntry<K, V> ch = p;
                while (parent != null && ch == parent.right) {
                    ch = parent;
                    parent = parent.parent;
                }
                return parent;
            }
            return p;
        }
        return null;
    }

    final TreeMapEntry<K, V> getFloorEntry(K key) {
        TreeMapEntry<K, V> p = this.root;
        while (p != null) {
            int cmp = this.compare(key, p.key);
            if (cmp > 0) {
                if (p.right != null) {
                    p = p.right;
                    continue;
                }
                return p;
            }
            if (cmp < 0) {
                if (p.left != null) {
                    p = p.left;
                    continue;
                }
                TreeMapEntry parent = p.parent;
                TreeMapEntry<K, V> ch = p;
                while (parent != null && ch == parent.left) {
                    ch = parent;
                    parent = parent.parent;
                }
                return parent;
            }
            return p;
        }
        return null;
    }

    final TreeMapEntry<K, V> getHigherEntry(K key) {
        TreeMapEntry<K, V> p = this.root;
        while (p != null) {
            int cmp = this.compare(key, p.key);
            if (cmp < 0) {
                if (p.left != null) {
                    p = p.left;
                    continue;
                }
                return p;
            }
            if (p.right != null) {
                p = p.right;
                continue;
            }
            TreeMapEntry parent = p.parent;
            TreeMapEntry<K, V> ch = p;
            while (parent != null && ch == parent.right) {
                ch = parent;
                parent = parent.parent;
            }
            return parent;
        }
        return null;
    }

    final TreeMapEntry<K, V> getLowerEntry(K key) {
        TreeMapEntry<K, V> p = this.root;
        while (p != null) {
            int cmp = this.compare(key, p.key);
            if (cmp > 0) {
                if (p.right != null) {
                    p = p.right;
                    continue;
                }
                return p;
            }
            if (p.left != null) {
                p = p.left;
                continue;
            }
            TreeMapEntry parent = p.parent;
            TreeMapEntry<K, V> ch = p;
            while (parent != null && ch == parent.left) {
                ch = parent;
                parent = parent.parent;
            }
            return parent;
        }
        return null;
    }

    @Override
    public V put(K key, V value) {
        int cmp;
        TreeMapEntry<K, V> parent;
        TreeMapEntry<K, V> t = this.root;
        if (t == null) {
            if (this.comparator != null) {
                if (key == null) {
                    this.comparator.compare(key, key);
                }
            } else {
                if (key == null) {
                    throw new NullPointerException("key == null");
                }
                if (!(key instanceof Comparable)) {
                    throw new ClassCastException("Cannot cast" + key.getClass().getName() + " to Comparable.");
                }
            }
            this.root = new TreeMapEntry<K, V>(key, value, null);
            this.size = 1;
            ++this.modCount;
            return null;
        }
        Comparator<K> cpr = this.comparator;
        if (cpr != null) {
            do {
                parent = t;
                cmp = cpr.compare(key, t.key);
                if (cmp < 0) {
                    t = t.left;
                    continue;
                }
                if (cmp > 0) {
                    t = t.right;
                    continue;
                }
                return t.setValue(value);
            } while (t != null);
        } else {
            if (key == null) {
                throw new NullPointerException();
            }
            Comparable k = (Comparable)key;
            do {
                parent = t;
                cmp = k.compareTo(t.key);
                if (cmp < 0) {
                    t = t.left;
                    continue;
                }
                if (cmp > 0) {
                    t = t.right;
                    continue;
                }
                return t.setValue(value);
            } while (t != null);
        }
        TreeMapEntry<K, V> e = new TreeMapEntry<K, V>(key, value, parent);
        if (cmp < 0) {
            parent.left = e;
        } else {
            parent.right = e;
        }
        this.fixAfterInsertion(e);
        ++this.size;
        ++this.modCount;
        return null;
    }

    @Override
    public V remove(Object key) {
        TreeMapEntry<K, V> p = this.getEntry(key);
        if (p == null) {
            return null;
        }
        Object oldValue = p.value;
        this.deleteEntry(p);
        return oldValue;
    }

    @Override
    public void clear() {
        ++this.modCount;
        this.size = 0;
        this.root = null;
    }

    @Override
    public Object clone() {
        TreeMap clone;
        try {
            clone = (TreeMap)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e);
        }
        clone.root = null;
        clone.size = 0;
        clone.modCount = 0;
        clone.entrySet = null;
        clone.navigableKeySet = null;
        clone.descendingMap = null;
        try {
            clone.buildFromSorted(this.size, this.entrySet().iterator(), null, null);
        }
        catch (IOException iOException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return clone;
    }

    @Override
    public Map.Entry<K, V> firstEntry() {
        return TreeMap.exportEntry(this.getFirstEntry());
    }

    @Override
    public Map.Entry<K, V> lastEntry() {
        return TreeMap.exportEntry(this.getLastEntry());
    }

    @Override
    public Map.Entry<K, V> pollFirstEntry() {
        TreeMapEntry<K, V> p = this.getFirstEntry();
        Map.Entry<K, V> result = TreeMap.exportEntry(p);
        if (p != null) {
            this.deleteEntry(p);
        }
        return result;
    }

    @Override
    public Map.Entry<K, V> pollLastEntry() {
        TreeMapEntry<K, V> p = this.getLastEntry();
        Map.Entry<K, V> result = TreeMap.exportEntry(p);
        if (p != null) {
            this.deleteEntry(p);
        }
        return result;
    }

    @Override
    public Map.Entry<K, V> lowerEntry(K key) {
        return TreeMap.exportEntry(this.getLowerEntry(key));
    }

    @Override
    public K lowerKey(K key) {
        return TreeMap.keyOrNull(this.getLowerEntry(key));
    }

    @Override
    public Map.Entry<K, V> floorEntry(K key) {
        return TreeMap.exportEntry(this.getFloorEntry(key));
    }

    @Override
    public K floorKey(K key) {
        return TreeMap.keyOrNull(this.getFloorEntry(key));
    }

    @Override
    public Map.Entry<K, V> ceilingEntry(K key) {
        return TreeMap.exportEntry(this.getCeilingEntry(key));
    }

    @Override
    public K ceilingKey(K key) {
        return TreeMap.keyOrNull(this.getCeilingEntry(key));
    }

    @Override
    public Map.Entry<K, V> higherEntry(K key) {
        return TreeMap.exportEntry(this.getHigherEntry(key));
    }

    @Override
    public K higherKey(K key) {
        return TreeMap.keyOrNull(this.getHigherEntry(key));
    }

    @Override
    public Set<K> keySet() {
        return this.navigableKeySet();
    }

    @Override
    public NavigableSet<K> navigableKeySet() {
        KeySet<K> nks = this.navigableKeySet;
        return nks != null ? nks : (this.navigableKeySet = new KeySet(this));
    }

    @Override
    public NavigableSet<K> descendingKeySet() {
        return this.descendingMap().navigableKeySet();
    }

    @Override
    public Collection<V> values() {
        Collection vs = this.values;
        if (vs == null) {
            this.values = vs = new Values();
        }
        return vs;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        EntrySet es = this.entrySet;
        return es != null ? es : (this.entrySet = new EntrySet());
    }

    @Override
    public NavigableMap<K, V> descendingMap() {
        NavigableMap<K, V> km = this.descendingMap;
        return km != null ? km : (this.descendingMap = new DescendingSubMap(this, true, null, true, true, null, true));
    }

    @Override
    public NavigableMap<K, V> subMap(K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
        return new AscendingSubMap(this, false, fromKey, fromInclusive, false, toKey, toInclusive);
    }

    @Override
    public NavigableMap<K, V> headMap(K toKey, boolean inclusive) {
        return new AscendingSubMap(this, true, null, true, false, toKey, inclusive);
    }

    @Override
    public NavigableMap<K, V> tailMap(K fromKey, boolean inclusive) {
        return new AscendingSubMap(this, false, fromKey, inclusive, true, null, true);
    }

    @Override
    public SortedMap<K, V> subMap(K fromKey, K toKey) {
        return this.subMap(fromKey, true, toKey, false);
    }

    @Override
    public SortedMap<K, V> headMap(K toKey) {
        return this.headMap(toKey, false);
    }

    @Override
    public SortedMap<K, V> tailMap(K fromKey) {
        return this.tailMap(fromKey, true);
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        TreeMapEntry<K, V> p = this.getEntry(key);
        if (p != null && Objects.equals(oldValue, p.value)) {
            p.value = newValue;
            return true;
        }
        return false;
    }

    @Override
    public V replace(K key, V value) {
        TreeMapEntry<K, V> p = this.getEntry(key);
        if (p != null) {
            Object oldValue = p.value;
            p.value = value;
            return oldValue;
        }
        return null;
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> action) {
        Objects.requireNonNull(action);
        int expectedModCount = this.modCount;
        TreeMapEntry<K, V> e = this.getFirstEntry();
        while (e != null) {
            action.accept(e.key, e.value);
            if (expectedModCount != this.modCount) {
                throw new ConcurrentModificationException();
            }
            e = TreeMap.successor(e);
        }
    }

    @Override
    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        Objects.requireNonNull(function);
        int expectedModCount = this.modCount;
        TreeMapEntry<K, V> e = this.getFirstEntry();
        while (e != null) {
            e.value = function.apply(e.key, e.value);
            if (expectedModCount != this.modCount) {
                throw new ConcurrentModificationException();
            }
            e = TreeMap.successor(e);
        }
    }

    Iterator<K> keyIterator() {
        return new KeyIterator(this.getFirstEntry());
    }

    Iterator<K> descendingKeyIterator() {
        return new DescendingKeyIterator(this.getLastEntry());
    }

    final int compare(Object k1, Object k2) {
        return this.comparator == null ? ((Comparable)k1).compareTo(k2) : this.comparator.compare(k1, k2);
    }

    static final boolean valEquals(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    static <K, V> Map.Entry<K, V> exportEntry(TreeMapEntry<K, V> e) {
        return e == null ? null : new AbstractMap.SimpleImmutableEntry<K, V>(e);
    }

    static <K, V> K keyOrNull(TreeMapEntry<K, V> e) {
        return e == null ? null : (K)e.key;
    }

    static <K> K key(TreeMapEntry<K, ?> e) {
        if (e == null) {
            throw new NoSuchElementException();
        }
        return e.key;
    }

    final TreeMapEntry<K, V> getFirstEntry() {
        TreeMapEntry<K, V> p = this.root;
        if (p != null) {
            while (p.left != null) {
                p = p.left;
            }
        }
        return p;
    }

    final TreeMapEntry<K, V> getLastEntry() {
        TreeMapEntry<K, V> p = this.root;
        if (p != null) {
            while (p.right != null) {
                p = p.right;
            }
        }
        return p;
    }

    static <K, V> TreeMapEntry<K, V> successor(TreeMapEntry<K, V> t) {
        if (t == null) {
            return null;
        }
        if (t.right != null) {
            TreeMapEntry p = t.right;
            while (p.left != null) {
                p = p.left;
            }
            return p;
        }
        TreeMapEntry p = t.parent;
        TreeMapEntry<K, V> ch = t;
        while (p != null && ch == p.right) {
            ch = p;
            p = p.parent;
        }
        return p;
    }

    static <K, V> TreeMapEntry<K, V> predecessor(TreeMapEntry<K, V> t) {
        if (t == null) {
            return null;
        }
        if (t.left != null) {
            TreeMapEntry p = t.left;
            while (p.right != null) {
                p = p.right;
            }
            return p;
        }
        TreeMapEntry p = t.parent;
        TreeMapEntry<K, V> ch = t;
        while (p != null && ch == p.left) {
            ch = p;
            p = p.parent;
        }
        return p;
    }

    private static <K, V> boolean colorOf(TreeMapEntry<K, V> p) {
        return p == null ? true : p.color;
    }

    private static <K, V> TreeMapEntry<K, V> parentOf(TreeMapEntry<K, V> p) {
        return p == null ? null : p.parent;
    }

    private static <K, V> void setColor(TreeMapEntry<K, V> p, boolean c) {
        if (p != null) {
            p.color = c;
        }
    }

    private static <K, V> TreeMapEntry<K, V> leftOf(TreeMapEntry<K, V> p) {
        return p == null ? null : p.left;
    }

    private static <K, V> TreeMapEntry<K, V> rightOf(TreeMapEntry<K, V> p) {
        return p == null ? null : p.right;
    }

    private void rotateLeft(TreeMapEntry<K, V> p) {
        if (p != null) {
            TreeMapEntry r = p.right;
            p.right = r.left;
            if (r.left != null) {
                r.left.parent = p;
            }
            r.parent = p.parent;
            if (p.parent == null) {
                this.root = r;
            } else if (p.parent.left == p) {
                p.parent.left = r;
            } else {
                p.parent.right = r;
            }
            r.left = p;
            p.parent = r;
        }
    }

    private void rotateRight(TreeMapEntry<K, V> p) {
        if (p != null) {
            TreeMapEntry l = p.left;
            p.left = l.right;
            if (l.right != null) {
                l.right.parent = p;
            }
            l.parent = p.parent;
            if (p.parent == null) {
                this.root = l;
            } else if (p.parent.right == p) {
                p.parent.right = l;
            } else {
                p.parent.left = l;
            }
            l.right = p;
            p.parent = l;
        }
    }

    private void fixAfterInsertion(TreeMapEntry<K, V> x) {
        x.color = false;
        while (x != null && x != this.root && !x.parent.color) {
            TreeMapEntry<K, V> y;
            if (TreeMap.parentOf(x) == TreeMap.leftOf(TreeMap.parentOf(TreeMap.parentOf(x)))) {
                y = TreeMap.rightOf(TreeMap.parentOf(TreeMap.parentOf(x)));
                if (!TreeMap.colorOf(y)) {
                    TreeMap.setColor(TreeMap.parentOf(x), true);
                    TreeMap.setColor(y, true);
                    TreeMap.setColor(TreeMap.parentOf(TreeMap.parentOf(x)), false);
                    x = TreeMap.parentOf(TreeMap.parentOf(x));
                    continue;
                }
                if (x == TreeMap.rightOf(TreeMap.parentOf(x))) {
                    x = TreeMap.parentOf(x);
                    this.rotateLeft(x);
                }
                TreeMap.setColor(TreeMap.parentOf(x), true);
                TreeMap.setColor(TreeMap.parentOf(TreeMap.parentOf(x)), false);
                this.rotateRight(TreeMap.parentOf(TreeMap.parentOf(x)));
                continue;
            }
            y = TreeMap.leftOf(TreeMap.parentOf(TreeMap.parentOf(x)));
            if (!TreeMap.colorOf(y)) {
                TreeMap.setColor(TreeMap.parentOf(x), true);
                TreeMap.setColor(y, true);
                TreeMap.setColor(TreeMap.parentOf(TreeMap.parentOf(x)), false);
                x = TreeMap.parentOf(TreeMap.parentOf(x));
                continue;
            }
            if (x == TreeMap.leftOf(TreeMap.parentOf(x))) {
                x = TreeMap.parentOf(x);
                this.rotateRight(x);
            }
            TreeMap.setColor(TreeMap.parentOf(x), true);
            TreeMap.setColor(TreeMap.parentOf(TreeMap.parentOf(x)), false);
            this.rotateLeft(TreeMap.parentOf(TreeMap.parentOf(x)));
        }
        this.root.color = true;
    }

    private void deleteEntry(TreeMapEntry<K, V> p) {
        TreeMapEntry replacement;
        ++this.modCount;
        --this.size;
        if (p.left != null && p.right != null) {
            TreeMapEntry<K, V> s = TreeMap.successor(p);
            p.key = s.key;
            p.value = s.value;
            p = s;
        }
        TreeMapEntry treeMapEntry = replacement = p.left != null ? p.left : p.right;
        if (replacement != null) {
            replacement.parent = p.parent;
            if (p.parent == null) {
                this.root = replacement;
            } else if (p == p.parent.left) {
                p.parent.left = replacement;
            } else {
                p.parent.right = replacement;
            }
            p.parent = null;
            p.right = null;
            p.left = null;
            if (p.color) {
                this.fixAfterDeletion(replacement);
            }
        } else if (p.parent == null) {
            this.root = null;
        } else {
            if (p.color) {
                this.fixAfterDeletion(p);
            }
            if (p.parent != null) {
                if (p == p.parent.left) {
                    p.parent.left = null;
                } else if (p == p.parent.right) {
                    p.parent.right = null;
                }
                p.parent = null;
            }
        }
    }

    private void fixAfterDeletion(TreeMapEntry<K, V> x) {
        while (x != this.root && TreeMap.colorOf(x)) {
            TreeMapEntry<K, V> sib;
            if (x == TreeMap.leftOf(TreeMap.parentOf(x))) {
                sib = TreeMap.rightOf(TreeMap.parentOf(x));
                if (!TreeMap.colorOf(sib)) {
                    TreeMap.setColor(sib, true);
                    TreeMap.setColor(TreeMap.parentOf(x), false);
                    this.rotateLeft(TreeMap.parentOf(x));
                    sib = TreeMap.rightOf(TreeMap.parentOf(x));
                }
                if (TreeMap.colorOf(TreeMap.leftOf(sib)) && TreeMap.colorOf(TreeMap.rightOf(sib))) {
                    TreeMap.setColor(sib, false);
                    x = TreeMap.parentOf(x);
                    continue;
                }
                if (TreeMap.colorOf(TreeMap.rightOf(sib))) {
                    TreeMap.setColor(TreeMap.leftOf(sib), true);
                    TreeMap.setColor(sib, false);
                    this.rotateRight(sib);
                    sib = TreeMap.rightOf(TreeMap.parentOf(x));
                }
                TreeMap.setColor(sib, TreeMap.colorOf(TreeMap.parentOf(x)));
                TreeMap.setColor(TreeMap.parentOf(x), true);
                TreeMap.setColor(TreeMap.rightOf(sib), true);
                this.rotateLeft(TreeMap.parentOf(x));
                x = this.root;
                continue;
            }
            sib = TreeMap.leftOf(TreeMap.parentOf(x));
            if (!TreeMap.colorOf(sib)) {
                TreeMap.setColor(sib, true);
                TreeMap.setColor(TreeMap.parentOf(x), false);
                this.rotateRight(TreeMap.parentOf(x));
                sib = TreeMap.leftOf(TreeMap.parentOf(x));
            }
            if (TreeMap.colorOf(TreeMap.rightOf(sib)) && TreeMap.colorOf(TreeMap.leftOf(sib))) {
                TreeMap.setColor(sib, false);
                x = TreeMap.parentOf(x);
                continue;
            }
            if (TreeMap.colorOf(TreeMap.leftOf(sib))) {
                TreeMap.setColor(TreeMap.rightOf(sib), true);
                TreeMap.setColor(sib, false);
                this.rotateLeft(sib);
                sib = TreeMap.leftOf(TreeMap.parentOf(x));
            }
            TreeMap.setColor(sib, TreeMap.colorOf(TreeMap.parentOf(x)));
            TreeMap.setColor(TreeMap.parentOf(x), true);
            TreeMap.setColor(TreeMap.leftOf(sib), true);
            this.rotateRight(TreeMap.parentOf(x));
            x = this.root;
        }
        TreeMap.setColor(x, true);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.size);
        for (Map.Entry<K, V> e : this.entrySet()) {
            s.writeObject(e.getKey());
            s.writeObject(e.getValue());
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int size = s.readInt();
        this.buildFromSorted(size, null, s, null);
    }

    void readTreeSet(int size, ObjectInputStream s, V defaultVal) throws IOException, ClassNotFoundException {
        this.buildFromSorted(size, null, s, defaultVal);
    }

    void addAllForTreeSet(SortedSet<? extends K> set, V defaultVal) {
        try {
            this.buildFromSorted(set.size(), set.iterator(), null, defaultVal);
        }
        catch (IOException iOException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    private void buildFromSorted(int size, Iterator<?> it, ObjectInputStream str, V defaultVal) throws IOException, ClassNotFoundException {
        this.size = size;
        this.root = this.buildFromSorted(0, 0, size - 1, TreeMap.computeRedLevel(size), it, str, defaultVal);
    }

    private final TreeMapEntry<K, V> buildFromSorted(int level, int lo, int hi, int redLevel, Iterator<?> it, ObjectInputStream str, V defaultVal) throws IOException, ClassNotFoundException {
        V value;
        Object key;
        if (hi < lo) {
            return null;
        }
        int mid = lo + hi >>> 1;
        TreeMapEntry<K, V> left = null;
        if (lo < mid) {
            left = this.buildFromSorted(level + 1, lo, mid - 1, redLevel, it, str, defaultVal);
        }
        if (it != null) {
            if (defaultVal == null) {
                Map.Entry entry = (Map.Entry)it.next();
                key = entry.getKey();
                value = entry.getValue();
            } else {
                key = it.next();
                value = defaultVal;
            }
        } else {
            key = str.readObject();
            value = defaultVal != null ? defaultVal : str.readObject();
        }
        TreeMapEntry<Object, V> middle = new TreeMapEntry<Object, V>(key, value, null);
        if (level == redLevel) {
            middle.color = false;
        }
        if (left != null) {
            middle.left = left;
            left.parent = middle;
        }
        if (mid < hi) {
            TreeMapEntry<K, V> right = this.buildFromSorted(level + 1, mid + 1, hi, redLevel, it, str, defaultVal);
            middle.right = right;
            right.parent = middle;
        }
        return middle;
    }

    private static int computeRedLevel(int sz) {
        int level = 0;
        int m = sz - 1;
        while (m >= 0) {
            ++level;
            m = m / 2 - 1;
        }
        return level;
    }

    static <K> Spliterator<K> keySpliteratorFor(NavigableMap<K, ?> m) {
        if (m instanceof TreeMap) {
            TreeMap t = (TreeMap)m;
            return t.keySpliterator();
        }
        if (m instanceof DescendingSubMap) {
            DescendingSubMap dm = (DescendingSubMap)m;
            TreeMap tm = dm.m;
            if (dm == tm.descendingMap) {
                TreeMap t = tm;
                return t.descendingKeySpliterator();
            }
        }
        NavigableSubMap sm = (NavigableSubMap)m;
        return sm.keySpliterator();
    }

    final Spliterator<K> keySpliterator() {
        return new KeySpliterator(this, null, null, 0, -1, 0);
    }

    final Spliterator<K> descendingKeySpliterator() {
        return new DescendingKeySpliterator(this, null, null, 0, -2, 0);
    }

    static final class EntrySpliterator<K, V>
    extends TreeMapSpliterator<K, V>
    implements Spliterator<Map.Entry<K, V>> {
        EntrySpliterator(TreeMap<K, V> tree, TreeMapEntry<K, V> origin, TreeMapEntry<K, V> fence, int side, int est, int expectedModCount) {
            super(tree, origin, fence, side, est, expectedModCount);
        }

        public EntrySpliterator<K, V> trySplit() {
            TreeMapEntry s;
            if (this.est < 0) {
                this.getEstimate();
            }
            int d = this.side;
            TreeMapEntry e = this.current;
            TreeMapEntry f = this.fence;
            TreeMapEntry treeMapEntry = e == null || e == f ? null : (d == 0 ? this.tree.root : (d > 0 ? e.right : (s = d < 0 && f != null ? f.left : null)));
            if (s != null && s != e && s != f && this.tree.compare(e.key, s.key) < 0) {
                this.side = 1;
                this.current = s;
                return new EntrySpliterator(this.tree, e, this.current, -1, this.est >>>= 1, this.expectedModCount);
            }
            return null;
        }

        @Override
        public void forEachRemaining(Consumer<? super Map.Entry<K, V>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.est < 0) {
                this.getEstimate();
            }
            TreeMapEntry f = this.fence;
            TreeMapEntry e = this.current;
            if (e != null && e != f) {
                TreeMapEntry p;
                this.current = f;
                do {
                    action.accept(e);
                    p = e.right;
                    if (p != null) {
                        TreeMapEntry pl;
                        while ((pl = p.left) != null) {
                            p = pl;
                        }
                    } else {
                        while ((p = e.parent) != null && e == p.right) {
                            e = p;
                        }
                    }
                } while ((e = p) != null && e != f);
                if (this.tree.modCount != this.expectedModCount) {
                    throw new ConcurrentModificationException();
                }
            }
        }

        @Override
        public boolean tryAdvance(Consumer<? super Map.Entry<K, V>> action) {
            TreeMapEntry e;
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.est < 0) {
                this.getEstimate();
            }
            if ((e = this.current) == null || e == this.fence) {
                return false;
            }
            this.current = TreeMap.successor(e);
            action.accept(e);
            if (this.tree.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            return true;
        }

        @Override
        public int characteristics() {
            return (this.side == 0 ? 64 : 0) | 1 | 4 | 0x10;
        }

        @Override
        public Comparator<Map.Entry<K, V>> getComparator() {
            if (this.tree.comparator != null) {
                return Map.Entry.comparingByKey(this.tree.comparator);
            }
            return (Comparator & Serializable)(e1, e2) -> {
                Comparable k1 = (Comparable)e1.getKey();
                return k1.compareTo(e2.getKey());
            };
        }
    }

    static final class ValueSpliterator<K, V>
    extends TreeMapSpliterator<K, V>
    implements Spliterator<V> {
        ValueSpliterator(TreeMap<K, V> tree, TreeMapEntry<K, V> origin, TreeMapEntry<K, V> fence, int side, int est, int expectedModCount) {
            super(tree, origin, fence, side, est, expectedModCount);
        }

        public ValueSpliterator<K, V> trySplit() {
            TreeMapEntry s;
            if (this.est < 0) {
                this.getEstimate();
            }
            int d = this.side;
            TreeMapEntry e = this.current;
            TreeMapEntry f = this.fence;
            TreeMapEntry treeMapEntry = e == null || e == f ? null : (d == 0 ? this.tree.root : (d > 0 ? e.right : (s = d < 0 && f != null ? f.left : null)));
            if (s != null && s != e && s != f && this.tree.compare(e.key, s.key) < 0) {
                this.side = 1;
                this.current = s;
                return new ValueSpliterator(this.tree, e, this.current, -1, this.est >>>= 1, this.expectedModCount);
            }
            return null;
        }

        @Override
        public void forEachRemaining(Consumer<? super V> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.est < 0) {
                this.getEstimate();
            }
            TreeMapEntry f = this.fence;
            TreeMapEntry e = this.current;
            if (e != null && e != f) {
                TreeMapEntry p;
                this.current = f;
                do {
                    action.accept(e.value);
                    p = e.right;
                    if (p != null) {
                        TreeMapEntry pl;
                        while ((pl = p.left) != null) {
                            p = pl;
                        }
                    } else {
                        while ((p = e.parent) != null && e == p.right) {
                            e = p;
                        }
                    }
                } while ((e = p) != null && e != f);
                if (this.tree.modCount != this.expectedModCount) {
                    throw new ConcurrentModificationException();
                }
            }
        }

        @Override
        public boolean tryAdvance(Consumer<? super V> action) {
            TreeMapEntry e;
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.est < 0) {
                this.getEstimate();
            }
            if ((e = this.current) == null || e == this.fence) {
                return false;
            }
            this.current = TreeMap.successor(e);
            action.accept(e.value);
            if (this.tree.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            return true;
        }

        @Override
        public int characteristics() {
            return (this.side == 0 ? 64 : 0) | 0x10;
        }
    }

    static final class DescendingKeySpliterator<K, V>
    extends TreeMapSpliterator<K, V>
    implements Spliterator<K> {
        DescendingKeySpliterator(TreeMap<K, V> tree, TreeMapEntry<K, V> origin, TreeMapEntry<K, V> fence, int side, int est, int expectedModCount) {
            super(tree, origin, fence, side, est, expectedModCount);
        }

        public DescendingKeySpliterator<K, V> trySplit() {
            TreeMapEntry s;
            if (this.est < 0) {
                this.getEstimate();
            }
            int d = this.side;
            TreeMapEntry e = this.current;
            TreeMapEntry f = this.fence;
            TreeMapEntry treeMapEntry = e == null || e == f ? null : (d == 0 ? this.tree.root : (d < 0 ? e.left : (s = d > 0 && f != null ? f.right : null)));
            if (s != null && s != e && s != f && this.tree.compare(e.key, s.key) > 0) {
                this.side = 1;
                this.current = s;
                return new DescendingKeySpliterator(this.tree, e, this.current, -1, this.est >>>= 1, this.expectedModCount);
            }
            return null;
        }

        @Override
        public void forEachRemaining(Consumer<? super K> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.est < 0) {
                this.getEstimate();
            }
            TreeMapEntry f = this.fence;
            TreeMapEntry e = this.current;
            if (e != null && e != f) {
                TreeMapEntry p;
                this.current = f;
                do {
                    action.accept(e.key);
                    p = e.left;
                    if (p != null) {
                        TreeMapEntry pr;
                        while ((pr = p.right) != null) {
                            p = pr;
                        }
                    } else {
                        while ((p = e.parent) != null && e == p.left) {
                            e = p;
                        }
                    }
                } while ((e = p) != null && e != f);
                if (this.tree.modCount != this.expectedModCount) {
                    throw new ConcurrentModificationException();
                }
            }
        }

        @Override
        public boolean tryAdvance(Consumer<? super K> action) {
            TreeMapEntry e;
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.est < 0) {
                this.getEstimate();
            }
            if ((e = this.current) == null || e == this.fence) {
                return false;
            }
            this.current = TreeMap.predecessor(e);
            action.accept(e.key);
            if (this.tree.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            return true;
        }

        @Override
        public int characteristics() {
            return (this.side == 0 ? 64 : 0) | 1 | 0x10;
        }
    }

    static final class KeySpliterator<K, V>
    extends TreeMapSpliterator<K, V>
    implements Spliterator<K> {
        KeySpliterator(TreeMap<K, V> tree, TreeMapEntry<K, V> origin, TreeMapEntry<K, V> fence, int side, int est, int expectedModCount) {
            super(tree, origin, fence, side, est, expectedModCount);
        }

        public KeySpliterator<K, V> trySplit() {
            TreeMapEntry s;
            if (this.est < 0) {
                this.getEstimate();
            }
            int d = this.side;
            TreeMapEntry e = this.current;
            TreeMapEntry f = this.fence;
            TreeMapEntry treeMapEntry = e == null || e == f ? null : (d == 0 ? this.tree.root : (d > 0 ? e.right : (s = d < 0 && f != null ? f.left : null)));
            if (s != null && s != e && s != f && this.tree.compare(e.key, s.key) < 0) {
                this.side = 1;
                this.current = s;
                return new KeySpliterator(this.tree, e, this.current, -1, this.est >>>= 1, this.expectedModCount);
            }
            return null;
        }

        @Override
        public void forEachRemaining(Consumer<? super K> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.est < 0) {
                this.getEstimate();
            }
            TreeMapEntry f = this.fence;
            TreeMapEntry e = this.current;
            if (e != null && e != f) {
                TreeMapEntry p;
                this.current = f;
                do {
                    action.accept(e.key);
                    p = e.right;
                    if (p != null) {
                        TreeMapEntry pl;
                        while ((pl = p.left) != null) {
                            p = pl;
                        }
                    } else {
                        while ((p = e.parent) != null && e == p.right) {
                            e = p;
                        }
                    }
                } while ((e = p) != null && e != f);
                if (this.tree.modCount != this.expectedModCount) {
                    throw new ConcurrentModificationException();
                }
            }
        }

        @Override
        public boolean tryAdvance(Consumer<? super K> action) {
            TreeMapEntry e;
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.est < 0) {
                this.getEstimate();
            }
            if ((e = this.current) == null || e == this.fence) {
                return false;
            }
            this.current = TreeMap.successor(e);
            action.accept(e.key);
            if (this.tree.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            return true;
        }

        @Override
        public int characteristics() {
            return (this.side == 0 ? 64 : 0) | 1 | 4 | 0x10;
        }

        @Override
        public final Comparator<? super K> getComparator() {
            return this.tree.comparator;
        }
    }

    static class TreeMapSpliterator<K, V> {
        final TreeMap<K, V> tree;
        TreeMapEntry<K, V> current;
        TreeMapEntry<K, V> fence;
        int side;
        int est;
        int expectedModCount;

        TreeMapSpliterator(TreeMap<K, V> tree, TreeMapEntry<K, V> origin, TreeMapEntry<K, V> fence, int side, int est, int expectedModCount) {
            this.tree = tree;
            this.current = origin;
            this.fence = fence;
            this.side = side;
            this.est = est;
            this.expectedModCount = expectedModCount;
        }

        final int getEstimate() {
            int s = this.est;
            if (s < 0) {
                TreeMap<K, V> t = this.tree;
                if (t != null) {
                    this.current = s == -1 ? t.getFirstEntry() : t.getLastEntry();
                    s = this.est = ((TreeMap)t).size;
                    this.expectedModCount = ((TreeMap)t).modCount;
                } else {
                    this.est = 0;
                    s = 0;
                }
            }
            return s;
        }

        public final long estimateSize() {
            return this.getEstimate();
        }
    }

    static final class TreeMapEntry<K, V>
    implements Map.Entry<K, V> {
        K key;
        V value;
        TreeMapEntry<K, V> left;
        TreeMapEntry<K, V> right;
        TreeMapEntry<K, V> parent;
        boolean color = true;

        TreeMapEntry(K key, V value, TreeMapEntry<K, V> parent) {
            this.key = key;
            this.value = value;
            this.parent = parent;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            V oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return TreeMap.valEquals(this.key, e.getKey()) && TreeMap.valEquals(this.value, e.getValue());
        }

        @Override
        public int hashCode() {
            int keyHash = this.key == null ? 0 : this.key.hashCode();
            int valueHash = this.value == null ? 0 : this.value.hashCode();
            return keyHash ^ valueHash;
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }

    private class SubMap
    extends AbstractMap<K, V>
    implements SortedMap<K, V>,
    Serializable {
        private static final long serialVersionUID = -6520786458950516097L;
        private boolean fromStart = false;
        private boolean toEnd = false;
        private K fromKey;
        private K toKey;

        private SubMap() {
        }

        private Object readResolve() {
            return new AscendingSubMap(TreeMap.this, this.fromStart, this.fromKey, true, this.toEnd, this.toKey, false);
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            throw new InternalError();
        }

        @Override
        public K lastKey() {
            throw new InternalError();
        }

        @Override
        public K firstKey() {
            throw new InternalError();
        }

        @Override
        public SortedMap<K, V> subMap(K fromKey, K toKey) {
            throw new InternalError();
        }

        @Override
        public SortedMap<K, V> headMap(K toKey) {
            throw new InternalError();
        }

        @Override
        public SortedMap<K, V> tailMap(K fromKey) {
            throw new InternalError();
        }

        @Override
        public Comparator<? super K> comparator() {
            throw new InternalError();
        }
    }

    static final class DescendingSubMap<K, V>
    extends NavigableSubMap<K, V> {
        private static final long serialVersionUID = 912986545866120460L;
        private final Comparator<? super K> reverseComparator;

        DescendingSubMap(TreeMap<K, V> m, boolean fromStart, K lo, boolean loInclusive, boolean toEnd, K hi, boolean hiInclusive) {
            super(m, fromStart, lo, loInclusive, toEnd, hi, hiInclusive);
            this.reverseComparator = Collections.reverseOrder(this.m.comparator);
        }

        @Override
        public Comparator<? super K> comparator() {
            return this.reverseComparator;
        }

        @Override
        public NavigableMap<K, V> subMap(K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
            if (!this.inRange(fromKey, fromInclusive)) {
                throw new IllegalArgumentException("fromKey out of range");
            }
            if (!this.inRange(toKey, toInclusive)) {
                throw new IllegalArgumentException("toKey out of range");
            }
            return new DescendingSubMap<K, V>(this.m, false, toKey, toInclusive, false, fromKey, fromInclusive);
        }

        @Override
        public NavigableMap<K, V> headMap(K toKey, boolean inclusive) {
            if (!this.inRange(toKey) && (this.fromStart || this.m.compare(toKey, this.lo) != 0 || this.loInclusive || inclusive)) {
                throw new IllegalArgumentException("toKey out of range");
            }
            return new DescendingSubMap<Object, V>(this.m, false, toKey, inclusive, this.toEnd, this.hi, this.hiInclusive);
        }

        @Override
        public NavigableMap<K, V> tailMap(K fromKey, boolean inclusive) {
            if (!this.inRange(fromKey) && (this.toEnd || this.m.compare(fromKey, this.hi) != 0 || this.hiInclusive || inclusive)) {
                throw new IllegalArgumentException("fromKey out of range");
            }
            return new DescendingSubMap<Object, V>(this.m, this.fromStart, this.lo, this.loInclusive, false, fromKey, inclusive);
        }

        @Override
        public NavigableMap<K, V> descendingMap() {
            AscendingSubMap mv = this.descendingMapView;
            return mv != null ? mv : (this.descendingMapView = new AscendingSubMap(this.m, this.fromStart, this.lo, this.loInclusive, this.toEnd, this.hi, this.hiInclusive));
        }

        @Override
        Iterator<K> keyIterator() {
            return new NavigableSubMap.DescendingSubMapKeyIterator(this.absHighest(), this.absLowFence());
        }

        @Override
        Spliterator<K> keySpliterator() {
            return new NavigableSubMap.DescendingSubMapKeyIterator(this.absHighest(), this.absLowFence());
        }

        @Override
        Iterator<K> descendingKeyIterator() {
            return new NavigableSubMap.SubMapKeyIterator(this.absLowest(), this.absHighFence());
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            NavigableSubMap.EntrySetView es = this.entrySetView;
            return es != null ? es : (this.entrySetView = new DescendingEntrySetView());
        }

        @Override
        TreeMapEntry<K, V> subLowest() {
            return this.absHighest();
        }

        @Override
        TreeMapEntry<K, V> subHighest() {
            return this.absLowest();
        }

        @Override
        TreeMapEntry<K, V> subCeiling(K key) {
            return this.absFloor(key);
        }

        @Override
        TreeMapEntry<K, V> subHigher(K key) {
            return this.absLower(key);
        }

        @Override
        TreeMapEntry<K, V> subFloor(K key) {
            return this.absCeiling(key);
        }

        @Override
        TreeMapEntry<K, V> subLower(K key) {
            return this.absHigher(key);
        }

        final class DescendingEntrySetView
        extends NavigableSubMap.EntrySetView {
            DescendingEntrySetView() {
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new NavigableSubMap.DescendingSubMapEntryIterator(DescendingSubMap.this.absHighest(), DescendingSubMap.this.absLowFence());
            }
        }
    }

    static final class AscendingSubMap<K, V>
    extends NavigableSubMap<K, V> {
        private static final long serialVersionUID = 912986545866124060L;

        AscendingSubMap(TreeMap<K, V> m, boolean fromStart, K lo, boolean loInclusive, boolean toEnd, K hi, boolean hiInclusive) {
            super(m, fromStart, lo, loInclusive, toEnd, hi, hiInclusive);
        }

        @Override
        public Comparator<? super K> comparator() {
            return this.m.comparator();
        }

        @Override
        public NavigableMap<K, V> subMap(K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
            if (!this.inRange(fromKey, fromInclusive)) {
                throw new IllegalArgumentException("fromKey out of range");
            }
            if (!this.inRange(toKey, toInclusive)) {
                throw new IllegalArgumentException("toKey out of range");
            }
            return new AscendingSubMap<K, V>(this.m, false, fromKey, fromInclusive, false, toKey, toInclusive);
        }

        @Override
        public NavigableMap<K, V> headMap(K toKey, boolean inclusive) {
            if (!this.inRange(toKey) && (this.toEnd || this.m.compare(toKey, this.hi) != 0 || this.hiInclusive || inclusive)) {
                throw new IllegalArgumentException("toKey out of range");
            }
            return new AscendingSubMap<Object, V>(this.m, this.fromStart, this.lo, this.loInclusive, false, toKey, inclusive);
        }

        @Override
        public NavigableMap<K, V> tailMap(K fromKey, boolean inclusive) {
            if (!this.inRange(fromKey) && (this.fromStart || this.m.compare(fromKey, this.lo) != 0 || this.loInclusive || inclusive)) {
                throw new IllegalArgumentException("fromKey out of range");
            }
            return new AscendingSubMap<Object, V>(this.m, false, fromKey, inclusive, this.toEnd, this.hi, this.hiInclusive);
        }

        @Override
        public NavigableMap<K, V> descendingMap() {
            DescendingSubMap mv = this.descendingMapView;
            return mv != null ? mv : (this.descendingMapView = new DescendingSubMap(this.m, this.fromStart, this.lo, this.loInclusive, this.toEnd, this.hi, this.hiInclusive));
        }

        @Override
        Iterator<K> keyIterator() {
            return new NavigableSubMap.SubMapKeyIterator(this.absLowest(), this.absHighFence());
        }

        @Override
        Spliterator<K> keySpliterator() {
            return new NavigableSubMap.SubMapKeyIterator(this.absLowest(), this.absHighFence());
        }

        @Override
        Iterator<K> descendingKeyIterator() {
            return new NavigableSubMap.DescendingSubMapKeyIterator(this.absHighest(), this.absLowFence());
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            NavigableSubMap.EntrySetView es = this.entrySetView;
            return es != null ? es : (this.entrySetView = new AscendingEntrySetView());
        }

        @Override
        TreeMapEntry<K, V> subLowest() {
            return this.absLowest();
        }

        @Override
        TreeMapEntry<K, V> subHighest() {
            return this.absHighest();
        }

        @Override
        TreeMapEntry<K, V> subCeiling(K key) {
            return this.absCeiling(key);
        }

        @Override
        TreeMapEntry<K, V> subHigher(K key) {
            return this.absHigher(key);
        }

        @Override
        TreeMapEntry<K, V> subFloor(K key) {
            return this.absFloor(key);
        }

        @Override
        TreeMapEntry<K, V> subLower(K key) {
            return this.absLower(key);
        }

        final class AscendingEntrySetView
        extends NavigableSubMap.EntrySetView {
            AscendingEntrySetView() {
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new NavigableSubMap.SubMapEntryIterator(AscendingSubMap.this.absLowest(), AscendingSubMap.this.absHighFence());
            }
        }
    }

    static abstract class NavigableSubMap<K, V>
    extends AbstractMap<K, V>
    implements NavigableMap<K, V>,
    Serializable {
        private static final long serialVersionUID = 2765629423043303731L;
        final TreeMap<K, V> m;
        final K lo;
        final K hi;
        final boolean fromStart;
        final boolean toEnd;
        final boolean loInclusive;
        final boolean hiInclusive;
        transient NavigableMap<K, V> descendingMapView;
        transient EntrySetView entrySetView;
        transient KeySet<K> navigableKeySetView;

        NavigableSubMap(TreeMap<K, V> m, boolean fromStart, K lo, boolean loInclusive, boolean toEnd, K hi, boolean hiInclusive) {
            if (!fromStart && !toEnd) {
                if (m.compare(lo, hi) > 0) {
                    throw new IllegalArgumentException("fromKey > toKey");
                }
            } else {
                if (!fromStart) {
                    m.compare(lo, lo);
                }
                if (!toEnd) {
                    m.compare(hi, hi);
                }
            }
            this.m = m;
            this.fromStart = fromStart;
            this.lo = lo;
            this.loInclusive = loInclusive;
            this.toEnd = toEnd;
            this.hi = hi;
            this.hiInclusive = hiInclusive;
        }

        final boolean tooLow(Object key) {
            int c;
            return !this.fromStart && ((c = this.m.compare(key, this.lo)) < 0 || c == 0 && !this.loInclusive);
        }

        final boolean tooHigh(Object key) {
            int c;
            return !this.toEnd && ((c = this.m.compare(key, this.hi)) > 0 || c == 0 && !this.hiInclusive);
        }

        final boolean inRange(Object key) {
            return !this.tooLow(key) && !this.tooHigh(key);
        }

        final boolean inClosedRange(Object key) {
            return !(!this.fromStart && this.m.compare(key, this.lo) < 0 || !this.toEnd && this.m.compare(this.hi, key) < 0);
        }

        final boolean inRange(Object key, boolean inclusive) {
            return inclusive ? this.inRange(key) : this.inClosedRange(key);
        }

        final TreeMapEntry<K, V> absLowest() {
            TreeMapEntry<K, V> e = this.fromStart ? this.m.getFirstEntry() : (this.loInclusive ? this.m.getCeilingEntry(this.lo) : this.m.getHigherEntry(this.lo));
            return e == null || this.tooHigh(e.key) ? null : e;
        }

        final TreeMapEntry<K, V> absHighest() {
            TreeMapEntry<K, V> e = this.toEnd ? this.m.getLastEntry() : (this.hiInclusive ? this.m.getFloorEntry(this.hi) : this.m.getLowerEntry(this.hi));
            return e == null || this.tooLow(e.key) ? null : e;
        }

        final TreeMapEntry<K, V> absCeiling(K key) {
            if (this.tooLow(key)) {
                return this.absLowest();
            }
            TreeMapEntry<K, V> e = this.m.getCeilingEntry(key);
            return e == null || this.tooHigh(e.key) ? null : e;
        }

        final TreeMapEntry<K, V> absHigher(K key) {
            if (this.tooLow(key)) {
                return this.absLowest();
            }
            TreeMapEntry<K, V> e = this.m.getHigherEntry(key);
            return e == null || this.tooHigh(e.key) ? null : e;
        }

        final TreeMapEntry<K, V> absFloor(K key) {
            if (this.tooHigh(key)) {
                return this.absHighest();
            }
            TreeMapEntry<K, V> e = this.m.getFloorEntry(key);
            return e == null || this.tooLow(e.key) ? null : e;
        }

        final TreeMapEntry<K, V> absLower(K key) {
            if (this.tooHigh(key)) {
                return this.absHighest();
            }
            TreeMapEntry<K, V> e = this.m.getLowerEntry(key);
            return e == null || this.tooLow(e.key) ? null : e;
        }

        final TreeMapEntry<K, V> absHighFence() {
            return this.toEnd ? null : (this.hiInclusive ? this.m.getHigherEntry(this.hi) : this.m.getCeilingEntry(this.hi));
        }

        final TreeMapEntry<K, V> absLowFence() {
            return this.fromStart ? null : (this.loInclusive ? this.m.getLowerEntry(this.lo) : this.m.getFloorEntry(this.lo));
        }

        abstract TreeMapEntry<K, V> subLowest();

        abstract TreeMapEntry<K, V> subHighest();

        abstract TreeMapEntry<K, V> subCeiling(K var1);

        abstract TreeMapEntry<K, V> subHigher(K var1);

        abstract TreeMapEntry<K, V> subFloor(K var1);

        abstract TreeMapEntry<K, V> subLower(K var1);

        abstract Iterator<K> keyIterator();

        abstract Spliterator<K> keySpliterator();

        abstract Iterator<K> descendingKeyIterator();

        @Override
        public boolean isEmpty() {
            return this.fromStart && this.toEnd ? this.m.isEmpty() : this.entrySet().isEmpty();
        }

        @Override
        public int size() {
            return this.fromStart && this.toEnd ? this.m.size() : this.entrySet().size();
        }

        @Override
        public final boolean containsKey(Object key) {
            return this.inRange(key) && this.m.containsKey(key);
        }

        @Override
        public final V put(K key, V value) {
            if (!this.inRange(key)) {
                throw new IllegalArgumentException("key out of range");
            }
            return this.m.put(key, value);
        }

        @Override
        public final V get(Object key) {
            return !this.inRange(key) ? null : (V)this.m.get(key);
        }

        @Override
        public final V remove(Object key) {
            return !this.inRange(key) ? null : (V)this.m.remove(key);
        }

        @Override
        public final Map.Entry<K, V> ceilingEntry(K key) {
            return TreeMap.exportEntry(this.subCeiling(key));
        }

        @Override
        public final K ceilingKey(K key) {
            return TreeMap.keyOrNull(this.subCeiling(key));
        }

        @Override
        public final Map.Entry<K, V> higherEntry(K key) {
            return TreeMap.exportEntry(this.subHigher(key));
        }

        @Override
        public final K higherKey(K key) {
            return TreeMap.keyOrNull(this.subHigher(key));
        }

        @Override
        public final Map.Entry<K, V> floorEntry(K key) {
            return TreeMap.exportEntry(this.subFloor(key));
        }

        @Override
        public final K floorKey(K key) {
            return TreeMap.keyOrNull(this.subFloor(key));
        }

        @Override
        public final Map.Entry<K, V> lowerEntry(K key) {
            return TreeMap.exportEntry(this.subLower(key));
        }

        @Override
        public final K lowerKey(K key) {
            return TreeMap.keyOrNull(this.subLower(key));
        }

        @Override
        public final K firstKey() {
            return TreeMap.key(this.subLowest());
        }

        @Override
        public final K lastKey() {
            return TreeMap.key(this.subHighest());
        }

        @Override
        public final Map.Entry<K, V> firstEntry() {
            return TreeMap.exportEntry(this.subLowest());
        }

        @Override
        public final Map.Entry<K, V> lastEntry() {
            return TreeMap.exportEntry(this.subHighest());
        }

        @Override
        public final Map.Entry<K, V> pollFirstEntry() {
            TreeMapEntry<K, V> e = this.subLowest();
            Map.Entry<K, V> result = TreeMap.exportEntry(e);
            if (e != null) {
                ((TreeMap)this.m).deleteEntry(e);
            }
            return result;
        }

        @Override
        public final Map.Entry<K, V> pollLastEntry() {
            TreeMapEntry<K, V> e = this.subHighest();
            Map.Entry<K, V> result = TreeMap.exportEntry(e);
            if (e != null) {
                ((TreeMap)this.m).deleteEntry(e);
            }
            return result;
        }

        @Override
        public final NavigableSet<K> navigableKeySet() {
            KeySet<K> nksv = this.navigableKeySetView;
            return nksv != null ? nksv : (this.navigableKeySetView = new KeySet(this));
        }

        @Override
        public final Set<K> keySet() {
            return this.navigableKeySet();
        }

        @Override
        public NavigableSet<K> descendingKeySet() {
            return this.descendingMap().navigableKeySet();
        }

        @Override
        public final SortedMap<K, V> subMap(K fromKey, K toKey) {
            return this.subMap(fromKey, true, toKey, false);
        }

        @Override
        public final SortedMap<K, V> headMap(K toKey) {
            return this.headMap(toKey, false);
        }

        @Override
        public final SortedMap<K, V> tailMap(K fromKey) {
            return this.tailMap(fromKey, true);
        }

        final class DescendingSubMapKeyIterator
        extends SubMapIterator<K>
        implements Spliterator<K> {
            DescendingSubMapKeyIterator(TreeMapEntry<K, V> last, TreeMapEntry<K, V> fence) {
                super(last, fence);
            }

            @Override
            public K next() {
                return this.prevEntry().key;
            }

            @Override
            public void remove() {
                this.removeDescending();
            }

            @Override
            public Spliterator<K> trySplit() {
                return null;
            }

            @Override
            public void forEachRemaining(Consumer<? super K> action) {
                while (this.hasNext()) {
                    action.accept(this.next());
                }
            }

            @Override
            public boolean tryAdvance(Consumer<? super K> action) {
                if (this.hasNext()) {
                    action.accept(this.next());
                    return true;
                }
                return false;
            }

            @Override
            public long estimateSize() {
                return Long.MAX_VALUE;
            }

            @Override
            public int characteristics() {
                return 17;
            }
        }

        final class SubMapKeyIterator
        extends SubMapIterator<K>
        implements Spliterator<K> {
            SubMapKeyIterator(TreeMapEntry<K, V> first, TreeMapEntry<K, V> fence) {
                super(first, fence);
            }

            @Override
            public K next() {
                return this.nextEntry().key;
            }

            @Override
            public void remove() {
                this.removeAscending();
            }

            @Override
            public Spliterator<K> trySplit() {
                return null;
            }

            @Override
            public void forEachRemaining(Consumer<? super K> action) {
                while (this.hasNext()) {
                    action.accept(this.next());
                }
            }

            @Override
            public boolean tryAdvance(Consumer<? super K> action) {
                if (this.hasNext()) {
                    action.accept(this.next());
                    return true;
                }
                return false;
            }

            @Override
            public long estimateSize() {
                return Long.MAX_VALUE;
            }

            @Override
            public int characteristics() {
                return 21;
            }

            @Override
            public final Comparator<? super K> getComparator() {
                return NavigableSubMap.this.comparator();
            }
        }

        final class DescendingSubMapEntryIterator
        extends SubMapIterator<Map.Entry<K, V>> {
            DescendingSubMapEntryIterator(TreeMapEntry<K, V> last, TreeMapEntry<K, V> fence) {
                super(last, fence);
            }

            @Override
            public Map.Entry<K, V> next() {
                return this.prevEntry();
            }

            @Override
            public void remove() {
                this.removeDescending();
            }
        }

        final class SubMapEntryIterator
        extends SubMapIterator<Map.Entry<K, V>> {
            SubMapEntryIterator(TreeMapEntry<K, V> first, TreeMapEntry<K, V> fence) {
                super(first, fence);
            }

            @Override
            public Map.Entry<K, V> next() {
                return this.nextEntry();
            }

            @Override
            public void remove() {
                this.removeAscending();
            }
        }

        abstract class SubMapIterator<T>
        implements Iterator<T> {
            TreeMapEntry<K, V> lastReturned;
            TreeMapEntry<K, V> next;
            final Object fenceKey;
            int expectedModCount;

            SubMapIterator(TreeMapEntry<K, V> first, TreeMapEntry<K, V> fence) {
                this.expectedModCount = NavigableSubMap.this.m.modCount;
                this.lastReturned = null;
                this.next = first;
                this.fenceKey = fence == null ? UNBOUNDED : fence.key;
            }

            @Override
            public final boolean hasNext() {
                return this.next != null && this.next.key != this.fenceKey;
            }

            final TreeMapEntry<K, V> nextEntry() {
                TreeMapEntry e = this.next;
                if (e == null || e.key == this.fenceKey) {
                    throw new NoSuchElementException();
                }
                if (NavigableSubMap.this.m.modCount != this.expectedModCount) {
                    throw new ConcurrentModificationException();
                }
                this.next = TreeMap.successor(e);
                this.lastReturned = e;
                return e;
            }

            final TreeMapEntry<K, V> prevEntry() {
                TreeMapEntry e = this.next;
                if (e == null || e.key == this.fenceKey) {
                    throw new NoSuchElementException();
                }
                if (NavigableSubMap.this.m.modCount != this.expectedModCount) {
                    throw new ConcurrentModificationException();
                }
                this.next = TreeMap.predecessor(e);
                this.lastReturned = e;
                return e;
            }

            final void removeAscending() {
                if (this.lastReturned == null) {
                    throw new IllegalStateException();
                }
                if (NavigableSubMap.this.m.modCount != this.expectedModCount) {
                    throw new ConcurrentModificationException();
                }
                if (this.lastReturned.left != null && this.lastReturned.right != null) {
                    this.next = this.lastReturned;
                }
                NavigableSubMap.this.m.deleteEntry(this.lastReturned);
                this.lastReturned = null;
                this.expectedModCount = NavigableSubMap.this.m.modCount;
            }

            final void removeDescending() {
                if (this.lastReturned == null) {
                    throw new IllegalStateException();
                }
                if (NavigableSubMap.this.m.modCount != this.expectedModCount) {
                    throw new ConcurrentModificationException();
                }
                NavigableSubMap.this.m.deleteEntry(this.lastReturned);
                this.lastReturned = null;
                this.expectedModCount = NavigableSubMap.this.m.modCount;
            }
        }

        abstract class EntrySetView
        extends AbstractSet<Map.Entry<K, V>> {
            private transient int size = -1;
            private transient int sizeModCount;

            EntrySetView() {
            }

            @Override
            public int size() {
                if (NavigableSubMap.this.fromStart && NavigableSubMap.this.toEnd) {
                    return NavigableSubMap.this.m.size();
                }
                if (this.size == -1 || this.sizeModCount != NavigableSubMap.this.m.modCount) {
                    this.sizeModCount = NavigableSubMap.this.m.modCount;
                    this.size = 0;
                    Iterator i = this.iterator();
                    while (i.hasNext()) {
                        ++this.size;
                        i.next();
                    }
                }
                return this.size;
            }

            @Override
            public boolean isEmpty() {
                TreeMapEntry n = NavigableSubMap.this.absLowest();
                return n == null || NavigableSubMap.this.tooHigh(n.key);
            }

            @Override
            public boolean contains(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)o;
                Object key = entry.getKey();
                if (!NavigableSubMap.this.inRange(key)) {
                    return false;
                }
                TreeMapEntry node = NavigableSubMap.this.m.getEntry(key);
                return node != null && TreeMap.valEquals(node.getValue(), entry.getValue());
            }

            @Override
            public boolean remove(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)o;
                Object key = entry.getKey();
                if (!NavigableSubMap.this.inRange(key)) {
                    return false;
                }
                TreeMapEntry node = NavigableSubMap.this.m.getEntry(key);
                if (node != null && TreeMap.valEquals(node.getValue(), entry.getValue())) {
                    NavigableSubMap.this.m.deleteEntry(node);
                    return true;
                }
                return false;
            }
        }
    }

    final class DescendingKeyIterator
    extends PrivateEntryIterator<K> {
        DescendingKeyIterator(TreeMapEntry<K, V> first) {
            super(first);
        }

        @Override
        public K next() {
            return this.prevEntry().key;
        }

        @Override
        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            if (TreeMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            TreeMap.this.deleteEntry(this.lastReturned);
            this.lastReturned = null;
            this.expectedModCount = TreeMap.this.modCount;
        }
    }

    final class KeyIterator
    extends PrivateEntryIterator<K> {
        KeyIterator(TreeMapEntry<K, V> first) {
            super(first);
        }

        @Override
        public K next() {
            return this.nextEntry().key;
        }
    }

    final class ValueIterator
    extends PrivateEntryIterator<V> {
        ValueIterator(TreeMapEntry<K, V> first) {
            super(first);
        }

        @Override
        public V next() {
            return this.nextEntry().value;
        }
    }

    final class EntryIterator
    extends PrivateEntryIterator<Map.Entry<K, V>> {
        EntryIterator(TreeMapEntry<K, V> first) {
            super(first);
        }

        @Override
        public Map.Entry<K, V> next() {
            return this.nextEntry();
        }
    }

    abstract class PrivateEntryIterator<T>
    implements Iterator<T> {
        TreeMapEntry<K, V> next;
        TreeMapEntry<K, V> lastReturned;
        int expectedModCount;

        PrivateEntryIterator(TreeMapEntry<K, V> first) {
            this.expectedModCount = TreeMap.this.modCount;
            this.lastReturned = null;
            this.next = first;
        }

        @Override
        public final boolean hasNext() {
            return this.next != null;
        }

        final TreeMapEntry<K, V> nextEntry() {
            TreeMapEntry e = this.next;
            if (e == null) {
                throw new NoSuchElementException();
            }
            if (TreeMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            this.next = TreeMap.successor(e);
            this.lastReturned = e;
            return e;
        }

        final TreeMapEntry<K, V> prevEntry() {
            TreeMapEntry e = this.next;
            if (e == null) {
                throw new NoSuchElementException();
            }
            if (TreeMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            this.next = TreeMap.predecessor(e);
            this.lastReturned = e;
            return e;
        }

        @Override
        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            if (TreeMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (this.lastReturned.left != null && this.lastReturned.right != null) {
                this.next = this.lastReturned;
            }
            TreeMap.this.deleteEntry(this.lastReturned);
            this.expectedModCount = TreeMap.this.modCount;
            this.lastReturned = null;
        }
    }

    static final class KeySet<E>
    extends AbstractSet<E>
    implements NavigableSet<E> {
        private final NavigableMap<E, ?> m;

        KeySet(NavigableMap<E, ?> map) {
            this.m = map;
        }

        @Override
        public Iterator<E> iterator() {
            if (this.m instanceof TreeMap) {
                return ((TreeMap)this.m).keyIterator();
            }
            return ((NavigableSubMap)this.m).keyIterator();
        }

        @Override
        public Iterator<E> descendingIterator() {
            if (this.m instanceof TreeMap) {
                return ((TreeMap)this.m).descendingKeyIterator();
            }
            return ((NavigableSubMap)this.m).descendingKeyIterator();
        }

        @Override
        public int size() {
            return this.m.size();
        }

        @Override
        public boolean isEmpty() {
            return this.m.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.m.containsKey(o);
        }

        @Override
        public void clear() {
            this.m.clear();
        }

        @Override
        public E lower(E e) {
            return this.m.lowerKey(e);
        }

        @Override
        public E floor(E e) {
            return this.m.floorKey(e);
        }

        @Override
        public E ceiling(E e) {
            return this.m.ceilingKey(e);
        }

        @Override
        public E higher(E e) {
            return this.m.higherKey(e);
        }

        @Override
        public E first() {
            return (E)this.m.firstKey();
        }

        @Override
        public E last() {
            return (E)this.m.lastKey();
        }

        @Override
        public Comparator<? super E> comparator() {
            return this.m.comparator();
        }

        @Override
        public E pollFirst() {
            Map.Entry<E, ?> e = this.m.pollFirstEntry();
            return e == null ? null : (E)e.getKey();
        }

        @Override
        public E pollLast() {
            Map.Entry<E, ?> e = this.m.pollLastEntry();
            return e == null ? null : (E)e.getKey();
        }

        @Override
        public boolean remove(Object o) {
            int oldSize = this.size();
            this.m.remove(o);
            return this.size() != oldSize;
        }

        @Override
        public NavigableSet<E> subSet(E fromElement, boolean fromInclusive, E toElement, boolean toInclusive) {
            return new KeySet<E>(this.m.subMap(fromElement, fromInclusive, toElement, toInclusive));
        }

        @Override
        public NavigableSet<E> headSet(E toElement, boolean inclusive) {
            return new KeySet<E>(this.m.headMap(toElement, inclusive));
        }

        @Override
        public NavigableSet<E> tailSet(E fromElement, boolean inclusive) {
            return new KeySet<E>(this.m.tailMap(fromElement, inclusive));
        }

        @Override
        public SortedSet<E> subSet(E fromElement, E toElement) {
            return this.subSet(fromElement, true, toElement, false);
        }

        @Override
        public SortedSet<E> headSet(E toElement) {
            return this.headSet(toElement, false);
        }

        @Override
        public SortedSet<E> tailSet(E fromElement) {
            return this.tailSet(fromElement, true);
        }

        @Override
        public NavigableSet<E> descendingSet() {
            return new KeySet<E>(this.m.descendingMap());
        }

        @Override
        public Spliterator<E> spliterator() {
            return TreeMap.keySpliteratorFor(this.m);
        }
    }

    class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator(TreeMap.this.getFirstEntry());
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o;
            Object value = entry.getValue();
            TreeMapEntry p = TreeMap.this.getEntry(entry.getKey());
            return p != null && TreeMap.valEquals(p.getValue(), value);
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o;
            Object value = entry.getValue();
            TreeMapEntry p = TreeMap.this.getEntry(entry.getKey());
            if (p != null && TreeMap.valEquals(p.getValue(), value)) {
                TreeMap.this.deleteEntry(p);
                return true;
            }
            return false;
        }

        @Override
        public int size() {
            return TreeMap.this.size();
        }

        @Override
        public void clear() {
            TreeMap.this.clear();
        }

        @Override
        public Spliterator<Map.Entry<K, V>> spliterator() {
            return new EntrySpliterator(TreeMap.this, null, null, 0, -1, 0);
        }
    }

    class Values
    extends AbstractCollection<V> {
        Values() {
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator(TreeMap.this.getFirstEntry());
        }

        @Override
        public int size() {
            return TreeMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return TreeMap.this.containsValue(o);
        }

        @Override
        public boolean remove(Object o) {
            TreeMapEntry e = TreeMap.this.getFirstEntry();
            while (e != null) {
                if (TreeMap.valEquals(e.getValue(), o)) {
                    TreeMap.this.deleteEntry(e);
                    return true;
                }
                e = TreeMap.successor(e);
            }
            return false;
        }

        @Override
        public void clear() {
            TreeMap.this.clear();
        }

        @Override
        public Spliterator<V> spliterator() {
            return new ValueSpliterator(TreeMap.this, null, null, 0, -1, 0);
        }
    }
}

