/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import android.icu.text.TimeZoneNames;
import java.io.IOException;
import java.io.Serializable;
import java.time.ZoneId;
import java.util.Date;
import java.util.Locale;
import java.util.PropertyPermission;
import java.util.SimpleTimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import libcore.io.IoUtils;
import libcore.util.ZoneInfoDB;
import org.apache.harmony.luni.internal.util.TimezoneGetter;

public abstract class TimeZone
implements Serializable,
Cloneable {
    public static final int SHORT = 0;
    public static final int LONG = 1;
    static final long serialVersionUID = 3581463369166924961L;
    private static final TimeZone GMT = new SimpleTimeZone(0, "GMT");
    private static final TimeZone UTC = new SimpleTimeZone(0, "UTC");
    static final TimeZone NO_TIMEZONE = null;
    private String ID;
    private static volatile TimeZone defaultTimeZone;

    public abstract int getOffset(int var1, int var2, int var3, int var4, int var5, int var6);

    public int getOffset(long date) {
        if (this.inDaylightTime(new Date(date))) {
            return this.getRawOffset() + this.getDSTSavings();
        }
        return this.getRawOffset();
    }

    int getOffsets(long date, int[] offsets) {
        int rawoffset = this.getRawOffset();
        int dstoffset = 0;
        if (this.inDaylightTime(new Date(date))) {
            dstoffset = this.getDSTSavings();
        }
        if (offsets != null) {
            offsets[0] = rawoffset;
            offsets[1] = dstoffset;
        }
        return rawoffset + dstoffset;
    }

    public abstract void setRawOffset(int var1);

    public abstract int getRawOffset();

    public String getID() {
        return this.ID;
    }

    public void setID(String ID) {
        if (ID == null) {
            throw new NullPointerException();
        }
        this.ID = ID;
    }

    public final String getDisplayName() {
        return this.getDisplayName(false, 1, Locale.getDefault(Locale.Category.DISPLAY));
    }

    public final String getDisplayName(Locale locale) {
        return this.getDisplayName(false, 1, locale);
    }

    public final String getDisplayName(boolean daylight, int style) {
        return this.getDisplayName(daylight, style, Locale.getDefault(Locale.Category.DISPLAY));
    }

    public String getDisplayName(boolean daylightTime, int style, Locale locale) {
        long now;
        TimeZoneNames names;
        String displayName;
        TimeZoneNames.NameType nameType;
        switch (style) {
            case 0: {
                nameType = daylightTime ? TimeZoneNames.NameType.SHORT_DAYLIGHT : TimeZoneNames.NameType.SHORT_STANDARD;
                break;
            }
            case 1: {
                nameType = daylightTime ? TimeZoneNames.NameType.LONG_DAYLIGHT : TimeZoneNames.NameType.LONG_STANDARD;
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal style: " + style);
            }
        }
        String canonicalID = android.icu.util.TimeZone.getCanonicalID(this.getID());
        if (canonicalID != null && (displayName = (names = TimeZoneNames.getInstance(locale)).getDisplayName(canonicalID, nameType, now = System.currentTimeMillis())) != null) {
            return displayName;
        }
        int offsetMillis = this.getRawOffset();
        if (daylightTime) {
            offsetMillis += this.getDSTSavings();
        }
        return TimeZone.createGmtOffsetString(true, true, offsetMillis);
    }

    public static String createGmtOffsetString(boolean includeGmt, boolean includeMinuteSeparator, int offsetMillis) {
        int offsetMinutes = offsetMillis / 60000;
        char sign = '+';
        if (offsetMinutes < 0) {
            sign = '-';
            offsetMinutes = -offsetMinutes;
        }
        StringBuilder builder = new StringBuilder(9);
        if (includeGmt) {
            builder.append("GMT");
        }
        builder.append(sign);
        TimeZone.appendNumber(builder, 2, offsetMinutes / 60);
        if (includeMinuteSeparator) {
            builder.append(':');
        }
        TimeZone.appendNumber(builder, 2, offsetMinutes % 60);
        return builder.toString();
    }

    private static void appendNumber(StringBuilder builder, int count, int value) {
        String string = Integer.toString(value);
        for (int i = 0; i < count - string.length(); ++i) {
            builder.append('0');
        }
        builder.append(string);
    }

    public int getDSTSavings() {
        if (this.useDaylightTime()) {
            return 3600000;
        }
        return 0;
    }

    public abstract boolean useDaylightTime();

    public boolean observesDaylightTime() {
        return this.useDaylightTime() || this.inDaylightTime(new Date());
    }

    public abstract boolean inDaylightTime(Date var1);

    public static synchronized TimeZone getTimeZone(String id) {
        if (id == null) {
            throw new NullPointerException("id == null");
        }
        if (id.length() == 3) {
            if (id.equals("GMT")) {
                return (TimeZone)GMT.clone();
            }
            if (id.equals("UTC")) {
                return (TimeZone)UTC.clone();
            }
        }
        TimeZone zone = null;
        try {
            zone = ZoneInfoDB.getInstance().makeTimeZone(id);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (zone == null && id.length() > 3 && id.startsWith("GMT")) {
            zone = TimeZone.getCustomTimeZone(id);
        }
        return zone != null ? zone : (TimeZone)GMT.clone();
    }

    public static TimeZone getTimeZone(ZoneId zoneId) {
        String tzid = zoneId.getId();
        char c = tzid.charAt(0);
        if (c == '+' || c == '-') {
            tzid = "GMT" + tzid;
        } else if (c == 'Z' && tzid.length() == 1) {
            tzid = "UTC";
        }
        return TimeZone.getTimeZone(tzid);
    }

    public ZoneId toZoneId() {
        return ZoneId.of(this.getID(), ZoneId.SHORT_IDS);
    }

    private static TimeZone getCustomTimeZone(String id) {
        int hour;
        Matcher m = NoImagePreloadHolder.CUSTOM_ZONE_ID_PATTERN.matcher(id);
        if (!m.matches()) {
            return null;
        }
        int minute = 0;
        try {
            hour = Integer.parseInt(m.group(1));
            if (m.group(3) != null) {
                minute = Integer.parseInt(m.group(3));
            }
        }
        catch (NumberFormatException impossible) {
            throw new AssertionError((Object)impossible);
        }
        if (hour < 0 || hour > 23 || minute < 0 || minute > 59) {
            return null;
        }
        char sign = id.charAt(3);
        int raw = hour * 3600000 + minute * 60000;
        if (sign == '-') {
            raw = -raw;
        }
        String cleanId = String.format(Locale.ROOT, "GMT%c%02d:%02d", Character.valueOf(sign), hour, minute);
        return new SimpleTimeZone(raw, cleanId);
    }

    public static synchronized String[] getAvailableIDs(int rawOffset) {
        return ZoneInfoDB.getInstance().getAvailableIDs(rawOffset);
    }

    public static synchronized String[] getAvailableIDs() {
        return ZoneInfoDB.getInstance().getAvailableIDs();
    }

    private static native String getSystemTimeZoneID(String var0, String var1);

    private static native String getSystemGMTOffsetID();

    public static TimeZone getDefault() {
        return (TimeZone)TimeZone.getDefaultRef().clone();
    }

    static synchronized TimeZone getDefaultRef() {
        if (defaultTimeZone == null) {
            String zoneName;
            TimezoneGetter tzGetter = TimezoneGetter.getInstance();
            String string = zoneName = tzGetter != null ? tzGetter.getId() : null;
            if (zoneName != null) {
                zoneName = zoneName.trim();
            }
            if (zoneName == null || zoneName.isEmpty()) {
                try {
                    zoneName = IoUtils.readFileAsString("/etc/timezone");
                }
                catch (IOException ex) {
                    zoneName = "GMT";
                }
            }
            defaultTimeZone = TimeZone.getTimeZone(zoneName);
        }
        return defaultTimeZone;
    }

    public static synchronized void setDefault(TimeZone timeZone) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new PropertyPermission("user.timezone", "write"));
        }
        defaultTimeZone = timeZone != null ? (TimeZone)timeZone.clone() : null;
        android.icu.util.TimeZone.clearCachedDefault();
    }

    public boolean hasSameRules(TimeZone other) {
        return other != null && this.getRawOffset() == other.getRawOffset() && this.useDaylightTime() == other.useDaylightTime();
    }

    public Object clone() {
        try {
            TimeZone other = (TimeZone)super.clone();
            other.ID = this.ID;
            return other;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e);
        }
    }

    private static class NoImagePreloadHolder {
        public static final Pattern CUSTOM_ZONE_ID_PATTERN = Pattern.compile("^GMT[-+](\\d{1,2})(:?(\\d\\d))?$");

        private NoImagePreloadHolder() {
        }
    }
}

