/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import dalvik.system.VMStack;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.jar.JarEntry;
import sun.reflect.CallerSensitive;
import sun.util.locale.BaseLocale;
import sun.util.locale.LocaleObjectCache;

public abstract class ResourceBundle {
    private static final int INITIAL_CACHE_SIZE = 32;
    private static final ResourceBundle NONEXISTENT_BUNDLE = new ResourceBundle(){

        @Override
        public Enumeration<String> getKeys() {
            return null;
        }

        @Override
        protected Object handleGetObject(String key) {
            return null;
        }

        public String toString() {
            return "NONEXISTENT_BUNDLE";
        }
    };
    private static final ConcurrentMap<CacheKey, BundleReference> cacheList = new ConcurrentHashMap<CacheKey, BundleReference>(32);
    private static final ReferenceQueue<Object> referenceQueue = new ReferenceQueue();
    protected ResourceBundle parent = null;
    private Locale locale = null;
    private String name;
    private volatile boolean expired;
    private volatile CacheKey cacheKey;
    private volatile Set<String> keySet;

    public String getBaseBundleName() {
        return this.name;
    }

    public final String getString(String key) {
        return (String)this.getObject(key);
    }

    public final String[] getStringArray(String key) {
        return (String[])this.getObject(key);
    }

    public final Object getObject(String key) {
        Object obj = this.handleGetObject(key);
        if (obj == null) {
            if (this.parent != null) {
                obj = this.parent.getObject(key);
            }
            if (obj == null) {
                throw new MissingResourceException("Can't find resource for bundle " + this.getClass().getName() + ", key " + key, this.getClass().getName(), key);
            }
        }
        return obj;
    }

    public Locale getLocale() {
        return this.locale;
    }

    private static ClassLoader getLoader(ClassLoader cl) {
        if (cl == null) {
            cl = RBClassLoader.INSTANCE;
        }
        return cl;
    }

    protected void setParent(ResourceBundle parent) {
        assert (parent != NONEXISTENT_BUNDLE);
        this.parent = parent;
    }

    @CallerSensitive
    public static final ResourceBundle getBundle(String baseName) {
        return ResourceBundle.getBundleImpl(baseName, Locale.getDefault(), ResourceBundle.getLoader(VMStack.getCallingClassLoader()), ResourceBundle.getDefaultControl(baseName));
    }

    @CallerSensitive
    public static final ResourceBundle getBundle(String baseName, Control control) {
        return ResourceBundle.getBundleImpl(baseName, Locale.getDefault(), ResourceBundle.getLoader(VMStack.getCallingClassLoader()), control);
    }

    @CallerSensitive
    public static final ResourceBundle getBundle(String baseName, Locale locale) {
        return ResourceBundle.getBundleImpl(baseName, locale, ResourceBundle.getLoader(VMStack.getCallingClassLoader()), ResourceBundle.getDefaultControl(baseName));
    }

    @CallerSensitive
    public static final ResourceBundle getBundle(String baseName, Locale targetLocale, Control control) {
        return ResourceBundle.getBundleImpl(baseName, targetLocale, ResourceBundle.getLoader(VMStack.getCallingClassLoader()), control);
    }

    public static ResourceBundle getBundle(String baseName, Locale locale, ClassLoader loader) {
        if (loader == null) {
            throw new NullPointerException();
        }
        return ResourceBundle.getBundleImpl(baseName, locale, loader, ResourceBundle.getDefaultControl(baseName));
    }

    public static ResourceBundle getBundle(String baseName, Locale targetLocale, ClassLoader loader, Control control) {
        if (loader == null || control == null) {
            throw new NullPointerException();
        }
        return ResourceBundle.getBundleImpl(baseName, targetLocale, loader, control);
    }

    private static Control getDefaultControl(String baseName) {
        return Control.INSTANCE;
    }

    private static ResourceBundle getBundleImpl(String baseName, Locale locale, ClassLoader loader, Control control) {
        if (locale == null || control == null) {
            throw new NullPointerException();
        }
        CacheKey cacheKey = new CacheKey(baseName, locale, loader);
        ResourceBundle bundle = null;
        BundleReference bundleRef = (BundleReference)cacheList.get(cacheKey);
        if (bundleRef != null) {
            bundle = (ResourceBundle)bundleRef.get();
            bundleRef = null;
        }
        if (ResourceBundle.isValidBundle(bundle) && ResourceBundle.hasValidParentChain(bundle)) {
            return bundle;
        }
        boolean isKnownControl = control == Control.INSTANCE || control instanceof SingleFormatControl;
        List<String> formats = control.getFormats(baseName);
        if (!isKnownControl && !ResourceBundle.checkList(formats)) {
            throw new IllegalArgumentException("Invalid Control: getFormats");
        }
        ResourceBundle baseBundle = null;
        Locale targetLocale = locale;
        while (targetLocale != null) {
            List<Locale> candidateLocales = control.getCandidateLocales(baseName, targetLocale);
            if (!isKnownControl && !ResourceBundle.checkList(candidateLocales)) {
                throw new IllegalArgumentException("Invalid Control: getCandidateLocales");
            }
            bundle = ResourceBundle.findBundle(cacheKey, candidateLocales, formats, 0, control, baseBundle);
            if (ResourceBundle.isValidBundle(bundle)) {
                boolean isBaseBundle = Locale.ROOT.equals(bundle.locale);
                if (!isBaseBundle || bundle.locale.equals(locale) || candidateLocales.size() == 1 && bundle.locale.equals(candidateLocales.get(0))) break;
                if (isBaseBundle && baseBundle == null) {
                    baseBundle = bundle;
                }
            }
            targetLocale = control.getFallbackLocale(baseName, targetLocale);
        }
        if (bundle == null) {
            if (baseBundle == null) {
                ResourceBundle.throwMissingResourceException(baseName, locale, cacheKey.getCause());
            }
            bundle = baseBundle;
        }
        return bundle;
    }

    private static boolean checkList(List<?> a) {
        boolean valid;
        boolean bl = valid = a != null && !a.isEmpty();
        if (valid) {
            int size = a.size();
            for (int i = 0; valid && i < size; ++i) {
                valid = a.get(i) != null;
            }
        }
        return valid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ResourceBundle findBundle(CacheKey cacheKey, List<Locale> candidateLocales, List<String> formats, int index, Control control, ResourceBundle baseBundle) {
        Reference<Object> ref;
        Locale targetLocale = candidateLocales.get(index);
        ResourceBundle parent = null;
        if (index != candidateLocales.size() - 1) {
            parent = ResourceBundle.findBundle(cacheKey, candidateLocales, formats, index + 1, control, baseBundle);
        } else if (baseBundle != null && Locale.ROOT.equals(targetLocale)) {
            return baseBundle;
        }
        while ((ref = referenceQueue.poll()) != null) {
            cacheList.remove(((CacheKeyReference)((Object)ref)).getCacheKey());
        }
        boolean expiredBundle = false;
        cacheKey.setLocale(targetLocale);
        ResourceBundle bundle = ResourceBundle.findBundleInCache(cacheKey, control);
        if (ResourceBundle.isValidBundle(bundle) && !(expiredBundle = bundle.expired)) {
            if (bundle.parent == parent) {
                return bundle;
            }
            BundleReference bundleRef = (BundleReference)cacheList.get(cacheKey);
            if (bundleRef != null && bundleRef.get() == bundle) {
                cacheList.remove(cacheKey, bundleRef);
            }
        }
        if (bundle != NONEXISTENT_BUNDLE) {
            CacheKey constKey = (CacheKey)cacheKey.clone();
            try {
                bundle = ResourceBundle.loadBundle(cacheKey, formats, control, expiredBundle);
                if (bundle != null) {
                    if (bundle.parent == null) {
                        bundle.setParent(parent);
                    }
                    bundle.locale = targetLocale;
                    ResourceBundle resourceBundle = bundle = ResourceBundle.putBundleInCache(cacheKey, bundle, control);
                    return resourceBundle;
                }
                ResourceBundle.putBundleInCache(cacheKey, NONEXISTENT_BUNDLE, control);
            }
            finally {
                if (constKey.getCause() instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        return parent;
    }

    private static ResourceBundle loadBundle(CacheKey cacheKey, List<String> formats, Control control, boolean reload) {
        Locale targetLocale = cacheKey.getLocale();
        ResourceBundle bundle = null;
        int size = formats.size();
        for (int i = 0; i < size; ++i) {
            String format = formats.get(i);
            try {
                bundle = control.newBundle(cacheKey.getName(), targetLocale, format, cacheKey.getLoader(), reload);
            }
            catch (LinkageError error) {
                cacheKey.setCause(error);
            }
            catch (Exception cause) {
                cacheKey.setCause(cause);
            }
            if (bundle == null) continue;
            cacheKey.setFormat(format);
            bundle.name = cacheKey.getName();
            bundle.locale = targetLocale;
            bundle.expired = false;
            break;
        }
        return bundle;
    }

    private static boolean isValidBundle(ResourceBundle bundle) {
        return bundle != null && bundle != NONEXISTENT_BUNDLE;
    }

    private static boolean hasValidParentChain(ResourceBundle bundle) {
        long now = System.currentTimeMillis();
        while (bundle != null) {
            long expirationTime;
            if (bundle.expired) {
                return false;
            }
            CacheKey key = bundle.cacheKey;
            if (key != null && (expirationTime = key.expirationTime) >= 0L && expirationTime <= now) {
                return false;
            }
            bundle = bundle.parent;
        }
        return true;
    }

    private static void throwMissingResourceException(String baseName, Locale locale, Throwable cause) {
        if (cause instanceof MissingResourceException) {
            cause = null;
        }
        throw new MissingResourceException("Can't find bundle for base name " + baseName + ", locale " + locale, baseName + "_" + locale, "", cause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ResourceBundle findBundleInCache(CacheKey cacheKey, Control control) {
        BundleReference bundleRef = (BundleReference)cacheList.get(cacheKey);
        if (bundleRef == null) {
            return null;
        }
        ResourceBundle bundle = (ResourceBundle)bundleRef.get();
        if (bundle == null) {
            return null;
        }
        ResourceBundle p = bundle.parent;
        assert (p != NONEXISTENT_BUNDLE);
        if (p != null && p.expired) {
            assert (bundle != NONEXISTENT_BUNDLE);
            bundle.expired = true;
            bundle.cacheKey = null;
            cacheList.remove(cacheKey, bundleRef);
            bundle = null;
        } else {
            CacheKey key = bundleRef.getCacheKey();
            long expirationTime = key.expirationTime;
            if (!bundle.expired && expirationTime >= 0L && expirationTime <= System.currentTimeMillis()) {
                if (bundle != NONEXISTENT_BUNDLE) {
                    ResourceBundle resourceBundle = bundle;
                    synchronized (resourceBundle) {
                        expirationTime = key.expirationTime;
                        if (!bundle.expired && expirationTime >= 0L && expirationTime <= System.currentTimeMillis()) {
                            try {
                                bundle.expired = control.needsReload(key.getName(), key.getLocale(), key.getFormat(), key.getLoader(), bundle, key.loadTime);
                            }
                            catch (Exception e) {
                                cacheKey.setCause(e);
                            }
                            if (bundle.expired) {
                                bundle.cacheKey = null;
                                cacheList.remove(cacheKey, bundleRef);
                            } else {
                                ResourceBundle.setExpirationTime(key, control);
                            }
                        }
                    }
                }
                cacheList.remove(cacheKey, bundleRef);
                bundle = null;
            }
        }
        return bundle;
    }

    private static ResourceBundle putBundleInCache(CacheKey cacheKey, ResourceBundle bundle, Control control) {
        ResourceBundle.setExpirationTime(cacheKey, control);
        if (cacheKey.expirationTime != -1L) {
            CacheKey key = (CacheKey)cacheKey.clone();
            BundleReference bundleRef = new BundleReference(bundle, referenceQueue, key);
            bundle.cacheKey = key;
            BundleReference result = cacheList.putIfAbsent(key, bundleRef);
            if (result != null) {
                ResourceBundle rb = (ResourceBundle)result.get();
                if (rb != null && !rb.expired) {
                    bundle.cacheKey = null;
                    bundle = rb;
                    bundleRef.clear();
                } else {
                    cacheList.put(key, bundleRef);
                }
            }
        }
        return bundle;
    }

    private static void setExpirationTime(CacheKey cacheKey, Control control) {
        long ttl = control.getTimeToLive(cacheKey.getName(), cacheKey.getLocale());
        if (ttl >= 0L) {
            long now = System.currentTimeMillis();
            cacheKey.loadTime = now;
            cacheKey.expirationTime = now + ttl;
        } else if (ttl >= -2L) {
            cacheKey.expirationTime = ttl;
        } else {
            throw new IllegalArgumentException("Invalid Control: TTL=" + ttl);
        }
    }

    @CallerSensitive
    public static final void clearCache() {
        ResourceBundle.clearCache(ResourceBundle.getLoader(VMStack.getCallingClassLoader()));
    }

    public static final void clearCache(ClassLoader loader) {
        if (loader == null) {
            throw new NullPointerException();
        }
        Set set = cacheList.keySet();
        for (CacheKey key : set) {
            if (key.getLoader() != loader) continue;
            set.remove(key);
        }
    }

    protected abstract Object handleGetObject(String var1);

    public abstract Enumeration<String> getKeys();

    public boolean containsKey(String key) {
        if (key == null) {
            throw new NullPointerException();
        }
        ResourceBundle rb = this;
        while (rb != null) {
            if (rb.handleKeySet().contains(key)) {
                return true;
            }
            rb = rb.parent;
        }
        return false;
    }

    public Set<String> keySet() {
        HashSet<String> keys = new HashSet<String>();
        ResourceBundle rb = this;
        while (rb != null) {
            keys.addAll(rb.handleKeySet());
            rb = rb.parent;
        }
        return keys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<String> handleKeySet() {
        if (this.keySet == null) {
            ResourceBundle resourceBundle = this;
            synchronized (resourceBundle) {
                if (this.keySet == null) {
                    HashSet<String> keys = new HashSet<String>();
                    Enumeration<String> enumKeys = this.getKeys();
                    while (enumKeys.hasMoreElements()) {
                        String key = enumKeys.nextElement();
                        if (this.handleGetObject(key) == null) continue;
                        keys.add(key);
                    }
                    this.keySet = keys;
                }
            }
        }
        return this.keySet;
    }

    private static final class NoFallbackControl
    extends SingleFormatControl {
        private static final Control NO_FALLBACK = new NoFallbackControl(FORMAT_DEFAULT);
        private static final Control PROPERTIES_ONLY_NO_FALLBACK = new NoFallbackControl(FORMAT_PROPERTIES);
        private static final Control CLASS_ONLY_NO_FALLBACK = new NoFallbackControl(FORMAT_CLASS);

        protected NoFallbackControl(List<String> formats) {
            super(formats);
        }

        @Override
        public Locale getFallbackLocale(String baseName, Locale locale) {
            if (baseName == null || locale == null) {
                throw new NullPointerException();
            }
            return null;
        }
    }

    private static class SingleFormatControl
    extends Control {
        private static final Control PROPERTIES_ONLY = new SingleFormatControl(FORMAT_PROPERTIES);
        private static final Control CLASS_ONLY = new SingleFormatControl(FORMAT_CLASS);
        private final List<String> formats;

        protected SingleFormatControl(List<String> formats) {
            this.formats = formats;
        }

        @Override
        public List<String> getFormats(String baseName) {
            if (baseName == null) {
                throw new NullPointerException();
            }
            return this.formats;
        }
    }

    public static class Control {
        public static final List<String> FORMAT_DEFAULT = Collections.unmodifiableList(Arrays.asList("java.class", "java.properties"));
        public static final List<String> FORMAT_CLASS = Collections.unmodifiableList(Arrays.asList("java.class"));
        public static final List<String> FORMAT_PROPERTIES = Collections.unmodifiableList(Arrays.asList("java.properties"));
        public static final long TTL_DONT_CACHE = -1L;
        public static final long TTL_NO_EXPIRATION_CONTROL = -2L;
        private static final Control INSTANCE = new Control();
        private static final CandidateListCache CANDIDATES_CACHE = new CandidateListCache();

        protected Control() {
        }

        public static final Control getControl(List<String> formats) {
            if (formats.equals(FORMAT_PROPERTIES)) {
                return SingleFormatControl.PROPERTIES_ONLY;
            }
            if (formats.equals(FORMAT_CLASS)) {
                return SingleFormatControl.CLASS_ONLY;
            }
            if (formats.equals(FORMAT_DEFAULT)) {
                return INSTANCE;
            }
            throw new IllegalArgumentException();
        }

        public static final Control getNoFallbackControl(List<String> formats) {
            if (formats.equals(FORMAT_DEFAULT)) {
                return NoFallbackControl.NO_FALLBACK;
            }
            if (formats.equals(FORMAT_PROPERTIES)) {
                return NoFallbackControl.PROPERTIES_ONLY_NO_FALLBACK;
            }
            if (formats.equals(FORMAT_CLASS)) {
                return NoFallbackControl.CLASS_ONLY_NO_FALLBACK;
            }
            throw new IllegalArgumentException();
        }

        public List<String> getFormats(String baseName) {
            if (baseName == null) {
                throw new NullPointerException();
            }
            return FORMAT_DEFAULT;
        }

        public List<Locale> getCandidateLocales(String baseName, Locale locale) {
            if (baseName == null) {
                throw new NullPointerException();
            }
            return new ArrayList<Locale>((Collection)CANDIDATES_CACHE.get(locale.getBaseLocale()));
        }

        public Locale getFallbackLocale(String baseName, Locale locale) {
            if (baseName == null) {
                throw new NullPointerException();
            }
            Locale defaultLocale = Locale.getDefault();
            return locale.equals(defaultLocale) ? null : defaultLocale;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) throws IllegalAccessException, InstantiationException, IOException {
            String bundleName = this.toBundleName(baseName, locale);
            ResourceBundle bundle = null;
            if (format.equals("java.class")) {
                try {
                    Class<?> bundleClass = loader.loadClass(bundleName);
                    if (!ResourceBundle.class.isAssignableFrom(bundleClass)) {
                        throw new ClassCastException(bundleClass.getName() + " cannot be cast to ResourceBundle");
                    }
                    bundle = (ResourceBundle)bundleClass.newInstance();
                }
                catch (ClassNotFoundException bundleClass) {}
            } else if (format.equals("java.properties")) {
                final String resourceName = this.toResourceName0(bundleName, "properties");
                if (resourceName == null) {
                    return bundle;
                }
                final ClassLoader classLoader = loader;
                final boolean reloadFlag = reload;
                InputStream stream = null;
                try {
                    stream = AccessController.doPrivileged(new PrivilegedExceptionAction<InputStream>(){

                        @Override
                        public InputStream run() throws IOException {
                            InputStream is = null;
                            if (reloadFlag) {
                                URLConnection connection;
                                URL url = classLoader.getResource(resourceName);
                                if (url != null && (connection = url.openConnection()) != null) {
                                    connection.setUseCaches(false);
                                    is = connection.getInputStream();
                                }
                            } else {
                                is = classLoader.getResourceAsStream(resourceName);
                            }
                            return is;
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    throw (IOException)e.getException();
                }
                if (stream != null) {
                    try {
                        bundle = new PropertyResourceBundle(new InputStreamReader(stream, StandardCharsets.UTF_8));
                    }
                    finally {
                        stream.close();
                    }
                }
            } else {
                throw new IllegalArgumentException("unknown format: " + format);
            }
            return bundle;
        }

        public long getTimeToLive(String baseName, Locale locale) {
            if (baseName == null || locale == null) {
                throw new NullPointerException();
            }
            return -2L;
        }

        public boolean needsReload(String baseName, Locale locale, String format, ClassLoader loader, ResourceBundle bundle, long loadTime) {
            if (bundle == null) {
                throw new NullPointerException();
            }
            if (format.equals("java.class") || format.equals("java.properties")) {
                format = format.substring(5);
            }
            boolean result = false;
            try {
                String resourceName = this.toResourceName0(this.toBundleName(baseName, locale), format);
                if (resourceName == null) {
                    return result;
                }
                URL url = loader.getResource(resourceName);
                if (url != null) {
                    long lastModified = 0L;
                    URLConnection connection = url.openConnection();
                    if (connection != null) {
                        connection.setUseCaches(false);
                        if (connection instanceof JarURLConnection) {
                            JarEntry ent = ((JarURLConnection)connection).getJarEntry();
                            if (ent != null && (lastModified = ent.getTime()) == -1L) {
                                lastModified = 0L;
                            }
                        } else {
                            lastModified = connection.getLastModified();
                        }
                    }
                    result = lastModified >= loadTime;
                }
            }
            catch (NullPointerException npe) {
                throw npe;
            }
            catch (Exception exception) {
                // empty catch block
            }
            return result;
        }

        public String toBundleName(String baseName, Locale locale) {
            if (locale == Locale.ROOT) {
                return baseName;
            }
            String language = locale.getLanguage();
            String script = locale.getScript();
            String country = locale.getCountry();
            String variant = locale.getVariant();
            if (language == "" && country == "" && variant == "") {
                return baseName;
            }
            StringBuilder sb = new StringBuilder(baseName);
            sb.append('_');
            if (script != "") {
                if (variant != "") {
                    sb.append(language).append('_').append(script).append('_').append(country).append('_').append(variant);
                } else if (country != "") {
                    sb.append(language).append('_').append(script).append('_').append(country);
                } else {
                    sb.append(language).append('_').append(script);
                }
            } else if (variant != "") {
                sb.append(language).append('_').append(country).append('_').append(variant);
            } else if (country != "") {
                sb.append(language).append('_').append(country);
            } else {
                sb.append(language);
            }
            return sb.toString();
        }

        public final String toResourceName(String bundleName, String suffix) {
            StringBuilder sb = new StringBuilder(bundleName.length() + 1 + suffix.length());
            sb.append(bundleName.replace('.', '/')).append('.').append(suffix);
            return sb.toString();
        }

        private String toResourceName0(String bundleName, String suffix) {
            if (bundleName.contains("://")) {
                return null;
            }
            return this.toResourceName(bundleName, suffix);
        }

        private static class CandidateListCache
        extends LocaleObjectCache<BaseLocale, List<Locale>> {
            private CandidateListCache() {
            }

            @Override
            protected List<Locale> createObject(BaseLocale base) {
                String language = base.getLanguage();
                String script = base.getScript();
                String region = base.getRegion();
                String variant = base.getVariant();
                boolean isNorwegianBokmal = false;
                boolean isNorwegianNynorsk = false;
                if (language.equals("no")) {
                    if (region.equals("NO") && variant.equals("NY")) {
                        variant = "";
                        isNorwegianNynorsk = true;
                    } else {
                        isNorwegianBokmal = true;
                    }
                }
                if (language.equals("nb") || isNorwegianBokmal) {
                    List<Locale> tmpList = CandidateListCache.getDefaultList("nb", script, region, variant);
                    LinkedList<Locale> bokmalList = new LinkedList<Locale>();
                    for (Locale l : tmpList) {
                        bokmalList.add(l);
                        if (l.getLanguage().length() == 0) break;
                        bokmalList.add(Locale.getInstance("no", l.getScript(), l.getCountry(), l.getVariant(), null));
                    }
                    return bokmalList;
                }
                if (language.equals("nn") || isNorwegianNynorsk) {
                    List<Locale> nynorskList = CandidateListCache.getDefaultList("nn", script, region, variant);
                    int idx = nynorskList.size() - 1;
                    nynorskList.add(idx++, Locale.getInstance("no", "NO", "NY"));
                    nynorskList.add(idx++, Locale.getInstance("no", "NO", ""));
                    nynorskList.add(idx++, Locale.getInstance("no", "", ""));
                    return nynorskList;
                }
                if (language.equals("zh")) {
                    if (script.length() == 0 && region.length() > 0) {
                        switch (region) {
                            case "TW": 
                            case "HK": 
                            case "MO": {
                                script = "Hant";
                                break;
                            }
                            case "CN": 
                            case "SG": {
                                script = "Hans";
                            }
                        }
                    } else if (script.length() > 0 && region.length() == 0) {
                        switch (script) {
                            case "Hans": {
                                region = "CN";
                                break;
                            }
                            case "Hant": {
                                region = "TW";
                            }
                        }
                    }
                }
                return CandidateListCache.getDefaultList(language, script, region, variant);
            }

            private static List<Locale> getDefaultList(String language, String script, String region, String variant) {
                LinkedList<String> variants = null;
                if (variant.length() > 0) {
                    variants = new LinkedList<String>();
                    int idx = variant.length();
                    while (idx != -1) {
                        variants.add(variant.substring(0, idx));
                        --idx;
                        idx = variant.lastIndexOf(95, idx);
                    }
                }
                LinkedList<Locale> list = new LinkedList<Locale>();
                if (variants != null) {
                    for (String v : variants) {
                        list.add(Locale.getInstance(language, script, region, v, null));
                    }
                }
                if (region.length() > 0) {
                    list.add(Locale.getInstance(language, script, region, "", null));
                }
                if (script.length() > 0) {
                    list.add(Locale.getInstance(language, script, "", "", null));
                    if (variants != null) {
                        for (String v : variants) {
                            list.add(Locale.getInstance(language, "", region, v, null));
                        }
                    }
                    if (region.length() > 0) {
                        list.add(Locale.getInstance(language, "", region, "", null));
                    }
                }
                if (language.length() > 0) {
                    list.add(Locale.getInstance(language, "", "", "", null));
                }
                list.add(Locale.ROOT);
                return list;
            }
        }
    }

    private static class BundleReference
    extends SoftReference<ResourceBundle>
    implements CacheKeyReference {
        private CacheKey cacheKey;

        BundleReference(ResourceBundle referent, ReferenceQueue<Object> q, CacheKey key) {
            super(referent, q);
            this.cacheKey = key;
        }

        @Override
        public CacheKey getCacheKey() {
            return this.cacheKey;
        }
    }

    private static class LoaderReference
    extends WeakReference<ClassLoader>
    implements CacheKeyReference {
        private CacheKey cacheKey;

        LoaderReference(ClassLoader referent, ReferenceQueue<Object> q, CacheKey key) {
            super(referent, q);
            this.cacheKey = key;
        }

        @Override
        public CacheKey getCacheKey() {
            return this.cacheKey;
        }
    }

    private static interface CacheKeyReference {
        public CacheKey getCacheKey();
    }

    private static class CacheKey
    implements Cloneable {
        private String name;
        private Locale locale;
        private LoaderReference loaderRef;
        private String format;
        private volatile long loadTime;
        private volatile long expirationTime;
        private Throwable cause;
        private int hashCodeCache;

        CacheKey(String baseName, Locale locale, ClassLoader loader) {
            this.name = baseName;
            this.locale = locale;
            this.loaderRef = loader == null ? null : new LoaderReference(loader, referenceQueue, this);
            this.calculateHashCode();
        }

        String getName() {
            return this.name;
        }

        CacheKey setName(String baseName) {
            if (!this.name.equals(baseName)) {
                this.name = baseName;
                this.calculateHashCode();
            }
            return this;
        }

        Locale getLocale() {
            return this.locale;
        }

        CacheKey setLocale(Locale locale) {
            if (!this.locale.equals(locale)) {
                this.locale = locale;
                this.calculateHashCode();
            }
            return this;
        }

        ClassLoader getLoader() {
            return this.loaderRef != null ? (ClassLoader)this.loaderRef.get() : null;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            try {
                CacheKey otherEntry = (CacheKey)other;
                if (this.hashCodeCache != otherEntry.hashCodeCache) {
                    return false;
                }
                if (!this.name.equals(otherEntry.name)) {
                    return false;
                }
                if (!this.locale.equals(otherEntry.locale)) {
                    return false;
                }
                if (this.loaderRef == null) {
                    return otherEntry.loaderRef == null;
                }
                ClassLoader loader = (ClassLoader)this.loaderRef.get();
                return otherEntry.loaderRef != null && loader != null && loader == otherEntry.loaderRef.get();
            }
            catch (ClassCastException | NullPointerException runtimeException) {
                return false;
            }
        }

        public int hashCode() {
            return this.hashCodeCache;
        }

        private void calculateHashCode() {
            this.hashCodeCache = this.name.hashCode() << 3;
            this.hashCodeCache ^= this.locale.hashCode();
            ClassLoader loader = this.getLoader();
            if (loader != null) {
                this.hashCodeCache ^= loader.hashCode();
            }
        }

        public Object clone() {
            try {
                CacheKey clone = (CacheKey)super.clone();
                if (this.loaderRef != null) {
                    clone.loaderRef = new LoaderReference((ClassLoader)this.loaderRef.get(), referenceQueue, clone);
                }
                clone.cause = null;
                return clone;
            }
            catch (CloneNotSupportedException e) {
                throw new InternalError(e);
            }
        }

        String getFormat() {
            return this.format;
        }

        void setFormat(String format) {
            this.format = format;
        }

        private void setCause(Throwable cause) {
            if (this.cause == null) {
                this.cause = cause;
            } else if (this.cause instanceof ClassNotFoundException) {
                this.cause = cause;
            }
        }

        private Throwable getCause() {
            return this.cause;
        }

        public String toString() {
            String l = this.locale.toString();
            if (l.length() == 0) {
                l = this.locale.getVariant().length() != 0 ? "__" + this.locale.getVariant() : "\"\"";
            }
            return "CacheKey[" + this.name + ", lc=" + l + ", ldr=" + this.getLoader() + "(format=" + this.format + ")]";
        }
    }

    private static class RBClassLoader
    extends ClassLoader {
        private static final RBClassLoader INSTANCE = AccessController.doPrivileged(new PrivilegedAction<RBClassLoader>(){

            @Override
            public RBClassLoader run() {
                return new RBClassLoader();
            }
        });
        private static final ClassLoader loader = ClassLoader.getSystemClassLoader();

        private RBClassLoader() {
        }

        @Override
        public Class<?> loadClass(String name) throws ClassNotFoundException {
            if (loader != null) {
                return loader.loadClass(name);
            }
            return Class.forName(name);
        }

        @Override
        public URL getResource(String name) {
            if (loader != null) {
                return loader.getResource(name);
            }
            return ClassLoader.getSystemResource(name);
        }

        @Override
        public InputStream getResourceAsStream(String name) {
            if (loader != null) {
                return loader.getResourceAsStream(name);
            }
            return ClassLoader.getSystemResourceAsStream(name);
        }
    }
}

