/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import libcore.icu.ICU;

public final class Currency
implements Serializable {
    private static final long serialVersionUID = -158308464356906721L;
    private final String currencyCode;
    private static ConcurrentMap<String, Currency> instances = new ConcurrentHashMap<String, Currency>(7);
    private static HashSet<Currency> available;
    private final transient android.icu.util.Currency icuCurrency;

    private Currency(android.icu.util.Currency icuCurrency) {
        this.icuCurrency = icuCurrency;
        this.currencyCode = icuCurrency.getCurrencyCode();
    }

    public static Currency getInstance(String currencyCode) {
        Currency instance = (Currency)instances.get(currencyCode);
        if (instance != null) {
            return instance;
        }
        android.icu.util.Currency icuInstance = android.icu.util.Currency.getInstance(currencyCode);
        if (icuInstance == null) {
            return null;
        }
        Currency currencyVal = new Currency(icuInstance);
        instance = instances.putIfAbsent(currencyCode, currencyVal);
        return instance != null ? instance : currencyVal;
    }

    public static Currency getInstance(Locale locale) {
        String currencyCode;
        android.icu.util.Currency icuInstance = android.icu.util.Currency.getInstance(locale);
        String variant = locale.getVariant();
        String country = locale.getCountry();
        if (!variant.isEmpty() && (variant.equals("EURO") || variant.equals("HK") || variant.equals("PREEURO"))) {
            country = country + "_" + variant;
        }
        if ((currencyCode = ICU.getCurrencyCode(country)) == null) {
            throw new IllegalArgumentException("Unsupported ISO 3166 country: " + locale);
        }
        if (icuInstance == null || icuInstance.getCurrencyCode().equals("XXX")) {
            return null;
        }
        return Currency.getInstance(currencyCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<Currency> getAvailableCurrencies() {
        Class<Currency> clazz = Currency.class;
        synchronized (Currency.class) {
            if (available == null) {
                Set<android.icu.util.Currency> icuAvailableCurrencies = android.icu.util.Currency.getAvailableCurrencies();
                available = new HashSet();
                for (android.icu.util.Currency icuCurrency : icuAvailableCurrencies) {
                    Currency currency = Currency.getInstance(icuCurrency.getCurrencyCode());
                    if (currency == null) {
                        currency = new Currency(icuCurrency);
                        instances.put(currency.currencyCode, currency);
                    }
                    available.add(currency);
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            Set result = (Set)available.clone();
            return result;
        }
    }

    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public String getSymbol() {
        return this.getSymbol(Locale.getDefault(Locale.Category.DISPLAY));
    }

    public String getSymbol(Locale locale) {
        if (locale == null) {
            throw new NullPointerException("locale == null");
        }
        return this.icuCurrency.getSymbol(locale);
    }

    public int getDefaultFractionDigits() {
        if (this.icuCurrency.getCurrencyCode().equals("XXX")) {
            return -1;
        }
        return this.icuCurrency.getDefaultFractionDigits();
    }

    public int getNumericCode() {
        return this.icuCurrency.getNumericCode();
    }

    public String getDisplayName() {
        return this.getDisplayName(Locale.getDefault(Locale.Category.DISPLAY));
    }

    public String getDisplayName(Locale locale) {
        return this.icuCurrency.getDisplayName(Objects.requireNonNull(locale));
    }

    public String toString() {
        return this.icuCurrency.toString();
    }

    private Object readResolve() {
        return Currency.getInstance(this.currencyCode);
    }
}

