/*
 * Decompiled with CFR 0.152.
 */
package java.time.zone;

import android.icu.impl.OlsonTimeZone;
import android.icu.impl.ZoneMeta;
import android.icu.util.AnnualTimeZoneRule;
import android.icu.util.DateTimeRule;
import android.icu.util.InitialTimeZoneRule;
import android.icu.util.TimeZone;
import android.icu.util.TimeZoneRule;
import android.icu.util.TimeZoneTransition;
import java.time.DayOfWeek;
import java.time.LocalTime;
import java.time.Month;
import java.time.ZoneOffset;
import java.time.zone.ZoneOffsetTransition;
import java.time.zone.ZoneOffsetTransitionRule;
import java.time.zone.ZoneRules;
import java.time.zone.ZoneRulesException;
import java.time.zone.ZoneRulesProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import libcore.util.BasicLruCache;

public class IcuZoneRulesProvider
extends ZoneRulesProvider {
    private static final int MAX_TRANSITIONS = 10000;
    private static final int SECONDS_IN_DAY = 86400;
    private final BasicLruCache<String, ZoneRules> cache = new ZoneRulesCache(8);

    @Override
    protected Set<String> provideZoneIds() {
        Set<String> zoneIds = ZoneMeta.getAvailableIDs(TimeZone.SystemTimeZoneType.ANY, null, null);
        zoneIds = new HashSet<String>(zoneIds);
        zoneIds.remove("GMT+0");
        zoneIds.remove("GMT-0");
        return zoneIds;
    }

    @Override
    protected ZoneRules provideRules(String zoneId, boolean forCaching) {
        return this.cache.get(zoneId);
    }

    @Override
    protected NavigableMap<String, ZoneRules> provideVersions(String zoneId) {
        return new TreeMap<String, ZoneRules>(Collections.singletonMap(TimeZone.getTZDataVersion(), this.provideRules(zoneId, false)));
    }

    /*
     * Enabled aggressive block sorting
     */
    static ZoneRules generateZoneRules(String zoneId) {
        TimeZone timeZone = TimeZone.getFrozenTimeZone(zoneId);
        IcuZoneRulesProvider.verify(timeZone instanceof OlsonTimeZone, zoneId, "Unexpected time zone class " + timeZone.getClass());
        OlsonTimeZone tz = (OlsonTimeZone)timeZone;
        TimeZoneRule[] rules = tz.getTimeZoneRules();
        InitialTimeZoneRule initial = (InitialTimeZoneRule)rules[0];
        ZoneOffset baseStandardOffset = IcuZoneRulesProvider.millisToOffset(initial.getRawOffset());
        ZoneOffset baseWallOffset = IcuZoneRulesProvider.millisToOffset(initial.getRawOffset() + initial.getDSTSavings());
        ArrayList<ZoneOffsetTransition> standardOffsetTransitionList = new ArrayList<ZoneOffsetTransition>();
        ArrayList<ZoneOffsetTransition> transitionList = new ArrayList<ZoneOffsetTransition>();
        ArrayList<ZoneOffsetTransitionRule> lastRules = new ArrayList<ZoneOffsetTransitionRule>();
        int preLastDstSavings = 0;
        TimeZoneRule last1 = null;
        AnnualTimeZoneRule last2 = null;
        TimeZoneTransition transition = tz.getNextTransition(Long.MIN_VALUE, false);
        int transitionCount = 1;
        while (transition != null) {
            block7: {
                int toTotalOffset;
                int fromTotalOffset;
                TimeZoneRule from = transition.getFrom();
                TimeZoneRule to = transition.getTo();
                boolean hadEffect = false;
                if (from.getRawOffset() != to.getRawOffset()) {
                    standardOffsetTransitionList.add(new ZoneOffsetTransition(TimeUnit.MILLISECONDS.toSeconds(transition.getTime()), IcuZoneRulesProvider.millisToOffset(from.getRawOffset()), IcuZoneRulesProvider.millisToOffset(to.getRawOffset())));
                    hadEffect = true;
                }
                if ((fromTotalOffset = from.getRawOffset() + from.getDSTSavings()) != (toTotalOffset = to.getRawOffset() + to.getDSTSavings())) {
                    transitionList.add(new ZoneOffsetTransition(TimeUnit.MILLISECONDS.toSeconds(transition.getTime()), IcuZoneRulesProvider.millisToOffset(fromTotalOffset), IcuZoneRulesProvider.millisToOffset(toTotalOffset)));
                    hadEffect = true;
                }
                IcuZoneRulesProvider.verify(hadEffect, zoneId, "Transition changed neither total nor raw offset.");
                if (to instanceof AnnualTimeZoneRule) {
                    if (last1 == null) {
                        preLastDstSavings = from.getDSTSavings();
                        last1 = (AnnualTimeZoneRule)to;
                        IcuZoneRulesProvider.verify(((AnnualTimeZoneRule)last1).getEndYear() == Integer.MAX_VALUE, zoneId, "AnnualTimeZoneRule is not permanent.");
                        break block7;
                    } else {
                        last2 = (AnnualTimeZoneRule)to;
                        IcuZoneRulesProvider.verify(last2.getEndYear() == Integer.MAX_VALUE, zoneId, "AnnualTimeZoneRule is not permanent.");
                        transition = tz.getNextTransition(transition.getTime(), false);
                        IcuZoneRulesProvider.verify(transition.getTo() == last1, zoneId, "Unexpected rule after 2 AnnualTimeZoneRules.");
                        break;
                    }
                }
                IcuZoneRulesProvider.verify(last1 == null, zoneId, "Unexpected rule after AnnualTimeZoneRule.");
            }
            IcuZoneRulesProvider.verify(transitionCount <= 10000, zoneId, "More than 10000 transitions.");
            transition = tz.getNextTransition(transition.getTime(), false);
            ++transitionCount;
        }
        if (last1 != null) {
            IcuZoneRulesProvider.verify(last2 != null, zoneId, "Only one AnnualTimeZoneRule.");
            lastRules.add(IcuZoneRulesProvider.toZoneOffsetTransitionRule(last1, preLastDstSavings));
            lastRules.add(IcuZoneRulesProvider.toZoneOffsetTransitionRule(last2, last1.getDSTSavings()));
        }
        return ZoneRules.of(baseStandardOffset, baseWallOffset, standardOffsetTransitionList, transitionList, lastRules);
    }

    private static void verify(boolean check, String zoneId, String message) {
        if (!check) {
            throw new ZoneRulesException(String.format("Failed verification of zone %s: %s", zoneId, message));
        }
    }

    private static ZoneOffsetTransitionRule toZoneOffsetTransitionRule(AnnualTimeZoneRule rule, int dstSavingMillisBefore) {
        ZoneOffsetTransitionRule.TimeDefinition timeDefinition;
        boolean timeEndOfDay;
        LocalTime time;
        int dayOfMonthIndicator;
        DateTimeRule dateTimeRule = rule.getRule();
        Month month = Month.JANUARY.plus(dateTimeRule.getRuleMonth());
        DayOfWeek dayOfWeek = DayOfWeek.SATURDAY.plus(dateTimeRule.getRuleDayOfWeek());
        switch (dateTimeRule.getDateRuleType()) {
            case 0: {
                dayOfMonthIndicator = dateTimeRule.getRuleDayOfMonth();
                dayOfWeek = null;
                break;
            }
            case 2: {
                dayOfMonthIndicator = dateTimeRule.getRuleDayOfMonth();
                break;
            }
            case 3: {
                dayOfMonthIndicator = -month.maxLength() + dateTimeRule.getRuleDayOfMonth() - 1;
                break;
            }
            case 1: {
                throw new ZoneRulesException("Date rule type DOW is unsupported");
            }
            default: {
                throw new ZoneRulesException("Unexpected date rule type: " + dateTimeRule.getDateRuleType());
            }
        }
        int secondOfDay = (int)TimeUnit.MILLISECONDS.toSeconds(dateTimeRule.getRuleMillisInDay());
        if (secondOfDay == 86400) {
            time = LocalTime.MIDNIGHT;
            timeEndOfDay = true;
        } else {
            time = LocalTime.ofSecondOfDay(secondOfDay);
            timeEndOfDay = false;
        }
        switch (dateTimeRule.getTimeRuleType()) {
            case 0: {
                timeDefinition = ZoneOffsetTransitionRule.TimeDefinition.WALL;
                break;
            }
            case 1: {
                timeDefinition = ZoneOffsetTransitionRule.TimeDefinition.STANDARD;
                break;
            }
            case 2: {
                timeDefinition = ZoneOffsetTransitionRule.TimeDefinition.UTC;
                break;
            }
            default: {
                throw new ZoneRulesException("Unexpected time rule type " + dateTimeRule.getTimeRuleType());
            }
        }
        ZoneOffset standardOffset = IcuZoneRulesProvider.millisToOffset(rule.getRawOffset());
        ZoneOffset offsetBefore = IcuZoneRulesProvider.millisToOffset(rule.getRawOffset() + dstSavingMillisBefore);
        ZoneOffset offsetAfter = IcuZoneRulesProvider.millisToOffset(rule.getRawOffset() + rule.getDSTSavings());
        return ZoneOffsetTransitionRule.of(month, dayOfMonthIndicator, dayOfWeek, time, timeEndOfDay, timeDefinition, standardOffset, offsetBefore, offsetAfter);
    }

    private static ZoneOffset millisToOffset(int offset) {
        return ZoneOffset.ofTotalSeconds((int)TimeUnit.MILLISECONDS.toSeconds(offset));
    }

    private static class ZoneRulesCache
    extends BasicLruCache<String, ZoneRules> {
        ZoneRulesCache(int maxSize) {
            super(maxSize);
        }

        @Override
        protected ZoneRules create(String zoneId) {
            String canonicalId = TimeZone.getCanonicalID(zoneId);
            if (!canonicalId.equals(zoneId)) {
                return (ZoneRules)this.get(canonicalId);
            }
            return IcuZoneRulesProvider.generateZoneRules(zoneId);
        }
    }
}

