/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.text.BreakIterator;
import java.text.CharacterIterator;

class IcuIteratorWrapper
extends BreakIterator {
    private android.icu.text.BreakIterator wrapped;

    IcuIteratorWrapper(android.icu.text.BreakIterator iterator) {
        this.wrapped = iterator;
    }

    @Override
    public Object clone() {
        IcuIteratorWrapper result = (IcuIteratorWrapper)super.clone();
        result.wrapped = (android.icu.text.BreakIterator)this.wrapped.clone();
        return result;
    }

    public boolean equals(Object that) {
        if (!(that instanceof IcuIteratorWrapper)) {
            return false;
        }
        return this.wrapped.equals(((IcuIteratorWrapper)that).wrapped);
    }

    public String toString() {
        return this.wrapped.toString();
    }

    public int hashCode() {
        return this.wrapped.hashCode();
    }

    @Override
    public int first() {
        return this.wrapped.first();
    }

    @Override
    public int last() {
        return this.wrapped.last();
    }

    @Override
    public int next(int n) {
        return this.wrapped.next(n);
    }

    @Override
    public int next() {
        return this.wrapped.next();
    }

    @Override
    public int previous() {
        return this.wrapped.previous();
    }

    protected static final void checkOffset(int offset, CharacterIterator text) {
        if (offset < text.getBeginIndex() || offset > text.getEndIndex()) {
            throw new IllegalArgumentException("offset out of bounds");
        }
    }

    @Override
    public int following(int offset) {
        CharacterIterator text = this.getText();
        IcuIteratorWrapper.checkOffset(offset, text);
        return this.wrapped.following(offset);
    }

    @Override
    public int preceding(int offset) {
        CharacterIterator text = this.getText();
        IcuIteratorWrapper.checkOffset(offset, text);
        return this.wrapped.preceding(offset);
    }

    @Override
    public boolean isBoundary(int offset) {
        CharacterIterator text = this.getText();
        IcuIteratorWrapper.checkOffset(offset, text);
        return this.wrapped.isBoundary(offset);
    }

    @Override
    public int current() {
        return this.wrapped.current();
    }

    @Override
    public CharacterIterator getText() {
        return this.wrapped.getText();
    }

    @Override
    public void setText(String newText) {
        this.wrapped.setText(newText);
    }

    @Override
    public void setText(CharacterIterator newText) {
        newText.current();
        this.wrapped.setText(newText);
    }
}

