/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import android.icu.math.BigDecimal;
import android.icu.text.NumberFormat;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.text.DecimalFormatSymbols;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Currency;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import libcore.icu.LocaleData;

public class DecimalFormat
extends NumberFormat {
    private transient android.icu.text.DecimalFormat icuDecimalFormat;
    private static final int currentSerialVersion = 4;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("positivePrefix", String.class), new ObjectStreamField("positiveSuffix", String.class), new ObjectStreamField("negativePrefix", String.class), new ObjectStreamField("negativeSuffix", String.class), new ObjectStreamField("posPrefixPattern", String.class), new ObjectStreamField("posSuffixPattern", String.class), new ObjectStreamField("negPrefixPattern", String.class), new ObjectStreamField("negSuffixPattern", String.class), new ObjectStreamField("multiplier", Integer.TYPE), new ObjectStreamField("groupingSize", Byte.TYPE), new ObjectStreamField("groupingUsed", Boolean.TYPE), new ObjectStreamField("decimalSeparatorAlwaysShown", Boolean.TYPE), new ObjectStreamField("parseBigDecimal", Boolean.TYPE), new ObjectStreamField("roundingMode", RoundingMode.class), new ObjectStreamField("symbols", DecimalFormatSymbols.class), new ObjectStreamField("useExponentialNotation", Boolean.TYPE), new ObjectStreamField("minExponentDigits", Byte.TYPE), new ObjectStreamField("maximumIntegerDigits", Integer.TYPE), new ObjectStreamField("minimumIntegerDigits", Integer.TYPE), new ObjectStreamField("maximumFractionDigits", Integer.TYPE), new ObjectStreamField("minimumFractionDigits", Integer.TYPE), new ObjectStreamField("serialVersionOnStream", Integer.TYPE)};
    private DecimalFormatSymbols symbols;
    private int maximumIntegerDigits;
    private int minimumIntegerDigits;
    private int maximumFractionDigits;
    private int minimumFractionDigits;
    private RoundingMode roundingMode = RoundingMode.HALF_EVEN;
    static final int DOUBLE_INTEGER_DIGITS = 309;
    static final int DOUBLE_FRACTION_DIGITS = 340;
    static final int MAXIMUM_INTEGER_DIGITS = Integer.MAX_VALUE;
    static final int MAXIMUM_FRACTION_DIGITS = Integer.MAX_VALUE;
    static final long serialVersionUID = 864413376551465018L;
    private static final ConcurrentMap<Locale, String> cachedLocaleData = new ConcurrentHashMap<Locale, String>(3);

    public DecimalFormat() {
        Locale def = Locale.getDefault(Locale.Category.FORMAT);
        String pattern = (String)cachedLocaleData.get(def);
        if (pattern == null) {
            pattern = LocaleData.get((Locale)def).numberPattern;
            cachedLocaleData.putIfAbsent(def, pattern);
        }
        this.symbols = new DecimalFormatSymbols(def);
        this.init(pattern);
    }

    public DecimalFormat(String pattern) {
        this.symbols = new DecimalFormatSymbols(Locale.getDefault(Locale.Category.FORMAT));
        this.init(pattern);
    }

    public DecimalFormat(String pattern, DecimalFormatSymbols symbols) {
        this.symbols = (DecimalFormatSymbols)symbols.clone();
        this.init(pattern);
    }

    private void init(String pattern) {
        this.icuDecimalFormat = new android.icu.text.DecimalFormat(pattern, this.symbols.getIcuDecimalFormatSymbols());
        this.updateFieldsFromIcu();
    }

    private static FieldPosition getIcuFieldPosition(FieldPosition fp) {
        NumberFormat.Field attribute;
        if (fp.getFieldAttribute() == null) {
            return fp;
        }
        if (fp.getFieldAttribute() == NumberFormat.Field.INTEGER) {
            attribute = NumberFormat.Field.INTEGER;
        } else if (fp.getFieldAttribute() == NumberFormat.Field.FRACTION) {
            attribute = NumberFormat.Field.FRACTION;
        } else if (fp.getFieldAttribute() == NumberFormat.Field.DECIMAL_SEPARATOR) {
            attribute = NumberFormat.Field.DECIMAL_SEPARATOR;
        } else if (fp.getFieldAttribute() == NumberFormat.Field.EXPONENT_SYMBOL) {
            attribute = NumberFormat.Field.EXPONENT_SYMBOL;
        } else if (fp.getFieldAttribute() == NumberFormat.Field.EXPONENT_SIGN) {
            attribute = NumberFormat.Field.EXPONENT_SIGN;
        } else if (fp.getFieldAttribute() == NumberFormat.Field.EXPONENT) {
            attribute = NumberFormat.Field.EXPONENT;
        } else if (fp.getFieldAttribute() == NumberFormat.Field.GROUPING_SEPARATOR) {
            attribute = NumberFormat.Field.GROUPING_SEPARATOR;
        } else if (fp.getFieldAttribute() == NumberFormat.Field.CURRENCY) {
            attribute = NumberFormat.Field.CURRENCY;
        } else if (fp.getFieldAttribute() == NumberFormat.Field.PERCENT) {
            attribute = NumberFormat.Field.PERCENT;
        } else if (fp.getFieldAttribute() == NumberFormat.Field.PERMILLE) {
            attribute = NumberFormat.Field.PERMILLE;
        } else if (fp.getFieldAttribute() == NumberFormat.Field.SIGN) {
            attribute = NumberFormat.Field.SIGN;
        } else {
            throw new IllegalArgumentException("Unexpected field position attribute type.");
        }
        FieldPosition icuFieldPosition = new FieldPosition(attribute);
        icuFieldPosition.setBeginIndex(fp.getBeginIndex());
        icuFieldPosition.setEndIndex(fp.getEndIndex());
        return icuFieldPosition;
    }

    private static NumberFormat.Field toJavaFieldAttribute(AttributedCharacterIterator.Attribute icuAttribute) {
        if (icuAttribute.getName().equals(NumberFormat.Field.INTEGER.getName())) {
            return NumberFormat.Field.INTEGER;
        }
        if (icuAttribute.getName().equals(NumberFormat.Field.CURRENCY.getName())) {
            return NumberFormat.Field.CURRENCY;
        }
        if (icuAttribute.getName().equals(NumberFormat.Field.DECIMAL_SEPARATOR.getName())) {
            return NumberFormat.Field.DECIMAL_SEPARATOR;
        }
        if (icuAttribute.getName().equals(NumberFormat.Field.EXPONENT.getName())) {
            return NumberFormat.Field.EXPONENT;
        }
        if (icuAttribute.getName().equals(NumberFormat.Field.EXPONENT_SIGN.getName())) {
            return NumberFormat.Field.EXPONENT_SIGN;
        }
        if (icuAttribute.getName().equals(NumberFormat.Field.EXPONENT_SYMBOL.getName())) {
            return NumberFormat.Field.EXPONENT_SYMBOL;
        }
        if (icuAttribute.getName().equals(NumberFormat.Field.FRACTION.getName())) {
            return NumberFormat.Field.FRACTION;
        }
        if (icuAttribute.getName().equals(NumberFormat.Field.GROUPING_SEPARATOR.getName())) {
            return NumberFormat.Field.GROUPING_SEPARATOR;
        }
        if (icuAttribute.getName().equals(NumberFormat.Field.SIGN.getName())) {
            return NumberFormat.Field.SIGN;
        }
        if (icuAttribute.getName().equals(NumberFormat.Field.PERCENT.getName())) {
            return NumberFormat.Field.PERCENT;
        }
        if (icuAttribute.getName().equals(NumberFormat.Field.PERMILLE.getName())) {
            return NumberFormat.Field.PERMILLE;
        }
        throw new IllegalArgumentException("Unrecognized attribute: " + icuAttribute.getName());
    }

    @Override
    public final StringBuffer format(Object number, StringBuffer toAppendTo, FieldPosition pos) {
        if (number instanceof Long || number instanceof Integer || number instanceof Short || number instanceof Byte || number instanceof AtomicInteger || number instanceof AtomicLong || number instanceof BigInteger && ((BigInteger)number).bitLength() < 64) {
            return this.format(((Number)number).longValue(), toAppendTo, pos);
        }
        if (number instanceof java.math.BigDecimal) {
            return this.format((java.math.BigDecimal)number, toAppendTo, pos);
        }
        if (number instanceof BigInteger) {
            return this.format((BigInteger)number, toAppendTo, pos);
        }
        if (number instanceof Number) {
            return this.format(((Number)number).doubleValue(), toAppendTo, pos);
        }
        throw new IllegalArgumentException("Cannot format given Object as a Number");
    }

    @Override
    public StringBuffer format(double number, StringBuffer result, FieldPosition fieldPosition) {
        FieldPosition icuFieldPosition = DecimalFormat.getIcuFieldPosition(fieldPosition);
        this.icuDecimalFormat.format(number, result, icuFieldPosition);
        fieldPosition.setBeginIndex(icuFieldPosition.getBeginIndex());
        fieldPosition.setEndIndex(icuFieldPosition.getEndIndex());
        return result;
    }

    @Override
    public StringBuffer format(long number, StringBuffer result, FieldPosition fieldPosition) {
        FieldPosition icuFieldPosition = DecimalFormat.getIcuFieldPosition(fieldPosition);
        this.icuDecimalFormat.format(number, result, icuFieldPosition);
        fieldPosition.setBeginIndex(icuFieldPosition.getBeginIndex());
        fieldPosition.setEndIndex(icuFieldPosition.getEndIndex());
        return result;
    }

    private StringBuffer format(java.math.BigDecimal number, StringBuffer result, FieldPosition fieldPosition) {
        FieldPosition icuFieldPosition = DecimalFormat.getIcuFieldPosition(fieldPosition);
        this.icuDecimalFormat.format(number, result, fieldPosition);
        fieldPosition.setBeginIndex(icuFieldPosition.getBeginIndex());
        fieldPosition.setEndIndex(icuFieldPosition.getEndIndex());
        return result;
    }

    private StringBuffer format(BigInteger number, StringBuffer result, FieldPosition fieldPosition) {
        FieldPosition icuFieldPosition = DecimalFormat.getIcuFieldPosition(fieldPosition);
        this.icuDecimalFormat.format(number, result, fieldPosition);
        fieldPosition.setBeginIndex(icuFieldPosition.getBeginIndex());
        fieldPosition.setEndIndex(icuFieldPosition.getEndIndex());
        return result;
    }

    @Override
    public AttributedCharacterIterator formatToCharacterIterator(Object obj) {
        if (obj == null) {
            throw new NullPointerException("object == null");
        }
        AttributedCharacterIterator original = this.icuDecimalFormat.formatToCharacterIterator(obj);
        StringBuilder textBuilder = new StringBuilder(original.getEndIndex() - original.getBeginIndex());
        for (int i = original.getBeginIndex(); i < original.getEndIndex(); ++i) {
            textBuilder.append(original.current());
            original.next();
        }
        AttributedString result = new AttributedString(textBuilder.toString());
        for (int i = original.getBeginIndex(); i < original.getEndIndex(); ++i) {
            original.setIndex(i);
            for (AttributedCharacterIterator.Attribute attribute : original.getAttributes().keySet()) {
                int start = original.getRunStart();
                int end = original.getRunLimit();
                NumberFormat.Field javaAttr = DecimalFormat.toJavaFieldAttribute(attribute);
                result.addAttribute(javaAttr, javaAttr, start, end);
            }
        }
        return result.getIterator();
    }

    @Override
    public Number parse(String text, ParsePosition pos) {
        if (pos.index < 0 || pos.index >= text.length()) {
            return null;
        }
        Number number = this.icuDecimalFormat.parse(text, pos);
        if (number == null) {
            return null;
        }
        if (this.isParseBigDecimal()) {
            if (number instanceof Long) {
                return new java.math.BigDecimal(number.longValue());
            }
            if (number instanceof Double && !((Double)number).isInfinite() && !((Double)number).isNaN()) {
                return new java.math.BigDecimal(number.toString());
            }
            if (number instanceof Double && (((Double)number).isNaN() || ((Double)number).isInfinite())) {
                return number;
            }
            if (number instanceof BigDecimal) {
                return ((BigDecimal)number).toBigDecimal();
            }
        }
        if (number instanceof BigDecimal || number instanceof BigInteger) {
            return number.doubleValue();
        }
        if (this.isParseIntegerOnly() && number.equals(new Double(-0.0))) {
            return 0L;
        }
        return number;
    }

    public DecimalFormatSymbols getDecimalFormatSymbols() {
        return DecimalFormatSymbols.fromIcuInstance(this.icuDecimalFormat.getDecimalFormatSymbols());
    }

    public void setDecimalFormatSymbols(DecimalFormatSymbols newSymbols) {
        try {
            this.symbols = (DecimalFormatSymbols)newSymbols.clone();
            this.icuDecimalFormat.setDecimalFormatSymbols(this.symbols.getIcuDecimalFormatSymbols());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getPositivePrefix() {
        return this.icuDecimalFormat.getPositivePrefix();
    }

    public void setPositivePrefix(String newValue) {
        this.icuDecimalFormat.setPositivePrefix(newValue);
    }

    public String getNegativePrefix() {
        return this.icuDecimalFormat.getNegativePrefix();
    }

    public void setNegativePrefix(String newValue) {
        this.icuDecimalFormat.setNegativePrefix(newValue);
    }

    public String getPositiveSuffix() {
        return this.icuDecimalFormat.getPositiveSuffix();
    }

    public void setPositiveSuffix(String newValue) {
        this.icuDecimalFormat.setPositiveSuffix(newValue);
    }

    public String getNegativeSuffix() {
        return this.icuDecimalFormat.getNegativeSuffix();
    }

    public void setNegativeSuffix(String newValue) {
        this.icuDecimalFormat.setNegativeSuffix(newValue);
    }

    public int getMultiplier() {
        return this.icuDecimalFormat.getMultiplier();
    }

    public void setMultiplier(int newValue) {
        this.icuDecimalFormat.setMultiplier(newValue);
    }

    public int getGroupingSize() {
        return this.icuDecimalFormat.getGroupingSize();
    }

    public void setGroupingSize(int newValue) {
        this.icuDecimalFormat.setGroupingSize(newValue);
    }

    @Override
    public boolean isGroupingUsed() {
        return this.icuDecimalFormat.isGroupingUsed();
    }

    @Override
    public void setGroupingUsed(boolean newValue) {
        this.icuDecimalFormat.setGroupingUsed(newValue);
    }

    public boolean isDecimalSeparatorAlwaysShown() {
        return this.icuDecimalFormat.isDecimalSeparatorAlwaysShown();
    }

    public void setDecimalSeparatorAlwaysShown(boolean newValue) {
        this.icuDecimalFormat.setDecimalSeparatorAlwaysShown(newValue);
    }

    public boolean isParseBigDecimal() {
        return this.icuDecimalFormat.isParseBigDecimal();
    }

    public void setParseBigDecimal(boolean newValue) {
        this.icuDecimalFormat.setParseBigDecimal(newValue);
    }

    @Override
    public void setParseIntegerOnly(boolean value) {
        super.setParseIntegerOnly(value);
        this.icuDecimalFormat.setParseIntegerOnly(value);
    }

    @Override
    public boolean isParseIntegerOnly() {
        return this.icuDecimalFormat.isParseIntegerOnly();
    }

    @Override
    public Object clone() {
        try {
            DecimalFormat other = (DecimalFormat)super.clone();
            other.icuDecimalFormat = (android.icu.text.DecimalFormat)this.icuDecimalFormat.clone();
            other.symbols = (DecimalFormatSymbols)this.symbols.clone();
            return other;
        }
        catch (Exception e) {
            throw new InternalError();
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DecimalFormat)) {
            return false;
        }
        DecimalFormat other = (DecimalFormat)obj;
        return this.icuDecimalFormat.equals(other.icuDecimalFormat) && this.compareIcuRoundingIncrement(other.icuDecimalFormat);
    }

    private boolean compareIcuRoundingIncrement(android.icu.text.DecimalFormat other) {
        java.math.BigDecimal increment = this.icuDecimalFormat.getRoundingIncrement();
        if (increment != null) {
            return other.getRoundingIncrement() != null && increment.equals(other.getRoundingIncrement());
        }
        return other.getRoundingIncrement() == null;
    }

    @Override
    public int hashCode() {
        return super.hashCode() * 37 + this.getPositivePrefix().hashCode();
    }

    public String toPattern() {
        return this.icuDecimalFormat.toPattern();
    }

    public String toLocalizedPattern() {
        return this.icuDecimalFormat.toLocalizedPattern();
    }

    public void applyPattern(String pattern) {
        this.icuDecimalFormat.applyPattern(pattern);
        this.updateFieldsFromIcu();
    }

    public void applyLocalizedPattern(String pattern) {
        this.icuDecimalFormat.applyLocalizedPattern(pattern);
        this.updateFieldsFromIcu();
    }

    private void updateFieldsFromIcu() {
        if (this.icuDecimalFormat.getMaximumIntegerDigits() == 309) {
            this.icuDecimalFormat.setMaximumIntegerDigits(2000000000);
        }
        this.maximumIntegerDigits = this.icuDecimalFormat.getMaximumIntegerDigits();
        this.minimumIntegerDigits = this.icuDecimalFormat.getMinimumIntegerDigits();
        this.maximumFractionDigits = this.icuDecimalFormat.getMaximumFractionDigits();
        this.minimumFractionDigits = this.icuDecimalFormat.getMinimumFractionDigits();
    }

    @Override
    public void setMaximumIntegerDigits(int newValue) {
        this.maximumIntegerDigits = Math.min(Math.max(0, newValue), Integer.MAX_VALUE);
        super.setMaximumIntegerDigits(this.maximumIntegerDigits > 309 ? 309 : this.maximumIntegerDigits);
        if (this.minimumIntegerDigits > this.maximumIntegerDigits) {
            this.minimumIntegerDigits = this.maximumIntegerDigits;
            super.setMinimumIntegerDigits(this.minimumIntegerDigits > 309 ? 309 : this.minimumIntegerDigits);
        }
        this.icuDecimalFormat.setMaximumIntegerDigits(this.getMaximumIntegerDigits());
    }

    @Override
    public void setMinimumIntegerDigits(int newValue) {
        this.minimumIntegerDigits = Math.min(Math.max(0, newValue), Integer.MAX_VALUE);
        super.setMinimumIntegerDigits(this.minimumIntegerDigits > 309 ? 309 : this.minimumIntegerDigits);
        if (this.minimumIntegerDigits > this.maximumIntegerDigits) {
            this.maximumIntegerDigits = this.minimumIntegerDigits;
            super.setMaximumIntegerDigits(this.maximumIntegerDigits > 309 ? 309 : this.maximumIntegerDigits);
        }
        this.icuDecimalFormat.setMinimumIntegerDigits(this.getMinimumIntegerDigits());
    }

    @Override
    public void setMaximumFractionDigits(int newValue) {
        this.maximumFractionDigits = Math.min(Math.max(0, newValue), Integer.MAX_VALUE);
        super.setMaximumFractionDigits(this.maximumFractionDigits > 340 ? 340 : this.maximumFractionDigits);
        if (this.minimumFractionDigits > this.maximumFractionDigits) {
            this.minimumFractionDigits = this.maximumFractionDigits;
            super.setMinimumFractionDigits(this.minimumFractionDigits > 340 ? 340 : this.minimumFractionDigits);
        }
        this.icuDecimalFormat.setMaximumFractionDigits(this.getMaximumFractionDigits());
    }

    @Override
    public void setMinimumFractionDigits(int newValue) {
        this.minimumFractionDigits = Math.min(Math.max(0, newValue), Integer.MAX_VALUE);
        super.setMinimumFractionDigits(this.minimumFractionDigits > 340 ? 340 : this.minimumFractionDigits);
        if (this.minimumFractionDigits > this.maximumFractionDigits) {
            this.maximumFractionDigits = this.minimumFractionDigits;
            super.setMaximumFractionDigits(this.maximumFractionDigits > 340 ? 340 : this.maximumFractionDigits);
        }
        this.icuDecimalFormat.setMinimumFractionDigits(this.getMinimumFractionDigits());
    }

    @Override
    public int getMaximumIntegerDigits() {
        return this.maximumIntegerDigits;
    }

    @Override
    public int getMinimumIntegerDigits() {
        return this.minimumIntegerDigits;
    }

    @Override
    public int getMaximumFractionDigits() {
        return this.maximumFractionDigits;
    }

    @Override
    public int getMinimumFractionDigits() {
        return this.minimumFractionDigits;
    }

    @Override
    public Currency getCurrency() {
        return this.symbols.getCurrency();
    }

    @Override
    public void setCurrency(Currency currency) {
        if (currency != this.symbols.getCurrency() || !currency.getSymbol().equals(this.symbols.getCurrencySymbol())) {
            this.symbols.setCurrency(currency);
            this.icuDecimalFormat.setDecimalFormatSymbols(this.symbols.getIcuDecimalFormatSymbols());
            this.icuDecimalFormat.setMinimumFractionDigits(this.minimumFractionDigits);
            this.icuDecimalFormat.setMaximumFractionDigits(this.maximumFractionDigits);
        }
    }

    @Override
    public RoundingMode getRoundingMode() {
        return this.roundingMode;
    }

    private static int convertRoundingMode(RoundingMode rm) {
        switch (rm) {
            case UP: {
                return 0;
            }
            case DOWN: {
                return 1;
            }
            case CEILING: {
                return 2;
            }
            case FLOOR: {
                return 3;
            }
            case HALF_UP: {
                return 4;
            }
            case HALF_DOWN: {
                return 5;
            }
            case HALF_EVEN: {
                return 6;
            }
            case UNNECESSARY: {
                return 7;
            }
        }
        throw new IllegalArgumentException("Invalid rounding mode specified");
    }

    @Override
    public void setRoundingMode(RoundingMode roundingMode) {
        if (roundingMode == null) {
            throw new NullPointerException();
        }
        this.roundingMode = roundingMode;
        this.icuDecimalFormat.setRoundingMode(DecimalFormat.convertRoundingMode(roundingMode));
    }

    void adjustForCurrencyDefaultFractionDigits() {
        int digits;
        Currency currency = this.symbols.getCurrency();
        if (currency == null) {
            try {
                currency = Currency.getInstance(this.symbols.getInternationalCurrencySymbol());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (currency != null && (digits = currency.getDefaultFractionDigits()) != -1) {
            int oldMinDigits = this.getMinimumFractionDigits();
            if (oldMinDigits == this.getMaximumFractionDigits()) {
                this.setMinimumFractionDigits(digits);
                this.setMaximumFractionDigits(digits);
            } else {
                this.setMinimumFractionDigits(Math.min(digits, oldMinDigits));
                this.setMaximumFractionDigits(digits);
            }
        }
    }

    private void writeObject(ObjectOutputStream stream) throws IOException, ClassNotFoundException {
        ObjectOutputStream.PutField fields = stream.putFields();
        fields.put("positivePrefix", this.icuDecimalFormat.getPositivePrefix());
        fields.put("positiveSuffix", this.icuDecimalFormat.getPositiveSuffix());
        fields.put("negativePrefix", this.icuDecimalFormat.getNegativePrefix());
        fields.put("negativeSuffix", this.icuDecimalFormat.getNegativeSuffix());
        fields.put("posPrefixPattern", null);
        fields.put("posSuffixPattern", null);
        fields.put("negPrefixPattern", null);
        fields.put("negSuffixPattern", null);
        fields.put("multiplier", this.icuDecimalFormat.getMultiplier());
        fields.put("groupingSize", (byte)this.icuDecimalFormat.getGroupingSize());
        fields.put("groupingUsed", this.icuDecimalFormat.isGroupingUsed());
        fields.put("decimalSeparatorAlwaysShown", this.icuDecimalFormat.isDecimalSeparatorAlwaysShown());
        fields.put("parseBigDecimal", this.icuDecimalFormat.isParseBigDecimal());
        fields.put("roundingMode", (Object)this.roundingMode);
        fields.put("symbols", this.symbols);
        fields.put("useExponentialNotation", false);
        fields.put("minExponentDigits", (byte)0);
        fields.put("maximumIntegerDigits", this.icuDecimalFormat.getMaximumIntegerDigits());
        fields.put("minimumIntegerDigits", this.icuDecimalFormat.getMinimumIntegerDigits());
        fields.put("maximumFractionDigits", this.icuDecimalFormat.getMaximumFractionDigits());
        fields.put("minimumFractionDigits", this.icuDecimalFormat.getMinimumFractionDigits());
        fields.put("serialVersionOnStream", 4);
        stream.writeFields();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField fields = stream.readFields();
        this.symbols = (DecimalFormatSymbols)fields.get("symbols", null);
        this.init("");
        this.icuDecimalFormat.setPositivePrefix((String)fields.get("positivePrefix", ""));
        this.icuDecimalFormat.setPositiveSuffix((String)fields.get("positiveSuffix", ""));
        this.icuDecimalFormat.setNegativePrefix((String)fields.get("negativePrefix", "-"));
        this.icuDecimalFormat.setNegativeSuffix((String)fields.get("negativeSuffix", ""));
        this.icuDecimalFormat.setMultiplier(fields.get("multiplier", 1));
        this.icuDecimalFormat.setGroupingSize(fields.get("groupingSize", (byte)3));
        this.icuDecimalFormat.setGroupingUsed(fields.get("groupingUsed", true));
        this.icuDecimalFormat.setDecimalSeparatorAlwaysShown(fields.get("decimalSeparatorAlwaysShown", false));
        this.setRoundingMode((RoundingMode)((Object)fields.get("roundingMode", (Object)RoundingMode.HALF_EVEN)));
        int maximumIntegerDigits = fields.get("maximumIntegerDigits", 309);
        int minimumIntegerDigits = fields.get("minimumIntegerDigits", 309);
        int maximumFractionDigits = fields.get("maximumFractionDigits", 340);
        int minimumFractionDigits = fields.get("minimumFractionDigits", 340);
        this.icuDecimalFormat.setMaximumIntegerDigits(maximumIntegerDigits);
        super.setMaximumIntegerDigits(this.icuDecimalFormat.getMaximumIntegerDigits());
        this.setMinimumIntegerDigits(minimumIntegerDigits);
        this.setMinimumFractionDigits(minimumFractionDigits);
        this.setMaximumFractionDigits(maximumFractionDigits);
        this.setParseBigDecimal(fields.get("parseBigDecimal", false));
        if (fields.get("serialVersionOnStream", 0) < 3) {
            this.setMaximumIntegerDigits(super.getMaximumIntegerDigits());
            this.setMinimumIntegerDigits(super.getMinimumIntegerDigits());
            this.setMaximumFractionDigits(super.getMaximumFractionDigits());
            this.setMinimumFractionDigits(super.getMinimumFractionDigits());
        }
    }
}

