/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import libcore.icu.ICU;
import libcore.icu.LocaleData;
import libcore.icu.TimeZoneNames;

public class DateFormatSymbols
implements Serializable,
Cloneable {
    String[] eras = null;
    String[] months = null;
    String[] shortMonths = null;
    String[] weekdays = null;
    String[] shortWeekdays = null;
    String[] ampms = null;
    String[][] zoneStrings = null;
    transient boolean isZoneStringsSet = false;
    static final String patternChars = "GyMdkHmsSEDFwWahKzZYuXLc";
    static final int PATTERN_ERA = 0;
    static final int PATTERN_YEAR = 1;
    static final int PATTERN_MONTH = 2;
    static final int PATTERN_DAY_OF_MONTH = 3;
    static final int PATTERN_HOUR_OF_DAY1 = 4;
    static final int PATTERN_HOUR_OF_DAY0 = 5;
    static final int PATTERN_MINUTE = 6;
    static final int PATTERN_SECOND = 7;
    static final int PATTERN_MILLISECOND = 8;
    static final int PATTERN_DAY_OF_WEEK = 9;
    static final int PATTERN_DAY_OF_YEAR = 10;
    static final int PATTERN_DAY_OF_WEEK_IN_MONTH = 11;
    static final int PATTERN_WEEK_OF_YEAR = 12;
    static final int PATTERN_WEEK_OF_MONTH = 13;
    static final int PATTERN_AM_PM = 14;
    static final int PATTERN_HOUR1 = 15;
    static final int PATTERN_HOUR0 = 16;
    static final int PATTERN_ZONE_NAME = 17;
    static final int PATTERN_ZONE_VALUE = 18;
    static final int PATTERN_WEEK_YEAR = 19;
    static final int PATTERN_ISO_DAY_OF_WEEK = 20;
    static final int PATTERN_ISO_ZONE = 21;
    static final int PATTERN_MONTH_STANDALONE = 22;
    static final int PATTERN_STANDALONE_DAY_OF_WEEK = 23;
    String localPatternChars = null;
    Locale locale = null;
    static final long serialVersionUID = -5987973545549424702L;
    static final int currentSerialVersion = 1;
    private int serialVersionOnStream = 1;
    private String[] tinyMonths;
    private String[] tinyWeekdays;
    private String[] standAloneMonths;
    private String[] shortStandAloneMonths;
    private String[] tinyStandAloneMonths;
    private String[] standAloneWeekdays;
    private String[] shortStandAloneWeekdays;
    private String[] tinyStandAloneWeekdays;
    static final int millisPerHour = 3600000;
    private static final ConcurrentMap<Locale, SoftReference<DateFormatSymbols>> cachedInstances = new ConcurrentHashMap<Locale, SoftReference<DateFormatSymbols>>(3);
    private transient int lastZoneIndex = 0;
    volatile transient int cachedHashCode = 0;

    public DateFormatSymbols() {
        this.initializeData(Locale.getDefault(Locale.Category.FORMAT));
    }

    public DateFormatSymbols(Locale locale) {
        this.initializeData(locale);
    }

    public static Locale[] getAvailableLocales() {
        return ICU.getAvailableLocales();
    }

    public static final DateFormatSymbols getInstance() {
        return DateFormatSymbols.getInstance(Locale.getDefault(Locale.Category.FORMAT));
    }

    public static final DateFormatSymbols getInstance(Locale locale) {
        return (DateFormatSymbols)DateFormatSymbols.getCachedInstance(locale).clone();
    }

    static final DateFormatSymbols getInstanceRef(Locale locale) {
        return DateFormatSymbols.getCachedInstance(locale);
    }

    private static DateFormatSymbols getCachedInstance(Locale locale) {
        SoftReference<DateFormatSymbols> x;
        SoftReference<DateFormatSymbols> ref = (SoftReference<DateFormatSymbols>)cachedInstances.get(locale);
        DateFormatSymbols dfs = null;
        if ((ref == null || (dfs = (DateFormatSymbols)ref.get()) == null) && (x = cachedInstances.putIfAbsent(locale, ref = new SoftReference<DateFormatSymbols>(dfs = new DateFormatSymbols(locale)))) != null) {
            DateFormatSymbols y = x.get();
            if (y != null) {
                dfs = y;
            } else {
                cachedInstances.put(locale, ref);
            }
        }
        return dfs;
    }

    public String[] getEras() {
        return Arrays.copyOf(this.eras, this.eras.length);
    }

    public void setEras(String[] newEras) {
        this.eras = Arrays.copyOf(newEras, newEras.length);
        this.cachedHashCode = 0;
    }

    public String[] getMonths() {
        return Arrays.copyOf(this.months, this.months.length);
    }

    public void setMonths(String[] newMonths) {
        this.months = Arrays.copyOf(newMonths, newMonths.length);
        this.cachedHashCode = 0;
    }

    public String[] getShortMonths() {
        return Arrays.copyOf(this.shortMonths, this.shortMonths.length);
    }

    public void setShortMonths(String[] newShortMonths) {
        this.shortMonths = Arrays.copyOf(newShortMonths, newShortMonths.length);
        this.cachedHashCode = 0;
    }

    public String[] getWeekdays() {
        return Arrays.copyOf(this.weekdays, this.weekdays.length);
    }

    public void setWeekdays(String[] newWeekdays) {
        this.weekdays = Arrays.copyOf(newWeekdays, newWeekdays.length);
        this.cachedHashCode = 0;
    }

    public String[] getShortWeekdays() {
        return Arrays.copyOf(this.shortWeekdays, this.shortWeekdays.length);
    }

    public void setShortWeekdays(String[] newShortWeekdays) {
        this.shortWeekdays = Arrays.copyOf(newShortWeekdays, newShortWeekdays.length);
        this.cachedHashCode = 0;
    }

    public String[] getAmPmStrings() {
        return Arrays.copyOf(this.ampms, this.ampms.length);
    }

    public void setAmPmStrings(String[] newAmpms) {
        this.ampms = Arrays.copyOf(newAmpms, newAmpms.length);
        this.cachedHashCode = 0;
    }

    public String[][] getZoneStrings() {
        return this.getZoneStringsImpl(true);
    }

    public void setZoneStrings(String[][] newZoneStrings) {
        String[][] aCopy = new String[newZoneStrings.length][];
        for (int i = 0; i < newZoneStrings.length; ++i) {
            int len = newZoneStrings[i].length;
            if (len < 5) {
                throw new IllegalArgumentException();
            }
            aCopy[i] = Arrays.copyOf(newZoneStrings[i], len);
        }
        this.zoneStrings = aCopy;
        this.isZoneStringsSet = true;
    }

    public String getLocalPatternChars() {
        return this.localPatternChars;
    }

    public void setLocalPatternChars(String newLocalPatternChars) {
        this.localPatternChars = newLocalPatternChars.toString();
        this.cachedHashCode = 0;
    }

    String[] getTinyMonths() {
        return this.tinyMonths;
    }

    String[] getStandAloneMonths() {
        return this.standAloneMonths;
    }

    String[] getShortStandAloneMonths() {
        return this.shortStandAloneMonths;
    }

    String[] getTinyStandAloneMonths() {
        return this.tinyStandAloneMonths;
    }

    String[] getTinyWeekdays() {
        return this.tinyWeekdays;
    }

    String[] getStandAloneWeekdays() {
        return this.standAloneWeekdays;
    }

    String[] getShortStandAloneWeekdays() {
        return this.shortStandAloneWeekdays;
    }

    String[] getTinyStandAloneWeekdays() {
        return this.tinyStandAloneWeekdays;
    }

    public Object clone() {
        try {
            DateFormatSymbols other = (DateFormatSymbols)super.clone();
            this.copyMembers(this, other);
            return other;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e);
        }
    }

    public int hashCode() {
        int hashCode = this.cachedHashCode;
        if (hashCode == 0) {
            hashCode = 5;
            hashCode = 11 * hashCode + Arrays.hashCode(this.eras);
            hashCode = 11 * hashCode + Arrays.hashCode(this.months);
            hashCode = 11 * hashCode + Arrays.hashCode(this.shortMonths);
            hashCode = 11 * hashCode + Arrays.hashCode(this.weekdays);
            hashCode = 11 * hashCode + Arrays.hashCode(this.shortWeekdays);
            hashCode = 11 * hashCode + Arrays.hashCode(this.ampms);
            this.cachedHashCode = hashCode = 11 * hashCode + Objects.hashCode(this.localPatternChars);
        }
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DateFormatSymbols that = (DateFormatSymbols)obj;
        if (!(Arrays.equals(this.eras, that.eras) && Arrays.equals(this.months, that.months) && Arrays.equals(this.shortMonths, that.shortMonths) && Arrays.equals(this.tinyMonths, that.tinyMonths) && Arrays.equals(this.weekdays, that.weekdays) && Arrays.equals(this.shortWeekdays, that.shortWeekdays) && Arrays.equals(this.tinyWeekdays, that.tinyWeekdays) && Arrays.equals(this.standAloneMonths, that.standAloneMonths) && Arrays.equals(this.shortStandAloneMonths, that.shortStandAloneMonths) && Arrays.equals(this.tinyStandAloneMonths, that.tinyStandAloneMonths) && Arrays.equals(this.standAloneWeekdays, that.standAloneWeekdays) && Arrays.equals(this.shortStandAloneWeekdays, that.shortStandAloneWeekdays) && Arrays.equals(this.tinyStandAloneWeekdays, that.tinyStandAloneWeekdays) && Arrays.equals(this.ampms, that.ampms) && (this.localPatternChars != null && this.localPatternChars.equals(that.localPatternChars) || this.localPatternChars == null && that.localPatternChars == null))) {
            return false;
        }
        if (!this.isZoneStringsSet && !that.isZoneStringsSet && Objects.equals(this.locale, that.locale)) {
            return true;
        }
        return Arrays.deepEquals((Object[])this.getZoneStringsWrapper(), (Object[])that.getZoneStringsWrapper());
    }

    private void initializeData(Locale desiredLocale) {
        DateFormatSymbols dfs;
        this.locale = desiredLocale;
        SoftReference ref = (SoftReference)cachedInstances.get(this.locale);
        if (ref != null && (dfs = (DateFormatSymbols)ref.get()) != null) {
            this.copyMembers(dfs, this);
            return;
        }
        this.locale = LocaleData.mapInvalidAndNullLocales(this.locale);
        LocaleData localeData = LocaleData.get(this.locale);
        this.eras = localeData.eras;
        this.months = localeData.longMonthNames;
        this.shortMonths = localeData.shortMonthNames;
        this.ampms = localeData.amPm;
        this.localPatternChars = patternChars;
        this.weekdays = localeData.longWeekdayNames;
        this.shortWeekdays = localeData.shortWeekdayNames;
        this.initializeSupplementaryData(localeData);
    }

    private void initializeSupplementaryData(LocaleData localeData) {
        this.tinyMonths = localeData.tinyMonthNames;
        this.tinyWeekdays = localeData.tinyWeekdayNames;
        this.standAloneMonths = localeData.longStandAloneMonthNames;
        this.shortStandAloneMonths = localeData.shortStandAloneMonthNames;
        this.tinyStandAloneMonths = localeData.tinyStandAloneMonthNames;
        this.standAloneWeekdays = localeData.longStandAloneWeekdayNames;
        this.shortStandAloneWeekdays = localeData.shortStandAloneWeekdayNames;
        this.tinyStandAloneWeekdays = localeData.tinyStandAloneWeekdayNames;
    }

    final int getZoneIndex(String ID) {
        String[][] zoneStrings = this.getZoneStringsWrapper();
        if (this.lastZoneIndex < zoneStrings.length && ID.equals(zoneStrings[this.lastZoneIndex][0])) {
            return this.lastZoneIndex;
        }
        for (int index = 0; index < zoneStrings.length; ++index) {
            if (!ID.equals(zoneStrings[index][0])) continue;
            this.lastZoneIndex = index;
            return index;
        }
        return -1;
    }

    final String[][] getZoneStringsWrapper() {
        if (this.isSubclassObject()) {
            return this.getZoneStrings();
        }
        return this.getZoneStringsImpl(false);
    }

    private final synchronized String[][] internalZoneStrings() {
        if (this.zoneStrings == null) {
            this.zoneStrings = TimeZoneNames.getZoneStrings(this.locale);
        }
        return this.zoneStrings;
    }

    private final String[][] getZoneStringsImpl(boolean needsCopy) {
        String[][] zoneStrings = this.internalZoneStrings();
        if (!needsCopy) {
            return zoneStrings;
        }
        int len = zoneStrings.length;
        String[][] aCopy = new String[len][];
        for (int i = 0; i < len; ++i) {
            aCopy[i] = Arrays.copyOf(zoneStrings[i], zoneStrings[i].length);
        }
        return aCopy;
    }

    private boolean isSubclassObject() {
        return !this.getClass().getName().equals("java.text.DateFormatSymbols");
    }

    private void copyMembers(DateFormatSymbols src, DateFormatSymbols dst) {
        dst.eras = Arrays.copyOf(src.eras, src.eras.length);
        dst.months = Arrays.copyOf(src.months, src.months.length);
        dst.shortMonths = Arrays.copyOf(src.shortMonths, src.shortMonths.length);
        dst.weekdays = Arrays.copyOf(src.weekdays, src.weekdays.length);
        dst.shortWeekdays = Arrays.copyOf(src.shortWeekdays, src.shortWeekdays.length);
        dst.ampms = Arrays.copyOf(src.ampms, src.ampms.length);
        dst.zoneStrings = src.zoneStrings != null ? src.getZoneStringsImpl(true) : (String[][])null;
        dst.localPatternChars = src.localPatternChars;
        dst.cachedHashCode = 0;
        dst.tinyMonths = src.tinyMonths;
        dst.tinyWeekdays = src.tinyWeekdays;
        dst.standAloneMonths = src.standAloneMonths;
        dst.shortStandAloneMonths = src.shortStandAloneMonths;
        dst.tinyStandAloneMonths = src.tinyStandAloneMonths;
        dst.standAloneWeekdays = src.standAloneWeekdays;
        dst.shortStandAloneWeekdays = src.shortStandAloneWeekdays;
        dst.tinyStandAloneWeekdays = src.tinyStandAloneWeekdays;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        if (this.serialVersionOnStream < 1) {
            LocaleData localeData = LocaleData.get(this.locale);
            this.initializeSupplementaryData(localeData);
        }
        this.serialVersionOnStream = 1;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        this.internalZoneStrings();
        stream.defaultWriteObject();
    }
}

