/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.text.CollationKey;
import java.text.RuleBasedCollator;
import java.util.Comparator;
import java.util.Locale;
import libcore.icu.ICU;

public abstract class Collator
implements Comparator<Object>,
Cloneable {
    public static final int PRIMARY = 0;
    public static final int SECONDARY = 1;
    public static final int TERTIARY = 2;
    public static final int IDENTICAL = 3;
    public static final int NO_DECOMPOSITION = 0;
    public static final int CANONICAL_DECOMPOSITION = 1;
    public static final int FULL_DECOMPOSITION = 2;
    android.icu.text.Collator icuColl;

    public static synchronized Collator getInstance() {
        return Collator.getInstance(Locale.getDefault());
    }

    public static synchronized Collator getInstance(Locale desiredLocale) {
        if (desiredLocale == null) {
            throw new NullPointerException("locale == null");
        }
        return new RuleBasedCollator((android.icu.text.RuleBasedCollator)android.icu.text.Collator.getInstance(desiredLocale));
    }

    @Override
    public abstract int compare(String var1, String var2);

    @Override
    public int compare(Object o1, Object o2) {
        return this.compare((String)o1, (String)o2);
    }

    public abstract CollationKey getCollationKey(String var1);

    public boolean equals(String source, String target) {
        return this.compare(source, target) == 0;
    }

    public synchronized int getStrength() {
        int value = this.icuColl.getStrength();
        return value == 15 ? 3 : value;
    }

    public synchronized void setStrength(int newStrength) {
        if (newStrength == 3) {
            newStrength = 15;
        }
        this.icuColl.setStrength(newStrength);
    }

    public synchronized int getDecomposition() {
        return this.decompositionMode_ICU_Java(this.icuColl.getDecomposition());
    }

    public synchronized void setDecomposition(int decompositionMode) {
        this.icuColl.setDecomposition(this.decompositionMode_Java_ICU(decompositionMode));
    }

    public static synchronized Locale[] getAvailableLocales() {
        return ICU.getAvailableCollatorLocales();
    }

    private int decompositionMode_Java_ICU(int mode) {
        switch (mode) {
            case 1: {
                return 17;
            }
            case 0: {
                return 16;
            }
        }
        throw new IllegalArgumentException("Bad mode: " + mode);
    }

    private int decompositionMode_ICU_Java(int mode) {
        int javaMode = mode;
        switch (mode) {
            case 16: {
                javaMode = 0;
                break;
            }
            case 17: {
                javaMode = 1;
            }
        }
        return javaMode;
    }

    public Object clone() {
        try {
            Collator clone = (Collator)super.clone();
            clone.icuColl = (android.icu.text.Collator)this.icuColl.clone();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (this.getClass() != that.getClass()) {
            return false;
        }
        Collator other = (Collator)that;
        return this.icuColl == null ? other.icuColl == null : this.icuColl.equals(other.icuColl);
    }

    public abstract int hashCode();

    protected Collator() {
        this.icuColl = android.icu.text.RuleBasedCollator.getInstance(Locale.getDefault());
    }

    Collator(android.icu.text.Collator icuColl) {
        this.icuColl = icuColl;
    }
}

