/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.Security;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import sun.security.util.Debug;

public abstract class Provider
extends Properties {
    static final long serialVersionUID = -4298000515446427739L;
    private volatile boolean registered = false;
    private static final Debug debug = Debug.getInstance("provider", "Provider");
    private String name;
    private String info;
    private double version;
    private transient Set<Map.Entry<Object, Object>> entrySet = null;
    private transient int entrySetCallCount = 0;
    private transient boolean initialized;
    private transient boolean legacyChanged;
    private transient boolean servicesChanged;
    private transient Map<String, String> legacyStrings;
    private transient Map<ServiceKey, Service> serviceMap;
    private transient Map<ServiceKey, Service> legacyMap;
    private transient Set<Service> serviceSet;
    private static final String ALIAS_PREFIX = "Alg.Alias.";
    private static final String ALIAS_PREFIX_LOWER = "alg.alias.";
    private static final int ALIAS_LENGTH = "Alg.Alias.".length();
    private static volatile ServiceKey previousKey = new ServiceKey("", "", false);
    private static final Map<String, EngineDescription> knownEngines = new HashMap<String, EngineDescription>();

    protected Provider(String name, double version, String info) {
        this.name = name;
        this.version = version;
        this.info = info;
        this.putId();
        this.initialized = true;
    }

    public String getName() {
        return this.name;
    }

    public double getVersion() {
        return this.version;
    }

    public String getInfo() {
        return this.info;
    }

    @Override
    public String toString() {
        return this.name + " version " + this.version;
    }

    @Override
    public synchronized void clear() {
        this.check("clearProviderProperties." + this.name);
        if (debug != null) {
            debug.println("Remove " + this.name + " provider properties");
        }
        this.implClear();
    }

    @Override
    public synchronized void load(InputStream inStream) throws IOException {
        this.check("putProviderProperty." + this.name);
        if (debug != null) {
            debug.println("Load " + this.name + " provider properties");
        }
        Properties tempProperties = new Properties();
        tempProperties.load(inStream);
        this.implPutAll(tempProperties);
    }

    @Override
    public synchronized void putAll(Map<?, ?> t) {
        this.check("putProviderProperty." + this.name);
        if (debug != null) {
            debug.println("Put all " + this.name + " provider properties");
        }
        this.implPutAll(t);
    }

    @Override
    public synchronized Set<Map.Entry<Object, Object>> entrySet() {
        this.checkInitialized();
        if (this.entrySet == null) {
            if (this.entrySetCallCount++ == 0) {
                this.entrySet = Collections.unmodifiableMap(this).entrySet();
            } else {
                return super.entrySet();
            }
        }
        if (this.entrySetCallCount != 2) {
            throw new RuntimeException("Internal error.");
        }
        return this.entrySet;
    }

    @Override
    public Set<Object> keySet() {
        this.checkInitialized();
        return Collections.unmodifiableSet(super.keySet());
    }

    @Override
    public Collection<Object> values() {
        this.checkInitialized();
        return Collections.unmodifiableCollection(super.values());
    }

    @Override
    public synchronized Object put(Object key, Object value) {
        this.check("putProviderProperty." + this.name);
        if (debug != null) {
            debug.println("Set " + this.name + " provider property [" + key + "/" + value + "]");
        }
        return this.implPut(key, value);
    }

    @Override
    public synchronized Object putIfAbsent(Object key, Object value) {
        this.check("putProviderProperty." + this.name);
        if (debug != null) {
            debug.println("Set " + this.name + " provider property [" + key + "/" + value + "]");
        }
        return this.implPutIfAbsent(key, value);
    }

    @Override
    public synchronized Object remove(Object key) {
        this.check("removeProviderProperty." + this.name);
        if (debug != null) {
            debug.println("Remove " + this.name + " provider property " + key);
        }
        return this.implRemove(key);
    }

    @Override
    public synchronized boolean remove(Object key, Object value) {
        this.check("removeProviderProperty." + this.name);
        if (debug != null) {
            debug.println("Remove " + this.name + " provider property " + key);
        }
        return this.implRemove(key, value);
    }

    @Override
    public synchronized boolean replace(Object key, Object oldValue, Object newValue) {
        this.check("putProviderProperty." + this.name);
        if (debug != null) {
            debug.println("Replace " + this.name + " provider property " + key);
        }
        return this.implReplace(key, oldValue, newValue);
    }

    @Override
    public synchronized Object replace(Object key, Object value) {
        this.check("putProviderProperty." + this.name);
        if (debug != null) {
            debug.println("Replace " + this.name + " provider property " + key);
        }
        return this.implReplace(key, value);
    }

    @Override
    public synchronized void replaceAll(BiFunction<? super Object, ? super Object, ? extends Object> function) {
        this.check("putProviderProperty." + this.name);
        if (debug != null) {
            debug.println("ReplaceAll " + this.name + " provider property ");
        }
        this.implReplaceAll(function);
    }

    @Override
    public synchronized Object compute(Object key, BiFunction<? super Object, ? super Object, ? extends Object> remappingFunction) {
        this.check("putProviderProperty." + this.name);
        this.check("removeProviderProperty" + this.name);
        if (debug != null) {
            debug.println("Compute " + this.name + " provider property " + key);
        }
        return this.implCompute(key, remappingFunction);
    }

    @Override
    public synchronized Object computeIfAbsent(Object key, Function<? super Object, ? extends Object> mappingFunction) {
        this.check("putProviderProperty." + this.name);
        this.check("removeProviderProperty" + this.name);
        if (debug != null) {
            debug.println("ComputeIfAbsent " + this.name + " provider property " + key);
        }
        return this.implComputeIfAbsent(key, mappingFunction);
    }

    @Override
    public synchronized Object computeIfPresent(Object key, BiFunction<? super Object, ? super Object, ? extends Object> remappingFunction) {
        this.check("putProviderProperty." + this.name);
        this.check("removeProviderProperty" + this.name);
        if (debug != null) {
            debug.println("ComputeIfPresent " + this.name + " provider property " + key);
        }
        return this.implComputeIfPresent(key, remappingFunction);
    }

    @Override
    public synchronized Object merge(Object key, Object value, BiFunction<? super Object, ? super Object, ? extends Object> remappingFunction) {
        this.check("putProviderProperty." + this.name);
        this.check("removeProviderProperty" + this.name);
        if (debug != null) {
            debug.println("Merge " + this.name + " provider property " + key);
        }
        return this.implMerge(key, value, remappingFunction);
    }

    @Override
    public Object get(Object key) {
        this.checkInitialized();
        return super.get(key);
    }

    @Override
    public synchronized Object getOrDefault(Object key, Object defaultValue) {
        this.checkInitialized();
        return super.getOrDefault(key, defaultValue);
    }

    @Override
    public synchronized void forEach(BiConsumer<? super Object, ? super Object> action) {
        this.checkInitialized();
        super.forEach(action);
    }

    @Override
    public Enumeration<Object> keys() {
        this.checkInitialized();
        return super.keys();
    }

    @Override
    public Enumeration<Object> elements() {
        this.checkInitialized();
        return super.elements();
    }

    @Override
    public String getProperty(String key) {
        this.checkInitialized();
        return super.getProperty(key);
    }

    private void checkInitialized() {
        if (!this.initialized) {
            throw new IllegalStateException();
        }
    }

    private void check(String directive) {
        this.checkInitialized();
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkSecurityAccess(directive);
        }
    }

    private void putId() {
        super.put("Provider.id name", String.valueOf(this.name));
        super.put("Provider.id version", String.valueOf(this.version));
        super.put("Provider.id info", String.valueOf(this.info));
        super.put("Provider.id className", this.getClass().getName());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.registered = false;
        HashMap copy = new HashMap();
        for (Map.Entry entry : super.entrySet()) {
            copy.put(entry.getKey(), entry.getValue());
        }
        this.defaults = null;
        in.defaultReadObject();
        this.implClear();
        this.initialized = true;
        this.putAll((Map<?, ?>)copy);
    }

    private boolean checkLegacy(Object key) {
        String keyString;
        if (this.registered) {
            Security.increaseVersion();
        }
        if ((keyString = (String)key).startsWith("Provider.")) {
            return false;
        }
        this.legacyChanged = true;
        if (this.legacyStrings == null) {
            this.legacyStrings = new LinkedHashMap<String, String>();
        }
        return true;
    }

    private void implPutAll(Map<?, ?> t) {
        for (Map.Entry<?, ?> e : t.entrySet()) {
            this.implPut(e.getKey(), e.getValue());
        }
        if (this.registered) {
            Security.increaseVersion();
        }
    }

    private Object implRemove(Object key) {
        if (key instanceof String) {
            if (!this.checkLegacy(key)) {
                return null;
            }
            this.legacyStrings.remove((String)key);
        }
        return super.remove(key);
    }

    private boolean implRemove(Object key, Object value) {
        if (key instanceof String && value instanceof String) {
            if (!this.checkLegacy(key)) {
                return false;
            }
            this.legacyStrings.remove((String)key, value);
        }
        return super.remove(key, value);
    }

    private boolean implReplace(Object key, Object oldValue, Object newValue) {
        if (key instanceof String && oldValue instanceof String && newValue instanceof String) {
            if (!this.checkLegacy(key)) {
                return false;
            }
            this.legacyStrings.replace((String)key, (String)oldValue, (String)newValue);
        }
        return super.replace(key, oldValue, newValue);
    }

    private Object implReplace(Object key, Object value) {
        if (key instanceof String && value instanceof String) {
            if (!this.checkLegacy(key)) {
                return null;
            }
            this.legacyStrings.replace((String)key, (String)value);
        }
        return super.replace(key, value);
    }

    private void implReplaceAll(BiFunction<? super Object, ? super Object, ? extends Object> function) {
        this.legacyChanged = true;
        if (this.legacyStrings == null) {
            this.legacyStrings = new LinkedHashMap<String, String>();
        } else {
            this.legacyStrings.replaceAll(function);
        }
        super.replaceAll(function);
    }

    private Object implMerge(Object key, Object value, BiFunction<? super Object, ? super Object, ? extends Object> remappingFunction) {
        if (key instanceof String && value instanceof String) {
            if (!this.checkLegacy(key)) {
                return null;
            }
            this.legacyStrings.merge((String)key, (String)value, remappingFunction);
        }
        return super.merge(key, value, remappingFunction);
    }

    private Object implCompute(Object key, BiFunction<? super Object, ? super Object, ? extends Object> remappingFunction) {
        if (key instanceof String) {
            if (!this.checkLegacy(key)) {
                return null;
            }
            this.legacyStrings.compute((String)key, remappingFunction);
        }
        return super.compute(key, remappingFunction);
    }

    private Object implComputeIfAbsent(Object key, Function<? super Object, ? extends Object> mappingFunction) {
        if (key instanceof String) {
            if (!this.checkLegacy(key)) {
                return null;
            }
            this.legacyStrings.computeIfAbsent((String)key, mappingFunction);
        }
        return super.computeIfAbsent(key, mappingFunction);
    }

    private Object implComputeIfPresent(Object key, BiFunction<? super Object, ? super Object, ? extends Object> remappingFunction) {
        if (key instanceof String) {
            if (!this.checkLegacy(key)) {
                return null;
            }
            this.legacyStrings.computeIfPresent((String)key, remappingFunction);
        }
        return super.computeIfPresent(key, remappingFunction);
    }

    private Object implPut(Object key, Object value) {
        if (key instanceof String && value instanceof String) {
            if (!this.checkLegacy(key)) {
                return null;
            }
            this.legacyStrings.put((String)key, (String)value);
        }
        return super.put(key, value);
    }

    private Object implPutIfAbsent(Object key, Object value) {
        if (key instanceof String && value instanceof String) {
            if (!this.checkLegacy(key)) {
                return null;
            }
            this.legacyStrings.putIfAbsent((String)key, (String)value);
        }
        return super.putIfAbsent(key, value);
    }

    private void implClear() {
        if (this.legacyStrings != null) {
            this.legacyStrings.clear();
        }
        if (this.legacyMap != null) {
            this.legacyMap.clear();
        }
        if (this.serviceMap != null) {
            this.serviceMap.clear();
        }
        this.legacyChanged = false;
        this.servicesChanged = false;
        this.serviceSet = null;
        super.clear();
        this.putId();
        if (this.registered) {
            Security.increaseVersion();
        }
    }

    private void ensureLegacyParsed() {
        if (!this.legacyChanged || this.legacyStrings == null) {
            return;
        }
        this.serviceSet = null;
        if (this.legacyMap == null) {
            this.legacyMap = new LinkedHashMap<ServiceKey, Service>();
        } else {
            this.legacyMap.clear();
        }
        for (Map.Entry<String, String> entry : this.legacyStrings.entrySet()) {
            this.parseLegacyPut(entry.getKey(), entry.getValue());
        }
        this.removeInvalidServices(this.legacyMap);
        this.legacyChanged = false;
    }

    private void removeInvalidServices(Map<ServiceKey, Service> map) {
        Iterator<Map.Entry<ServiceKey, Service>> t = map.entrySet().iterator();
        while (t.hasNext()) {
            Service s = t.next().getValue();
            if (s.isValid()) continue;
            t.remove();
        }
    }

    private String[] getTypeAndAlgorithm(String key) {
        int i = key.indexOf(".");
        if (i < 1) {
            if (debug != null) {
                debug.println("Ignoring invalid entry in provider " + this.name + ":" + key);
            }
            return null;
        }
        String type = key.substring(0, i);
        String alg = key.substring(i + 1);
        return new String[]{type, alg};
    }

    private void parseLegacyPut(String name, String value) {
        if (name.toLowerCase(Locale.ENGLISH).startsWith(ALIAS_PREFIX_LOWER)) {
            String stdAlg = value;
            String aliasKey = name.substring(ALIAS_LENGTH);
            String[] typeAndAlg = this.getTypeAndAlgorithm(aliasKey);
            if (typeAndAlg == null) {
                return;
            }
            String type = Provider.getEngineName(typeAndAlg[0]);
            String aliasAlg = typeAndAlg[1].intern();
            ServiceKey key = new ServiceKey(type, stdAlg, true);
            Service s = this.legacyMap.get(key);
            if (s == null) {
                s = new Service(this);
                s.type = type;
                s.algorithm = stdAlg;
                this.legacyMap.put(key, s);
            }
            this.legacyMap.put(new ServiceKey(type, aliasAlg, true), s);
            s.addAlias(aliasAlg);
        } else {
            String[] typeAndAlg = this.getTypeAndAlgorithm(name);
            if (typeAndAlg == null) {
                return;
            }
            int i = typeAndAlg[1].indexOf(32);
            if (i == -1) {
                String type = Provider.getEngineName(typeAndAlg[0]);
                String stdAlg = typeAndAlg[1].intern();
                String className = value;
                ServiceKey key = new ServiceKey(type, stdAlg, true);
                Service s = this.legacyMap.get(key);
                if (s == null) {
                    s = new Service(this);
                    s.type = type;
                    s.algorithm = stdAlg;
                    this.legacyMap.put(key, s);
                }
                s.className = className;
            } else {
                String attributeValue = value;
                String type = Provider.getEngineName(typeAndAlg[0]);
                String attributeString = typeAndAlg[1];
                String stdAlg = attributeString.substring(0, i).intern();
                String attributeName = attributeString.substring(i + 1);
                while (attributeName.startsWith(" ")) {
                    attributeName = attributeName.substring(1);
                }
                attributeName = attributeName.intern();
                ServiceKey key = new ServiceKey(type, stdAlg, true);
                Service s = this.legacyMap.get(key);
                if (s == null) {
                    s = new Service(this);
                    s.type = type;
                    s.algorithm = stdAlg;
                    this.legacyMap.put(key, s);
                }
                s.addAttribute(attributeName, attributeValue);
            }
        }
    }

    public synchronized Service getService(String type, String algorithm) {
        Service service;
        this.checkInitialized();
        ServiceKey key = previousKey;
        if (!key.matches(type, algorithm)) {
            previousKey = key = new ServiceKey(type, algorithm, false);
        }
        if (this.serviceMap != null && (service = this.serviceMap.get(key)) != null) {
            return service;
        }
        this.ensureLegacyParsed();
        return this.legacyMap != null ? this.legacyMap.get(key) : null;
    }

    public synchronized Set<Service> getServices() {
        this.checkInitialized();
        if (this.legacyChanged || this.servicesChanged) {
            this.serviceSet = null;
        }
        if (this.serviceSet == null) {
            this.ensureLegacyParsed();
            LinkedHashSet<Service> set = new LinkedHashSet<Service>();
            if (this.serviceMap != null) {
                set.addAll(this.serviceMap.values());
            }
            if (this.legacyMap != null) {
                set.addAll(this.legacyMap.values());
            }
            this.serviceSet = Collections.unmodifiableSet(set);
            this.servicesChanged = false;
        }
        return this.serviceSet;
    }

    protected synchronized void putService(Service s) {
        this.check("putProviderProperty." + this.name);
        if (debug != null) {
            debug.println(this.name + ".putService(): " + s);
        }
        if (s == null) {
            throw new NullPointerException();
        }
        if (s.getProvider() != this) {
            throw new IllegalArgumentException("service.getProvider() must match this Provider object");
        }
        if (this.serviceMap == null) {
            this.serviceMap = new LinkedHashMap<ServiceKey, Service>();
        }
        this.servicesChanged = true;
        String type = s.getType();
        String algorithm = s.getAlgorithm();
        ServiceKey key = new ServiceKey(type, algorithm, true);
        this.implRemoveService(this.serviceMap.get(key));
        this.serviceMap.put(key, s);
        for (String alias : s.getAliases()) {
            this.serviceMap.put(new ServiceKey(type, alias, true), s);
        }
        this.putPropertyStrings(s);
    }

    private void putPropertyStrings(Service s) {
        String type = s.getType();
        String algorithm = s.getAlgorithm();
        super.put(type + "." + algorithm, s.getClassName());
        for (String string : s.getAliases()) {
            super.put(ALIAS_PREFIX + type + "." + string, algorithm);
        }
        for (Map.Entry entry : s.attributes.entrySet()) {
            String key = type + "." + algorithm + " " + entry.getKey();
            super.put(key, entry.getValue());
        }
        if (this.registered) {
            Security.increaseVersion();
        }
    }

    private void removePropertyStrings(Service s) {
        String type = s.getType();
        String algorithm = s.getAlgorithm();
        super.remove(type + "." + algorithm);
        for (String string : s.getAliases()) {
            super.remove(ALIAS_PREFIX + type + "." + string);
        }
        for (Map.Entry entry : s.attributes.entrySet()) {
            String key = type + "." + algorithm + " " + entry.getKey();
            super.remove(key);
        }
        if (this.registered) {
            Security.increaseVersion();
        }
    }

    protected synchronized void removeService(Service s) {
        this.check("removeProviderProperty." + this.name);
        if (debug != null) {
            debug.println(this.name + ".removeService(): " + s);
        }
        if (s == null) {
            throw new NullPointerException();
        }
        this.implRemoveService(s);
    }

    private void implRemoveService(Service s) {
        String algorithm;
        if (s == null || this.serviceMap == null) {
            return;
        }
        String type = s.getType();
        ServiceKey key = new ServiceKey(type, algorithm = s.getAlgorithm(), false);
        Service oldService = this.serviceMap.get(key);
        if (s != oldService) {
            return;
        }
        this.servicesChanged = true;
        this.serviceMap.remove(key);
        for (String alias : s.getAliases()) {
            this.serviceMap.remove(new ServiceKey(type, alias, false));
        }
        this.removePropertyStrings(s);
    }

    private static void addEngine(String name, boolean sp, String paramName) {
        EngineDescription ed = new EngineDescription(name, sp, paramName);
        knownEngines.put(name.toLowerCase(Locale.ENGLISH), ed);
        knownEngines.put(name, ed);
    }

    private static String getEngineName(String s) {
        EngineDescription e = knownEngines.get(s);
        if (e == null) {
            e = knownEngines.get(s.toLowerCase(Locale.ENGLISH));
        }
        return e == null ? s : e.name;
    }

    public void setRegistered() {
        this.registered = true;
    }

    public void setUnregistered() {
        this.registered = false;
    }

    public boolean isRegistered() {
        return this.registered;
    }

    public synchronized void warmUpServiceProvision() {
        this.checkInitialized();
        this.ensureLegacyParsed();
        this.getServices();
    }

    static {
        Provider.addEngine("AlgorithmParameterGenerator", false, null);
        Provider.addEngine("AlgorithmParameters", false, null);
        Provider.addEngine("KeyFactory", false, null);
        Provider.addEngine("KeyPairGenerator", false, null);
        Provider.addEngine("KeyStore", false, null);
        Provider.addEngine("MessageDigest", false, null);
        Provider.addEngine("SecureRandom", false, null);
        Provider.addEngine("Signature", true, null);
        Provider.addEngine("CertificateFactory", false, null);
        Provider.addEngine("CertPathBuilder", false, null);
        Provider.addEngine("CertPathValidator", false, null);
        Provider.addEngine("CertStore", false, "java.security.cert.CertStoreParameters");
        Provider.addEngine("Cipher", true, null);
        Provider.addEngine("ExemptionMechanism", false, null);
        Provider.addEngine("Mac", true, null);
        Provider.addEngine("KeyAgreement", true, null);
        Provider.addEngine("KeyGenerator", false, null);
        Provider.addEngine("SecretKeyFactory", false, null);
        Provider.addEngine("KeyManagerFactory", false, null);
        Provider.addEngine("SSLContext", false, null);
        Provider.addEngine("TrustManagerFactory", false, null);
        Provider.addEngine("GssApiMechanism", false, null);
        Provider.addEngine("SaslClientFactory", false, null);
        Provider.addEngine("SaslServerFactory", false, null);
        Provider.addEngine("Policy", false, "java.security.Policy$Parameters");
        Provider.addEngine("Configuration", false, "javax.security.auth.login.Configuration$Parameters");
        Provider.addEngine("XMLSignatureFactory", false, null);
        Provider.addEngine("KeyInfoFactory", false, null);
        Provider.addEngine("TransformService", false, null);
        Provider.addEngine("TerminalFactory", false, "java.lang.Object");
    }

    public static class Service {
        private String type;
        private String algorithm;
        private String className;
        private final Provider provider;
        private List<String> aliases;
        private Map<UString, String> attributes;
        private volatile Reference<Class<?>> classRef;
        private volatile Boolean hasKeyAttributes;
        private String[] supportedFormats;
        private Class[] supportedClasses;
        private boolean registered;
        private static final Class<?>[] CLASS0 = new Class[0];

        private Service(Provider provider) {
            this.provider = provider;
            this.aliases = Collections.emptyList();
            this.attributes = Collections.emptyMap();
        }

        private boolean isValid() {
            return this.type != null && this.algorithm != null && this.className != null;
        }

        private void addAlias(String alias) {
            if (this.aliases.isEmpty()) {
                this.aliases = new ArrayList<String>(2);
            }
            this.aliases.add(alias);
        }

        void addAttribute(String type, String value) {
            if (this.attributes.isEmpty()) {
                this.attributes = new HashMap<UString, String>(8);
            }
            this.attributes.put(new UString(type), value);
        }

        public Service(Provider provider, String type, String algorithm, String className, List<String> aliases, Map<String, String> attributes) {
            if (provider == null || type == null || algorithm == null || className == null) {
                throw new NullPointerException();
            }
            this.provider = provider;
            this.type = Provider.getEngineName(type);
            this.algorithm = algorithm;
            this.className = className;
            this.aliases = aliases == null ? Collections.emptyList() : new ArrayList<String>(aliases);
            if (attributes == null) {
                this.attributes = Collections.emptyMap();
            } else {
                this.attributes = new HashMap<UString, String>();
                for (Map.Entry<String, String> entry : attributes.entrySet()) {
                    this.attributes.put(new UString(entry.getKey()), entry.getValue());
                }
            }
        }

        public final String getType() {
            return this.type;
        }

        public final String getAlgorithm() {
            return this.algorithm;
        }

        public final Provider getProvider() {
            return this.provider;
        }

        public final String getClassName() {
            return this.className;
        }

        private final List<String> getAliases() {
            return this.aliases;
        }

        public final String getAttribute(String name) {
            if (name == null) {
                throw new NullPointerException();
            }
            return this.attributes.get(new UString(name));
        }

        public Object newInstance(Object constructorParameter) throws NoSuchAlgorithmException {
            if (!this.registered) {
                if (this.provider.getService(this.type, this.algorithm) != this) {
                    throw new NoSuchAlgorithmException("Service not registered with Provider " + this.provider.getName() + ": " + this);
                }
                this.registered = true;
            }
            try {
                Class<?> argClass;
                EngineDescription cap = (EngineDescription)knownEngines.get(this.type);
                if (cap == null) {
                    return this.newInstanceGeneric(constructorParameter);
                }
                if (cap.constructorParameterClassName == null) {
                    if (constructorParameter != null) {
                        throw new InvalidParameterException("constructorParameter not used with " + this.type + " engines");
                    }
                    Class<?> clazz = this.getImplClass();
                    Class[] empty = new Class[]{};
                    Constructor<?> con = clazz.getConstructor(empty);
                    return con.newInstance(new Object[0]);
                }
                Class<?> paramClass = cap.getConstructorParameterClass();
                if (constructorParameter != null && !paramClass.isAssignableFrom(argClass = constructorParameter.getClass())) {
                    throw new InvalidParameterException("constructorParameter must be instanceof " + cap.constructorParameterClassName.replace('$', '.') + " for engine type " + this.type);
                }
                Class<?> clazz = this.getImplClass();
                Constructor<?> cons = clazz.getConstructor(paramClass);
                return cons.newInstance(constructorParameter);
            }
            catch (NoSuchAlgorithmException e) {
                throw e;
            }
            catch (InvocationTargetException e) {
                throw new NoSuchAlgorithmException("Error constructing implementation (algorithm: " + this.algorithm + ", provider: " + this.provider.getName() + ", class: " + this.className + ")", e.getCause());
            }
            catch (Exception e) {
                throw new NoSuchAlgorithmException("Error constructing implementation (algorithm: " + this.algorithm + ", provider: " + this.provider.getName() + ", class: " + this.className + ")", e);
            }
        }

        private Class<?> getImplClass() throws NoSuchAlgorithmException {
            try {
                Class<?> clazz;
                Reference<Class<?>> ref = this.classRef;
                Class<?> clazz2 = clazz = ref == null ? null : ref.get();
                if (clazz == null) {
                    ClassLoader cl = this.provider.getClass().getClassLoader();
                    clazz = cl == null ? Class.forName(this.className) : cl.loadClass(this.className);
                    if (!Modifier.isPublic(clazz.getModifiers())) {
                        throw new NoSuchAlgorithmException("class configured for " + this.type + " (provider: " + this.provider.getName() + ") is not public.");
                    }
                    this.classRef = new WeakReference(clazz);
                }
                return clazz;
            }
            catch (ClassNotFoundException e) {
                throw new NoSuchAlgorithmException("class configured for " + this.type + " (provider: " + this.provider.getName() + ") cannot be found.", e);
            }
        }

        private Object newInstanceGeneric(Object constructorParameter) throws Exception {
            Constructor<?>[] cons;
            Class<?> clazz = this.getImplClass();
            if (constructorParameter == null) {
                try {
                    Class[] empty = new Class[]{};
                    Constructor<?> con = clazz.getConstructor(empty);
                    return con.newInstance(new Object[0]);
                }
                catch (NoSuchMethodException e) {
                    throw new NoSuchAlgorithmException("No public no-arg constructor found in class " + this.className);
                }
            }
            Class<?> argClass = constructorParameter.getClass();
            for (Constructor<?> con : cons = clazz.getConstructors()) {
                Class<?>[] paramTypes = con.getParameterTypes();
                if (paramTypes.length != 1 || !paramTypes[0].isAssignableFrom(argClass)) continue;
                return con.newInstance(constructorParameter);
            }
            throw new NoSuchAlgorithmException("No public constructor matching " + argClass.getName() + " found in class " + this.className);
        }

        public boolean supportsParameter(Object parameter) {
            EngineDescription cap = (EngineDescription)knownEngines.get(this.type);
            if (cap == null) {
                return true;
            }
            if (!cap.supportsParameter) {
                throw new InvalidParameterException("supportsParameter() not used with " + this.type + " engines");
            }
            if (parameter != null && !(parameter instanceof Key)) {
                throw new InvalidParameterException("Parameter must be instanceof Key for engine " + this.type);
            }
            if (!this.hasKeyAttributes()) {
                return true;
            }
            if (parameter == null) {
                return false;
            }
            Key key = (Key)parameter;
            if (this.supportsKeyFormat(key)) {
                return true;
            }
            return this.supportsKeyClass(key);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean hasKeyAttributes() {
            Boolean b = this.hasKeyAttributes;
            if (b == null) {
                Service service = this;
                synchronized (service) {
                    String s = this.getAttribute("SupportedKeyFormats");
                    if (s != null) {
                        this.supportedFormats = s.split("\\|");
                    }
                    if ((s = this.getAttribute("SupportedKeyClasses")) != null) {
                        String[] classNames = s.split("\\|");
                        ArrayList classList = new ArrayList(classNames.length);
                        for (String className : classNames) {
                            Class<?> clazz = this.getKeyClass(className);
                            if (clazz == null) continue;
                            classList.add(clazz);
                        }
                        this.supportedClasses = classList.toArray(CLASS0);
                    }
                    boolean bool = this.supportedFormats != null || this.supportedClasses != null;
                    this.hasKeyAttributes = b = Boolean.valueOf(bool);
                }
            }
            return b;
        }

        private Class<?> getKeyClass(String name) {
            try {
                return Class.forName(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                try {
                    ClassLoader cl = this.provider.getClass().getClassLoader();
                    if (cl != null) {
                        return cl.loadClass(name);
                    }
                }
                catch (ClassNotFoundException classNotFoundException2) {
                    // empty catch block
                }
                return null;
            }
        }

        private boolean supportsKeyFormat(Key key) {
            if (this.supportedFormats == null) {
                return false;
            }
            String format = key.getFormat();
            if (format == null) {
                return false;
            }
            for (String supportedFormat : this.supportedFormats) {
                if (!supportedFormat.equals(format)) continue;
                return true;
            }
            return false;
        }

        private boolean supportsKeyClass(Key key) {
            if (this.supportedClasses == null) {
                return false;
            }
            Class<?> keyClass = key.getClass();
            for (Class clazz : this.supportedClasses) {
                if (!clazz.isAssignableFrom(keyClass)) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            String aString = this.aliases.isEmpty() ? "" : "\r\n  aliases: " + this.aliases.toString();
            String attrs = this.attributes.isEmpty() ? "" : "\r\n  attributes: " + this.attributes.toString();
            return this.provider.getName() + ": " + this.type + "." + this.algorithm + " -> " + this.className + aString + attrs + "\r\n";
        }
    }

    private static class EngineDescription {
        final String name;
        final boolean supportsParameter;
        final String constructorParameterClassName;
        private volatile Class<?> constructorParameterClass;

        EngineDescription(String name, boolean sp, String paramName) {
            this.name = name;
            this.supportsParameter = sp;
            this.constructorParameterClassName = paramName;
        }

        Class<?> getConstructorParameterClass() throws ClassNotFoundException {
            Class<?> clazz = this.constructorParameterClass;
            if (clazz == null) {
                this.constructorParameterClass = clazz = Class.forName(this.constructorParameterClassName);
            }
            return clazz;
        }
    }

    private static class UString {
        final String string;
        final String lowerString;

        UString(String s) {
            this.string = s;
            this.lowerString = s.toLowerCase(Locale.ENGLISH);
        }

        public int hashCode() {
            return this.lowerString.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof UString)) {
                return false;
            }
            UString other = (UString)obj;
            return this.lowerString.equals(other.lowerString);
        }

        public String toString() {
            return this.string;
        }
    }

    private static class ServiceKey {
        private final String type;
        private final String algorithm;
        private final String originalAlgorithm;

        private ServiceKey(String type, String algorithm, boolean intern) {
            this.type = type;
            this.originalAlgorithm = algorithm;
            algorithm = algorithm.toUpperCase(Locale.ENGLISH);
            this.algorithm = intern ? algorithm.intern() : algorithm;
        }

        public int hashCode() {
            return this.type.hashCode() + this.algorithm.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ServiceKey)) {
                return false;
            }
            ServiceKey other = (ServiceKey)obj;
            return this.type.equals(other.type) && this.algorithm.equals(other.algorithm);
        }

        boolean matches(String type, String algorithm) {
            return this.type == type && this.originalAlgorithm == algorithm;
        }
    }
}

