/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableEntryException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Date;
import java.util.Enumeration;
import javax.crypto.SecretKey;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

public abstract class KeyStoreSpi {
    public abstract Key engineGetKey(String var1, char[] var2) throws NoSuchAlgorithmException, UnrecoverableKeyException;

    public abstract Certificate[] engineGetCertificateChain(String var1);

    public abstract Certificate engineGetCertificate(String var1);

    public abstract Date engineGetCreationDate(String var1);

    public abstract void engineSetKeyEntry(String var1, Key var2, char[] var3, Certificate[] var4) throws KeyStoreException;

    public abstract void engineSetKeyEntry(String var1, byte[] var2, Certificate[] var3) throws KeyStoreException;

    public abstract void engineSetCertificateEntry(String var1, Certificate var2) throws KeyStoreException;

    public abstract void engineDeleteEntry(String var1) throws KeyStoreException;

    public abstract Enumeration<String> engineAliases();

    public abstract boolean engineContainsAlias(String var1);

    public abstract int engineSize();

    public abstract boolean engineIsKeyEntry(String var1);

    public abstract boolean engineIsCertificateEntry(String var1);

    public abstract String engineGetCertificateAlias(Certificate var1);

    public abstract void engineStore(OutputStream var1, char[] var2) throws IOException, NoSuchAlgorithmException, CertificateException;

    public void engineStore(KeyStore.LoadStoreParameter param) throws IOException, NoSuchAlgorithmException, CertificateException {
        throw new UnsupportedOperationException();
    }

    public abstract void engineLoad(InputStream var1, char[] var2) throws IOException, NoSuchAlgorithmException, CertificateException;

    public void engineLoad(KeyStore.LoadStoreParameter param) throws IOException, NoSuchAlgorithmException, CertificateException {
        if (param == null) {
            this.engineLoad(null, null);
            return;
        }
        if (param instanceof KeyStore.SimpleLoadStoreParameter) {
            char[] password;
            KeyStore.ProtectionParameter protection = param.getProtectionParameter();
            if (protection instanceof KeyStore.PasswordProtection) {
                password = ((KeyStore.PasswordProtection)protection).getPassword();
            } else if (protection instanceof KeyStore.CallbackHandlerProtection) {
                CallbackHandler handler = ((KeyStore.CallbackHandlerProtection)protection).getCallbackHandler();
                PasswordCallback callback = new PasswordCallback("Password: ", false);
                try {
                    handler.handle(new Callback[]{callback});
                }
                catch (UnsupportedCallbackException e) {
                    throw new NoSuchAlgorithmException("Could not obtain password", e);
                }
                password = callback.getPassword();
                callback.clearPassword();
                if (password == null) {
                    throw new NoSuchAlgorithmException("No password provided");
                }
            } else {
                throw new NoSuchAlgorithmException("ProtectionParameter must be PasswordProtection or CallbackHandlerProtection");
            }
            this.engineLoad(null, password);
            return;
        }
        throw new UnsupportedOperationException();
    }

    public KeyStore.Entry engineGetEntry(String alias, KeyStore.ProtectionParameter protParam) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableEntryException {
        if (!this.engineContainsAlias(alias)) {
            return null;
        }
        if (protParam == null && this.engineIsCertificateEntry(alias)) {
            return new KeyStore.TrustedCertificateEntry(this.engineGetCertificate(alias));
        }
        if (protParam == null || protParam instanceof KeyStore.PasswordProtection) {
            if (this.engineIsCertificateEntry(alias)) {
                throw new UnsupportedOperationException("trusted certificate entries are not password-protected");
            }
            if (this.engineIsKeyEntry(alias)) {
                Key key;
                char[] password = null;
                if (protParam != null) {
                    KeyStore.PasswordProtection pp = (KeyStore.PasswordProtection)protParam;
                    password = pp.getPassword();
                }
                if ((key = this.engineGetKey(alias, password)) instanceof PrivateKey) {
                    Certificate[] chain = this.engineGetCertificateChain(alias);
                    return new KeyStore.PrivateKeyEntry((PrivateKey)key, chain);
                }
                if (key instanceof SecretKey) {
                    return new KeyStore.SecretKeyEntry((SecretKey)key);
                }
            }
        }
        throw new UnsupportedOperationException();
    }

    public void engineSetEntry(String alias, KeyStore.Entry entry, KeyStore.ProtectionParameter protParam) throws KeyStoreException {
        char[] password;
        if (protParam != null && !(protParam instanceof KeyStore.PasswordProtection)) {
            throw new KeyStoreException("unsupported protection parameter");
        }
        KeyStore.PasswordProtection pProtect = null;
        if (protParam != null) {
            pProtect = (KeyStore.PasswordProtection)protParam;
        }
        char[] cArray = password = pProtect == null ? null : pProtect.getPassword();
        if (entry instanceof KeyStore.TrustedCertificateEntry) {
            KeyStore.TrustedCertificateEntry tce = (KeyStore.TrustedCertificateEntry)entry;
            this.engineSetCertificateEntry(alias, tce.getTrustedCertificate());
            return;
        }
        if (entry instanceof KeyStore.PrivateKeyEntry) {
            this.engineSetKeyEntry(alias, ((KeyStore.PrivateKeyEntry)entry).getPrivateKey(), password, ((KeyStore.PrivateKeyEntry)entry).getCertificateChain());
            return;
        }
        if (entry instanceof KeyStore.SecretKeyEntry) {
            this.engineSetKeyEntry(alias, ((KeyStore.SecretKeyEntry)entry).getSecretKey(), password, null);
            return;
        }
        throw new KeyStoreException("unsupported entry type: " + entry.getClass().getName());
    }

    public boolean engineEntryInstanceOf(String alias, Class<? extends KeyStore.Entry> entryClass) {
        if (entryClass == KeyStore.TrustedCertificateEntry.class) {
            return this.engineIsCertificateEntry(alias);
        }
        if (entryClass == KeyStore.PrivateKeyEntry.class) {
            return this.engineIsKeyEntry(alias) && this.engineGetCertificate(alias) != null;
        }
        if (entryClass == KeyStore.SecretKeyEntry.class) {
            return this.engineIsKeyEntry(alias) && this.engineGetCertificate(alias) == null;
        }
        return false;
    }
}

