/*
 * Decompiled with CFR 0.152.
 */
package java.nio.charset;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.nio.charset.spi.CharsetProvider;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import libcore.icu.NativeConverter;
import sun.misc.ASCIICaseInsensitiveComparator;
import sun.misc.VM;
import sun.nio.cs.ThreadLocalCoders;
import sun.security.action.GetPropertyAction;

public abstract class Charset
implements Comparable<Charset> {
    private static volatile String bugLevel = null;
    private static volatile Map.Entry<String, Charset> cache1 = null;
    private static final HashMap<String, Charset> cache2 = new HashMap();
    private static ThreadLocal<ThreadLocal<?>> gate = new ThreadLocal();
    private static Charset defaultCharset;
    private final String name;
    private final String[] aliases;
    private Set<String> aliasSet = null;

    static boolean atBugLevel(String bl) {
        String level = bugLevel;
        if (level == null) {
            if (!VM.isBooted()) {
                return false;
            }
            bugLevel = level = AccessController.doPrivileged(new GetPropertyAction("sun.nio.cs.bugLevel", ""));
        }
        return level.equals(bl);
    }

    private static void checkName(String s) {
        int n = s.length();
        if (!Charset.atBugLevel("1.4") && n == 0) {
            throw new IllegalCharsetNameException(s);
        }
        for (int i = 0; i < n; ++i) {
            char c = s.charAt(i);
            if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '-' && i != 0 || c == '+' && i != 0 || c == ':' && i != 0 || c == '_' && i != 0 || c == '.' && i != 0) continue;
            throw new IllegalCharsetNameException(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cache(String charsetName, Charset cs) {
        HashMap<String, Charset> hashMap = cache2;
        synchronized (hashMap) {
            String canonicalName = cs.name();
            Charset canonicalCharset = cache2.get(canonicalName);
            if (canonicalCharset != null) {
                cs = canonicalCharset;
            } else {
                cache2.put(canonicalName, cs);
                for (String alias : cs.aliases()) {
                    cache2.put(alias, cs);
                }
            }
            cache2.put(charsetName, cs);
        }
        cache1 = new AbstractMap.SimpleImmutableEntry<String, Charset>(charsetName, cs);
    }

    private static Iterator<CharsetProvider> providers() {
        return new Iterator<CharsetProvider>(){
            ServiceLoader<CharsetProvider> sl = ServiceLoader.load(CharsetProvider.class);
            Iterator<CharsetProvider> i = this.sl.iterator();
            CharsetProvider next = null;

            private boolean getNext() {
                while (this.next == null) {
                    try {
                        if (!this.i.hasNext()) {
                            return false;
                        }
                        this.next = this.i.next();
                    }
                    catch (ServiceConfigurationError sce) {
                        if (sce.getCause() instanceof SecurityException) continue;
                        throw sce;
                    }
                }
                return true;
            }

            @Override
            public boolean hasNext() {
                return this.getNext();
            }

            @Override
            public CharsetProvider next() {
                if (!this.getNext()) {
                    throw new NoSuchElementException();
                }
                CharsetProvider n = this.next;
                this.next = null;
                return n;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private static Charset lookupViaProviders(final String charsetName) {
        if (!VM.isBooted()) {
            return null;
        }
        if (gate.get() != null) {
            return null;
        }
        try {
            gate.set(gate);
            Charset charset = AccessController.doPrivileged(new PrivilegedAction<Charset>(){

                @Override
                public Charset run() {
                    Iterator i = Charset.providers();
                    while (i.hasNext()) {
                        CharsetProvider cp = (CharsetProvider)i.next();
                        Charset cs = cp.charsetForName(charsetName);
                        if (cs == null) continue;
                        return cs;
                    }
                    return null;
                }
            });
            return charset;
        }
        finally {
            gate.set(null);
        }
    }

    private static Charset lookup(String charsetName) {
        if (charsetName == null) {
            throw new IllegalArgumentException("Null charset name");
        }
        Map.Entry<String, Charset> cached = cache1;
        if (cached != null && charsetName.equals(cached.getKey())) {
            return cached.getValue();
        }
        return Charset.lookup2(charsetName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Charset lookup2(String charsetName) {
        Charset cs;
        HashMap<String, Charset> hashMap = cache2;
        synchronized (hashMap) {
            cs = cache2.get(charsetName);
            if (cs != null) {
                cache1 = new AbstractMap.SimpleImmutableEntry<String, Charset>(charsetName, cs);
                return cs;
            }
        }
        cs = NativeConverter.charsetForName(charsetName);
        if (cs != null || (cs = Charset.lookupViaProviders(charsetName)) != null) {
            Charset.cache(charsetName, cs);
            return cs;
        }
        Charset.checkName(charsetName);
        return null;
    }

    public static boolean isSupported(String charsetName) {
        return Charset.lookup(charsetName) != null;
    }

    public static Charset forName(String charsetName) {
        Charset cs = Charset.lookup(charsetName);
        if (cs != null) {
            return cs;
        }
        throw new UnsupportedCharsetException(charsetName);
    }

    public static Charset forNameUEE(String charsetName) throws UnsupportedEncodingException {
        try {
            return Charset.forName(charsetName);
        }
        catch (Exception cause) {
            UnsupportedEncodingException ex = new UnsupportedEncodingException(charsetName);
            ex.initCause(cause);
            throw ex;
        }
    }

    private static void put(Iterator<Charset> i, Map<String, Charset> m) {
        while (i.hasNext()) {
            Charset cs = i.next();
            if (m.containsKey(cs.name())) continue;
            m.put(cs.name(), cs);
        }
    }

    public static SortedMap<String, Charset> availableCharsets() {
        return AccessController.doPrivileged(new PrivilegedAction<SortedMap<String, Charset>>(){

            @Override
            public SortedMap<String, Charset> run() {
                TreeMap<String, Charset> m = new TreeMap<String, Charset>(ASCIICaseInsensitiveComparator.CASE_INSENSITIVE_ORDER);
                for (String charsetName : NativeConverter.getAvailableCharsetNames()) {
                    Charset charset = NativeConverter.charsetForName(charsetName);
                    m.put(charset.name(), charset);
                }
                Iterator i = Charset.providers();
                while (i.hasNext()) {
                    CharsetProvider cp = (CharsetProvider)i.next();
                    Charset.put(cp.charsets(), m);
                }
                return Collections.unmodifiableSortedMap(m);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Charset defaultCharset() {
        Class<Charset> clazz = Charset.class;
        synchronized (Charset.class) {
            if (defaultCharset == null) {
                defaultCharset = StandardCharsets.UTF_8;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return defaultCharset;
        }
    }

    protected Charset(String canonicalName, String[] aliases) {
        Charset.checkName(canonicalName);
        String[] as = aliases == null ? new String[]{} : aliases;
        for (int i = 0; i < as.length; ++i) {
            Charset.checkName(as[i]);
        }
        this.name = canonicalName;
        this.aliases = as;
    }

    public final String name() {
        return this.name;
    }

    public final Set<String> aliases() {
        if (this.aliasSet != null) {
            return this.aliasSet;
        }
        int n = this.aliases.length;
        HashSet<String> hs = new HashSet<String>(n);
        for (int i = 0; i < n; ++i) {
            hs.add(this.aliases[i]);
        }
        this.aliasSet = Collections.unmodifiableSet(hs);
        return this.aliasSet;
    }

    public String displayName() {
        return this.name;
    }

    public final boolean isRegistered() {
        return !this.name.startsWith("X-") && !this.name.startsWith("x-");
    }

    public String displayName(Locale locale) {
        return this.name;
    }

    public abstract boolean contains(Charset var1);

    public abstract CharsetDecoder newDecoder();

    public abstract CharsetEncoder newEncoder();

    public boolean canEncode() {
        return true;
    }

    public final CharBuffer decode(ByteBuffer bb) {
        try {
            return ThreadLocalCoders.decoderFor(this).onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE).decode(bb);
        }
        catch (CharacterCodingException x) {
            throw new Error(x);
        }
    }

    public final ByteBuffer encode(CharBuffer cb) {
        try {
            return ThreadLocalCoders.encoderFor(this).onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE).encode(cb);
        }
        catch (CharacterCodingException x) {
            throw new Error(x);
        }
    }

    public final ByteBuffer encode(String str) {
        return this.encode(CharBuffer.wrap(str));
    }

    @Override
    public final int compareTo(Charset that) {
        return this.name().compareToIgnoreCase(that.name());
    }

    public final int hashCode() {
        return this.name().hashCode();
    }

    public final boolean equals(Object ob) {
        if (!(ob instanceof Charset)) {
            return false;
        }
        if (this == ob) {
            return true;
        }
        return this.name.equals(((Charset)ob).name());
    }

    public final String toString() {
        return this.name();
    }
}

