/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Bits;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteBufferAsCharBuffer;
import java.nio.ByteBufferAsDoubleBuffer;
import java.nio.ByteBufferAsFloatBuffer;
import java.nio.ByteBufferAsIntBuffer;
import java.nio.ByteBufferAsLongBuffer;
import java.nio.ByteBufferAsShortBuffer;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ReadOnlyBufferException;
import java.nio.ShortBuffer;
import libcore.io.Memory;

final class HeapByteBuffer
extends ByteBuffer {
    HeapByteBuffer(int cap, int lim) {
        this(cap, lim, false);
    }

    private HeapByteBuffer(int cap, int lim, boolean isReadOnly) {
        super(-1, 0, lim, cap, new byte[cap], 0);
        this.isReadOnly = isReadOnly;
    }

    HeapByteBuffer(byte[] buf, int off, int len) {
        this(buf, off, len, false);
    }

    private HeapByteBuffer(byte[] buf, int off, int len, boolean isReadOnly) {
        super(-1, off, off + len, buf.length, buf, 0);
        this.isReadOnly = isReadOnly;
    }

    private HeapByteBuffer(byte[] buf, int mark, int pos, int lim, int cap, int off, boolean isReadOnly) {
        super(mark, pos, lim, cap, buf, off);
        this.isReadOnly = isReadOnly;
    }

    @Override
    public ByteBuffer slice() {
        return new HeapByteBuffer(this.hb, -1, 0, this.remaining(), this.remaining(), this.position() + this.offset, this.isReadOnly);
    }

    @Override
    public ByteBuffer duplicate() {
        return new HeapByteBuffer(this.hb, this.markValue(), this.position(), this.limit(), this.capacity(), this.offset, this.isReadOnly);
    }

    @Override
    public ByteBuffer asReadOnlyBuffer() {
        return new HeapByteBuffer(this.hb, this.markValue(), this.position(), this.limit(), this.capacity(), this.offset, true);
    }

    protected int ix(int i) {
        return i + this.offset;
    }

    @Override
    public byte get() {
        return this.hb[this.ix(this.nextGetIndex())];
    }

    @Override
    public byte get(int i) {
        return this.hb[this.ix(this.checkIndex(i))];
    }

    @Override
    public ByteBuffer get(byte[] dst, int offset, int length) {
        HeapByteBuffer.checkBounds(offset, length, dst.length);
        if (length > this.remaining()) {
            throw new BufferUnderflowException();
        }
        System.arraycopy(this.hb, this.ix(this.position()), dst, offset, length);
        this.position(this.position() + length);
        return this;
    }

    @Override
    public boolean isDirect() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    @Override
    public ByteBuffer put(byte x) {
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        this.hb[this.ix((int)this.nextPutIndex())] = x;
        return this;
    }

    @Override
    public ByteBuffer put(int i, byte x) {
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        this.hb[this.ix((int)this.checkIndex((int)i))] = x;
        return this;
    }

    @Override
    public ByteBuffer put(byte[] src, int offset, int length) {
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        HeapByteBuffer.checkBounds(offset, length, src.length);
        if (length > this.remaining()) {
            throw new BufferOverflowException();
        }
        System.arraycopy(src, offset, this.hb, this.ix(this.position()), length);
        this.position(this.position() + length);
        return this;
    }

    @Override
    public ByteBuffer compact() {
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        System.arraycopy(this.hb, this.ix(this.position()), this.hb, this.ix(0), this.remaining());
        this.position(this.remaining());
        this.limit(this.capacity());
        this.discardMark();
        return this;
    }

    @Override
    byte _get(int i) {
        return this.hb[i];
    }

    @Override
    void _put(int i, byte b) {
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        this.hb[i] = b;
    }

    @Override
    public char getChar() {
        return Bits.getChar(this, this.ix(this.nextGetIndex(2)), this.bigEndian);
    }

    @Override
    public char getChar(int i) {
        return Bits.getChar(this, this.ix(this.checkIndex(i, 2)), this.bigEndian);
    }

    @Override
    char getCharUnchecked(int i) {
        return Bits.getChar(this, this.ix(i), this.bigEndian);
    }

    @Override
    void getUnchecked(int pos, char[] dst, int dstOffset, int length) {
        Memory.unsafeBulkGet(dst, dstOffset, length * 2, this.hb, this.ix(pos), 2, !this.nativeByteOrder);
    }

    @Override
    public ByteBuffer putChar(char x) {
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        Bits.putChar(this, this.ix(this.nextPutIndex(2)), x, this.bigEndian);
        return this;
    }

    @Override
    public ByteBuffer putChar(int i, char x) {
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        Bits.putChar(this, this.ix(this.checkIndex(i, 2)), x, this.bigEndian);
        return this;
    }

    @Override
    void putCharUnchecked(int i, char x) {
        Bits.putChar(this, this.ix(i), x, this.bigEndian);
    }

    @Override
    void putUnchecked(int pos, char[] src, int srcOffset, int length) {
        Memory.unsafeBulkPut(this.hb, this.ix(pos), length * 2, src, srcOffset, 2, !this.nativeByteOrder);
    }

    @Override
    public CharBuffer asCharBuffer() {
        int size = this.remaining() >> 1;
        int off = this.position();
        return new ByteBufferAsCharBuffer(this, -1, 0, size, size, off, this.order());
    }

    @Override
    public short getShort() {
        return Bits.getShort(this, this.ix(this.nextGetIndex(2)), this.bigEndian);
    }

    @Override
    public short getShort(int i) {
        return Bits.getShort(this, this.ix(this.checkIndex(i, 2)), this.bigEndian);
    }

    @Override
    short getShortUnchecked(int i) {
        return Bits.getShort(this, this.ix(i), this.bigEndian);
    }

    @Override
    void getUnchecked(int pos, short[] dst, int dstOffset, int length) {
        Memory.unsafeBulkGet(dst, dstOffset, length * 2, this.hb, this.ix(pos), 2, !this.nativeByteOrder);
    }

    @Override
    public ByteBuffer putShort(short x) {
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        Bits.putShort(this, this.ix(this.nextPutIndex(2)), x, this.bigEndian);
        return this;
    }

    @Override
    public ByteBuffer putShort(int i, short x) {
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        Bits.putShort(this, this.ix(this.checkIndex(i, 2)), x, this.bigEndian);
        return this;
    }

    @Override
    void putShortUnchecked(int i, short x) {
        Bits.putShort(this, this.ix(i), x, this.bigEndian);
    }

    @Override
    void putUnchecked(int pos, short[] src, int srcOffset, int length) {
        Memory.unsafeBulkPut(this.hb, this.ix(pos), length * 2, src, srcOffset, 2, !this.nativeByteOrder);
    }

    @Override
    public ShortBuffer asShortBuffer() {
        int size = this.remaining() >> 1;
        int off = this.position();
        return new ByteBufferAsShortBuffer(this, -1, 0, size, size, off, this.order());
    }

    @Override
    public int getInt() {
        return Bits.getInt(this, this.ix(this.nextGetIndex(4)), this.bigEndian);
    }

    @Override
    public int getInt(int i) {
        return Bits.getInt(this, this.ix(this.checkIndex(i, 4)), this.bigEndian);
    }

    @Override
    int getIntUnchecked(int i) {
        return Bits.getInt(this, this.ix(i), this.bigEndian);
    }

    @Override
    void getUnchecked(int pos, int[] dst, int dstOffset, int length) {
        Memory.unsafeBulkGet(dst, dstOffset, length * 4, this.hb, this.ix(pos), 4, !this.nativeByteOrder);
    }

    @Override
    public ByteBuffer putInt(int x) {
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        Bits.putInt(this, this.ix(this.nextPutIndex(4)), x, this.bigEndian);
        return this;
    }

    @Override
    public ByteBuffer putInt(int i, int x) {
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        Bits.putInt(this, this.ix(this.checkIndex(i, 4)), x, this.bigEndian);
        return this;
    }

    @Override
    void putIntUnchecked(int i, int x) {
        Bits.putInt(this, this.ix(i), x, this.bigEndian);
    }

    @Override
    void putUnchecked(int pos, int[] src, int srcOffset, int length) {
        Memory.unsafeBulkPut(this.hb, this.ix(pos), length * 4, src, srcOffset, 4, !this.nativeByteOrder);
    }

    @Override
    public IntBuffer asIntBuffer() {
        int size = this.remaining() >> 2;
        int off = this.position();
        return new ByteBufferAsIntBuffer(this, -1, 0, size, size, off, this.order());
    }

    @Override
    public long getLong() {
        return Bits.getLong(this, this.ix(this.nextGetIndex(8)), this.bigEndian);
    }

    @Override
    public long getLong(int i) {
        return Bits.getLong(this, this.ix(this.checkIndex(i, 8)), this.bigEndian);
    }

    @Override
    long getLongUnchecked(int i) {
        return Bits.getLong(this, this.ix(i), this.bigEndian);
    }

    @Override
    void getUnchecked(int pos, long[] dst, int dstOffset, int length) {
        Memory.unsafeBulkGet(dst, dstOffset, length * 8, this.hb, this.ix(pos), 8, !this.nativeByteOrder);
    }

    @Override
    public ByteBuffer putLong(long x) {
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        Bits.putLong(this, this.ix(this.nextPutIndex(8)), x, this.bigEndian);
        return this;
    }

    @Override
    public ByteBuffer putLong(int i, long x) {
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        Bits.putLong(this, this.ix(this.checkIndex(i, 8)), x, this.bigEndian);
        return this;
    }

    @Override
    void putLongUnchecked(int i, long x) {
        Bits.putLong(this, this.ix(i), x, this.bigEndian);
    }

    @Override
    void putUnchecked(int pos, long[] src, int srcOffset, int length) {
        Memory.unsafeBulkPut(this.hb, this.ix(pos), length * 8, src, srcOffset, 8, !this.nativeByteOrder);
    }

    @Override
    public LongBuffer asLongBuffer() {
        int size = this.remaining() >> 3;
        int off = this.position();
        return new ByteBufferAsLongBuffer(this, -1, 0, size, size, off, this.order());
    }

    @Override
    public float getFloat() {
        return Bits.getFloat(this, this.ix(this.nextGetIndex(4)), this.bigEndian);
    }

    @Override
    public float getFloat(int i) {
        return Bits.getFloat(this, this.ix(this.checkIndex(i, 4)), this.bigEndian);
    }

    @Override
    float getFloatUnchecked(int i) {
        return Bits.getFloat(this, this.ix(i), this.bigEndian);
    }

    @Override
    void getUnchecked(int pos, float[] dst, int dstOffset, int length) {
        Memory.unsafeBulkGet(dst, dstOffset, length * 4, this.hb, this.ix(pos), 4, !this.nativeByteOrder);
    }

    @Override
    public ByteBuffer putFloat(float x) {
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        Bits.putFloat(this, this.ix(this.nextPutIndex(4)), x, this.bigEndian);
        return this;
    }

    @Override
    public ByteBuffer putFloat(int i, float x) {
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        Bits.putFloat(this, this.ix(this.checkIndex(i, 4)), x, this.bigEndian);
        return this;
    }

    @Override
    void putFloatUnchecked(int i, float x) {
        Bits.putFloat(this, this.ix(i), x, this.bigEndian);
    }

    @Override
    void putUnchecked(int pos, float[] src, int srcOffset, int length) {
        Memory.unsafeBulkPut(this.hb, this.ix(pos), length * 4, src, srcOffset, 4, !this.nativeByteOrder);
    }

    @Override
    public FloatBuffer asFloatBuffer() {
        int size = this.remaining() >> 2;
        int off = this.position();
        return new ByteBufferAsFloatBuffer(this, -1, 0, size, size, off, this.order());
    }

    @Override
    public double getDouble() {
        return Bits.getDouble(this, this.ix(this.nextGetIndex(8)), this.bigEndian);
    }

    @Override
    public double getDouble(int i) {
        return Bits.getDouble(this, this.ix(this.checkIndex(i, 8)), this.bigEndian);
    }

    @Override
    double getDoubleUnchecked(int i) {
        return Bits.getDouble(this, this.ix(i), this.bigEndian);
    }

    @Override
    void getUnchecked(int pos, double[] dst, int dstOffset, int length) {
        Memory.unsafeBulkGet(dst, dstOffset, length * 8, this.hb, this.ix(pos), 8, !this.nativeByteOrder);
    }

    @Override
    public ByteBuffer putDouble(double x) {
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        Bits.putDouble(this, this.ix(this.nextPutIndex(8)), x, this.bigEndian);
        return this;
    }

    @Override
    public ByteBuffer putDouble(int i, double x) {
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        Bits.putDouble(this, this.ix(this.checkIndex(i, 8)), x, this.bigEndian);
        return this;
    }

    @Override
    void putDoubleUnchecked(int i, double x) {
        Bits.putDouble(this, this.ix(i), x, this.bigEndian);
    }

    @Override
    void putUnchecked(int pos, double[] src, int srcOffset, int length) {
        Memory.unsafeBulkPut(this.hb, this.ix(pos), length * 8, src, srcOffset, 8, !this.nativeByteOrder);
    }

    @Override
    public DoubleBuffer asDoubleBuffer() {
        int size = this.remaining() >> 3;
        int off = this.position();
        return new ByteBufferAsDoubleBuffer(this, -1, 0, size, size, off, this.order());
    }
}

