/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import dalvik.system.VMRuntime;
import java.io.FileDescriptor;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteBufferAsCharBuffer;
import java.nio.ByteBufferAsDoubleBuffer;
import java.nio.ByteBufferAsFloatBuffer;
import java.nio.ByteBufferAsIntBuffer;
import java.nio.ByteBufferAsLongBuffer;
import java.nio.ByteBufferAsShortBuffer;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.MappedByteBuffer;
import java.nio.ReadOnlyBufferException;
import java.nio.ShortBuffer;
import libcore.io.Memory;
import sun.misc.Cleaner;
import sun.nio.ch.DirectBuffer;

public class DirectByteBuffer
extends MappedByteBuffer
implements DirectBuffer {
    final Cleaner cleaner;
    final MemoryRef memoryRef;

    DirectByteBuffer(int capacity, MemoryRef memoryRef) {
        super(-1, 0, capacity, capacity, memoryRef.buffer, memoryRef.offset);
        this.memoryRef = memoryRef;
        this.address = memoryRef.allocatedAddress + (long)memoryRef.offset;
        this.cleaner = null;
        this.isReadOnly = false;
    }

    private DirectByteBuffer(long addr, int cap) {
        super(-1, 0, cap, cap);
        this.memoryRef = new MemoryRef(addr, this);
        this.address = addr;
        this.cleaner = null;
    }

    public DirectByteBuffer(int cap, long addr, FileDescriptor fd, Runnable unmapper, boolean isReadOnly) {
        super(-1, 0, cap, cap, fd);
        this.isReadOnly = isReadOnly;
        this.memoryRef = new MemoryRef(addr, null);
        this.address = addr;
        this.cleaner = Cleaner.create(this.memoryRef, unmapper);
    }

    DirectByteBuffer(MemoryRef memoryRef, int mark, int pos, int lim, int cap, int off) {
        this(memoryRef, mark, pos, lim, cap, off, false);
    }

    DirectByteBuffer(MemoryRef memoryRef, int mark, int pos, int lim, int cap, int off, boolean isReadOnly) {
        super(mark, pos, lim, cap, memoryRef.buffer, off);
        this.isReadOnly = isReadOnly;
        this.memoryRef = memoryRef;
        this.address = memoryRef.allocatedAddress + (long)off;
        this.cleaner = null;
    }

    @Override
    public final Object attachment() {
        return this.memoryRef;
    }

    @Override
    public final Cleaner cleaner() {
        return this.cleaner;
    }

    @Override
    public final ByteBuffer slice() {
        if (!this.memoryRef.isAccessible) {
            throw new IllegalStateException("buffer is inaccessible");
        }
        int pos = this.position();
        int lim = this.limit();
        assert (pos <= lim);
        int rem = pos <= lim ? lim - pos : 0;
        int off = pos + this.offset;
        assert (off >= 0);
        return new DirectByteBuffer(this.memoryRef, -1, 0, rem, rem, off, this.isReadOnly);
    }

    @Override
    public final ByteBuffer duplicate() {
        if (this.memoryRef.isFreed) {
            throw new IllegalStateException("buffer has been freed");
        }
        return new DirectByteBuffer(this.memoryRef, this.markValue(), this.position(), this.limit(), this.capacity(), this.offset, this.isReadOnly);
    }

    @Override
    public final ByteBuffer asReadOnlyBuffer() {
        if (this.memoryRef.isFreed) {
            throw new IllegalStateException("buffer has been freed");
        }
        return new DirectByteBuffer(this.memoryRef, this.markValue(), this.position(), this.limit(), this.capacity(), this.offset, true);
    }

    @Override
    public final long address() {
        return this.address;
    }

    private long ix(int i) {
        return this.address + (long)i;
    }

    private byte get(long a) {
        return Memory.peekByte(a);
    }

    @Override
    public final byte get() {
        if (!this.memoryRef.isAccessible) {
            throw new IllegalStateException("buffer is inaccessible");
        }
        return this.get(this.ix(this.nextGetIndex()));
    }

    @Override
    public final byte get(int i) {
        if (!this.memoryRef.isAccessible) {
            throw new IllegalStateException("buffer is inaccessible");
        }
        return this.get(this.ix(this.checkIndex(i)));
    }

    @Override
    public ByteBuffer get(byte[] dst, int dstOffset, int length) {
        int rem;
        if (!this.memoryRef.isAccessible) {
            throw new IllegalStateException("buffer is inaccessible");
        }
        DirectByteBuffer.checkBounds(dstOffset, length, dst.length);
        int pos = this.position();
        int lim = this.limit();
        assert (pos <= lim);
        int n = rem = pos <= lim ? lim - pos : 0;
        if (length > rem) {
            throw new BufferUnderflowException();
        }
        Memory.peekByteArray(this.ix(pos), dst, dstOffset, length);
        this.position = pos + length;
        return this;
    }

    private ByteBuffer put(long a, byte x) {
        Memory.pokeByte(a, x);
        return this;
    }

    @Override
    public final ByteBuffer put(byte x) {
        if (!this.memoryRef.isAccessible) {
            throw new IllegalStateException("buffer is inaccessible");
        }
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        this.put(this.ix(this.nextPutIndex()), x);
        return this;
    }

    @Override
    public final ByteBuffer put(int i, byte x) {
        if (!this.memoryRef.isAccessible) {
            throw new IllegalStateException("buffer is inaccessible");
        }
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        this.put(this.ix(this.checkIndex(i)), x);
        return this;
    }

    @Override
    public ByteBuffer put(byte[] src, int srcOffset, int length) {
        int rem;
        if (!this.memoryRef.isAccessible) {
            throw new IllegalStateException("buffer is inaccessible");
        }
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        DirectByteBuffer.checkBounds(srcOffset, length, src.length);
        int pos = this.position();
        int lim = this.limit();
        assert (pos <= lim);
        int n = rem = pos <= lim ? lim - pos : 0;
        if (length > rem) {
            throw new BufferOverflowException();
        }
        Memory.pokeByteArray(this.ix(pos), src, srcOffset, length);
        this.position = pos + length;
        return this;
    }

    @Override
    public final ByteBuffer compact() {
        if (!this.memoryRef.isAccessible) {
            throw new IllegalStateException("buffer is inaccessible");
        }
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        int pos = this.position();
        int lim = this.limit();
        assert (pos <= lim);
        int rem = pos <= lim ? lim - pos : 0;
        System.arraycopy(this.hb, this.position + this.offset, this.hb, this.offset, this.remaining());
        this.position(rem);
        this.limit(this.capacity());
        this.discardMark();
        return this;
    }

    @Override
    public final boolean isDirect() {
        return true;
    }

    @Override
    public final boolean isReadOnly() {
        return this.isReadOnly;
    }

    @Override
    final byte _get(int i) {
        return this.get(i);
    }

    @Override
    final void _put(int i, byte b) {
        this.put(i, b);
    }

    @Override
    public final char getChar() {
        if (!this.memoryRef.isAccessible) {
            throw new IllegalStateException("buffer is inaccessible");
        }
        int newPosition = this.position + 2;
        if (newPosition > this.limit()) {
            throw new BufferUnderflowException();
        }
        char x = (char)Memory.peekShort(this.ix(this.position), !this.nativeByteOrder);
        this.position = newPosition;
        return x;
    }

    @Override
    public final char getChar(int i) {
        if (!this.memoryRef.isAccessible) {
            throw new IllegalStateException("buffer is inaccessible");
        }
        this.checkIndex(i, 2);
        return (char)Memory.peekShort(this.ix(i), !this.nativeByteOrder);
    }

    @Override
    char getCharUnchecked(int i) {
        if (!this.memoryRef.isAccessible) {
            throw new IllegalStateException("buffer is inaccessible");
        }
        return (char)Memory.peekShort(this.ix(i), !this.nativeByteOrder);
    }

    @Override
    void getUnchecked(int pos, char[] dst, int dstOffset, int length) {
        if (!this.memoryRef.isAccessible) {
            throw new IllegalStateException("buffer is inaccessible");
        }
        Memory.peekCharArray(this.ix(pos), dst, dstOffset, length, !this.nativeByteOrder);
    }

    private ByteBuffer putChar(long a, char x) {
        Memory.pokeShort(a, (short)x, !this.nativeByteOrder);
        return this;
    }

    @Override
    public final ByteBuffer putChar(char x) {
        if (!this.memoryRef.isAccessible) {
            throw new IllegalStateException("buffer is inaccessible");
        }
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        this.putChar(this.ix(this.nextPutIndex(2)), x);
        return this;
    }

    @Override
    public final ByteBuffer putChar(int i, char x) {
        if (!this.memoryRef.isAccessible) {
            throw new IllegalStateException("buffer is inaccessible");
        }
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        this.putChar(this.ix(this.checkIndex(i, 2)), x);
        return this;
    }

    @Override
    void putCharUnchecked(int i, char x) {
        if (!this.memoryRef.isAccessible) {
            throw new IllegalStateException("buffer is inaccessible");
        }
        this.putChar(this.ix(i), x);
    }

    @Override
    void putUnchecked(int pos, char[] src, int srcOffset, int length) {
        if (!this.memoryRef.isAccessible) {
            throw new IllegalStateException("buffer is inaccessible");
        }
        Memory.pokeCharArray(this.ix(pos), src, srcOffset, length, !this.nativeByteOrder);
    }

    @Override
    public final CharBuffer asCharBuffer() {
        if (this.memoryRef.isFreed) {
            throw new IllegalStateException("buffer has been freed");
        }
        int off = this.position();
        int lim = this.limit();
        assert (off <= lim);
        int rem = off <= lim ? lim - off : 0;
        int size = rem >> 1;
        return new ByteBufferAsCharBuffer(this, -1, 0, size, size, off, this.order());
    }

    private short getShort(long a) {
        return Memory.peekShort(a, !this.nativeByteOrder);
    }

    @Override
    public final short getShort() {
        if (!this.memoryRef.isAccessible) {
            throw new IllegalStateException("buffer is inaccessible");
        }
        return this.getShort(this.ix(this.nextGetIndex(2)));
    }

    @Override
    public final short getShort(int i) {
        if (!this.memoryRef.isAccessible) {
            throw new IllegalStateException("buffer is inaccessible");
        }
        return this.getShort(this.ix(this.checkIndex(i, 2)));
    }

    @Override
    short getShortUnchecked(int i) {
        if (!this.memoryRef.isAccessible) {
            throw new IllegalStateException("buffer is inaccessible");
        }
        return this.getShort(this.ix(i));
    }

    @Override
    void getUnchecked(int pos, short[] dst, int dstOffset, int length) {
        if (!this.memoryRef.isAccessible) {
            throw new IllegalStateException("buffer is inaccessible");
        }
        Memory.peekShortArray(this.ix(pos), dst, dstOffset, length, !this.nativeByteOrder);
    }

    private ByteBuffer putShort(long a, short x) {
        Memory.pokeShort(a, x, !this.nativeByteOrder);
        return this;
    }

    @Override
    public final ByteBuffer putShort(short x) {
        if (!this.memoryRef.isAccessible) {
            throw new IllegalStateException("buffer is inaccessible");
        }
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        this.putShort(this.ix(this.nextPutIndex(2)), x);
        return this;
    }

    @Override
    public final ByteBuffer putShort(int i, short x) {
        if (!this.memoryRef.isAccessible) {
            throw new IllegalStateException("buffer is inaccessible");
        }
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        this.putShort(this.ix(this.checkIndex(i, 2)), x);
        return this;
    }

    @Override
    void putShortUnchecked(int i, short x) {
        if (!this.memoryRef.isAccessible) {
            throw new IllegalStateException("buffer is inaccessible");
        }
        this.putShort(this.ix(i), x);
    }

    @Override
    void putUnchecked(int pos, short[] src, int srcOffset, int length) {
        if (!this.memoryRef.isAccessible) {
            throw new IllegalStateException("buffer is inaccessible");
        }
        Memory.pokeShortArray(this.ix(pos), src, srcOffset, length, !this.nativeByteOrder);
    }

    @Override
    public final ShortBuffer asShortBuffer() {
        if (this.memoryRef.isFreed) {
            throw new IllegalStateException("buffer has been freed");
        }
        int off = this.position();
        int lim = this.limit();
        assert (off <= lim);
        int rem = off <= lim ? lim - off : 0;
        int size = rem >> 1;
        return new ByteBufferAsShortBuffer(this, -1, 0, size, size, off, this.order());
    }

    private int getInt(long a) {
        return Memory.peekInt(a, !this.nativeByteOrder);
    }

    @Override
    public int getInt() {
        if (!this.memoryRef.isAccessible) {
            throw new IllegalStateException("buffer is inaccessible");
        }
        return this.getInt(this.ix(this.nextGetIndex(4)));
    }

    @Override
    public int getInt(int i) {
        if (!this.memoryRef.isAccessible) {
            throw new IllegalStateException("buffer is inaccessible");
        }
        return this.getInt(this.ix(this.checkIndex(i, 4)));
    }

    @Override
    final int getIntUnchecked(int i) {
        if (!this.memoryRef.isAccessible) {
            throw new IllegalStateException("buffer is inaccessible");
        }
        return this.getInt(this.ix(i));
    }

    @Override
    final void getUnchecked(int pos, int[] dst, int dstOffset, int length) {
        if (!this.memoryRef.isAccessible) {
            throw new IllegalStateException("buffer is inaccessible");
        }
        Memory.peekIntArray(this.ix(pos), dst, dstOffset, length, !this.nativeByteOrder);
    }

    private ByteBuffer putInt(long a, int x) {
        Memory.pokeInt(a, x, !this.nativeByteOrder);
        return this;
    }

    @Override
    public final ByteBuffer putInt(int x) {
        if (!this.memoryRef.isAccessible) {
            throw new IllegalStateException("buffer is inaccessible");
        }
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        this.putInt(this.ix(this.nextPutIndex(4)), x);
        return this;
    }

    @Override
    public final ByteBuffer putInt(int i, int x) {
        if (!this.memoryRef.isAccessible) {
            throw new IllegalStateException("buffer is inaccessible");
        }
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        this.putInt(this.ix(this.checkIndex(i, 4)), x);
        return this;
    }

    @Override
    final void putIntUnchecked(int i, int x) {
        if (!this.memoryRef.isAccessible) {
            throw new IllegalStateException("buffer is inaccessible");
        }
        this.putInt(this.ix(i), x);
    }

    @Override
    final void putUnchecked(int pos, int[] src, int srcOffset, int length) {
        if (!this.memoryRef.isAccessible) {
            throw new IllegalStateException("buffer is inaccessible");
        }
        Memory.pokeIntArray(this.ix(pos), src, srcOffset, length, !this.nativeByteOrder);
    }

    @Override
    public final IntBuffer asIntBuffer() {
        if (this.memoryRef.isFreed) {
            throw new IllegalStateException("buffer has been freed");
        }
        int off = this.position();
        int lim = this.limit();
        assert (off <= lim);
        int rem = off <= lim ? lim - off : 0;
        int size = rem >> 2;
        return new ByteBufferAsIntBuffer(this, -1, 0, size, size, off, this.order());
    }

    private long getLong(long a) {
        return Memory.peekLong(a, !this.nativeByteOrder);
    }

    @Override
    public final long getLong() {
        if (!this.memoryRef.isAccessible) {
            throw new IllegalStateException("buffer is inaccessible");
        }
        return this.getLong(this.ix(this.nextGetIndex(8)));
    }

    @Override
    public final long getLong(int i) {
        if (!this.memoryRef.isAccessible) {
            throw new IllegalStateException("buffer is inaccessible");
        }
        return this.getLong(this.ix(this.checkIndex(i, 8)));
    }

    @Override
    final long getLongUnchecked(int i) {
        if (!this.memoryRef.isAccessible) {
            throw new IllegalStateException("buffer is inaccessible");
        }
        return this.getLong(this.ix(i));
    }

    @Override
    final void getUnchecked(int pos, long[] dst, int dstOffset, int length) {
        if (!this.memoryRef.isAccessible) {
            throw new IllegalStateException("buffer is inaccessible");
        }
        Memory.peekLongArray(this.ix(pos), dst, dstOffset, length, !this.nativeByteOrder);
    }

    private ByteBuffer putLong(long a, long x) {
        Memory.pokeLong(a, x, !this.nativeByteOrder);
        return this;
    }

    @Override
    public final ByteBuffer putLong(long x) {
        if (!this.memoryRef.isAccessible) {
            throw new IllegalStateException("buffer is inaccessible");
        }
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        this.putLong(this.ix(this.nextPutIndex(8)), x);
        return this;
    }

    @Override
    public final ByteBuffer putLong(int i, long x) {
        if (!this.memoryRef.isAccessible) {
            throw new IllegalStateException("buffer is inaccessible");
        }
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        this.putLong(this.ix(this.checkIndex(i, 8)), x);
        return this;
    }

    @Override
    final void putLongUnchecked(int i, long x) {
        if (!this.memoryRef.isAccessible) {
            throw new IllegalStateException("buffer is inaccessible");
        }
        this.putLong(this.ix(i), x);
    }

    @Override
    final void putUnchecked(int pos, long[] src, int srcOffset, int length) {
        if (!this.memoryRef.isAccessible) {
            throw new IllegalStateException("buffer is inaccessible");
        }
        Memory.pokeLongArray(this.ix(pos), src, srcOffset, length, !this.nativeByteOrder);
    }

    @Override
    public final LongBuffer asLongBuffer() {
        if (this.memoryRef.isFreed) {
            throw new IllegalStateException("buffer has been freed");
        }
        int off = this.position();
        int lim = this.limit();
        assert (off <= lim);
        int rem = off <= lim ? lim - off : 0;
        int size = rem >> 3;
        return new ByteBufferAsLongBuffer(this, -1, 0, size, size, off, this.order());
    }

    private float getFloat(long a) {
        int x = Memory.peekInt(a, !this.nativeByteOrder);
        return Float.intBitsToFloat(x);
    }

    @Override
    public final float getFloat() {
        if (!this.memoryRef.isAccessible) {
            throw new IllegalStateException("buffer is inaccessible");
        }
        return this.getFloat(this.ix(this.nextGetIndex(4)));
    }

    @Override
    public final float getFloat(int i) {
        if (!this.memoryRef.isAccessible) {
            throw new IllegalStateException("buffer is inaccessible");
        }
        return this.getFloat(this.ix(this.checkIndex(i, 4)));
    }

    @Override
    final float getFloatUnchecked(int i) {
        if (!this.memoryRef.isAccessible) {
            throw new IllegalStateException("buffer is inaccessible");
        }
        return this.getFloat(this.ix(i));
    }

    @Override
    final void getUnchecked(int pos, float[] dst, int dstOffset, int length) {
        if (!this.memoryRef.isAccessible) {
            throw new IllegalStateException("buffer is inaccessible");
        }
        Memory.peekFloatArray(this.ix(pos), dst, dstOffset, length, !this.nativeByteOrder);
    }

    private ByteBuffer putFloat(long a, float x) {
        int y = Float.floatToRawIntBits(x);
        Memory.pokeInt(a, y, !this.nativeByteOrder);
        return this;
    }

    @Override
    public final ByteBuffer putFloat(float x) {
        if (!this.memoryRef.isAccessible) {
            throw new IllegalStateException("buffer is inaccessible");
        }
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        this.putFloat(this.ix(this.nextPutIndex(4)), x);
        return this;
    }

    @Override
    public final ByteBuffer putFloat(int i, float x) {
        if (!this.memoryRef.isAccessible) {
            throw new IllegalStateException("buffer is inaccessible");
        }
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        this.putFloat(this.ix(this.checkIndex(i, 4)), x);
        return this;
    }

    @Override
    final void putFloatUnchecked(int i, float x) {
        if (!this.memoryRef.isAccessible) {
            throw new IllegalStateException("buffer is inaccessible");
        }
        this.putFloat(this.ix(i), x);
    }

    @Override
    final void putUnchecked(int pos, float[] src, int srcOffset, int length) {
        if (!this.memoryRef.isAccessible) {
            throw new IllegalStateException("buffer is inaccessible");
        }
        Memory.pokeFloatArray(this.ix(pos), src, srcOffset, length, !this.nativeByteOrder);
    }

    @Override
    public final FloatBuffer asFloatBuffer() {
        if (this.memoryRef.isFreed) {
            throw new IllegalStateException("buffer has been freed");
        }
        int off = this.position();
        int lim = this.limit();
        assert (off <= lim);
        int rem = off <= lim ? lim - off : 0;
        int size = rem >> 2;
        return new ByteBufferAsFloatBuffer(this, -1, 0, size, size, off, this.order());
    }

    private double getDouble(long a) {
        long x = Memory.peekLong(a, !this.nativeByteOrder);
        return Double.longBitsToDouble(x);
    }

    @Override
    public final double getDouble() {
        if (!this.memoryRef.isAccessible) {
            throw new IllegalStateException("buffer is inaccessible");
        }
        return this.getDouble(this.ix(this.nextGetIndex(8)));
    }

    @Override
    public final double getDouble(int i) {
        if (!this.memoryRef.isAccessible) {
            throw new IllegalStateException("buffer is inaccessible");
        }
        return this.getDouble(this.ix(this.checkIndex(i, 8)));
    }

    @Override
    final double getDoubleUnchecked(int i) {
        if (!this.memoryRef.isAccessible) {
            throw new IllegalStateException("buffer is inaccessible");
        }
        return this.getDouble(this.ix(i));
    }

    @Override
    final void getUnchecked(int pos, double[] dst, int dstOffset, int length) {
        if (!this.memoryRef.isAccessible) {
            throw new IllegalStateException("buffer is inaccessible");
        }
        Memory.peekDoubleArray(this.ix(pos), dst, dstOffset, length, !this.nativeByteOrder);
    }

    private ByteBuffer putDouble(long a, double x) {
        long y = Double.doubleToRawLongBits(x);
        Memory.pokeLong(a, y, !this.nativeByteOrder);
        return this;
    }

    @Override
    public final ByteBuffer putDouble(double x) {
        if (!this.memoryRef.isAccessible) {
            throw new IllegalStateException("buffer is inaccessible");
        }
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        this.putDouble(this.ix(this.nextPutIndex(8)), x);
        return this;
    }

    @Override
    public final ByteBuffer putDouble(int i, double x) {
        if (!this.memoryRef.isAccessible) {
            throw new IllegalStateException("buffer is inaccessible");
        }
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        this.putDouble(this.ix(this.checkIndex(i, 8)), x);
        return this;
    }

    @Override
    final void putDoubleUnchecked(int i, double x) {
        if (!this.memoryRef.isAccessible) {
            throw new IllegalStateException("buffer is inaccessible");
        }
        this.putDouble(this.ix(i), x);
    }

    @Override
    final void putUnchecked(int pos, double[] src, int srcOffset, int length) {
        if (!this.memoryRef.isAccessible) {
            throw new IllegalStateException("buffer is inaccessible");
        }
        Memory.pokeDoubleArray(this.ix(pos), src, srcOffset, length, !this.nativeByteOrder);
    }

    @Override
    public final DoubleBuffer asDoubleBuffer() {
        if (this.memoryRef.isFreed) {
            throw new IllegalStateException("buffer has been freed");
        }
        int off = this.position();
        int lim = this.limit();
        assert (off <= lim);
        int rem = off <= lim ? lim - off : 0;
        int size = rem >> 3;
        return new ByteBufferAsDoubleBuffer(this, -1, 0, size, size, off, this.order());
    }

    @Override
    public final boolean isAccessible() {
        return this.memoryRef.isAccessible;
    }

    @Override
    public final void setAccessible(boolean value) {
        this.memoryRef.isAccessible = value;
    }

    static final class MemoryRef {
        byte[] buffer;
        long allocatedAddress;
        final int offset;
        boolean isAccessible;
        boolean isFreed;
        final Object originalBufferObject;

        MemoryRef(int capacity) {
            VMRuntime runtime = VMRuntime.getRuntime();
            this.buffer = (byte[])runtime.newNonMovableArray(Byte.TYPE, capacity + 7);
            this.allocatedAddress = runtime.addressOf(this.buffer);
            this.offset = (int)((this.allocatedAddress + 7L & 0xFFFFFFFFFFFFFFF8L) - this.allocatedAddress);
            this.isAccessible = true;
            this.isFreed = false;
            this.originalBufferObject = null;
        }

        MemoryRef(long allocatedAddress, Object originalBufferObject) {
            this.buffer = null;
            this.allocatedAddress = allocatedAddress;
            this.offset = 0;
            this.originalBufferObject = originalBufferObject;
            this.isAccessible = true;
        }

        void free() {
            this.buffer = null;
            this.allocatedAddress = 0L;
            this.isAccessible = false;
            this.isFreed = true;
        }
    }
}

