/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DirectByteBuffer;
import java.nio.ReadOnlyBufferException;
import java.nio.ShortBuffer;
import libcore.io.Memory;

class ByteBufferAsShortBuffer
extends ShortBuffer {
    protected final ByteBuffer bb;
    protected final int offset;
    private final ByteOrder order;

    ByteBufferAsShortBuffer(ByteBuffer bb, int mark, int pos, int lim, int cap, int off, ByteOrder order) {
        super(mark, pos, lim, cap);
        this.bb = bb.duplicate();
        this.isReadOnly = bb.isReadOnly;
        if (bb instanceof DirectByteBuffer) {
            this.address = bb.address + (long)off;
        }
        this.bb.order(order);
        this.order = order;
        this.offset = off;
    }

    @Override
    public ShortBuffer slice() {
        int pos = this.position();
        int lim = this.limit();
        assert (pos <= lim);
        int rem = pos <= lim ? lim - pos : 0;
        int off = (pos << 1) + this.offset;
        assert (off >= 0);
        return new ByteBufferAsShortBuffer(this.bb, -1, 0, rem, rem, off, this.order);
    }

    @Override
    public ShortBuffer duplicate() {
        return new ByteBufferAsShortBuffer(this.bb, this.markValue(), this.position(), this.limit(), this.capacity(), this.offset, this.order);
    }

    @Override
    public ShortBuffer asReadOnlyBuffer() {
        return new ByteBufferAsShortBuffer(this.bb.asReadOnlyBuffer(), this.markValue(), this.position(), this.limit(), this.capacity(), this.offset, this.order);
    }

    protected int ix(int i) {
        return (i << 1) + this.offset;
    }

    @Override
    public short get() {
        return this.get(this.nextGetIndex());
    }

    @Override
    public short get(int i) {
        return this.bb.getShortUnchecked(this.ix(this.checkIndex(i)));
    }

    @Override
    public ShortBuffer get(short[] dst, int offset, int length) {
        ByteBufferAsShortBuffer.checkBounds(offset, length, dst.length);
        if (length > this.remaining()) {
            throw new BufferUnderflowException();
        }
        this.bb.getUnchecked(this.ix(this.position), dst, offset, length);
        this.position += length;
        return this;
    }

    @Override
    public ShortBuffer put(short x) {
        this.put(this.nextPutIndex(), x);
        return this;
    }

    @Override
    public ShortBuffer put(int i, short x) {
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        this.bb.putShortUnchecked(this.ix(this.checkIndex(i)), x);
        return this;
    }

    @Override
    public ShortBuffer put(short[] src, int offset, int length) {
        ByteBufferAsShortBuffer.checkBounds(offset, length, src.length);
        if (length > this.remaining()) {
            throw new BufferOverflowException();
        }
        this.bb.putUnchecked(this.ix(this.position), src, offset, length);
        this.position += length;
        return this;
    }

    @Override
    public ShortBuffer compact() {
        int rem;
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        int pos = this.position();
        int lim = this.limit();
        assert (pos <= lim);
        int n = rem = pos <= lim ? lim - pos : 0;
        if (!(this.bb instanceof DirectByteBuffer)) {
            System.arraycopy(this.bb.array(), this.ix(pos), this.bb.array(), this.ix(0), rem << 1);
        } else {
            Memory.memmove(this, this.ix(0), this, this.ix(pos), rem << 1);
        }
        this.position(rem);
        this.limit(this.capacity());
        this.discardMark();
        return this;
    }

    @Override
    public boolean isDirect() {
        return this.bb.isDirect();
    }

    @Override
    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    @Override
    public ByteOrder order() {
        return this.order;
    }
}

