/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DirectByteBuffer;
import java.nio.LongBuffer;
import java.nio.ReadOnlyBufferException;
import libcore.io.Memory;

class ByteBufferAsLongBuffer
extends LongBuffer {
    protected final ByteBuffer bb;
    protected final int offset;
    private final ByteOrder order;

    ByteBufferAsLongBuffer(ByteBuffer bb, int mark, int pos, int lim, int cap, int off, ByteOrder order) {
        super(mark, pos, lim, cap);
        this.bb = bb.duplicate();
        this.isReadOnly = bb.isReadOnly;
        if (bb instanceof DirectByteBuffer) {
            this.address = bb.address + (long)off;
        }
        this.bb.order(order);
        this.order = order;
        this.offset = off;
    }

    @Override
    public LongBuffer slice() {
        int pos = this.position();
        int lim = this.limit();
        assert (pos <= lim);
        int rem = pos <= lim ? lim - pos : 0;
        int off = (pos << 3) + this.offset;
        assert (off >= 0);
        return new ByteBufferAsLongBuffer(this.bb, -1, 0, rem, rem, off, this.order);
    }

    @Override
    public LongBuffer duplicate() {
        return new ByteBufferAsLongBuffer(this.bb, this.markValue(), this.position(), this.limit(), this.capacity(), this.offset, this.order);
    }

    @Override
    public LongBuffer asReadOnlyBuffer() {
        return new ByteBufferAsLongBuffer(this.bb.asReadOnlyBuffer(), this.markValue(), this.position(), this.limit(), this.capacity(), this.offset, this.order);
    }

    protected int ix(int i) {
        return (i << 3) + this.offset;
    }

    @Override
    public long get() {
        return this.get(this.nextGetIndex());
    }

    @Override
    public long get(int i) {
        return this.bb.getLongUnchecked(this.ix(this.checkIndex(i)));
    }

    @Override
    public LongBuffer get(long[] dst, int offset, int length) {
        ByteBufferAsLongBuffer.checkBounds(offset, length, dst.length);
        if (length > this.remaining()) {
            throw new BufferUnderflowException();
        }
        this.bb.getUnchecked(this.ix(this.position), dst, offset, length);
        this.position += length;
        return this;
    }

    @Override
    public LongBuffer put(long x) {
        this.put(this.nextPutIndex(), x);
        return this;
    }

    @Override
    public LongBuffer put(int i, long x) {
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        this.bb.putLongUnchecked(this.ix(this.checkIndex(i)), x);
        return this;
    }

    @Override
    public LongBuffer put(long[] src, int offset, int length) {
        ByteBufferAsLongBuffer.checkBounds(offset, length, src.length);
        if (length > this.remaining()) {
            throw new BufferOverflowException();
        }
        this.bb.putUnchecked(this.ix(this.position), src, offset, length);
        this.position += length;
        return this;
    }

    @Override
    public LongBuffer compact() {
        int rem;
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        int pos = this.position();
        int lim = this.limit();
        assert (pos <= lim);
        int n = rem = pos <= lim ? lim - pos : 0;
        if (!(this.bb instanceof DirectByteBuffer)) {
            System.arraycopy(this.bb.array(), this.ix(pos), this.bb.array(), this.ix(0), rem << 3);
        } else {
            Memory.memmove(this, this.ix(0), this, this.ix(pos), rem << 3);
        }
        this.position(rem);
        this.limit(this.capacity());
        this.discardMark();
        return this;
    }

    @Override
    public boolean isDirect() {
        return this.bb.isDirect();
    }

    @Override
    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    @Override
    public ByteOrder order() {
        return this.order;
    }
}

