/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DirectByteBuffer;
import java.nio.IntBuffer;
import java.nio.ReadOnlyBufferException;
import libcore.io.Memory;

class ByteBufferAsIntBuffer
extends IntBuffer {
    protected final ByteBuffer bb;
    protected final int offset;
    private final ByteOrder order;

    ByteBufferAsIntBuffer(ByteBuffer bb, int mark, int pos, int lim, int cap, int off, ByteOrder order) {
        super(mark, pos, lim, cap);
        this.bb = bb.duplicate();
        this.isReadOnly = bb.isReadOnly;
        if (bb instanceof DirectByteBuffer) {
            this.address = bb.address + (long)off;
        }
        this.bb.order(order);
        this.order = order;
        this.offset = off;
    }

    @Override
    public IntBuffer slice() {
        int pos = this.position();
        int lim = this.limit();
        assert (pos <= lim);
        int rem = pos <= lim ? lim - pos : 0;
        int off = (pos << 2) + this.offset;
        assert (off >= 0);
        return new ByteBufferAsIntBuffer(this.bb, -1, 0, rem, rem, off, this.order);
    }

    @Override
    public IntBuffer duplicate() {
        return new ByteBufferAsIntBuffer(this.bb, this.markValue(), this.position(), this.limit(), this.capacity(), this.offset, this.order);
    }

    @Override
    public IntBuffer asReadOnlyBuffer() {
        return new ByteBufferAsIntBuffer(this.bb.asReadOnlyBuffer(), this.markValue(), this.position(), this.limit(), this.capacity(), this.offset, this.order);
    }

    protected int ix(int i) {
        return (i << 2) + this.offset;
    }

    @Override
    public int get() {
        return this.get(this.nextGetIndex());
    }

    @Override
    public int get(int i) {
        return this.bb.getIntUnchecked(this.ix(this.checkIndex(i)));
    }

    @Override
    public IntBuffer get(int[] dst, int offset, int length) {
        ByteBufferAsIntBuffer.checkBounds(offset, length, dst.length);
        if (length > this.remaining()) {
            throw new BufferUnderflowException();
        }
        this.bb.getUnchecked(this.ix(this.position), dst, offset, length);
        this.position += length;
        return this;
    }

    @Override
    public IntBuffer put(int x) {
        this.put(this.nextPutIndex(), x);
        return this;
    }

    @Override
    public IntBuffer put(int i, int x) {
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        this.bb.putIntUnchecked(this.ix(this.checkIndex(i)), x);
        return this;
    }

    @Override
    public IntBuffer put(int[] src, int offset, int length) {
        ByteBufferAsIntBuffer.checkBounds(offset, length, src.length);
        if (length > this.remaining()) {
            throw new BufferOverflowException();
        }
        this.bb.putUnchecked(this.ix(this.position), src, offset, length);
        this.position += length;
        return this;
    }

    @Override
    public IntBuffer compact() {
        int rem;
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        int pos = this.position();
        int lim = this.limit();
        assert (pos <= lim);
        int n = rem = pos <= lim ? lim - pos : 0;
        if (!(this.bb instanceof DirectByteBuffer)) {
            System.arraycopy(this.bb.array(), this.ix(pos), this.bb.array(), this.ix(0), rem << 2);
        } else {
            Memory.memmove(this, this.ix(0), this, this.ix(pos), rem << 2);
        }
        this.position(rem);
        this.limit(this.capacity());
        this.discardMark();
        return this;
    }

    @Override
    public boolean isDirect() {
        return this.bb.isDirect();
    }

    @Override
    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    @Override
    public ByteOrder order() {
        return this.order;
    }
}

