/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DirectByteBuffer;
import java.nio.FloatBuffer;
import java.nio.ReadOnlyBufferException;
import libcore.io.Memory;

class ByteBufferAsFloatBuffer
extends FloatBuffer {
    protected final ByteBuffer bb;
    protected final int offset;
    private final ByteOrder order;

    ByteBufferAsFloatBuffer(ByteBuffer bb, int mark, int pos, int lim, int cap, int off, ByteOrder order) {
        super(mark, pos, lim, cap);
        this.bb = bb.duplicate();
        this.isReadOnly = bb.isReadOnly;
        if (bb instanceof DirectByteBuffer) {
            this.address = bb.address + (long)off;
        }
        this.bb.order(order);
        this.order = order;
        this.offset = off;
    }

    @Override
    public FloatBuffer slice() {
        int pos = this.position();
        int lim = this.limit();
        assert (pos <= lim);
        int rem = pos <= lim ? lim - pos : 0;
        int off = (pos << 2) + this.offset;
        assert (off >= 0);
        return new ByteBufferAsFloatBuffer(this.bb, -1, 0, rem, rem, off, this.order);
    }

    @Override
    public FloatBuffer duplicate() {
        return new ByteBufferAsFloatBuffer(this.bb, this.markValue(), this.position(), this.limit(), this.capacity(), this.offset, this.order);
    }

    @Override
    public FloatBuffer asReadOnlyBuffer() {
        return new ByteBufferAsFloatBuffer(this.bb.asReadOnlyBuffer(), this.markValue(), this.position(), this.limit(), this.capacity(), this.offset, this.order);
    }

    protected int ix(int i) {
        return (i << 2) + this.offset;
    }

    @Override
    public float get() {
        return this.get(this.nextGetIndex());
    }

    @Override
    public float get(int i) {
        return this.bb.getFloatUnchecked(this.ix(this.checkIndex(i)));
    }

    @Override
    public FloatBuffer get(float[] dst, int offset, int length) {
        ByteBufferAsFloatBuffer.checkBounds(offset, length, dst.length);
        if (length > this.remaining()) {
            throw new BufferUnderflowException();
        }
        this.bb.getUnchecked(this.ix(this.position), dst, offset, length);
        this.position += length;
        return this;
    }

    @Override
    public FloatBuffer put(float x) {
        this.put(this.nextPutIndex(), x);
        return this;
    }

    @Override
    public FloatBuffer put(int i, float x) {
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        this.bb.putFloatUnchecked(this.ix(this.checkIndex(i)), x);
        return this;
    }

    @Override
    public FloatBuffer put(float[] src, int offset, int length) {
        ByteBufferAsFloatBuffer.checkBounds(offset, length, src.length);
        if (length > this.remaining()) {
            throw new BufferOverflowException();
        }
        this.bb.putUnchecked(this.ix(this.position), src, offset, length);
        this.position += length;
        return this;
    }

    @Override
    public FloatBuffer compact() {
        int rem;
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        int pos = this.position();
        int lim = this.limit();
        assert (pos <= lim);
        int n = rem = pos <= lim ? lim - pos : 0;
        if (!(this.bb instanceof DirectByteBuffer)) {
            System.arraycopy(this.bb.array(), this.ix(pos), this.bb.array(), this.ix(0), rem << 2);
        } else {
            Memory.memmove(this, this.ix(0), this, this.ix(pos), rem << 2);
        }
        this.position(rem);
        this.limit(this.capacity());
        this.discardMark();
        return this;
    }

    @Override
    public boolean isDirect() {
        return this.bb.isDirect();
    }

    @Override
    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    @Override
    public ByteOrder order() {
        return this.order;
    }
}

