/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DirectByteBuffer;
import java.nio.ReadOnlyBufferException;
import libcore.io.Memory;

class ByteBufferAsCharBuffer
extends CharBuffer {
    protected final ByteBuffer bb;
    protected final int offset;
    private final ByteOrder order;

    ByteBufferAsCharBuffer(ByteBuffer bb, int mark, int pos, int lim, int cap, int off, ByteOrder order) {
        super(mark, pos, lim, cap);
        this.bb = bb.duplicate();
        this.isReadOnly = bb.isReadOnly;
        if (bb instanceof DirectByteBuffer) {
            this.address = bb.address + (long)off;
        }
        this.bb.order(order);
        this.order = order;
        this.offset = off;
    }

    @Override
    public CharBuffer slice() {
        int pos = this.position();
        int lim = this.limit();
        assert (pos <= lim);
        int rem = pos <= lim ? lim - pos : 0;
        int off = (pos << 1) + this.offset;
        assert (off >= 0);
        return new ByteBufferAsCharBuffer(this.bb, -1, 0, rem, rem, off, this.order);
    }

    @Override
    public CharBuffer duplicate() {
        return new ByteBufferAsCharBuffer(this.bb, this.markValue(), this.position(), this.limit(), this.capacity(), this.offset, this.order);
    }

    @Override
    public CharBuffer asReadOnlyBuffer() {
        return new ByteBufferAsCharBuffer(this.bb.asReadOnlyBuffer(), this.markValue(), this.position(), this.limit(), this.capacity(), this.offset, this.order);
    }

    protected int ix(int i) {
        return (i << 1) + this.offset;
    }

    @Override
    public char get() {
        return this.get(this.nextGetIndex());
    }

    @Override
    public char get(int i) {
        return this.bb.getCharUnchecked(this.ix(this.checkIndex(i)));
    }

    @Override
    public CharBuffer get(char[] dst, int offset, int length) {
        ByteBufferAsCharBuffer.checkBounds(offset, length, dst.length);
        if (length > this.remaining()) {
            throw new BufferUnderflowException();
        }
        this.bb.getUnchecked(this.ix(this.position), dst, offset, length);
        this.position += length;
        return this;
    }

    @Override
    char getUnchecked(int i) {
        return this.bb.getCharUnchecked(this.ix(i));
    }

    @Override
    public CharBuffer put(char x) {
        this.put(this.nextPutIndex(), x);
        return this;
    }

    @Override
    public CharBuffer put(int i, char x) {
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        this.bb.putCharUnchecked(this.ix(this.checkIndex(i)), x);
        return this;
    }

    @Override
    public CharBuffer put(char[] src, int offset, int length) {
        ByteBufferAsCharBuffer.checkBounds(offset, length, src.length);
        if (length > this.remaining()) {
            throw new BufferOverflowException();
        }
        this.bb.putUnchecked(this.ix(this.position), src, offset, length);
        this.position += length;
        return this;
    }

    @Override
    public CharBuffer compact() {
        int rem;
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        int pos = this.position();
        int lim = this.limit();
        assert (pos <= lim);
        int n = rem = pos <= lim ? lim - pos : 0;
        if (!(this.bb instanceof DirectByteBuffer)) {
            System.arraycopy(this.bb.array(), this.ix(pos), this.bb.array(), this.ix(0), rem << 1);
        } else {
            Memory.memmove(this, this.ix(0), this, this.ix(pos), rem << 1);
        }
        this.position(rem);
        this.limit(this.capacity());
        this.discardMark();
        return this;
    }

    @Override
    public boolean isDirect() {
        return this.bb.isDirect();
    }

    @Override
    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    @Override
    public String toString(int start, int end) {
        if (end > this.limit() || start > end) {
            throw new IndexOutOfBoundsException();
        }
        try {
            int len = end - start;
            char[] ca = new char[len];
            CharBuffer cb = CharBuffer.wrap(ca);
            CharBuffer db = this.duplicate();
            db.position(start);
            db.limit(end);
            cb.put(db);
            return new String(ca);
        }
        catch (StringIndexOutOfBoundsException x) {
            throw new IndexOutOfBoundsException();
        }
    }

    @Override
    public CharBuffer subSequence(int start, int end) {
        int pos = this.position();
        int lim = this.limit();
        assert (pos <= lim);
        pos = pos <= lim ? pos : lim;
        int len = lim - pos;
        if (start < 0 || end > len || start > end) {
            throw new IndexOutOfBoundsException();
        }
        return new ByteBufferAsCharBuffer(this.bb, -1, pos + start, pos + end, this.capacity(), this.offset, this.order);
    }

    @Override
    public ByteOrder order() {
        return this.order;
    }
}

