/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Bits;
import java.nio.Buffer;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DirectByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.HeapByteBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ReadOnlyBufferException;
import java.nio.ShortBuffer;
import libcore.io.Memory;

public abstract class ByteBuffer
extends Buffer
implements Comparable<ByteBuffer> {
    final byte[] hb;
    final int offset;
    boolean isReadOnly;
    boolean bigEndian = true;
    boolean nativeByteOrder = Bits.byteOrder() == ByteOrder.BIG_ENDIAN;

    ByteBuffer(int mark, int pos, int lim, int cap, byte[] hb, int offset) {
        super(mark, pos, lim, cap, 0);
        this.hb = hb;
        this.offset = offset;
    }

    ByteBuffer(int mark, int pos, int lim, int cap) {
        this(mark, pos, lim, cap, null, 0);
    }

    public static ByteBuffer allocateDirect(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException("capacity < 0: " + capacity);
        }
        DirectByteBuffer.MemoryRef memoryRef = new DirectByteBuffer.MemoryRef(capacity);
        return new DirectByteBuffer(capacity, memoryRef);
    }

    public static ByteBuffer allocate(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        return new HeapByteBuffer(capacity, capacity);
    }

    public static ByteBuffer wrap(byte[] array, int offset, int length) {
        try {
            return new HeapByteBuffer(array, offset, length);
        }
        catch (IllegalArgumentException x) {
            throw new IndexOutOfBoundsException();
        }
    }

    public static ByteBuffer wrap(byte[] array) {
        return ByteBuffer.wrap(array, 0, array.length);
    }

    public abstract ByteBuffer slice();

    public abstract ByteBuffer duplicate();

    public abstract ByteBuffer asReadOnlyBuffer();

    public abstract byte get();

    public abstract ByteBuffer put(byte var1);

    public abstract byte get(int var1);

    public abstract ByteBuffer put(int var1, byte var2);

    public ByteBuffer get(byte[] dst, int offset, int length) {
        ByteBuffer.checkBounds(offset, length, dst.length);
        if (length > this.remaining()) {
            throw new BufferUnderflowException();
        }
        int end = offset + length;
        for (int i = offset; i < end; ++i) {
            dst[i] = this.get();
        }
        return this;
    }

    public ByteBuffer get(byte[] dst) {
        return this.get(dst, 0, dst.length);
    }

    public ByteBuffer put(ByteBuffer src) {
        if (!this.isAccessible()) {
            throw new IllegalStateException("buffer is inaccessible");
        }
        if (src == this) {
            throw new IllegalArgumentException();
        }
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        int n = src.remaining();
        if (n > this.remaining()) {
            throw new BufferOverflowException();
        }
        if (this.hb != null && src.hb != null) {
            System.arraycopy(src.hb, src.position() + src.offset, this.hb, this.position() + this.offset, n);
        } else {
            ByteBuffer dst;
            Object srcObject = src.isDirect() ? src : (Object)src.hb;
            int srcOffset = src.position();
            if (!src.isDirect()) {
                srcOffset += src.offset;
            }
            Object dstObject = (dst = this).isDirect() ? dst : (Object)dst.hb;
            int dstOffset = dst.position();
            if (!dst.isDirect()) {
                dstOffset += dst.offset;
            }
            Memory.memmove(dstObject, dstOffset, srcObject, srcOffset, n);
        }
        src.position(src.limit());
        this.position(this.position() + n);
        return this;
    }

    public ByteBuffer put(byte[] src, int offset, int length) {
        ByteBuffer.checkBounds(offset, length, src.length);
        if (length > this.remaining()) {
            throw new BufferOverflowException();
        }
        int end = offset + length;
        for (int i = offset; i < end; ++i) {
            this.put(src[i]);
        }
        return this;
    }

    public final ByteBuffer put(byte[] src) {
        return this.put(src, 0, src.length);
    }

    @Override
    public final boolean hasArray() {
        return this.hb != null && !this.isReadOnly();
    }

    public final byte[] array() {
        if (this.hb == null) {
            throw new UnsupportedOperationException();
        }
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        return this.hb;
    }

    @Override
    public final int arrayOffset() {
        if (this.hb == null) {
            throw new UnsupportedOperationException();
        }
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        return this.offset;
    }

    public abstract ByteBuffer compact();

    @Override
    public abstract boolean isDirect();

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName());
        sb.append("[pos=");
        sb.append(this.position());
        sb.append(" lim=");
        sb.append(this.limit());
        sb.append(" cap=");
        sb.append(this.capacity());
        sb.append("]");
        return sb.toString();
    }

    public int hashCode() {
        int h = 1;
        int p = this.position();
        for (int i = this.limit() - 1; i >= p; --i) {
            h = 31 * h + this.get(i);
        }
        return h;
    }

    public boolean equals(Object ob) {
        if (this == ob) {
            return true;
        }
        if (!(ob instanceof ByteBuffer)) {
            return false;
        }
        ByteBuffer that = (ByteBuffer)ob;
        if (this.remaining() != that.remaining()) {
            return false;
        }
        int p = this.position();
        int i = this.limit() - 1;
        int j = that.limit() - 1;
        while (i >= p) {
            if (!ByteBuffer.equals(this.get(i), that.get(j))) {
                return false;
            }
            --i;
            --j;
        }
        return true;
    }

    private static boolean equals(byte x, byte y) {
        return x == y;
    }

    @Override
    public int compareTo(ByteBuffer that) {
        int n = this.position() + Math.min(this.remaining(), that.remaining());
        int i = this.position();
        int j = that.position();
        while (i < n) {
            int cmp = ByteBuffer.compare(this.get(i), that.get(j));
            if (cmp != 0) {
                return cmp;
            }
            ++i;
            ++j;
        }
        return this.remaining() - that.remaining();
    }

    private static int compare(byte x, byte y) {
        return Byte.compare(x, y);
    }

    public final ByteOrder order() {
        return this.bigEndian ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
    }

    public final ByteBuffer order(ByteOrder bo) {
        this.bigEndian = bo == ByteOrder.BIG_ENDIAN;
        this.nativeByteOrder = this.bigEndian == (Bits.byteOrder() == ByteOrder.BIG_ENDIAN);
        return this;
    }

    abstract byte _get(int var1);

    abstract void _put(int var1, byte var2);

    public abstract char getChar();

    public abstract ByteBuffer putChar(char var1);

    public abstract char getChar(int var1);

    char getCharUnchecked(int index) {
        throw new UnsupportedOperationException();
    }

    void getUnchecked(int pos, char[] dst, int dstOffset, int length) {
        throw new UnsupportedOperationException();
    }

    public abstract ByteBuffer putChar(int var1, char var2);

    void putCharUnchecked(int index, char value) {
        throw new UnsupportedOperationException();
    }

    void putUnchecked(int pos, char[] dst, int srcOffset, int length) {
        throw new UnsupportedOperationException();
    }

    public abstract CharBuffer asCharBuffer();

    public abstract short getShort();

    public abstract ByteBuffer putShort(short var1);

    public abstract short getShort(int var1);

    short getShortUnchecked(int index) {
        throw new UnsupportedOperationException();
    }

    void getUnchecked(int pos, short[] dst, int dstOffset, int length) {
        throw new UnsupportedOperationException();
    }

    public abstract ByteBuffer putShort(int var1, short var2);

    void putShortUnchecked(int index, short value) {
        throw new UnsupportedOperationException();
    }

    void putUnchecked(int pos, short[] dst, int srcOffset, int length) {
        throw new UnsupportedOperationException();
    }

    public abstract ShortBuffer asShortBuffer();

    public abstract int getInt();

    public abstract ByteBuffer putInt(int var1);

    public abstract int getInt(int var1);

    int getIntUnchecked(int index) {
        throw new UnsupportedOperationException();
    }

    void getUnchecked(int pos, int[] dst, int dstOffset, int length) {
        throw new UnsupportedOperationException();
    }

    public abstract ByteBuffer putInt(int var1, int var2);

    void putIntUnchecked(int index, int value) {
        throw new UnsupportedOperationException();
    }

    void putUnchecked(int pos, int[] dst, int srcOffset, int length) {
        throw new UnsupportedOperationException();
    }

    public abstract IntBuffer asIntBuffer();

    public abstract long getLong();

    public abstract ByteBuffer putLong(long var1);

    public abstract long getLong(int var1);

    long getLongUnchecked(int index) {
        throw new UnsupportedOperationException();
    }

    void getUnchecked(int pos, long[] dst, int dstOffset, int length) {
        throw new UnsupportedOperationException();
    }

    public abstract ByteBuffer putLong(int var1, long var2);

    void putLongUnchecked(int index, long value) {
        throw new UnsupportedOperationException();
    }

    void putUnchecked(int pos, long[] dst, int srcOffset, int length) {
        throw new UnsupportedOperationException();
    }

    public abstract LongBuffer asLongBuffer();

    public abstract float getFloat();

    public abstract ByteBuffer putFloat(float var1);

    public abstract float getFloat(int var1);

    float getFloatUnchecked(int index) {
        throw new UnsupportedOperationException();
    }

    void getUnchecked(int pos, float[] dst, int dstOffset, int length) {
        throw new UnsupportedOperationException();
    }

    public abstract ByteBuffer putFloat(int var1, float var2);

    void putFloatUnchecked(int index, float value) {
        throw new UnsupportedOperationException();
    }

    void putUnchecked(int pos, float[] dst, int srcOffset, int length) {
        throw new UnsupportedOperationException();
    }

    public abstract FloatBuffer asFloatBuffer();

    public abstract double getDouble();

    public abstract ByteBuffer putDouble(double var1);

    public abstract double getDouble(int var1);

    double getDoubleUnchecked(int index) {
        throw new UnsupportedOperationException();
    }

    void getUnchecked(int pos, double[] dst, int dstOffset, int length) {
        throw new UnsupportedOperationException();
    }

    public abstract ByteBuffer putDouble(int var1, double var2);

    void putDoubleUnchecked(int index, double value) {
        throw new UnsupportedOperationException();
    }

    void putUnchecked(int pos, double[] dst, int srcOffset, int length) {
        throw new UnsupportedOperationException();
    }

    public abstract DoubleBuffer asDoubleBuffer();

    public boolean isAccessible() {
        return true;
    }

    public void setAccessible(boolean value) {
        throw new UnsupportedOperationException();
    }
}

