/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.Objects;
import sun.net.util.IPAddressUtil;

public abstract class URLStreamHandler {
    protected abstract URLConnection openConnection(URL var1) throws IOException;

    protected URLConnection openConnection(URL u, Proxy p) throws IOException {
        throw new UnsupportedOperationException("Method not implemented.");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void parseURL(URL u, String spec, int start, int limit) {
        int ind;
        String protocol = u.getProtocol();
        String authority = u.getAuthority();
        String userInfo = u.getUserInfo();
        String host = u.getHost();
        int port = u.getPort();
        String path = u.getPath();
        String query = u.getQuery();
        String ref = u.getRef();
        boolean isRelPath = false;
        boolean queryOnly = false;
        boolean querySet = false;
        if (start < limit) {
            int queryStart = spec.indexOf(63);
            boolean bl = queryOnly = queryStart == start;
            if (queryStart != -1 && queryStart < limit) {
                query = spec.substring(queryStart + 1, limit);
                if (limit > queryStart) {
                    limit = queryStart;
                }
                spec = spec.substring(0, queryStart);
                querySet = true;
            }
        }
        int i = 0;
        boolean isUNCName = false;
        if (!isUNCName && start <= limit - 2 && spec.charAt(start) == '/' && spec.charAt(start + 1) == '/') {
            block3: for (i = start += 2; i < limit; ++i) {
                switch (spec.charAt(i)) {
                    case '#': 
                    case '/': 
                    case '?': 
                    case '\\': {
                        break block3;
                    }
                    default: {
                        continue block3;
                    }
                }
            }
            host = authority = spec.substring(start, i);
            ind = authority.indexOf(64);
            if (ind != -1) {
                if (ind != authority.lastIndexOf(64)) {
                    userInfo = null;
                    host = null;
                } else {
                    userInfo = authority.substring(0, ind);
                    host = authority.substring(ind + 1);
                }
            } else {
                userInfo = null;
            }
            if (host != null) {
                if (host.length() > 0 && host.charAt(0) == '[') {
                    ind = host.indexOf(93);
                    if (ind <= 2) throw new IllegalArgumentException("Invalid authority field: " + authority);
                    String nhost = host;
                    if (!IPAddressUtil.isIPv6LiteralAddress((host = nhost.substring(0, ind + 1)).substring(1, ind))) {
                        throw new IllegalArgumentException("Invalid host: " + host);
                    }
                    port = -1;
                    if (nhost.length() > ind + 1) {
                        if (nhost.charAt(ind + 1) != ':') throw new IllegalArgumentException("Invalid authority field: " + authority);
                        if (nhost.length() > ++ind + 1) {
                            port = Integer.parseInt(nhost.substring(ind + 1));
                        }
                    }
                } else {
                    ind = host.indexOf(58);
                    port = -1;
                    if (ind >= 0) {
                        if (host.length() > ind + 1) {
                            char firstPortChar = host.charAt(ind + 1);
                            if (firstPortChar < '0' || firstPortChar > '9') throw new IllegalArgumentException("invalid port: " + host.substring(ind + 1));
                            port = Integer.parseInt(host.substring(ind + 1));
                        }
                        host = host.substring(0, ind);
                    }
                }
            } else {
                host = "";
            }
            if (port < -1) {
                throw new IllegalArgumentException("Invalid port number :" + port);
            }
            start = i;
            path = null;
            if (!querySet) {
                query = null;
            }
        }
        if (host == null) {
            host = "";
        }
        if (start < limit) {
            if (spec.charAt(start) == '/' || spec.charAt(start) == '\\') {
                path = spec.substring(start, limit);
            } else if (path != null && path.length() > 0) {
                isRelPath = true;
                ind = path.lastIndexOf(47);
                String seperator = "";
                if (ind == -1 && authority != null) {
                    seperator = "/";
                }
                path = path.substring(0, ind + 1) + seperator + spec.substring(start, limit);
            } else {
                String seperator = authority != null ? "/" : "";
                path = seperator + spec.substring(start, limit);
            }
        }
        if (path == null) {
            path = "";
        }
        while ((i = path.indexOf("/./")) >= 0) {
            path = path.substring(0, i) + path.substring(i + 2);
        }
        i = 0;
        while ((i = path.indexOf("/../", i)) >= 0) {
            if (i == 0) {
                path = path.substring(i + 3);
                i = 0;
                continue;
            }
            if (i > 0 && (limit = path.lastIndexOf(47, i - 1)) >= 0 && path.indexOf("/../", limit) != 0) {
                path = path.substring(0, limit) + path.substring(i + 3);
                i = 0;
                continue;
            }
            i += 3;
        }
        while (path.endsWith("/..") && (limit = path.lastIndexOf(47, (i = path.indexOf("/..")) - 1)) >= 0) {
            path = path.substring(0, limit + 1);
        }
        if (path.startsWith("./") && path.length() > 2) {
            path = path.substring(2);
        }
        if (path.endsWith("/.")) {
            path = path.substring(0, path.length() - 1);
        }
        if (path.endsWith("?")) {
            path = path.substring(0, path.length() - 1);
        }
        this.setURL(u, protocol, host, port, authority, userInfo, path, query, ref);
    }

    protected int getDefaultPort() {
        return -1;
    }

    protected boolean equals(URL u1, URL u2) {
        return Objects.equals(u1.getRef(), u2.getRef()) && Objects.equals(u1.getQuery(), u2.getQuery()) && this.sameFile(u1, u2);
    }

    protected int hashCode(URL u) {
        return Objects.hash(u.getRef(), u.getQuery(), u.getProtocol(), u.getFile(), u.getHost(), u.getPort());
    }

    protected boolean sameFile(URL u1, URL u2) {
        int port2;
        if (!(u1.getProtocol() == u2.getProtocol() || u1.getProtocol() != null && u1.getProtocol().equalsIgnoreCase(u2.getProtocol()))) {
            return false;
        }
        if (!(u1.getFile() == u2.getFile() || u1.getFile() != null && u1.getFile().equals(u2.getFile()))) {
            return false;
        }
        int port1 = u1.getPort() != -1 ? u1.getPort() : u1.handler.getDefaultPort();
        int n = port2 = u2.getPort() != -1 ? u2.getPort() : u2.handler.getDefaultPort();
        if (port1 != port2) {
            return false;
        }
        return this.hostsEqual(u1, u2);
    }

    protected synchronized InetAddress getHostAddress(URL u) {
        if (u.hostAddress != null) {
            return u.hostAddress;
        }
        String host = u.getHost();
        if (host == null || host.equals("")) {
            return null;
        }
        try {
            u.hostAddress = InetAddress.getByName(host);
        }
        catch (UnknownHostException ex) {
            return null;
        }
        catch (SecurityException se) {
            return null;
        }
        return u.hostAddress;
    }

    protected boolean hostsEqual(URL u1, URL u2) {
        if (u1.getHost() != null && u2.getHost() != null) {
            return u1.getHost().equalsIgnoreCase(u2.getHost());
        }
        return u1.getHost() == null && u2.getHost() == null;
    }

    protected String toExternalForm(URL u) {
        String fileAndQuery;
        int len = u.getProtocol().length() + 1;
        if (u.getAuthority() != null && u.getAuthority().length() > 0) {
            len += 2 + u.getAuthority().length();
        }
        if (u.getPath() != null) {
            len += u.getPath().length();
        }
        if (u.getQuery() != null) {
            len += 1 + u.getQuery().length();
        }
        if (u.getRef() != null) {
            len += 1 + u.getRef().length();
        }
        StringBuilder result = new StringBuilder(len);
        result.append(u.getProtocol());
        result.append(":");
        if (u.getAuthority() != null) {
            result.append("//");
            result.append(u.getAuthority());
        }
        if ((fileAndQuery = u.getFile()) != null) {
            result.append(fileAndQuery);
        }
        if (u.getRef() != null) {
            result.append("#");
            result.append(u.getRef());
        }
        return result.toString();
    }

    protected void setURL(URL u, String protocol, String host, int port, String authority, String userInfo, String path, String query, String ref) {
        if (this != u.handler) {
            throw new SecurityException("handler for url different from this handler");
        }
        u.set(u.getProtocol(), host, port, authority, userInfo, path, query, ref);
    }

    @Deprecated
    protected void setURL(URL u, String protocol, String host, int port, String file, String ref) {
        String authority = null;
        String userInfo = null;
        if (host != null && host.length() != 0) {
            authority = port == -1 ? host : host + ":" + port;
            int at = host.lastIndexOf(64);
            if (at != -1) {
                userInfo = host.substring(0, at);
                host = host.substring(at + 1);
            }
        }
        String path = null;
        String query = null;
        if (file != null) {
            int q = file.lastIndexOf(63);
            if (q != -1) {
                query = file.substring(q + 1);
                path = file.substring(0, q);
            } else {
                path = file;
            }
        }
        this.setURL(u, protocol, host, port, authority, userInfo, path, query, ref);
    }
}

