/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.Authenticator;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.PlainSocketImpl;
import java.net.Proxy;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketInputStream;
import java.net.SocketTimeoutException;
import java.net.SocksConsts;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import sun.security.action.GetPropertyAction;

class SocksSocketImpl
extends PlainSocketImpl
implements SocksConsts {
    private String server = null;
    private int serverPort = 1080;
    private InetSocketAddress external_address;
    private boolean useV4 = false;
    private Socket cmdsock = null;
    private InputStream cmdIn = null;
    private OutputStream cmdOut = null;
    private boolean applicationSetProxy;

    SocksSocketImpl() {
    }

    SocksSocketImpl(String server, int port) {
        this.server = server;
        this.serverPort = port == -1 ? 1080 : port;
    }

    SocksSocketImpl(Proxy proxy) {
        SocketAddress a = proxy.address();
        if (a instanceof InetSocketAddress) {
            InetSocketAddress ad = (InetSocketAddress)a;
            this.server = ad.getHostString();
            this.serverPort = ad.getPort();
        }
    }

    void setV4() {
        this.useV4 = true;
    }

    private synchronized void privilegedConnect(final String host, final int port, final int timeout) throws IOException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws IOException {
                    SocksSocketImpl.this.superConnectServer(host, port, timeout);
                    SocksSocketImpl.this.cmdIn = SocksSocketImpl.this.getInputStream();
                    SocksSocketImpl.this.cmdOut = SocksSocketImpl.this.getOutputStream();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw (IOException)pae.getException();
        }
    }

    private void superConnectServer(String host, int port, int timeout) throws IOException {
        super.connect(new InetSocketAddress(host, port), timeout);
    }

    private static int remainingMillis(long deadlineMillis) throws IOException {
        if (deadlineMillis == 0L) {
            return 0;
        }
        long remaining = deadlineMillis - System.currentTimeMillis();
        if (remaining > 0L) {
            return (int)remaining;
        }
        throw new SocketTimeoutException();
    }

    private int readSocksReply(InputStream in, byte[] data) throws IOException {
        return this.readSocksReply(in, data, 0L);
    }

    private int readSocksReply(InputStream in, byte[] data, long deadlineMillis) throws IOException {
        int count;
        int len = data.length;
        int received = 0;
        for (int attempts = 0; received < len && attempts < 3; received += count, ++attempts) {
            try {
                count = ((SocketInputStream)in).read(data, received, len - received, SocksSocketImpl.remainingMillis(deadlineMillis));
            }
            catch (SocketTimeoutException e) {
                throw new SocketTimeoutException("Connect timed out");
            }
            if (count >= 0) continue;
            throw new SocketException("Malformed reply from SOCKS server");
        }
        return received;
    }

    private boolean authenticate(byte method, InputStream in, BufferedOutputStream out) throws IOException {
        return this.authenticate(method, in, out, 0L);
    }

    private boolean authenticate(byte method, InputStream in, BufferedOutputStream out, long deadlineMillis) throws IOException {
        if (method == 0) {
            return true;
        }
        if (method == 2) {
            String password;
            block13: {
                String userName;
                password = null;
                final InetAddress addr = InetAddress.getByName(this.server);
                PasswordAuthentication pw = AccessController.doPrivileged(new PrivilegedAction<PasswordAuthentication>(){

                    @Override
                    public PasswordAuthentication run() {
                        return Authenticator.requestPasswordAuthentication(SocksSocketImpl.this.server, addr, SocksSocketImpl.this.serverPort, "SOCKS5", "SOCKS authentication", null);
                    }
                });
                if (pw != null) {
                    userName = pw.getUserName();
                    password = new String(pw.getPassword());
                } else {
                    userName = AccessController.doPrivileged(new GetPropertyAction("user.name"));
                }
                if (userName == null) {
                    return false;
                }
                out.write(1);
                out.write(userName.length());
                try {
                    out.write(userName.getBytes("ISO-8859-1"));
                }
                catch (UnsupportedEncodingException uee) {
                    if ($assertionsDisabled) break block13;
                    throw new AssertionError();
                }
            }
            if (password != null) {
                out.write(password.length());
                try {
                    out.write(password.getBytes("ISO-8859-1"));
                }
                catch (UnsupportedEncodingException uee) {
                    assert (false);
                }
            } else {
                out.write(0);
            }
            out.flush();
            byte[] data = new byte[2];
            int i = this.readSocksReply(in, data, deadlineMillis);
            if (i != 2 || data[1] != 0) {
                out.close();
                in.close();
                return false;
            }
            return true;
        }
        return false;
    }

    private void connectV4(InputStream in, OutputStream out, InetSocketAddress endpoint, long deadlineMillis) throws IOException {
        block12: {
            if (!(endpoint.getAddress() instanceof Inet4Address)) {
                throw new SocketException("SOCKS V4 requires IPv4 only addresses");
            }
            out.write(4);
            out.write(1);
            out.write(endpoint.getPort() >> 8 & 0xFF);
            out.write(endpoint.getPort() >> 0 & 0xFF);
            out.write(endpoint.getAddress().getAddress());
            String userName = this.getUserName();
            try {
                out.write(userName.getBytes("ISO-8859-1"));
            }
            catch (UnsupportedEncodingException uee) {
                if ($assertionsDisabled) break block12;
                throw new AssertionError();
            }
        }
        out.write(0);
        out.flush();
        byte[] data = new byte[8];
        int n = this.readSocksReply(in, data, deadlineMillis);
        if (n != 8) {
            throw new SocketException("Reply from SOCKS server has bad length: " + n);
        }
        if (data[0] != 0 && data[0] != 4) {
            throw new SocketException("Reply from SOCKS server has bad version");
        }
        SocketException ex = null;
        switch (data[1]) {
            case 90: {
                this.external_address = endpoint;
                break;
            }
            case 91: {
                ex = new SocketException("SOCKS request rejected");
                break;
            }
            case 92: {
                ex = new SocketException("SOCKS server couldn't reach destination");
                break;
            }
            case 93: {
                ex = new SocketException("SOCKS authentication failed");
                break;
            }
            default: {
                ex = new SocketException("Reply from SOCKS server contains bad status");
            }
        }
        if (ex != null) {
            in.close();
            out.close();
            throw ex;
        }
    }

    @Override
    protected void connect(SocketAddress endpoint, int timeout) throws IOException {
        long finish;
        long deadlineMillis = timeout == 0 ? 0L : ((finish = System.currentTimeMillis() + (long)timeout) < 0L ? Long.MAX_VALUE : finish);
        SecurityManager security = System.getSecurityManager();
        if (endpoint == null || !(endpoint instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Unsupported address type");
        }
        InetSocketAddress epoint = (InetSocketAddress)endpoint;
        if (security != null) {
            if (epoint.isUnresolved()) {
                security.checkConnect(epoint.getHostName(), epoint.getPort());
            } else {
                security.checkConnect(epoint.getAddress().getHostAddress(), epoint.getPort());
            }
        }
        if (this.server == null) {
            super.connect(epoint, SocksSocketImpl.remainingMillis(deadlineMillis));
            return;
        }
        try {
            this.privilegedConnect(this.server, this.serverPort, SocksSocketImpl.remainingMillis(deadlineMillis));
        }
        catch (IOException e) {
            throw new SocketException(e.getMessage());
        }
        BufferedOutputStream out = new BufferedOutputStream(this.cmdOut, 512);
        InputStream in = this.cmdIn;
        if (this.useV4) {
            if (epoint.isUnresolved()) {
                throw new UnknownHostException(epoint.toString());
            }
            this.connectV4(in, out, epoint, deadlineMillis);
            return;
        }
        out.write(5);
        out.write(2);
        out.write(0);
        out.write(2);
        out.flush();
        byte[] data = new byte[2];
        int i = this.readSocksReply(in, data, deadlineMillis);
        if (i != 2 || data[0] != 5) {
            if (epoint.isUnresolved()) {
                throw new UnknownHostException(epoint.toString());
            }
            this.connectV4(in, out, epoint, deadlineMillis);
            return;
        }
        if (data[1] == -1) {
            throw new SocketException("SOCKS : No acceptable methods");
        }
        if (!this.authenticate(data[1], in, out, deadlineMillis)) {
            throw new SocketException("SOCKS : authentication failed");
        }
        out.write(5);
        out.write(1);
        out.write(0);
        if (epoint.isUnresolved()) {
            block40: {
                out.write(3);
                out.write(epoint.getHostName().length());
                try {
                    out.write(epoint.getHostName().getBytes("ISO-8859-1"));
                }
                catch (UnsupportedEncodingException uee) {
                    if ($assertionsDisabled) break block40;
                    throw new AssertionError();
                }
            }
            out.write(epoint.getPort() >> 8 & 0xFF);
            out.write(epoint.getPort() >> 0 & 0xFF);
        } else if (epoint.getAddress() instanceof Inet6Address) {
            out.write(4);
            out.write(epoint.getAddress().getAddress());
            out.write(epoint.getPort() >> 8 & 0xFF);
            out.write(epoint.getPort() >> 0 & 0xFF);
        } else {
            out.write(1);
            out.write(epoint.getAddress().getAddress());
            out.write(epoint.getPort() >> 8 & 0xFF);
            out.write(epoint.getPort() >> 0 & 0xFF);
        }
        out.flush();
        data = new byte[4];
        i = this.readSocksReply(in, data, deadlineMillis);
        if (i != 4) {
            throw new SocketException("Reply from SOCKS server has bad length");
        }
        SocketException ex = null;
        block2 : switch (data[1]) {
            case 0: {
                switch (data[3]) {
                    case 1: {
                        byte[] addr = new byte[4];
                        i = this.readSocksReply(in, addr, deadlineMillis);
                        if (i != 4) {
                            throw new SocketException("Reply from SOCKS server badly formatted");
                        }
                        data = new byte[2];
                        i = this.readSocksReply(in, data, deadlineMillis);
                        if (i == 2) break block2;
                        throw new SocketException("Reply from SOCKS server badly formatted");
                    }
                    case 3: {
                        byte len = data[1];
                        byte[] host = new byte[len];
                        i = this.readSocksReply(in, host, deadlineMillis);
                        if (i != len) {
                            throw new SocketException("Reply from SOCKS server badly formatted");
                        }
                        data = new byte[2];
                        i = this.readSocksReply(in, data, deadlineMillis);
                        if (i == 2) break block2;
                        throw new SocketException("Reply from SOCKS server badly formatted");
                    }
                    case 4: {
                        byte len = data[1];
                        byte[] addr = new byte[len];
                        i = this.readSocksReply(in, addr, deadlineMillis);
                        if (i != len) {
                            throw new SocketException("Reply from SOCKS server badly formatted");
                        }
                        data = new byte[2];
                        i = this.readSocksReply(in, data, deadlineMillis);
                        if (i == 2) break block2;
                        throw new SocketException("Reply from SOCKS server badly formatted");
                    }
                }
                ex = new SocketException("Reply from SOCKS server contains wrong code");
                break;
            }
            case 1: {
                ex = new SocketException("SOCKS server general failure");
                break;
            }
            case 2: {
                ex = new SocketException("SOCKS: Connection not allowed by ruleset");
                break;
            }
            case 3: {
                ex = new SocketException("SOCKS: Network unreachable");
                break;
            }
            case 4: {
                ex = new SocketException("SOCKS: Host unreachable");
                break;
            }
            case 5: {
                ex = new SocketException("SOCKS: Connection refused");
                break;
            }
            case 6: {
                ex = new SocketException("SOCKS: TTL expired");
                break;
            }
            case 7: {
                ex = new SocketException("SOCKS: Command not supported");
                break;
            }
            case 8: {
                ex = new SocketException("SOCKS: address type not supported");
            }
        }
        if (ex != null) {
            in.close();
            out.close();
            throw ex;
        }
        this.external_address = epoint;
    }

    @Override
    protected InetAddress getInetAddress() {
        if (this.external_address != null) {
            return this.external_address.getAddress();
        }
        return super.getInetAddress();
    }

    @Override
    protected int getPort() {
        if (this.external_address != null) {
            return this.external_address.getPort();
        }
        return super.getPort();
    }

    @Override
    protected int getLocalPort() {
        if (this.socket != null) {
            return super.getLocalPort();
        }
        if (this.external_address != null) {
            return this.external_address.getPort();
        }
        return super.getLocalPort();
    }

    @Override
    protected void close() throws IOException {
        if (this.cmdsock != null) {
            this.cmdsock.close();
        }
        this.cmdsock = null;
        super.close();
    }

    private String getUserName() {
        String userName = "";
        if (this.applicationSetProxy) {
            try {
                userName = System.getProperty("user.name");
            }
            catch (SecurityException securityException) {}
        } else {
            userName = AccessController.doPrivileged(new GetPropertyAction("user.name"));
        }
        return userName;
    }
}

