/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import android.system.ErrnoException;
import android.system.OsConstants;
import java.io.FileDescriptor;
import java.io.IOException;
import java.net.AbstractPlainSocketImpl;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.SocketImpl;
import java.net.SocketOption;
import java.net.SocketTimeoutException;
import jdk.net.ExtendedSocketOptions;
import jdk.net.SocketFlow;
import libcore.io.AsynchronousCloseMonitor;
import libcore.io.IoBridge;
import libcore.io.IoUtils;
import libcore.io.Libcore;
import sun.net.ExtendedOptionsImpl;

class PlainSocketImpl
extends AbstractPlainSocketImpl {
    PlainSocketImpl() {
        this(new FileDescriptor());
    }

    PlainSocketImpl(FileDescriptor fd) {
        this.fd = fd;
    }

    @Override
    protected <T> void setOption(SocketOption<T> name, T value) throws IOException {
        if (!name.equals(ExtendedSocketOptions.SO_FLOW_SLA)) {
            super.setOption(name, value);
        } else {
            if (this.isClosedOrPending()) {
                throw new SocketException("Socket closed");
            }
            ExtendedOptionsImpl.checkSetOptionPermission(name);
            ExtendedOptionsImpl.checkValueType(value, SocketFlow.class);
            ExtendedOptionsImpl.setFlowOption(this.getFileDescriptor(), (SocketFlow)value);
        }
    }

    @Override
    protected <T> T getOption(SocketOption<T> name) throws IOException {
        if (!name.equals(ExtendedSocketOptions.SO_FLOW_SLA)) {
            return super.getOption(name);
        }
        if (this.isClosedOrPending()) {
            throw new SocketException("Socket closed");
        }
        ExtendedOptionsImpl.checkGetOptionPermission(name);
        SocketFlow flow = SocketFlow.create();
        ExtendedOptionsImpl.getFlowOption(this.getFileDescriptor(), flow);
        return (T)flow;
    }

    @Override
    protected void socketSetOption(int opt, Object val) throws SocketException {
        block2: {
            try {
                this.socketSetOption0(opt, val);
            }
            catch (SocketException se) {
                if (this.socket != null && this.socket.isConnected()) break block2;
                throw se;
            }
        }
    }

    @Override
    void socketCreate(boolean isStream) throws IOException {
        this.fd.setInt$(IoBridge.socket(OsConstants.AF_INET6, isStream ? OsConstants.SOCK_STREAM : OsConstants.SOCK_DGRAM, 0).getInt$());
        if (this.serverSocket != null) {
            IoUtils.setBlocking(this.fd, false);
            IoBridge.setSocketOption(this.fd, 4, true);
        }
    }

    @Override
    void socketConnect(InetAddress address, int port, int timeout) throws IOException {
        if (this.fd == null || !this.fd.valid()) {
            throw new SocketException("Socket closed");
        }
        IoBridge.connect(this.fd, address, port, timeout);
        this.address = address;
        this.port = port;
        if (this.localport == 0 && !this.isClosedOrPending()) {
            this.localport = IoBridge.getLocalInetSocketAddress(this.fd).getPort();
        }
    }

    @Override
    void socketBind(InetAddress address, int port) throws IOException {
        if (this.fd == null || !this.fd.valid()) {
            throw new SocketException("Socket closed");
        }
        IoBridge.bind(this.fd, address, port);
        this.address = address;
        this.localport = port == 0 ? IoBridge.getLocalInetSocketAddress(this.fd).getPort() : port;
    }

    @Override
    void socketListen(int count) throws IOException {
        if (this.fd == null || !this.fd.valid()) {
            throw new SocketException("Socket closed");
        }
        try {
            Libcore.os.listen(this.fd, count);
        }
        catch (ErrnoException errnoException) {
            throw errnoException.rethrowAsSocketException();
        }
    }

    @Override
    void socketAccept(SocketImpl s) throws IOException {
        if (this.fd == null || !this.fd.valid()) {
            throw new SocketException("Socket closed");
        }
        if (this.timeout <= 0) {
            IoBridge.poll(this.fd, OsConstants.POLLIN | OsConstants.POLLERR, -1);
        } else {
            IoBridge.poll(this.fd, OsConstants.POLLIN | OsConstants.POLLERR, this.timeout);
        }
        InetSocketAddress peerAddress = new InetSocketAddress();
        try {
            FileDescriptor newfd = Libcore.os.accept(this.fd, peerAddress);
            s.fd.setInt$(newfd.getInt$());
            s.address = peerAddress.getAddress();
            s.port = peerAddress.getPort();
        }
        catch (ErrnoException errnoException) {
            if (errnoException.errno == OsConstants.EAGAIN) {
                throw new SocketTimeoutException(errnoException);
            }
            if (errnoException.errno == OsConstants.EINVAL || errnoException.errno == OsConstants.EBADF) {
                throw new SocketException("Socket closed");
            }
            errnoException.rethrowAsSocketException();
        }
        s.localport = IoBridge.getLocalInetSocketAddress(s.fd).getPort();
    }

    @Override
    int socketAvailable() throws IOException {
        return IoBridge.available(this.fd);
    }

    @Override
    void socketClose0(boolean useDeferredClose) throws IOException {
        if (this.fd == null || !this.fd.valid()) {
            throw new SocketException("socket already closed");
        }
        FileDescriptor markerFD = null;
        if (useDeferredClose) {
            markerFD = this.getMarkerFD();
        }
        if (useDeferredClose && markerFD != null) {
            try {
                Libcore.os.dup2(markerFD, this.fd.getInt$());
                Libcore.os.close(markerFD);
                AsynchronousCloseMonitor.signalBlockedThreads(this.fd);
            }
            catch (ErrnoException errnoException) {}
        } else {
            IoBridge.closeAndSignalBlockedThreads(this.fd);
        }
    }

    private FileDescriptor getMarkerFD() throws SocketException {
        FileDescriptor fd1 = new FileDescriptor();
        FileDescriptor fd2 = new FileDescriptor();
        try {
            Libcore.os.socketpair(OsConstants.AF_UNIX, OsConstants.SOCK_STREAM, 0, fd1, fd2);
            Libcore.os.shutdown(fd1, OsConstants.SHUT_RDWR);
            Libcore.os.close(fd2);
        }
        catch (ErrnoException errnoException) {
            return null;
        }
        return fd1;
    }

    @Override
    void socketShutdown(int howto) throws IOException {
        try {
            Libcore.os.shutdown(this.fd, howto);
        }
        catch (ErrnoException errnoException) {
            throw errnoException.rethrowAsIOException();
        }
    }

    void socketSetOption0(int cmd, Object value) throws SocketException {
        if (cmd == 4102) {
            return;
        }
        IoBridge.setSocketOption(this.fd, cmd, value);
    }

    @Override
    Object socketGetOption(int opt) throws SocketException {
        return IoBridge.getSocketOption(this.fd, opt);
    }

    @Override
    void socketSendUrgentData(int data) throws IOException {
        if (this.fd == null || !this.fd.valid()) {
            throw new SocketException("Socket closed");
        }
        try {
            byte[] buffer = new byte[]{(byte)data};
            Libcore.os.sendto(this.fd, buffer, 0, 1, OsConstants.MSG_OOB, null, 0);
        }
        catch (ErrnoException errnoException) {
            throw errnoException.rethrowAsSocketException();
        }
    }
}

