/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import android.system.ErrnoException;
import android.system.OsConstants;
import android.system.StructGroupReq;
import java.io.IOException;
import java.net.AbstractPlainDatagramSocketImpl;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.SocketOption;
import jdk.net.ExtendedSocketOptions;
import jdk.net.SocketFlow;
import libcore.io.IoBridge;
import libcore.io.Libcore;
import libcore.util.EmptyArray;
import sun.net.ExtendedOptionsImpl;

class PlainDatagramSocketImpl
extends AbstractPlainDatagramSocketImpl {
    PlainDatagramSocketImpl() {
    }

    @Override
    protected <T> void setOption(SocketOption<T> name, T value) throws IOException {
        if (!name.equals(ExtendedSocketOptions.SO_FLOW_SLA)) {
            super.setOption(name, value);
        } else {
            if (this.isClosed()) {
                throw new SocketException("Socket closed");
            }
            ExtendedOptionsImpl.checkSetOptionPermission(name);
            ExtendedOptionsImpl.checkValueType(value, SocketFlow.class);
            ExtendedOptionsImpl.setFlowOption(this.getFileDescriptor(), (SocketFlow)value);
        }
    }

    @Override
    protected <T> T getOption(SocketOption<T> name) throws IOException {
        if (!name.equals(ExtendedSocketOptions.SO_FLOW_SLA)) {
            return super.getOption(name);
        }
        if (this.isClosed()) {
            throw new SocketException("Socket closed");
        }
        ExtendedOptionsImpl.checkGetOptionPermission(name);
        SocketFlow flow = SocketFlow.create();
        ExtendedOptionsImpl.getFlowOption(this.getFileDescriptor(), flow);
        return (T)flow;
    }

    @Override
    protected void socketSetOption(int opt, Object val) throws SocketException {
        block2: {
            try {
                this.socketSetOption0(opt, val);
            }
            catch (SocketException se) {
                if (this.connected) break block2;
                throw se;
            }
        }
    }

    @Override
    protected synchronized void bind0(int lport, InetAddress laddr) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket closed");
        }
        IoBridge.bind(this.fd, laddr, lport);
        this.localPort = lport == 0 ? IoBridge.getLocalInetSocketAddress(this.fd).getPort() : lport;
    }

    @Override
    protected void send(DatagramPacket p) throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket closed");
        }
        if (p.getData() == null || p.getAddress() == null) {
            throw new NullPointerException("null buffer || null address");
        }
        int port = this.connected ? 0 : p.getPort();
        InetAddress address = this.connected ? null : p.getAddress();
        IoBridge.sendto(this.fd, p.getData(), p.getOffset(), p.getLength(), 0, address, port);
    }

    @Override
    protected synchronized int peek(InetAddress i) throws IOException {
        DatagramPacket p = new DatagramPacket(EmptyArray.BYTE, 0);
        this.doRecv(p, OsConstants.MSG_PEEK);
        i.holder().address = p.getAddress().holder().address;
        return p.getPort();
    }

    @Override
    protected synchronized int peekData(DatagramPacket p) throws IOException {
        this.doRecv(p, OsConstants.MSG_PEEK);
        return p.getPort();
    }

    @Override
    protected synchronized void receive0(DatagramPacket p) throws IOException {
        this.doRecv(p, 0);
    }

    private void doRecv(DatagramPacket p, int flags) throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket closed");
        }
        if (this.timeout != 0) {
            IoBridge.poll(this.fd, OsConstants.POLLIN | OsConstants.POLLERR, this.timeout);
        }
        IoBridge.recvfrom(false, this.fd, p.getData(), p.getOffset(), p.bufLength, flags, p, this.connected);
    }

    @Override
    protected void setTimeToLive(int ttl) throws IOException {
        IoBridge.setSocketOption(this.fd, 17, ttl);
    }

    @Override
    protected int getTimeToLive() throws IOException {
        return (Integer)IoBridge.getSocketOption(this.fd, 17);
    }

    @Override
    protected void setTTL(byte ttl) throws IOException {
        this.setTimeToLive(ttl & 0xFF);
    }

    @Override
    protected byte getTTL() throws IOException {
        return (byte)this.getTimeToLive();
    }

    private static StructGroupReq makeGroupReq(InetAddress gr_group, NetworkInterface networkInterface) {
        int gr_interface = networkInterface != null ? networkInterface.getIndex() : 0;
        return new StructGroupReq(gr_interface, gr_group);
    }

    @Override
    protected void join(InetAddress inetaddr, NetworkInterface netIf) throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket closed");
        }
        IoBridge.setSocketOption(this.fd, 19, PlainDatagramSocketImpl.makeGroupReq(inetaddr, netIf));
    }

    @Override
    protected void leave(InetAddress inetaddr, NetworkInterface netIf) throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket closed");
        }
        IoBridge.setSocketOption(this.fd, 20, PlainDatagramSocketImpl.makeGroupReq(inetaddr, netIf));
    }

    @Override
    protected void datagramSocketCreate() throws SocketException {
        this.fd = IoBridge.socket(OsConstants.AF_INET6, OsConstants.SOCK_DGRAM, 0);
        IoBridge.setSocketOption(this.fd, 32, true);
        try {
            Libcore.os.setsockoptInt(this.fd, OsConstants.IPPROTO_IP, OsConstants.IP_MULTICAST_ALL, 0);
        }
        catch (ErrnoException errnoException) {
            throw errnoException.rethrowAsSocketException();
        }
    }

    @Override
    protected void datagramSocketClose() {
        try {
            IoBridge.closeAndSignalBlockedThreads(this.fd);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void socketSetOption0(int opt, Object val) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket closed");
        }
        IoBridge.setSocketOption(this.fd, opt, val);
    }

    @Override
    protected Object socketGetOption(int opt) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket closed");
        }
        return IoBridge.getSocketOption(this.fd, opt);
    }

    @Override
    protected void connect0(InetAddress address, int port) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket closed");
        }
        IoBridge.connect(this.fd, address, port);
    }

    @Override
    protected void disconnect0(int family) {
        if (this.isClosed()) {
            return;
        }
        InetAddress inetAddressUnspec = new InetAddress();
        inetAddressUnspec.holder().family = OsConstants.AF_UNSPEC;
        try {
            IoBridge.connect(this.fd, inetAddressUnspec, 0);
        }
        catch (SocketException socketException) {
            // empty catch block
        }
    }
}

