/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import android.system.ErrnoException;
import android.system.OsConstants;
import android.system.StructIfaddrs;
import java.io.FileDescriptor;
import java.net.DefaultInterface;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetPermission;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import libcore.io.IoUtils;
import libcore.io.Libcore;

public final class NetworkInterface {
    private String name;
    private String displayName;
    private int index;
    private InetAddress[] addrs;
    private InterfaceAddress[] bindings;
    private List<NetworkInterface> childs;
    private NetworkInterface parent = null;
    private boolean virtual = false;
    private byte[] hardwareAddr;
    private static final NetworkInterface defaultInterface = DefaultInterface.getDefault();
    private static final int defaultIndex = defaultInterface != null ? defaultInterface.getIndex() : 0;

    NetworkInterface() {
    }

    NetworkInterface(String name, int index, InetAddress[] addrs) {
        this.name = name;
        this.index = index;
        this.addrs = addrs;
    }

    public String getName() {
        return this.name;
    }

    public Enumeration<InetAddress> getInetAddresses() {
        class CheckedAddresses
        implements Enumeration<InetAddress> {
            private int i = 0;
            private int count = 0;
            private InetAddress[] local_addrs;

            CheckedAddresses() {
                this.local_addrs = new InetAddress[NetworkInterface.this.addrs.length];
                boolean trusted = true;
                SecurityManager sec = System.getSecurityManager();
                if (sec != null) {
                    try {
                        sec.checkPermission(new NetPermission("getNetworkInformation"));
                    }
                    catch (SecurityException e) {
                        trusted = false;
                    }
                }
                for (int j = 0; j < NetworkInterface.this.addrs.length; ++j) {
                    try {
                        if (sec != null && !trusted) {
                            sec.checkConnect(NetworkInterface.this.addrs[j].getHostAddress(), -1);
                        }
                        this.local_addrs[this.count++] = NetworkInterface.this.addrs[j];
                        continue;
                    }
                    catch (SecurityException securityException) {
                        // empty catch block
                    }
                }
            }

            @Override
            public InetAddress nextElement() {
                if (this.i < this.count) {
                    return this.local_addrs[this.i++];
                }
                throw new NoSuchElementException();
            }

            @Override
            public boolean hasMoreElements() {
                return this.i < this.count;
            }
        }
        return new CheckedAddresses();
    }

    public List<InterfaceAddress> getInterfaceAddresses() {
        ArrayList<InterfaceAddress> lst = new ArrayList<InterfaceAddress>(1);
        if (this.bindings != null) {
            SecurityManager sec = System.getSecurityManager();
            for (int j = 0; j < this.bindings.length; ++j) {
                try {
                    if (sec != null) {
                        sec.checkConnect(this.bindings[j].getAddress().getHostAddress(), -1);
                    }
                    lst.add(this.bindings[j]);
                    continue;
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
        }
        return lst;
    }

    public Enumeration<NetworkInterface> getSubInterfaces() {
        return Collections.enumeration(this.childs);
    }

    public NetworkInterface getParent() {
        return this.parent;
    }

    public int getIndex() {
        return this.index;
    }

    public String getDisplayName() {
        return "".equals(this.displayName) ? null : this.displayName;
    }

    public static NetworkInterface getByName(String name) throws SocketException {
        NetworkInterface[] nis;
        if (name == null) {
            throw new NullPointerException();
        }
        for (NetworkInterface ni : nis = NetworkInterface.getAll()) {
            if (!ni.getName().equals(name)) continue;
            return ni;
        }
        return null;
    }

    public static NetworkInterface getByIndex(int index) throws SocketException {
        NetworkInterface[] nis;
        if (index < 0) {
            throw new IllegalArgumentException("Interface index can't be negative");
        }
        for (NetworkInterface ni : nis = NetworkInterface.getAll()) {
            if (ni.getIndex() != index) continue;
            return ni;
        }
        return null;
    }

    public static NetworkInterface getByInetAddress(InetAddress addr) throws SocketException {
        NetworkInterface[] nis;
        if (addr == null) {
            throw new NullPointerException();
        }
        if (!(addr instanceof Inet4Address) && !(addr instanceof Inet6Address)) {
            throw new IllegalArgumentException("invalid address type");
        }
        for (NetworkInterface ni : nis = NetworkInterface.getAll()) {
            for (InetAddress inetAddress : Collections.list(ni.getInetAddresses())) {
                if (!inetAddress.equals(addr)) continue;
                return ni;
            }
        }
        return null;
    }

    public static Enumeration<NetworkInterface> getNetworkInterfaces() throws SocketException {
        NetworkInterface[] netifs = NetworkInterface.getAll();
        if (netifs.length == 0) {
            return null;
        }
        return Collections.enumeration(Arrays.asList(netifs));
    }

    private static NetworkInterface[] getAll() throws SocketException {
        StructIfaddrs[] ifaddrs;
        HashMap<String, ArrayList<StructIfaddrs>> inetMap = new HashMap<String, ArrayList<StructIfaddrs>>();
        try {
            ifaddrs = Libcore.os.getifaddrs();
        }
        catch (ErrnoException e) {
            throw e.rethrowAsSocketException();
        }
        for (StructIfaddrs ifa : ifaddrs) {
            String name = ifa.ifa_name;
            ArrayList<StructIfaddrs> ifas = (ArrayList<StructIfaddrs>)inetMap.get(name);
            if (ifas == null) {
                ifas = new ArrayList<StructIfaddrs>();
                inetMap.put(name, ifas);
            }
            ifas.add(ifa);
        }
        HashMap<String, NetworkInterface> nis = new HashMap<String, NetworkInterface>(inetMap.size());
        for (Map.Entry e : inetMap.entrySet()) {
            String name = (String)e.getKey();
            int index = Libcore.os.if_nametoindex((String)e.getKey());
            if (index == 0) continue;
            NetworkInterface ni = new NetworkInterface(name, index, null);
            ni.displayName = name;
            ArrayList<InetAddress> addrs = new ArrayList<InetAddress>();
            ArrayList<InterfaceAddress> binds = new ArrayList<InterfaceAddress>();
            for (StructIfaddrs ifa : (List)e.getValue()) {
                if (ifa.ifa_addr != null) {
                    addrs.add(ifa.ifa_addr);
                    binds.add(new InterfaceAddress(ifa.ifa_addr, (Inet4Address)ifa.ifa_broadaddr, ifa.ifa_netmask));
                }
                if (ifa.hwaddr == null) continue;
                ni.hardwareAddr = ifa.hwaddr;
            }
            ni.addrs = addrs.toArray(new InetAddress[addrs.size()]);
            ni.bindings = binds.toArray(new InterfaceAddress[binds.size()]);
            ni.childs = new ArrayList<NetworkInterface>(0);
            nis.put(name, ni);
        }
        for (Map.Entry e : nis.entrySet()) {
            NetworkInterface ni = (NetworkInterface)e.getValue();
            String niName = ni.getName();
            int colonIdx = niName.indexOf(58);
            if (colonIdx == -1) continue;
            String parentName = niName.substring(0, colonIdx);
            NetworkInterface parent = (NetworkInterface)nis.get(parentName);
            ni.virtual = true;
            ni.parent = parent;
            parent.childs.add(ni);
        }
        return nis.values().toArray(new NetworkInterface[nis.size()]);
    }

    public boolean isUp() throws SocketException {
        return (this.getFlags() & OsConstants.IFF_UP) != 0;
    }

    public boolean isLoopback() throws SocketException {
        return (this.getFlags() & OsConstants.IFF_LOOPBACK) != 0;
    }

    public boolean isPointToPoint() throws SocketException {
        return (this.getFlags() & OsConstants.IFF_POINTOPOINT) != 0;
    }

    public boolean supportsMulticast() throws SocketException {
        return (this.getFlags() & OsConstants.IFF_MULTICAST) != 0;
    }

    public byte[] getHardwareAddress() throws SocketException {
        NetworkInterface ni = NetworkInterface.getByName(this.name);
        if (ni == null) {
            throw new SocketException("NetworkInterface doesn't exist anymore");
        }
        return ni.hardwareAddr;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getMTU() throws SocketException {
        int n;
        FileDescriptor fd = null;
        try {
            fd = Libcore.rawOs.socket(OsConstants.AF_INET, OsConstants.SOCK_DGRAM, 0);
            n = Libcore.rawOs.ioctlMTU(fd, this.name);
        }
        catch (ErrnoException e) {
            try {
                throw e.rethrowAsSocketException();
                catch (Exception ex) {
                    throw new SocketException(ex);
                }
            }
            catch (Throwable throwable) {
                IoUtils.closeQuietly(fd);
                throw throwable;
            }
        }
        IoUtils.closeQuietly(fd);
        return n;
    }

    public boolean isVirtual() {
        return this.virtual;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int getFlags() throws SocketException {
        int n;
        FileDescriptor fd = null;
        try {
            fd = Libcore.rawOs.socket(OsConstants.AF_INET, OsConstants.SOCK_DGRAM, 0);
            n = Libcore.rawOs.ioctlFlags(fd, this.name);
        }
        catch (ErrnoException e) {
            try {
                throw e.rethrowAsSocketException();
                catch (Exception ex) {
                    throw new SocketException(ex);
                }
            }
            catch (Throwable throwable) {
                IoUtils.closeQuietly(fd);
                throw throwable;
            }
        }
        IoUtils.closeQuietly(fd);
        return n;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof NetworkInterface)) {
            return false;
        }
        NetworkInterface that = (NetworkInterface)obj;
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.addrs == null) {
            return that.addrs == null;
        }
        if (that.addrs == null) {
            return false;
        }
        if (this.addrs.length != that.addrs.length) {
            return false;
        }
        InetAddress[] thatAddrs = that.addrs;
        int count = thatAddrs.length;
        for (int i = 0; i < count; ++i) {
            boolean found = false;
            for (int j = 0; j < count; ++j) {
                if (!this.addrs[i].equals(thatAddrs[j])) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.name == null ? 0 : this.name.hashCode();
    }

    public String toString() {
        String result = "name:";
        result = result + (this.name == null ? "null" : this.name);
        if (this.displayName != null) {
            result = result + " (" + this.displayName + ")";
        }
        return result;
    }

    static NetworkInterface getDefault() {
        return defaultInterface;
    }
}

