/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.net.Inet4Address;
import java.net.InetAddress;

public class InterfaceAddress {
    private InetAddress address = null;
    private Inet4Address broadcast = null;
    private short maskLength = 0;

    InterfaceAddress() {
    }

    InterfaceAddress(InetAddress address, Inet4Address broadcast, InetAddress netmask) {
        this.address = address;
        this.broadcast = broadcast;
        this.maskLength = this.countPrefixLength(netmask);
    }

    private short countPrefixLength(InetAddress netmask) {
        short count = 0;
        for (byte b : netmask.getAddress()) {
            while (b != 0) {
                b = (byte)(b << 1);
                count = (short)(count + 1);
            }
        }
        return count;
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public InetAddress getBroadcast() {
        return this.broadcast;
    }

    public short getNetworkPrefixLength() {
        return this.maskLength;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof InterfaceAddress)) {
            return false;
        }
        InterfaceAddress cmp = (InterfaceAddress)obj;
        if (!(this.address != null ? this.address.equals(cmp.address) : cmp.address == null)) {
            return false;
        }
        if (!(this.broadcast != null ? this.broadcast.equals(cmp.broadcast) : cmp.broadcast == null)) {
            return false;
        }
        return this.maskLength == cmp.maskLength;
    }

    public int hashCode() {
        return this.address.hashCode() + (this.broadcast != null ? this.broadcast.hashCode() : 0) + this.maskLength;
    }

    public String toString() {
        return this.address + "/" + this.maskLength + " [" + this.broadcast + "]";
    }
}

