/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import android.system.ErrnoException;
import android.system.GaiException;
import android.system.OsConstants;
import android.system.StructAddrinfo;
import android.system.StructIcmpHdr;
import dalvik.system.BlockGuard;
import java.io.FileDescriptor;
import java.io.IOException;
import java.net.AddressCache;
import java.net.DatagramPacket;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetAddressImpl;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.Enumeration;
import libcore.io.IoBridge;
import libcore.io.Libcore;

class Inet6AddressImpl
implements InetAddressImpl {
    private static InetAddress anyLocalAddress;
    private static InetAddress[] loopbackAddresses;
    private static final AddressCache addressCache;

    Inet6AddressImpl() {
    }

    @Override
    public InetAddress[] lookupAllHostAddr(String host, int netId) throws UnknownHostException {
        if (host == null || host.isEmpty()) {
            return this.loopbackAddresses();
        }
        InetAddress result = InetAddress.parseNumericAddressNoThrow(host);
        if (result != null) {
            if ((result = InetAddress.disallowDeprecatedFormats(host, result)) == null) {
                throw new UnknownHostException("Deprecated IPv4 address format: " + host);
            }
            return new InetAddress[]{result};
        }
        return Inet6AddressImpl.lookupHostByName(host, netId);
    }

    private static InetAddress[] lookupHostByName(String host, int netId) throws UnknownHostException {
        BlockGuard.getThreadPolicy().onNetwork();
        Object cachedResult = addressCache.get(host, netId);
        if (cachedResult != null) {
            if (cachedResult instanceof InetAddress[]) {
                return (InetAddress[])cachedResult;
            }
            throw new UnknownHostException((String)cachedResult);
        }
        try {
            InetAddress[] addresses;
            StructAddrinfo hints = new StructAddrinfo();
            hints.ai_flags = OsConstants.AI_ADDRCONFIG;
            hints.ai_family = OsConstants.AF_UNSPEC;
            hints.ai_socktype = OsConstants.SOCK_STREAM;
            for (InetAddress address : addresses = Libcore.os.android_getaddrinfo(host, hints, netId)) {
                address.holder().hostName = host;
            }
            addressCache.put(host, netId, addresses);
            return addresses;
        }
        catch (GaiException gaiException) {
            if (gaiException.getCause() instanceof ErrnoException && ((ErrnoException)gaiException.getCause()).errno == OsConstants.EACCES) {
                throw new SecurityException("Permission denied (missing INTERNET permission?)", gaiException);
            }
            String detailMessage = "Unable to resolve host \"" + host + "\": " + Libcore.os.gai_strerror(gaiException.error);
            addressCache.putUnknownHost(host, netId, detailMessage);
            throw gaiException.rethrowAsUnknownHostException(detailMessage);
        }
    }

    @Override
    public String getHostByAddr(byte[] addr) throws UnknownHostException {
        BlockGuard.getThreadPolicy().onNetwork();
        return this.getHostByAddr0(addr);
    }

    @Override
    public void clearAddressCache() {
        addressCache.clear();
    }

    @Override
    public boolean isReachable(InetAddress addr, int timeout, NetworkInterface netif, int ttl) throws IOException {
        InetAddress sourceAddr = null;
        if (netif != null) {
            Enumeration<InetAddress> it = netif.getInetAddresses();
            InetAddress inetaddr = null;
            while (it.hasMoreElements()) {
                inetaddr = it.nextElement();
                if (!inetaddr.getClass().isInstance(addr)) continue;
                sourceAddr = inetaddr;
                break;
            }
            if (sourceAddr == null) {
                return false;
            }
        }
        if (this.icmpEcho(addr, timeout, sourceAddr, ttl)) {
            return true;
        }
        return this.tcpEcho(addr, timeout, sourceAddr, ttl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tcpEcho(InetAddress addr, int timeout, InetAddress sourceAddr, int ttl) throws IOException {
        boolean bl;
        FileDescriptor fd = null;
        try {
            fd = IoBridge.socket(OsConstants.AF_INET6, OsConstants.SOCK_STREAM, 0);
            if (ttl > 0) {
                IoBridge.setSocketOption(fd, 25, ttl);
            }
            if (sourceAddr != null) {
                IoBridge.bind(fd, sourceAddr, 0);
            }
            IoBridge.connect(fd, addr, 7, timeout);
            bl = true;
        }
        catch (IOException e) {
            boolean bl2;
            try {
                Throwable cause = e.getCause();
                bl2 = cause instanceof ErrnoException && ((ErrnoException)cause).errno == OsConstants.ECONNREFUSED;
            }
            catch (Throwable throwable) {
                IoBridge.closeAndSignalBlockedThreads(fd);
                throw throwable;
            }
            IoBridge.closeAndSignalBlockedThreads(fd);
            return bl2;
        }
        IoBridge.closeAndSignalBlockedThreads(fd);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean icmpEcho(InetAddress addr, int timeout, InetAddress sourceAddr, int ttl) throws IOException {
        block19: {
            block18: {
                fd = null;
                try {
                    isIPv4 = addr instanceof Inet4Address;
                    domain = isIPv4 != false ? OsConstants.AF_INET : OsConstants.AF_INET6;
                    icmpProto = isIPv4 != false ? OsConstants.IPPROTO_ICMP : OsConstants.IPPROTO_ICMPV6;
                    fd = IoBridge.socket(domain, OsConstants.SOCK_DGRAM, icmpProto);
                    if (ttl > 0) {
                        IoBridge.setSocketOption(fd, 25, ttl);
                    }
                    if (sourceAddr != null) {
                        IoBridge.bind(fd, sourceAddr, 0);
                    }
                    to = timeout;
                    seq = 0;
lbl13:
                    // 2 sources

                    while (to > 0) {
                        sockTo = to >= 1000 ? 1000 : to;
                        IoBridge.setSocketOption(fd, 4102, sockTo);
                        packet = StructIcmpHdr.IcmpEchoHdr(isIPv4, seq).getBytes();
                        IoBridge.sendto(fd, packet, 0, packet.length, 0, addr, 0);
                        icmpId = IoBridge.getLocalInetSocketAddress(fd).getPort();
                        received = new byte[packet.length];
                        receivedPacket = new DatagramPacket(received, packet.length);
                        size = IoBridge.recvfrom(true, fd, received, 0, received.length, 0, receivedPacket, false);
                        if (size == packet.length) {
                            v0 = expectedType = isIPv4 != false ? (byte)OsConstants.ICMP_ECHOREPLY : (byte)OsConstants.ICMP6_ECHO_REPLY;
                            if (receivedPacket.getAddress().equals(addr) && received[0] == expectedType && received[4] == (byte)(icmpId >> 8) && received[5] == (byte)icmpId && received[6] == (byte)(seq >> 8) && received[7] == (byte)seq) {
                                var18_21 = true;
                                break block18;
                            }
                        }
                        ** GOTO lbl-1000
                    }
                    break block19;
                }
                catch (IOException var6_8) {
                    try {
                        Libcore.os.close(fd);
                        return false;
                    }
                    catch (ErrnoException var6_9) {
                        return false;
                    }
                    catch (Throwable var20_23) {
                        try {
                            Libcore.os.close(fd);
                            throw var20_23;
                        }
                        catch (ErrnoException var21_24) {
                            // empty catch block
                        }
                        throw var20_23;
                    }
                }
            }
            try {
                Libcore.os.close(fd);
                return var18_21;
            }
            catch (ErrnoException var19_22) {
                // empty catch block
            }
            return var18_21;
lbl-1000:
            // 1 sources

            {
                to -= sockTo;
                ++seq;
                ** GOTO lbl13
            }
        }
        try {
            Libcore.os.close(fd);
            return false;
        }
        catch (ErrnoException var6_7) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InetAddress anyLocalAddress() {
        Class<Inet6AddressImpl> clazz = Inet6AddressImpl.class;
        synchronized (Inet6AddressImpl.class) {
            if (anyLocalAddress == null) {
                Inet6Address anyAddress = new Inet6Address();
                anyAddress.holder().hostName = "::";
                anyLocalAddress = anyAddress;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return anyLocalAddress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InetAddress[] loopbackAddresses() {
        Class<Inet6AddressImpl> clazz = Inet6AddressImpl.class;
        synchronized (Inet6AddressImpl.class) {
            if (loopbackAddresses == null) {
                loopbackAddresses = new InetAddress[]{Inet6Address.LOOPBACK, Inet4Address.LOOPBACK};
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return loopbackAddresses;
        }
    }

    private String getHostByAddr0(byte[] addr) throws UnknownHostException {
        InetAddress hostaddr = InetAddress.getByAddress(addr);
        try {
            return Libcore.os.getnameinfo(hostaddr, OsConstants.NI_NAMEREQD);
        }
        catch (GaiException e) {
            UnknownHostException uhe = new UnknownHostException(hostaddr.toString());
            uhe.initCause(e);
            throw uhe;
        }
    }

    static {
        addressCache = new AddressCache();
    }
}

