/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import dalvik.system.VMRuntime;
import java.net.CookieStore;
import java.net.HttpCookie;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;

public class InMemoryCookieStore
implements CookieStore {
    private Map<URI, List<HttpCookie>> uriIndex = new HashMap<URI, List<HttpCookie>>();
    private ReentrantLock lock = new ReentrantLock(false);
    private final boolean applyMCompatibility;

    public InMemoryCookieStore() {
        this(VMRuntime.getRuntime().getTargetSdkVersion());
    }

    public InMemoryCookieStore(int targetSdkVersion) {
        this.applyMCompatibility = targetSdkVersion <= 23;
    }

    @Override
    public void add(URI uri, HttpCookie cookie) {
        if (cookie == null) {
            throw new NullPointerException("cookie is null");
        }
        this.lock.lock();
        try {
            this.addIndex(this.uriIndex, this.getEffectiveURI(uri), cookie);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public List<HttpCookie> get(URI uri) {
        if (uri == null) {
            throw new NullPointerException("uri is null");
        }
        ArrayList<HttpCookie> cookies = new ArrayList<HttpCookie>();
        this.lock.lock();
        try {
            this.getInternal1(cookies, this.uriIndex, uri.getHost());
            this.getInternal2(cookies, this.uriIndex, this.getEffectiveURI(uri));
        }
        finally {
            this.lock.unlock();
        }
        return cookies;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<HttpCookie> getCookies() {
        ArrayList<HttpCookie> rt = new ArrayList();
        this.lock.lock();
        try {
            for (List<HttpCookie> list : this.uriIndex.values()) {
                Iterator<HttpCookie> it = list.iterator();
                while (it.hasNext()) {
                    HttpCookie cookie = it.next();
                    if (cookie.hasExpired()) {
                        it.remove();
                        continue;
                    }
                    if (rt.contains(cookie)) continue;
                    rt.add(cookie);
                }
            }
        }
        finally {
            rt = Collections.unmodifiableList(rt);
            this.lock.unlock();
        }
        return rt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<URI> getURIs() {
        ArrayList<URI> uris = new ArrayList<URI>();
        this.lock.lock();
        try {
            ArrayList<URI> result = new ArrayList<URI>(this.uriIndex.keySet());
            result.remove(null);
            List<URI> list = Collections.unmodifiableList(result);
            return list;
        }
        finally {
            uris.addAll(this.uriIndex.keySet());
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(URI uri, HttpCookie ck) {
        if (ck == null) {
            throw new NullPointerException("cookie is null");
        }
        this.lock.lock();
        try {
            uri = this.getEffectiveURI(uri);
            if (this.uriIndex.get(uri) == null) {
                boolean bl = false;
                return bl;
            }
            List<HttpCookie> cookies = this.uriIndex.get(uri);
            if (cookies != null) {
                boolean bl = cookies.remove(ck);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean removeAll() {
        this.lock.lock();
        boolean result = false;
        try {
            result = !this.uriIndex.isEmpty();
            this.uriIndex.clear();
        }
        finally {
            this.lock.unlock();
        }
        return result;
    }

    private boolean netscapeDomainMatches(String domain, String host) {
        if (domain == null || host == null) {
            return false;
        }
        boolean isLocalDomain = ".local".equalsIgnoreCase(domain);
        int embeddedDotInDomain = domain.indexOf(46);
        if (embeddedDotInDomain == 0) {
            embeddedDotInDomain = domain.indexOf(46, 1);
        }
        if (!(isLocalDomain || embeddedDotInDomain != -1 && embeddedDotInDomain != domain.length() - 1)) {
            return false;
        }
        int firstDotInHost = host.indexOf(46);
        if (firstDotInHost == -1 && isLocalDomain) {
            return true;
        }
        int domainLength = domain.length();
        int lengthDiff = host.length() - domainLength;
        if (lengthDiff == 0) {
            return host.equalsIgnoreCase(domain);
        }
        if (lengthDiff > 0) {
            String D = host.substring(lengthDiff);
            if (this.applyMCompatibility && !domain.startsWith(".")) {
                return false;
            }
            return D.equalsIgnoreCase(domain);
        }
        if (lengthDiff == -1) {
            return domain.charAt(0) == '.' && host.equalsIgnoreCase(domain.substring(1));
        }
        return false;
    }

    private void getInternal1(List<HttpCookie> cookies, Map<URI, List<HttpCookie>> cookieIndex, String host) {
        ArrayList<HttpCookie> toRemove = new ArrayList<HttpCookie>();
        for (Map.Entry<URI, List<HttpCookie>> entry : cookieIndex.entrySet()) {
            List<HttpCookie> lst = entry.getValue();
            for (HttpCookie c : lst) {
                String domain = c.getDomain();
                if ((c.getVersion() != 0 || !this.netscapeDomainMatches(domain, host)) && (c.getVersion() != 1 || !HttpCookie.domainMatches(domain, host))) continue;
                if (!c.hasExpired()) {
                    if (cookies.contains(c)) continue;
                    cookies.add(c);
                    continue;
                }
                toRemove.add(c);
            }
            for (HttpCookie c : toRemove) {
                lst.remove(c);
            }
            toRemove.clear();
        }
    }

    private <T extends Comparable<T>> void getInternal2(List<HttpCookie> cookies, Map<T, List<HttpCookie>> cookieIndex, T comparator) {
        for (Comparable index : cookieIndex.keySet()) {
            List<HttpCookie> indexedCookies;
            if (index != comparator && (index == null || comparator.compareTo((Comparable)index) != 0) || (indexedCookies = cookieIndex.get(index)) == null) continue;
            Iterator<HttpCookie> it = indexedCookies.iterator();
            while (it.hasNext()) {
                HttpCookie ck = it.next();
                if (!ck.hasExpired()) {
                    if (cookies.contains(ck)) continue;
                    cookies.add(ck);
                    continue;
                }
                it.remove();
            }
        }
    }

    private <T> void addIndex(Map<T, List<HttpCookie>> indexStore, T index, HttpCookie cookie) {
        List<HttpCookie> cookies = indexStore.get(index);
        if (cookies != null) {
            cookies.remove(cookie);
            cookies.add(cookie);
        } else {
            cookies = new ArrayList<HttpCookie>();
            cookies.add(cookie);
            indexStore.put(index, cookies);
        }
    }

    private URI getEffectiveURI(URI uri) {
        URI effectiveURI = null;
        if (uri == null) {
            return null;
        }
        try {
            effectiveURI = new URI("http", uri.getHost(), null, null, null);
        }
        catch (URISyntaxException ignored) {
            effectiveURI = uri;
        }
        return effectiveURI;
    }
}

