/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.net.CookieHandler;
import java.net.CookiePolicy;
import java.net.CookieStore;
import java.net.HttpCookie;
import java.net.InMemoryCookieStore;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sun.util.logging.PlatformLogger;

public class CookieManager
extends CookieHandler {
    private CookiePolicy policyCallback;
    private CookieStore cookieJar = null;

    public CookieManager() {
        this(null, null);
    }

    public CookieManager(CookieStore store, CookiePolicy cookiePolicy) {
        this.policyCallback = cookiePolicy == null ? CookiePolicy.ACCEPT_ORIGINAL_SERVER : cookiePolicy;
        this.cookieJar = store == null ? new InMemoryCookieStore() : store;
    }

    public void setCookiePolicy(CookiePolicy cookiePolicy) {
        if (cookiePolicy != null) {
            this.policyCallback = cookiePolicy;
        }
    }

    public CookieStore getCookieStore() {
        return this.cookieJar;
    }

    @Override
    public Map<String, List<String>> get(URI uri, Map<String, List<String>> requestHeaders) throws IOException {
        if (uri == null || requestHeaders == null) {
            throw new IllegalArgumentException("Argument is null");
        }
        HashMap<String, List<String>> cookieMap = new HashMap<String, List<String>>();
        if (this.cookieJar == null) {
            return Collections.unmodifiableMap(cookieMap);
        }
        boolean secureLink = "https".equalsIgnoreCase(uri.getScheme());
        ArrayList<HttpCookie> cookies = new ArrayList<HttpCookie>();
        for (HttpCookie cookie : this.cookieJar.get(uri)) {
            if (!CookieManager.pathMatches(uri, cookie) || !secureLink && cookie.getSecure()) continue;
            String ports = cookie.getPortlist();
            if (ports != null && !ports.isEmpty()) {
                int port = uri.getPort();
                if (port == -1) {
                    int n = port = "https".equals(uri.getScheme()) ? 443 : 80;
                }
                if (!CookieManager.isInPortList(ports, port)) continue;
                cookies.add(cookie);
                continue;
            }
            cookies.add(cookie);
        }
        if (cookies.isEmpty()) {
            return Collections.emptyMap();
        }
        List<String> cookieHeader = this.sortByPath(cookies);
        cookieMap.put("Cookie", cookieHeader);
        return Collections.unmodifiableMap(cookieMap);
    }

    @Override
    public void put(URI uri, Map<String, List<String>> responseHeaders) throws IOException {
        if (uri == null || responseHeaders == null) {
            throw new IllegalArgumentException("Argument is null");
        }
        if (this.cookieJar == null) {
            return;
        }
        PlatformLogger logger = PlatformLogger.getLogger("java.net.CookieManager");
        for (String headerKey : responseHeaders.keySet()) {
            if (headerKey == null || !headerKey.equalsIgnoreCase("Set-Cookie2") && !headerKey.equalsIgnoreCase("Set-Cookie")) continue;
            for (String headerValue : responseHeaders.get(headerKey)) {
                try {
                    List<HttpCookie> cookies;
                    block17: {
                        try {
                            cookies = HttpCookie.parse(headerValue);
                        }
                        catch (IllegalArgumentException e) {
                            cookies = Collections.emptyList();
                            if (!logger.isLoggable(PlatformLogger.Level.SEVERE)) break block17;
                            logger.severe("Invalid cookie for " + uri + ": " + headerValue);
                        }
                    }
                    for (HttpCookie cookie : cookies) {
                        String ports;
                        if (cookie.getPath() == null) {
                            String path = uri.getPath();
                            if (!path.endsWith("/")) {
                                int i = path.lastIndexOf("/");
                                path = i > 0 ? path.substring(0, i + 1) : "/";
                            }
                            cookie.setPath(path);
                        } else if (!CookieManager.pathMatches(uri, cookie)) continue;
                        if (cookie.getDomain() == null) {
                            String host = uri.getHost();
                            if (host != null && !host.contains(".")) {
                                host = host + ".local";
                            }
                            cookie.setDomain(host);
                        }
                        if ((ports = cookie.getPortlist()) != null) {
                            int port = uri.getPort();
                            if (port == -1) {
                                int n = port = "https".equals(uri.getScheme()) ? 443 : 80;
                            }
                            if (ports.isEmpty()) {
                                cookie.setPortlist("" + port);
                                if (!this.shouldAcceptInternal(uri, cookie)) continue;
                                this.cookieJar.add(uri, cookie);
                                continue;
                            }
                            if (!CookieManager.isInPortList(ports, port) || !this.shouldAcceptInternal(uri, cookie)) continue;
                            this.cookieJar.add(uri, cookie);
                            continue;
                        }
                        if (!this.shouldAcceptInternal(uri, cookie)) continue;
                        this.cookieJar.add(uri, cookie);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
            }
        }
    }

    private boolean shouldAcceptInternal(URI uri, HttpCookie cookie) {
        try {
            return this.policyCallback.shouldAccept(uri, cookie);
        }
        catch (Exception ignored) {
            return false;
        }
    }

    private static boolean isInPortList(String lst, int port) {
        int i = lst.indexOf(",");
        int val = -1;
        while (i > 0) {
            try {
                val = Integer.parseInt(lst.substring(0, i));
                if (val == port) {
                    return true;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            lst = lst.substring(i + 1);
            i = lst.indexOf(",");
        }
        if (!lst.isEmpty()) {
            try {
                val = Integer.parseInt(lst);
                if (val == port) {
                    return true;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    private static boolean pathMatches(URI uri, HttpCookie cookie) {
        return CookieManager.normalizePath(uri.getPath()).startsWith(CookieManager.normalizePath(cookie.getPath()));
    }

    private static String normalizePath(String path) {
        if (path == null) {
            path = "";
        }
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        return path;
    }

    private List<String> sortByPath(List<HttpCookie> cookies) {
        Collections.sort(cookies, new CookiePathComparator());
        StringBuilder result = new StringBuilder();
        int minVersion = 1;
        for (HttpCookie cookie : cookies) {
            if (cookie.getVersion() >= minVersion) continue;
            minVersion = cookie.getVersion();
        }
        if (minVersion == 1) {
            result.append("$Version=\"1\"; ");
        }
        for (int i = 0; i < cookies.size(); ++i) {
            if (i != 0) {
                result.append("; ");
            }
            result.append(cookies.get(i).toString());
        }
        ArrayList<String> cookieHeader = new ArrayList<String>();
        cookieHeader.add(result.toString());
        return cookieHeader;
    }

    static class CookiePathComparator
    implements Comparator<HttpCookie> {
        CookiePathComparator() {
        }

        @Override
        public int compare(HttpCookie c1, HttpCookie c2) {
            String c2Path;
            if (c1 == c2) {
                return 0;
            }
            if (c1 == null) {
                return -1;
            }
            if (c2 == null) {
                return 1;
            }
            if (!c1.getName().equals(c2.getName())) {
                return 0;
            }
            String c1Path = CookieManager.normalizePath(c1.getPath());
            if (c1Path.startsWith(c2Path = CookieManager.normalizePath(c2.getPath()))) {
                return -1;
            }
            if (c2Path.startsWith(c1Path)) {
                return 1;
            }
            return 0;
        }
    }
}

