/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import dalvik.system.BlockGuard;
import dalvik.system.CloseGuard;
import dalvik.system.SocketTagger;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketImpl;
import java.net.SocketInputStream;
import java.net.SocketOutputStream;
import java.net.UnknownHostException;
import sun.net.ConnectionResetException;
import sun.net.NetHooks;
import sun.net.ResourceManager;

abstract class AbstractPlainSocketImpl
extends SocketImpl {
    int timeout;
    private boolean shut_rd = false;
    private boolean shut_wr = false;
    private SocketInputStream socketInputStream = null;
    private SocketOutputStream socketOutputStream = null;
    protected int fdUseCount = 0;
    protected final Object fdLock = new Object();
    protected boolean closePending = false;
    private int CONNECTION_NOT_RESET = 0;
    private int CONNECTION_RESET_PENDING = 1;
    private int CONNECTION_RESET = 2;
    private int resetState;
    private final Object resetLock = new Object();
    protected boolean stream;
    private final CloseGuard guard = CloseGuard.get();
    public static final int SHUT_RD = 0;
    public static final int SHUT_WR = 1;

    AbstractPlainSocketImpl() {
    }

    @Override
    protected synchronized void create(boolean stream) throws IOException {
        this.stream = stream;
        if (!stream) {
            ResourceManager.beforeUdpCreate();
            try {
                this.socketCreate(false);
            }
            catch (IOException ioe) {
                ResourceManager.afterUdpClose();
                throw ioe;
            }
        } else {
            this.socketCreate(true);
        }
        if (this.socket != null) {
            this.socket.setCreated();
        }
        if (this.serverSocket != null) {
            this.serverSocket.setCreated();
        }
        if (this.fd != null && this.fd.valid()) {
            this.guard.open("close");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void connect(String host, int port) throws UnknownHostException, IOException {
        boolean connected = false;
        try {
            InetAddress address = InetAddress.getByName(host);
            this.port = port;
            this.address = address;
            this.connectToAddress(address, port, this.timeout);
            connected = true;
        }
        finally {
            if (!connected) {
                try {
                    this.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    protected void connect(InetAddress address, int port) throws IOException {
        this.port = port;
        this.address = address;
        try {
            this.connectToAddress(address, port, this.timeout);
            return;
        }
        catch (IOException e) {
            this.close();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void connect(SocketAddress address, int timeout) throws IOException {
        boolean connected = false;
        try {
            if (address == null || !(address instanceof InetSocketAddress)) {
                throw new IllegalArgumentException("unsupported address type");
            }
            InetSocketAddress addr = (InetSocketAddress)address;
            if (addr.isUnresolved()) {
                throw new UnknownHostException(addr.getHostName());
            }
            this.port = addr.getPort();
            this.address = addr.getAddress();
            this.connectToAddress(this.address, this.port, timeout);
            connected = true;
        }
        finally {
            if (!connected) {
                try {
                    this.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void connectToAddress(InetAddress address, int port, int timeout) throws IOException {
        if (address.isAnyLocalAddress()) {
            this.doConnect(InetAddress.getLocalHost(), port, timeout);
        } else {
            this.doConnect(address, port, timeout);
        }
    }

    @Override
    public void setOption(int opt, Object val) throws SocketException {
        if (this.isClosedOrPending()) {
            throw new SocketException("Socket Closed");
        }
        if (opt == 4102) {
            this.timeout = (Integer)val;
        }
        this.socketSetOption(opt, val);
    }

    @Override
    public Object getOption(int opt) throws SocketException {
        if (this.isClosedOrPending()) {
            throw new SocketException("Socket Closed");
        }
        if (opt == 4102) {
            return new Integer(this.timeout);
        }
        return this.socketGetOption(opt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void doConnect(InetAddress address, int port, int timeout) throws IOException {
        Object object = this.fdLock;
        synchronized (object) {
            if (!(this.closePending || this.socket != null && this.socket.isBound())) {
                NetHooks.beforeTcpConnect(this.fd, address, port);
            }
        }
        try {
            this.acquireFD();
            try {
                BlockGuard.getThreadPolicy().onNetwork();
                this.socketConnect(address, port, timeout);
                object = this.fdLock;
                synchronized (object) {
                    if (this.closePending) {
                        throw new SocketException("Socket closed");
                    }
                }
                if (this.socket != null) {
                    this.socket.setBound();
                    this.socket.setConnected();
                }
            }
            finally {
                this.releaseFD();
            }
        }
        catch (IOException e) {
            this.close();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized void bind(InetAddress address, int lport) throws IOException {
        Object object = this.fdLock;
        synchronized (object) {
            if (!(this.closePending || this.socket != null && this.socket.isBound())) {
                NetHooks.beforeTcpBind(this.fd, address, lport);
            }
        }
        this.socketBind(address, lport);
        if (this.socket != null) {
            this.socket.setBound();
        }
        if (this.serverSocket != null) {
            this.serverSocket.setBound();
        }
    }

    @Override
    protected synchronized void listen(int count) throws IOException {
        this.socketListen(count);
    }

    @Override
    protected void accept(SocketImpl s) throws IOException {
        this.acquireFD();
        try {
            BlockGuard.getThreadPolicy().onNetwork();
            this.socketAccept(s);
        }
        finally {
            this.releaseFD();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized InputStream getInputStream() throws IOException {
        Object object = this.fdLock;
        synchronized (object) {
            if (this.isClosedOrPending()) {
                throw new IOException("Socket Closed");
            }
            if (this.shut_rd) {
                throw new IOException("Socket input is shutdown");
            }
            if (this.socketInputStream == null) {
                this.socketInputStream = new SocketInputStream(this);
            }
        }
        return this.socketInputStream;
    }

    void setInputStream(SocketInputStream in) {
        this.socketInputStream = in;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized OutputStream getOutputStream() throws IOException {
        Object object = this.fdLock;
        synchronized (object) {
            if (this.isClosedOrPending()) {
                throw new IOException("Socket Closed");
            }
            if (this.shut_wr) {
                throw new IOException("Socket output is shutdown");
            }
            if (this.socketOutputStream == null) {
                this.socketOutputStream = new SocketOutputStream(this);
            }
        }
        return this.socketOutputStream;
    }

    void setFileDescriptor(FileDescriptor fd) {
        this.fd = fd;
    }

    void setAddress(InetAddress address) {
        this.address = address;
    }

    void setPort(int port) {
        this.port = port;
    }

    void setLocalPort(int localport) {
        this.localport = localport;
    }

    @Override
    protected synchronized int available() throws IOException {
        if (this.isClosedOrPending()) {
            throw new IOException("Stream closed.");
        }
        if (this.isConnectionReset()) {
            return 0;
        }
        int n = 0;
        try {
            n = this.socketAvailable();
            if (n == 0 && this.isConnectionResetPending()) {
                this.setConnectionReset();
            }
        }
        catch (ConnectionResetException exc1) {
            this.setConnectionResetPending();
            try {
                n = this.socketAvailable();
                if (n == 0) {
                    this.setConnectionReset();
                }
            }
            catch (ConnectionResetException connectionResetException) {
                // empty catch block
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void close() throws IOException {
        Object object = this.fdLock;
        synchronized (object) {
            if (this.fd != null && this.fd.valid()) {
                if (!this.stream) {
                    ResourceManager.afterUdpClose();
                }
                if (!this.closePending) {
                    this.closePending = true;
                    SocketTagger.get().untag(this.fd);
                    this.guard.close();
                    if (this.fdUseCount == 0) {
                        try {
                            this.socketPreClose();
                        }
                        finally {
                            this.socketClose();
                        }
                        return;
                    }
                    --this.fdUseCount;
                    this.socketPreClose();
                }
            }
        }
    }

    @Override
    void reset() throws IOException {
        if (this.fd != null && this.fd.valid()) {
            this.socketClose();
            this.guard.close();
        }
        super.reset();
    }

    @Override
    protected void shutdownInput() throws IOException {
        if (this.fd != null && this.fd.valid()) {
            this.socketShutdown(0);
            if (this.socketInputStream != null) {
                this.socketInputStream.setEOF(true);
            }
            this.shut_rd = true;
        }
    }

    @Override
    protected void shutdownOutput() throws IOException {
        if (this.fd != null && this.fd.valid()) {
            this.socketShutdown(1);
            this.shut_wr = true;
        }
    }

    @Override
    protected boolean supportsUrgentData() {
        return true;
    }

    @Override
    protected void sendUrgentData(int data) throws IOException {
        if (this.fd == null || !this.fd.valid()) {
            throw new IOException("Socket Closed");
        }
        this.socketSendUrgentData(data);
    }

    protected void finalize() throws IOException {
        if (this.guard != null) {
            this.guard.warnIfOpen();
        }
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FileDescriptor acquireFD() {
        Object object = this.fdLock;
        synchronized (object) {
            ++this.fdUseCount;
            return this.fd;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseFD() {
        Object object = this.fdLock;
        synchronized (object) {
            --this.fdUseCount;
            if (this.fdUseCount == -1 && this.fd != null) {
                try {
                    this.socketClose();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnectionReset() {
        Object object = this.resetLock;
        synchronized (object) {
            return this.resetState == this.CONNECTION_RESET;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnectionResetPending() {
        Object object = this.resetLock;
        synchronized (object) {
            return this.resetState == this.CONNECTION_RESET_PENDING;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConnectionReset() {
        Object object = this.resetLock;
        synchronized (object) {
            this.resetState = this.CONNECTION_RESET;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConnectionResetPending() {
        Object object = this.resetLock;
        synchronized (object) {
            if (this.resetState == this.CONNECTION_NOT_RESET) {
                this.resetState = this.CONNECTION_RESET_PENDING;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosedOrPending() {
        Object object = this.fdLock;
        synchronized (object) {
            return this.closePending || this.fd == null || !this.fd.valid();
            {
            }
        }
    }

    public int getTimeout() {
        return this.timeout;
    }

    private void socketPreClose() throws IOException {
        this.socketClose0(true);
    }

    protected void socketClose() throws IOException {
        this.socketClose0(false);
    }

    abstract void socketCreate(boolean var1) throws IOException;

    abstract void socketConnect(InetAddress var1, int var2, int var3) throws IOException;

    abstract void socketBind(InetAddress var1, int var2) throws IOException;

    abstract void socketListen(int var1) throws IOException;

    abstract void socketAccept(SocketImpl var1) throws IOException;

    abstract int socketAvailable() throws IOException;

    abstract void socketClose0(boolean var1) throws IOException;

    abstract void socketShutdown(int var1) throws IOException;

    abstract void socketSetOption(int var1, Object var2) throws SocketException;

    abstract Object socketGetOption(int var1) throws SocketException;

    abstract void socketSendUrgentData(int var1) throws IOException;
}

