/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import dalvik.system.BlockGuard;
import dalvik.system.CloseGuard;
import java.io.FileDescriptor;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocketImpl;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.SocketException;
import java.security.AccessController;
import java.util.Enumeration;
import libcore.io.IoBridge;
import sun.net.ResourceManager;
import sun.security.action.GetPropertyAction;

abstract class AbstractPlainDatagramSocketImpl
extends DatagramSocketImpl {
    int timeout = 0;
    boolean connected = false;
    private int trafficClass = 0;
    protected InetAddress connectedAddress = null;
    private int connectedPort = -1;
    private final CloseGuard guard = CloseGuard.get();
    private static final String os = AccessController.doPrivileged(new GetPropertyAction("os.name"));
    private static final boolean connectDisabled = os.contains("OS X");

    AbstractPlainDatagramSocketImpl() {
    }

    @Override
    protected synchronized void create() throws SocketException {
        ResourceManager.beforeUdpCreate();
        this.fd = new FileDescriptor();
        try {
            this.datagramSocketCreate();
        }
        catch (SocketException ioe) {
            ResourceManager.afterUdpClose();
            this.fd = null;
            throw ioe;
        }
        if (this.fd != null && this.fd.valid()) {
            this.guard.open("close");
        }
    }

    @Override
    protected synchronized void bind(int lport, InetAddress laddr) throws SocketException {
        this.bind0(lport, laddr);
    }

    protected abstract void bind0(int var1, InetAddress var2) throws SocketException;

    @Override
    protected abstract void send(DatagramPacket var1) throws IOException;

    @Override
    protected void connect(InetAddress address, int port) throws SocketException {
        BlockGuard.getThreadPolicy().onNetwork();
        this.connect0(address, port);
        this.connectedAddress = address;
        this.connectedPort = port;
        this.connected = true;
    }

    @Override
    protected void disconnect() {
        this.disconnect0(this.connectedAddress.holder().getFamily());
        this.connected = false;
        this.connectedAddress = null;
        this.connectedPort = -1;
    }

    @Override
    protected abstract int peek(InetAddress var1) throws IOException;

    @Override
    protected abstract int peekData(DatagramPacket var1) throws IOException;

    @Override
    protected synchronized void receive(DatagramPacket p) throws IOException {
        this.receive0(p);
    }

    protected abstract void receive0(DatagramPacket var1) throws IOException;

    @Override
    protected abstract void setTimeToLive(int var1) throws IOException;

    @Override
    protected abstract int getTimeToLive() throws IOException;

    @Override
    @Deprecated
    protected abstract void setTTL(byte var1) throws IOException;

    @Override
    @Deprecated
    protected abstract byte getTTL() throws IOException;

    @Override
    protected void join(InetAddress inetaddr) throws IOException {
        this.join(inetaddr, null);
    }

    @Override
    protected void leave(InetAddress inetaddr) throws IOException {
        this.leave(inetaddr, null);
    }

    @Override
    protected void joinGroup(SocketAddress mcastaddr, NetworkInterface netIf) throws IOException {
        if (mcastaddr == null || !(mcastaddr instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Unsupported address type");
        }
        this.join(((InetSocketAddress)mcastaddr).getAddress(), netIf);
    }

    protected abstract void join(InetAddress var1, NetworkInterface var2) throws IOException;

    @Override
    protected void leaveGroup(SocketAddress mcastaddr, NetworkInterface netIf) throws IOException {
        if (mcastaddr == null || !(mcastaddr instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Unsupported address type");
        }
        this.leave(((InetSocketAddress)mcastaddr).getAddress(), netIf);
    }

    protected abstract void leave(InetAddress var1, NetworkInterface var2) throws IOException;

    @Override
    protected void close() {
        this.guard.close();
        if (this.fd != null) {
            this.datagramSocketClose();
            ResourceManager.afterUdpClose();
            this.fd = null;
        }
    }

    protected boolean isClosed() {
        return this.fd == null;
    }

    protected void finalize() {
        if (this.guard != null) {
            this.guard.warnIfOpen();
        }
        this.close();
    }

    @Override
    public void setOption(int optID, Object o) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket Closed");
        }
        switch (optID) {
            case 4102: {
                if (o == null || !(o instanceof Integer)) {
                    throw new SocketException("bad argument for SO_TIMEOUT");
                }
                int tmp = (Integer)o;
                if (tmp < 0) {
                    throw new IllegalArgumentException("timeout < 0");
                }
                this.timeout = tmp;
                return;
            }
            case 3: {
                if (o == null || !(o instanceof Integer)) {
                    throw new SocketException("bad argument for IP_TOS");
                }
                this.trafficClass = (Integer)o;
                break;
            }
            case 4: {
                if (o != null && o instanceof Boolean) break;
                throw new SocketException("bad argument for SO_REUSEADDR");
            }
            case 32: {
                if (o != null && o instanceof Boolean) break;
                throw new SocketException("bad argument for SO_BROADCAST");
            }
            case 15: {
                throw new SocketException("Cannot re-bind Socket");
            }
            case 4097: 
            case 4098: {
                if (o != null && o instanceof Integer && (Integer)o >= 0) break;
                throw new SocketException("bad argument for SO_SNDBUF or SO_RCVBUF");
            }
            case 16: {
                if (o != null && o instanceof InetAddress) break;
                throw new SocketException("bad argument for IP_MULTICAST_IF");
            }
            case 31: {
                if (o == null || !(o instanceof Integer) && !(o instanceof NetworkInterface)) {
                    throw new SocketException("bad argument for IP_MULTICAST_IF2");
                }
                if (!(o instanceof NetworkInterface)) break;
                o = new Integer(((NetworkInterface)o).getIndex());
                break;
            }
            case 18: {
                if (o != null && o instanceof Boolean) break;
                throw new SocketException("bad argument for IP_MULTICAST_LOOP");
            }
            default: {
                throw new SocketException("invalid option: " + optID);
            }
        }
        this.socketSetOption(optID, o);
    }

    @Override
    public Object getOption(int optID) throws SocketException {
        Object result;
        if (this.isClosed()) {
            throw new SocketException("Socket Closed");
        }
        switch (optID) {
            case 4102: {
                result = new Integer(this.timeout);
                break;
            }
            case 3: {
                result = this.socketGetOption(optID);
                if ((Integer)result != -1) break;
                result = new Integer(this.trafficClass);
                break;
            }
            case 4: 
            case 15: 
            case 16: 
            case 18: 
            case 31: 
            case 32: 
            case 4097: 
            case 4098: {
                result = this.socketGetOption(optID);
                if (optID != 16) break;
                return AbstractPlainDatagramSocketImpl.getNIFirstAddress((Integer)result);
            }
            default: {
                throw new SocketException("invalid option: " + optID);
            }
        }
        return result;
    }

    static InetAddress getNIFirstAddress(int niIndex) throws SocketException {
        NetworkInterface networkInterface;
        Enumeration<InetAddress> addressesEnum;
        if (niIndex > 0 && (addressesEnum = (networkInterface = NetworkInterface.getByIndex(niIndex)).getInetAddresses()).hasMoreElements()) {
            return addressesEnum.nextElement();
        }
        return InetAddress.anyLocalAddress();
    }

    protected abstract void datagramSocketCreate() throws SocketException;

    protected abstract void datagramSocketClose();

    protected abstract void socketSetOption(int var1, Object var2) throws SocketException;

    protected abstract Object socketGetOption(int var1) throws SocketException;

    protected abstract void connect0(InetAddress var1, int var2) throws SocketException;

    protected abstract void disconnect0(int var1);

    protected boolean nativeConnectDisabled() {
        return connectDisabled;
    }

    @Override
    int dataAvailable() {
        try {
            return IoBridge.available(this.fd);
        }
        catch (IOException e) {
            return -1;
        }
    }
}

