/*
 * Decompiled with CFR 0.152.
 */
package java.math;

import java.math.BigInteger;
import java.util.Arrays;

class MutableModFn {
    long[] digits;

    MutableModFn(long[] digits) {
        this.digits = digits;
    }

    MutableModFn(int length) {
        this.digits = new long[length];
    }

    void copyTo(MutableModFn b) {
        System.arraycopy(this.digits, 0, b.digits, 0, this.digits.length);
    }

    void add(MutableModFn b) {
        long sum;
        int i;
        boolean carry = false;
        for (i = this.digits.length - 1; i >= 0; --i) {
            sum = this.digits[i] + b.digits[i];
            if (carry) {
                ++sum;
            }
            carry = sum >>> 63 < (this.digits[i] >>> 63) + (b.digits[i] >>> 63);
            this.digits[i] = sum;
        }
        for (i = this.digits.length - 1; carry && i >= 0; --i) {
            this.digits[i] = sum = this.digits[i] + 1L;
            carry = sum == 0L;
        }
        this.reduce();
    }

    void subtract(MutableModFn b) {
        int i;
        boolean borrow = false;
        for (i = this.digits.length - 1; i >= 0; --i) {
            long diff = this.digits[i] - b.digits[i];
            if (borrow) {
                --diff;
            }
            borrow = diff >>> 63 > (this.digits[i] >>> 63) - (b.digits[i] >>> 63);
            this.digits[i] = diff;
        }
        if (borrow) {
            this.digits[0] = this.digits[0] + 1L;
            boolean carry = true;
            for (i = this.digits.length - 1; carry && i >= 0; --i) {
                long sum;
                this.digits[i] = sum = this.digits[i] + 1L;
                carry = sum == 0L;
            }
        }
    }

    void multiply(MutableModFn b) {
        if (this.digits[0] == 1L && b.digits[0] == 1L) {
            Arrays.fill(this.digits, 0L);
            this.digits[this.digits.length - 1] = 1L;
        } else {
            int[] intDigits = MutableModFn.toIntArrayOdd(this.digits);
            BigInteger aBigInt = new BigInteger(1, intDigits);
            int[] intBDigits = MutableModFn.toIntArrayOdd(b.digits);
            BigInteger bBigInt = new BigInteger(1, intBDigits);
            int[] cInt = aBigInt.multiply((BigInteger)bBigInt).mag;
            int[] cIntPad = new int[intDigits.length - 1 + intBDigits.length - 1];
            System.arraycopy(cInt, 0, cIntPad, cIntPad.length - cInt.length, cInt.length);
            long[] c = MutableModFn.toLongArrayEven(cIntPad);
            MutableModFn.reduceWide(c);
            System.arraycopy(c, c.length / 2 - 1, this.digits, 0, c.length / 2 + 1);
        }
    }

    void square() {
        if (this.digits[0] == 1L) {
            Arrays.fill(this.digits, 0L);
            this.digits[this.digits.length - 1] = 1L;
        } else {
            int[] intDigits = MutableModFn.toIntArrayOdd(this.digits);
            BigInteger aBigInt = new BigInteger(1, intDigits);
            int[] cInt = aBigInt.square().mag;
            int[] cIntPad = new int[2 * intDigits.length - 2];
            System.arraycopy(cInt, 0, cIntPad, cIntPad.length - cInt.length, cInt.length);
            long[] c = MutableModFn.toLongArrayEven(cIntPad);
            MutableModFn.reduceWide(c);
            System.arraycopy(c, c.length / 2 - 1, this.digits, 0, c.length / 2 + 1);
        }
    }

    private void reduce() {
        int i;
        int len = this.digits.length;
        long bi = this.digits[0];
        long diff = this.digits[len - 1] - bi;
        boolean borrow = diff >>> 63 > (this.digits[len - 1] >>> 63) - (bi >>> 63);
        this.digits[len - 1] = diff;
        this.digits[0] = 0L;
        if (borrow) {
            i = len - 2;
            do {
                this.digits[i] = diff = this.digits[i] - 1L;
            } while ((borrow = diff == -1L) && --i >= 0);
        }
        if (borrow) {
            boolean carry = true;
            this.digits[0] = 0L;
            for (i = this.digits.length - 1; carry && i >= 0; --i) {
                long sum;
                this.digits[i] = sum = this.digits[i] + 1L;
                carry = sum == 0L;
            }
        }
    }

    private static void reduceWide(long[] a) {
        int i;
        int len = a.length;
        boolean carry = false;
        for (i = len - 1; i >= len / 2; --i) {
            long bi = a[i - len / 2];
            long diff = a[i] - bi;
            if (carry) {
                --diff;
            }
            carry = diff >>> 63 > (a[i] >>> 63) - (bi >>> 63);
            a[i] = diff;
        }
        for (i = len / 2 - 1; i >= 0; --i) {
            a[i] = 0L;
        }
        if (carry) {
            int j = len - 1;
            do {
                long sum;
                a[j] = sum = a[j] + 1L;
                boolean bl = carry = sum == 0L;
            } while (--j > 0 && carry);
        }
    }

    static void reduce(int[] digits) {
        int i;
        int len = digits.length;
        int bi = digits[0];
        int diff = digits[len - 1] - bi;
        boolean borrow = diff >>> 31 > (digits[len - 1] >>> 31) - (bi >>> 31);
        digits[len - 1] = diff;
        digits[0] = 0;
        if (borrow) {
            i = len - 2;
            do {
                digits[i] = diff = digits[i] - 1;
            } while ((borrow = diff == -1) && --i >= 0);
        }
        if (borrow) {
            boolean carry = true;
            digits[0] = 0;
            for (i = digits.length - 1; carry && i >= 0; --i) {
                int sum;
                digits[i] = sum = digits[i] + 1;
                carry = sum == 0;
            }
        }
    }

    void shiftRight(int shiftAmtBits, MutableModFn b) {
        int i;
        int len = this.digits.length;
        if (shiftAmtBits > 64 * (len - 1)) {
            this.shiftLeft(128 * (len - 1) - shiftAmtBits, b);
            return;
        }
        int shiftAmtLongs = shiftAmtBits / 64;
        if (shiftAmtLongs > 0) {
            boolean borrow = false;
            for (int i2 = 1; i2 < len - shiftAmtLongs; ++i2) {
                long diff = this.digits[i2];
                if (borrow) {
                    // empty if block
                }
                b.digits[shiftAmtLongs + i2] = --diff;
                borrow = diff == -1L && borrow;
            }
            long diff = this.digits[0] - this.digits[len - 1];
            borrow = borrow ? --diff == -1L : this.digits[0] == 0L && this.digits[len - 1] != 0L;
            b.digits[shiftAmtLongs] = diff;
            for (i = 1; i < shiftAmtLongs; ++i) {
                b.digits[shiftAmtLongs - i] = -this.digits[len - 1 - i];
                if (borrow) {
                    int n = shiftAmtLongs - i;
                    b.digits[n] = b.digits[n] - 1L;
                }
                borrow = b.digits[shiftAmtLongs - i] != 0L || borrow;
            }
            boolean carry = borrow;
            if (carry) {
                long sum;
                b.digits[0] = 0L;
                int i3 = len - 1;
                do {
                    b.digits[i3] = sum = b.digits[i3] + 1L;
                } while ((carry = sum == 0L) && --i3 >= 0);
            } else {
                b.digits[0] = 0L;
            }
        } else {
            System.arraycopy(this.digits, 0, b.digits, 0, len);
        }
        int shiftAmtFrac = shiftAmtBits % 64;
        if (shiftAmtFrac != 0) {
            long bhi = b.digits[len - 1] << 64 - shiftAmtFrac;
            int n = len - 1;
            b.digits[n] = b.digits[n] >>> shiftAmtFrac;
            for (i = len - 1; i > 0; --i) {
                int n2 = i;
                b.digits[n2] = b.digits[n2] | b.digits[i - 1] << 64 - shiftAmtFrac;
                int n3 = i - 1;
                b.digits[n3] = b.digits[n3] >>> shiftAmtFrac;
            }
            long diff = b.digits[1] - bhi;
            boolean borrow = diff >>> 63 > (b.digits[1] >>> 63) - (bhi >>> 63);
            b.digits[1] = diff;
            boolean carry = borrow;
            if (carry) {
                long sum;
                b.digits[0] = 0L;
                int i4 = len - 1;
                do {
                    b.digits[i4] = sum = b.digits[i4] + 1L;
                } while ((carry = sum == 0L) && --i4 >= 0);
            } else {
                b.digits[0] = 0L;
            }
        }
    }

    void shiftLeft(int shiftAmtBits, MutableModFn b) {
        int len = this.digits.length;
        if (shiftAmtBits > 64 * (len - 1)) {
            this.shiftRight(128 * (len - 1) - shiftAmtBits, b);
            return;
        }
        int shiftAmtLongs = shiftAmtBits / 64;
        if (shiftAmtLongs > 0) {
            boolean borrow = false;
            for (int i = 0; i < shiftAmtLongs; ++i) {
                b.digits[len - 1 - i] = -this.digits[shiftAmtLongs - i];
                if (borrow) {
                    int n = len - 1 - i;
                    b.digits[n] = b.digits[n] - 1L;
                }
                borrow = b.digits[len - 1 - i] != 0L || borrow;
            }
            long diff = shiftAmtLongs < len - 1 ? this.digits[len - 1] - this.digits[0] : -this.digits[0];
            borrow = borrow ? --diff == -1L : this.digits[0] == 1L && diff == -1L;
            b.digits[len - 1 - shiftAmtLongs] = diff;
            for (int i = 1; i < len - shiftAmtLongs - 1; ++i) {
                diff = this.digits[len - 1 - i];
                if (borrow) {
                    // empty if block
                }
                b.digits[len - 1 - shiftAmtLongs - i] = --diff;
                borrow = diff == -1L && borrow;
            }
            boolean carry = borrow;
            if (carry) {
                long sum;
                b.digits[0] = 0L;
                int i = len - 1;
                do {
                    b.digits[i] = sum = b.digits[i] + 1L;
                } while ((carry = sum == 0L) && --i >= 0);
            } else {
                b.digits[0] = 0L;
            }
        } else {
            System.arraycopy(this.digits, 0, b.digits, 0, len);
        }
        int shiftAmtFrac = shiftAmtBits % 64;
        if (shiftAmtFrac != 0) {
            b.digits[0] = b.digits[0] << shiftAmtFrac;
            int i = 1;
            while (i < len) {
                int n = i - 1;
                b.digits[n] = b.digits[n] | b.digits[i] >>> 64 - shiftAmtFrac;
                int n2 = i++;
                b.digits[n2] = b.digits[n2] << shiftAmtFrac;
            }
        }
        b.reduce();
    }

    private static long[] toLongArrayEven(int[] digits) {
        long[] longDigits = new long[digits.length / 2];
        for (int i = 0; i < longDigits.length; ++i) {
            longDigits[i] = (long)digits[2 * i] << 32 | (long)digits[2 * i + 1] & 0xFFFFFFFFL;
        }
        return longDigits;
    }

    static int[] toIntArrayOdd(long[] digits) {
        int[] intDigits = new int[digits.length * 2 - 1];
        intDigits[0] = (int)digits[0];
        for (int i = 1; i < digits.length; ++i) {
            intDigits[2 * i - 1] = (int)(digits[i] >>> 32);
            intDigits[2 * i] = (int)(digits[i] & 0xFFFFFFFFFFFFFFFFL);
        }
        return intDigits;
    }
}

