/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import dalvik.annotation.optimization.FastNative;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.WeakCache;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiFunction;
import libcore.util.EmptyArray;
import sun.reflect.CallerSensitive;

public class Proxy
implements Serializable {
    private static final long serialVersionUID = -2222568056686623797L;
    private static final Class<?>[] constructorParams = new Class[]{InvocationHandler.class};
    private static final WeakCache<ClassLoader, Class<?>[], Class<?>> proxyClassCache = new WeakCache(new KeyFactory(), new ProxyClassFactory());
    protected InvocationHandler h;
    private static final Object key0 = new Object();
    private static final Comparator<Method> ORDER_BY_SIGNATURE_AND_SUBTYPE = new Comparator<Method>(){

        @Override
        public int compare(Method a, Method b) {
            Class<?> bClass;
            int comparison = Method.ORDER_BY_SIGNATURE.compare(a, b);
            if (comparison != 0) {
                return comparison;
            }
            Class<?> aClass = a.getDeclaringClass();
            if (aClass == (bClass = b.getDeclaringClass())) {
                return 0;
            }
            if (aClass.isAssignableFrom(bClass)) {
                return 1;
            }
            if (bClass.isAssignableFrom(aClass)) {
                return -1;
            }
            return 0;
        }
    };

    private Proxy() {
    }

    protected Proxy(InvocationHandler h) {
        Objects.requireNonNull(h);
        this.h = h;
    }

    @CallerSensitive
    public static Class<?> getProxyClass(ClassLoader loader, Class<?> ... interfaces) throws IllegalArgumentException {
        return Proxy.getProxyClass0(loader, interfaces);
    }

    private static Class<?> getProxyClass0(ClassLoader loader, Class<?> ... interfaces) {
        if (interfaces.length > 65535) {
            throw new IllegalArgumentException("interface limit exceeded");
        }
        return proxyClassCache.get(loader, interfaces);
    }

    private static List<Class<?>[]> deduplicateAndGetExceptions(List<Method> methods) {
        ArrayList<Class<?>[]> exceptions = new ArrayList<Class<?>[]>(methods.size());
        int i = 0;
        while (i < methods.size()) {
            Method method = methods.get(i);
            Class<?>[] exceptionTypes = method.getExceptionTypes();
            if (i > 0 && Method.ORDER_BY_SIGNATURE.compare(method, methods.get(i - 1)) == 0) {
                exceptions.set(i - 1, Proxy.intersectExceptions((Class[])exceptions.get(i - 1), exceptionTypes));
                methods.remove(i);
                continue;
            }
            exceptions.add(exceptionTypes);
            ++i;
        }
        return exceptions;
    }

    private static Class<?>[] intersectExceptions(Class<?>[] aExceptions, Class<?>[] bExceptions) {
        if (aExceptions.length == 0 || bExceptions.length == 0) {
            return EmptyArray.CLASS;
        }
        if (Arrays.equals(aExceptions, bExceptions)) {
            return aExceptions;
        }
        HashSet intersection = new HashSet();
        for (Class<?> a : aExceptions) {
            for (Class<?> b : bExceptions) {
                if (a.isAssignableFrom(b)) {
                    intersection.add(b);
                    continue;
                }
                if (!b.isAssignableFrom(a)) continue;
                intersection.add(a);
            }
        }
        return intersection.toArray(new Class[intersection.size()]);
    }

    private static void validateReturnTypes(List<Method> methods) {
        Method vs = null;
        for (Method method : methods) {
            if (vs == null || !vs.equalNameAndParameters(method)) {
                vs = method;
                continue;
            }
            Class<?> returnType = method.getReturnType();
            Class<?> vsReturnType = vs.getReturnType();
            if (returnType.isInterface() && vsReturnType.isInterface()) continue;
            if (vsReturnType.isAssignableFrom(returnType)) {
                vs = method;
                continue;
            }
            if (returnType.isAssignableFrom(vsReturnType)) continue;
            throw new IllegalArgumentException("proxied interface methods have incompatible return types:\n  " + vs + "\n  " + method);
        }
    }

    private static List<Method> getMethods(Class<?>[] interfaces) {
        ArrayList<Method> result = new ArrayList<Method>();
        try {
            result.add(Object.class.getMethod("equals", Object.class));
            result.add(Object.class.getMethod("hashCode", EmptyArray.CLASS));
            result.add(Object.class.getMethod("toString", EmptyArray.CLASS));
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError();
        }
        Proxy.getMethodsRecursive(interfaces, result);
        return result;
    }

    private static void getMethodsRecursive(Class<?>[] interfaces, List<Method> methods) {
        for (Class<?> i : interfaces) {
            Proxy.getMethodsRecursive(i.getInterfaces(), methods);
            Collections.addAll(methods, i.getDeclaredMethods());
        }
    }

    @FastNative
    private static native Class<?> generateProxy(String var0, Class<?>[] var1, ClassLoader var2, Method[] var3, Class<?>[][] var4);

    @CallerSensitive
    public static Object newProxyInstance(ClassLoader loader, Class<?>[] interfaces, InvocationHandler h) throws IllegalArgumentException {
        Objects.requireNonNull(h);
        Class[] intfs = (Class[])interfaces.clone();
        Class<?> cl = Proxy.getProxyClass0(loader, intfs);
        try {
            Constructor<?> cons = cl.getConstructor(constructorParams);
            InvocationHandler ih = h;
            if (!Modifier.isPublic(cl.getModifiers())) {
                cons.setAccessible(true);
            }
            return cons.newInstance(h);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new InternalError(e.toString(), e);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getCause();
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new InternalError(t.toString(), t);
        }
        catch (NoSuchMethodException e) {
            throw new InternalError(e.toString(), e);
        }
    }

    public static boolean isProxyClass(Class<?> cl) {
        return Proxy.class.isAssignableFrom(cl) && proxyClassCache.containsValue(cl);
    }

    @CallerSensitive
    public static InvocationHandler getInvocationHandler(Object proxy) throws IllegalArgumentException {
        if (!Proxy.isProxyClass(proxy.getClass())) {
            throw new IllegalArgumentException("not a proxy instance");
        }
        Proxy p = (Proxy)proxy;
        InvocationHandler ih = p.h;
        return ih;
    }

    private static Object invoke(Proxy proxy, Method method, Object[] args) throws Throwable {
        InvocationHandler h = proxy.h;
        return h.invoke(proxy, method, args);
    }

    private static final class ProxyClassFactory
    implements BiFunction<ClassLoader, Class<?>[], Class<?>> {
        private static final String proxyClassNamePrefix = "$Proxy";
        private static final AtomicLong nextUniqueNumber = new AtomicLong();

        private ProxyClassFactory() {
        }

        @Override
        public Class<?> apply(ClassLoader loader, Class<?>[] interfaces) {
            IdentityHashMap interfaceSet = new IdentityHashMap(interfaces.length);
            for (Class<?> intf : interfaces) {
                Class<?> interfaceClass = null;
                try {
                    interfaceClass = Class.forName(intf.getName(), false, loader);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                if (interfaceClass != intf) {
                    throw new IllegalArgumentException(intf + " is not visible from class loader");
                }
                if (!interfaceClass.isInterface()) {
                    throw new IllegalArgumentException(interfaceClass.getName() + " is not an interface");
                }
                if (interfaceSet.put(interfaceClass, Boolean.TRUE) == null) continue;
                throw new IllegalArgumentException("repeated interface: " + interfaceClass.getName());
            }
            String proxyPkg = null;
            int accessFlags = 17;
            for (Class<?> intf : interfaces) {
                String pkg;
                int flags = intf.getModifiers();
                if (Modifier.isPublic(flags)) continue;
                accessFlags = 16;
                String name = intf.getName();
                int n = name.lastIndexOf(46);
                String string = pkg = n == -1 ? "" : name.substring(0, n + 1);
                if (proxyPkg == null) {
                    proxyPkg = pkg;
                    continue;
                }
                if (pkg.equals(proxyPkg)) continue;
                throw new IllegalArgumentException("non-public interfaces from different packages");
            }
            if (proxyPkg == null) {
                proxyPkg = "";
            }
            List methods = Proxy.getMethods(interfaces);
            Collections.sort(methods, ORDER_BY_SIGNATURE_AND_SUBTYPE);
            Proxy.validateReturnTypes(methods);
            List exceptions = Proxy.deduplicateAndGetExceptions(methods);
            Method[] methodsArray = methods.toArray(new Method[methods.size()]);
            Class[][] exceptionsArray = (Class[][])exceptions.toArray((T[])new Class[exceptions.size()][]);
            long num = nextUniqueNumber.getAndIncrement();
            String proxyName = proxyPkg + proxyClassNamePrefix + num;
            return Proxy.generateProxy(proxyName, interfaces, loader, methodsArray, exceptionsArray);
        }
    }

    private static final class KeyFactory
    implements BiFunction<ClassLoader, Class<?>[], Object> {
        private KeyFactory() {
        }

        @Override
        public Object apply(ClassLoader classLoader, Class<?>[] interfaces) {
            switch (interfaces.length) {
                case 1: {
                    return new Key1(interfaces[0]);
                }
                case 2: {
                    return new Key2(interfaces[0], interfaces[1]);
                }
                case 0: {
                    return key0;
                }
            }
            return new KeyX(interfaces);
        }
    }

    private static final class KeyX {
        private final int hash;
        private final WeakReference<Class<?>>[] refs;

        KeyX(Class<?>[] interfaces) {
            this.hash = Arrays.hashCode(interfaces);
            this.refs = new WeakReference[interfaces.length];
            for (int i = 0; i < interfaces.length; ++i) {
                this.refs[i] = new WeakReference(interfaces[i]);
            }
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            return this == obj || obj != null && obj.getClass() == KeyX.class && KeyX.equals(this.refs, ((KeyX)obj).refs);
        }

        private static boolean equals(WeakReference<Class<?>>[] refs1, WeakReference<Class<?>>[] refs2) {
            if (refs1.length != refs2.length) {
                return false;
            }
            for (int i = 0; i < refs1.length; ++i) {
                Class intf = (Class)refs1[i].get();
                if (intf != null && intf == refs2[i].get()) continue;
                return false;
            }
            return true;
        }
    }

    private static final class Key2
    extends WeakReference<Class<?>> {
        private final int hash;
        private final WeakReference<Class<?>> ref2;

        Key2(Class<?> intf1, Class<?> intf2) {
            super(intf1);
            this.hash = 31 * intf1.hashCode() + intf2.hashCode();
            this.ref2 = new WeakReference(intf2);
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            Class intf2;
            Class intf1;
            return this == obj || obj != null && obj.getClass() == Key2.class && (intf1 = (Class)this.get()) != null && intf1 == ((Key2)obj).get() && (intf2 = (Class)this.ref2.get()) != null && intf2 == ((Key2)obj).ref2.get();
        }
    }

    private static final class Key1
    extends WeakReference<Class<?>> {
        private final int hash;

        Key1(Class<?> intf) {
            super(intf);
            this.hash = intf.hashCode();
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            Class intf;
            return this == obj || obj != null && obj.getClass() == Key1.class && (intf = (Class)this.get()) != null && intf == ((Key1)obj).get();
        }
    }
}

