/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import dalvik.annotation.optimization.FastNative;
import java.lang.annotation.Annotation;
import java.lang.reflect.Executable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Comparator;
import libcore.reflect.Types;
import libcore.util.EmptyArray;

public final class Method
extends Executable {
    public static final Comparator<Method> ORDER_BY_SIGNATURE = new Comparator<Method>(){

        @Override
        public int compare(Method a, Method b) {
            if (a == b) {
                return 0;
            }
            int comparison = a.getName().compareTo(b.getName());
            if (comparison == 0 && (comparison = a.compareMethodParametersInternal(b)) == 0) {
                Class<?> bReturnType;
                Class<?> aReturnType = a.getReturnType();
                comparison = aReturnType == (bReturnType = b.getReturnType()) ? 0 : aReturnType.getName().compareTo(bReturnType.getName());
            }
            return comparison;
        }
    };

    private Method() {
    }

    @Override
    boolean hasGenericInformation() {
        return super.hasGenericInformationInternal();
    }

    @Override
    public Class<?> getDeclaringClass() {
        return super.getDeclaringClassInternal();
    }

    @Override
    public String getName() {
        return this.getMethodNameInternal();
    }

    @Override
    public int getModifiers() {
        return super.getModifiersInternal();
    }

    public TypeVariable<Method>[] getTypeParameters() {
        Executable.GenericInfo info = this.getMethodOrConstructorGenericInfoInternal();
        return (TypeVariable[])info.formalTypeParameters.clone();
    }

    public Class<?> getReturnType() {
        return this.getMethodReturnTypeInternal();
    }

    public Type getGenericReturnType() {
        return Types.getType(this.getMethodOrConstructorGenericInfoInternal().genericReturnType);
    }

    @Override
    public Class<?>[] getParameterTypes() {
        Class<?>[] paramTypes = super.getParameterTypesInternal();
        if (paramTypes == null) {
            return EmptyArray.CLASS;
        }
        return paramTypes;
    }

    @Override
    public int getParameterCount() {
        return super.getParameterCountInternal();
    }

    @Override
    public Type[] getGenericParameterTypes() {
        return super.getGenericParameterTypes();
    }

    @Override
    @FastNative
    public native Class<?>[] getExceptionTypes();

    @Override
    public Type[] getGenericExceptionTypes() {
        return super.getGenericExceptionTypes();
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof Method) {
            Method other = (Method)obj;
            if (this.getDeclaringClass() == other.getDeclaringClass() && this.getName() == other.getName()) {
                if (!this.getReturnType().equals(other.getReturnType())) {
                    return false;
                }
                return this.equalParamTypes(this.getParameterTypes(), other.getParameterTypes());
            }
        }
        return false;
    }

    public int hashCode() {
        return this.getDeclaringClass().getName().hashCode() ^ this.getName().hashCode();
    }

    public String toString() {
        return this.sharedToString(Modifier.methodModifiers(), this.isDefault(), this.getParameterTypes(), this.getExceptionTypes());
    }

    @Override
    void specificToStringHeader(StringBuilder sb) {
        sb.append(this.getReturnType().getTypeName()).append(' ');
        sb.append(this.getDeclaringClass().getTypeName()).append('.');
        sb.append(this.getName());
    }

    @Override
    public String toGenericString() {
        return this.sharedToGenericString(Modifier.methodModifiers(), this.isDefault());
    }

    @Override
    void specificToGenericStringHeader(StringBuilder sb) {
        Type genRetType = this.getGenericReturnType();
        sb.append(genRetType.getTypeName()).append(' ');
        sb.append(this.getDeclaringClass().getTypeName()).append('.');
        sb.append(this.getName());
    }

    @FastNative
    public native Object invoke(Object var1, Object ... var2) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException;

    public boolean isBridge() {
        return super.isBridgeMethodInternal();
    }

    @Override
    public boolean isVarArgs() {
        return super.isVarArgs();
    }

    @Override
    public boolean isSynthetic() {
        return super.isSynthetic();
    }

    public boolean isDefault() {
        return super.isDefaultMethodInternal();
    }

    @FastNative
    public native Object getDefaultValue();

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return super.getAnnotation(annotationClass);
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        return super.getDeclaredAnnotations();
    }

    @Override
    public Annotation[][] getParameterAnnotations() {
        return super.getParameterAnnotationsInternal();
    }

    boolean equalNameAndParameters(Method m) {
        return this.equalNameAndParametersInternal(m);
    }
}

