/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import dalvik.annotation.optimization.FastNative;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Objects;
import libcore.reflect.AnnotatedElements;
import libcore.reflect.GenericSignatureParser;

public final class Field
extends AccessibleObject
implements Member {
    private int accessFlags;
    private Class<?> declaringClass;
    private int dexFieldIndex;
    private int offset;
    private Class<?> type;

    private Field() {
    }

    @Override
    public Class<?> getDeclaringClass() {
        return this.declaringClass;
    }

    @Override
    public String getName() {
        if (this.dexFieldIndex == -1) {
            if (!this.declaringClass.isProxy()) {
                throw new AssertionError();
            }
            return "throws";
        }
        return this.getNameInternal();
    }

    @FastNative
    private native String getNameInternal();

    @Override
    public int getModifiers() {
        return this.accessFlags & 0xFFFF;
    }

    public boolean isEnumConstant() {
        return (this.getModifiers() & 0x4000) != 0;
    }

    @Override
    public boolean isSynthetic() {
        return Modifier.isSynthetic(this.getModifiers());
    }

    public Class<?> getType() {
        return this.type;
    }

    public Type getGenericType() {
        String signatureAttribute = this.getSignatureAttribute();
        ClassLoader cl = this.declaringClass.getClassLoader();
        GenericSignatureParser parser = new GenericSignatureParser(cl);
        parser.parseForField(this.declaringClass, signatureAttribute);
        Class<?> genericType = parser.fieldType;
        if (genericType == null) {
            genericType = this.getType();
        }
        return genericType;
    }

    private String getSignatureAttribute() {
        String[] annotation = this.getSignatureAnnotation();
        if (annotation == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        for (String s : annotation) {
            result.append(s);
        }
        return result.toString();
    }

    @FastNative
    private native String[] getSignatureAnnotation();

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof Field) {
            Field other = (Field)obj;
            return this.getDeclaringClass() == other.getDeclaringClass() && this.getName() == other.getName() && this.getType() == other.getType();
        }
        return false;
    }

    public int hashCode() {
        return this.getDeclaringClass().getName().hashCode() ^ this.getName().hashCode();
    }

    public String toString() {
        int mod = this.getModifiers();
        return (mod == 0 ? "" : Modifier.toString(mod) + " ") + this.getType().getTypeName() + " " + this.getDeclaringClass().getTypeName() + "." + this.getName();
    }

    public String toGenericString() {
        int mod = this.getModifiers();
        Type fieldType = this.getGenericType();
        return (mod == 0 ? "" : Modifier.toString(mod) + " ") + fieldType.getTypeName() + " " + this.getDeclaringClass().getTypeName() + "." + this.getName();
    }

    @FastNative
    public native Object get(Object var1) throws IllegalArgumentException, IllegalAccessException;

    @FastNative
    public native boolean getBoolean(Object var1) throws IllegalArgumentException, IllegalAccessException;

    @FastNative
    public native byte getByte(Object var1) throws IllegalArgumentException, IllegalAccessException;

    @FastNative
    public native char getChar(Object var1) throws IllegalArgumentException, IllegalAccessException;

    @FastNative
    public native short getShort(Object var1) throws IllegalArgumentException, IllegalAccessException;

    @FastNative
    public native int getInt(Object var1) throws IllegalArgumentException, IllegalAccessException;

    @FastNative
    public native long getLong(Object var1) throws IllegalArgumentException, IllegalAccessException;

    @FastNative
    public native float getFloat(Object var1) throws IllegalArgumentException, IllegalAccessException;

    @FastNative
    public native double getDouble(Object var1) throws IllegalArgumentException, IllegalAccessException;

    @FastNative
    public native void set(Object var1, Object var2) throws IllegalArgumentException, IllegalAccessException;

    @FastNative
    public native void setBoolean(Object var1, boolean var2) throws IllegalArgumentException, IllegalAccessException;

    @FastNative
    public native void setByte(Object var1, byte var2) throws IllegalArgumentException, IllegalAccessException;

    @FastNative
    public native void setChar(Object var1, char var2) throws IllegalArgumentException, IllegalAccessException;

    @FastNative
    public native void setShort(Object var1, short var2) throws IllegalArgumentException, IllegalAccessException;

    @FastNative
    public native void setInt(Object var1, int var2) throws IllegalArgumentException, IllegalAccessException;

    @FastNative
    public native void setLong(Object var1, long var2) throws IllegalArgumentException, IllegalAccessException;

    @FastNative
    public native void setFloat(Object var1, float var2) throws IllegalArgumentException, IllegalAccessException;

    @FastNative
    public native void setDouble(Object var1, double var2) throws IllegalArgumentException, IllegalAccessException;

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        Objects.requireNonNull(annotationClass);
        return this.getAnnotationNative(annotationClass);
    }

    @FastNative
    private native <A extends Annotation> A getAnnotationNative(Class<A> var1);

    @Override
    public <T extends Annotation> T[] getAnnotationsByType(Class<T> annotationClass) {
        return AnnotatedElements.getDirectOrIndirectAnnotationsByType((AnnotatedElement)this, annotationClass);
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
        if (annotationType == null) {
            throw new NullPointerException("annotationType == null");
        }
        return this.isAnnotationPresentNative(annotationType);
    }

    @FastNative
    private native boolean isAnnotationPresentNative(Class<? extends Annotation> var1);

    @Override
    @FastNative
    public native Annotation[] getDeclaredAnnotations();

    public int getDexFieldIndex() {
        return this.dexFieldIndex;
    }

    public int getOffset() {
        return this.offset;
    }

    @FastNative
    public native long getArtField();
}

