/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import dalvik.annotation.optimization.FastNative;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.MalformedParametersException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Objects;
import libcore.reflect.AnnotatedElements;
import libcore.reflect.GenericSignatureParser;
import libcore.reflect.ListOfTypes;
import libcore.reflect.Types;

public abstract class Executable
extends AccessibleObject
implements Member,
GenericDeclaration {
    private volatile transient boolean hasRealParameterData;
    private volatile transient Parameter[] parameters;
    private int accessFlags;
    private long artMethod;
    private Class<?> declaringClass;
    private Class<?> declaringClassOfOverriddenMethod;
    private int dexMethodIndex;

    Executable() {
    }

    abstract boolean hasGenericInformation();

    boolean equalParamTypes(Class<?>[] params1, Class<?>[] params2) {
        if (params1.length == params2.length) {
            for (int i = 0; i < params1.length; ++i) {
                if (params1[i] == params2[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    void separateWithCommas(Class<?>[] types, StringBuilder sb) {
        for (int j = 0; j < types.length; ++j) {
            sb.append(types[j].getTypeName());
            if (j >= types.length - 1) continue;
            sb.append(",");
        }
    }

    void printModifiersIfNonzero(StringBuilder sb, int mask, boolean isDefault) {
        int mod = this.getModifiers() & mask;
        if (mod != 0 && !isDefault) {
            sb.append(Modifier.toString(mod)).append(' ');
        } else {
            int access_mod = mod & 7;
            if (access_mod != 0) {
                sb.append(Modifier.toString(access_mod)).append(' ');
            }
            if (isDefault) {
                sb.append("default ");
            }
            if ((mod &= 0xFFFFFFF8) != 0) {
                sb.append(Modifier.toString(mod)).append(' ');
            }
        }
    }

    String sharedToString(int modifierMask, boolean isDefault, Class<?>[] parameterTypes, Class<?>[] exceptionTypes) {
        try {
            StringBuilder sb = new StringBuilder();
            this.printModifiersIfNonzero(sb, modifierMask, isDefault);
            this.specificToStringHeader(sb);
            sb.append('(');
            this.separateWithCommas(parameterTypes, sb);
            sb.append(')');
            if (exceptionTypes.length > 0) {
                sb.append(" throws ");
                this.separateWithCommas(exceptionTypes, sb);
            }
            return sb.toString();
        }
        catch (Exception e) {
            return "<" + e + ">";
        }
    }

    abstract void specificToStringHeader(StringBuilder var1);

    String sharedToGenericString(int modifierMask, boolean isDefault) {
        try {
            StringBuilder sb = new StringBuilder();
            this.printModifiersIfNonzero(sb, modifierMask, isDefault);
            TypeVariable<?>[] typeparms = this.getTypeParameters();
            if (typeparms.length > 0) {
                boolean first = true;
                sb.append('<');
                for (TypeVariable<?> typeparm : typeparms) {
                    if (!first) {
                        sb.append(',');
                    }
                    sb.append(typeparm.toString());
                    first = false;
                }
                sb.append("> ");
            }
            this.specificToGenericStringHeader(sb);
            sb.append('(');
            Type[] params = this.getGenericParameterTypes();
            for (int j = 0; j < params.length; ++j) {
                String param = params[j].getTypeName();
                if (this.isVarArgs() && j == params.length - 1) {
                    param = param.replaceFirst("\\[\\]$", "...");
                }
                sb.append(param);
                if (j >= params.length - 1) continue;
                sb.append(',');
            }
            sb.append(')');
            Type[] exceptions = this.getGenericExceptionTypes();
            if (exceptions.length > 0) {
                sb.append(" throws ");
                for (int k = 0; k < exceptions.length; ++k) {
                    sb.append(exceptions[k] instanceof Class ? ((Class)exceptions[k]).getName() : exceptions[k].toString());
                    if (k >= exceptions.length - 1) continue;
                    sb.append(',');
                }
            }
            return sb.toString();
        }
        catch (Exception e) {
            return "<" + e + ">";
        }
    }

    abstract void specificToGenericStringHeader(StringBuilder var1);

    @Override
    public abstract Class<?> getDeclaringClass();

    @Override
    public abstract String getName();

    @Override
    public abstract int getModifiers();

    @Override
    public abstract TypeVariable<?>[] getTypeParameters();

    public abstract Class<?>[] getParameterTypes();

    public int getParameterCount() {
        throw new AbstractMethodError();
    }

    public Type[] getGenericParameterTypes() {
        return Types.getTypeArray(this.getMethodOrConstructorGenericInfoInternal().genericParameterTypes, false);
    }

    Type[] getAllGenericParameterTypes() {
        boolean genericInfo = this.hasGenericInformation();
        if (!genericInfo) {
            return this.getParameterTypes();
        }
        boolean realParamData = this.hasRealParameterData();
        Type[] genericParamTypes = this.getGenericParameterTypes();
        Class<?>[] nonGenericParamTypes = this.getParameterTypes();
        Type[] out = new Type[nonGenericParamTypes.length];
        Parameter[] params = this.getParameters();
        int fromidx = 0;
        if (realParamData) {
            for (int i = 0; i < out.length; ++i) {
                Parameter param = params[i];
                if (param.isSynthetic() || param.isImplicit()) {
                    out[i] = nonGenericParamTypes[i];
                    continue;
                }
                out[i] = genericParamTypes[fromidx];
                ++fromidx;
            }
        } else {
            return genericParamTypes.length == nonGenericParamTypes.length ? genericParamTypes : nonGenericParamTypes;
        }
        return out;
    }

    public Parameter[] getParameters() {
        return (Parameter[])this.privateGetParameters().clone();
    }

    private Parameter[] synthesizeAllParams() {
        int realparams = this.getParameterCount();
        Parameter[] out = new Parameter[realparams];
        for (int i = 0; i < realparams; ++i) {
            out[i] = new Parameter("arg" + i, 0, this, i);
        }
        return out;
    }

    private void verifyParameters(Parameter[] parameters) {
        int mask = 36880;
        if (this.getParameterTypes().length != parameters.length) {
            throw new MalformedParametersException("Wrong number of parameters in MethodParameters attribute");
        }
        for (Parameter parameter : parameters) {
            String name = parameter.getRealName();
            int mods = parameter.getModifiers();
            if (name != null && (name.isEmpty() || name.indexOf(46) != -1 || name.indexOf(59) != -1 || name.indexOf(91) != -1 || name.indexOf(47) != -1)) {
                throw new MalformedParametersException("Invalid parameter name \"" + name + "\"");
            }
            if (mods == (mods & 0x9010)) continue;
            throw new MalformedParametersException("Invalid parameter modifiers");
        }
    }

    private Parameter[] privateGetParameters() {
        Parameter[] tmp = this.parameters;
        if (tmp == null) {
            try {
                tmp = this.getParameters0();
            }
            catch (IllegalArgumentException e) {
                MalformedParametersException e2 = new MalformedParametersException("Invalid parameter metadata in class file");
                e2.initCause(e);
                throw e2;
            }
            if (tmp == null) {
                this.hasRealParameterData = false;
                tmp = this.synthesizeAllParams();
            } else {
                this.hasRealParameterData = true;
                this.verifyParameters(tmp);
            }
            this.parameters = tmp;
        }
        return tmp;
    }

    boolean hasRealParameterData() {
        if (this.parameters == null) {
            this.privateGetParameters();
        }
        return this.hasRealParameterData;
    }

    @FastNative
    private native Parameter[] getParameters0();

    public abstract Class<?>[] getExceptionTypes();

    public Type[] getGenericExceptionTypes() {
        return Types.getTypeArray(this.getMethodOrConstructorGenericInfoInternal().genericExceptionTypes, false);
    }

    public abstract String toGenericString();

    public boolean isVarArgs() {
        return (this.accessFlags & 0x80) != 0;
    }

    @Override
    public boolean isSynthetic() {
        return (this.accessFlags & 0x1000) != 0;
    }

    public abstract Annotation[][] getParameterAnnotations();

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        Objects.requireNonNull(annotationClass);
        return this.getAnnotationNative(annotationClass);
    }

    @FastNative
    private native <T extends Annotation> T getAnnotationNative(Class<T> var1);

    @Override
    public <T extends Annotation> T[] getAnnotationsByType(Class<T> annotationClass) {
        return AnnotatedElements.getDirectOrIndirectAnnotationsByType((AnnotatedElement)this, annotationClass);
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        return this.getDeclaredAnnotationsNative();
    }

    @FastNative
    private native Annotation[] getDeclaredAnnotationsNative();

    private static int fixMethodFlags(int flags) {
        int ACC_DECLARED_SYNCHRONIZED;
        if ((flags & 0x400) != 0) {
            flags &= 0xFFFFFEFF;
        }
        if (((flags &= 0xFFFFFFDF) & (ACC_DECLARED_SYNCHRONIZED = 131072)) != 0) {
            flags |= 0x20;
        }
        return flags & 0xFFFF;
    }

    final int getModifiersInternal() {
        return Executable.fixMethodFlags(this.accessFlags);
    }

    final Class<?> getDeclaringClassInternal() {
        return this.declaringClass;
    }

    @FastNative
    final native Class<?>[] getParameterTypesInternal();

    @FastNative
    final native int getParameterCountInternal();

    @Override
    public final boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
        Objects.requireNonNull(annotationType);
        return this.isAnnotationPresentNative(annotationType);
    }

    @FastNative
    private native boolean isAnnotationPresentNative(Class<? extends Annotation> var1);

    final Annotation[][] getParameterAnnotationsInternal() {
        Annotation[][] parameterAnnotations = this.getParameterAnnotationsNative();
        if (parameterAnnotations == null) {
            parameterAnnotations = new Annotation[this.getParameterTypes().length][0];
        }
        return parameterAnnotations;
    }

    @FastNative
    private native Annotation[][] getParameterAnnotationsNative();

    public final int getAccessFlags() {
        return this.accessFlags;
    }

    public final long getArtMethod() {
        return this.artMethod;
    }

    final boolean hasGenericInformationInternal() {
        return this.getSignatureAnnotation() != null;
    }

    final GenericInfo getMethodOrConstructorGenericInfoInternal() {
        String signatureAttribute = this.getSignatureAttribute();
        Class<?>[] exceptionTypes = this.getExceptionTypes();
        GenericSignatureParser parser = new GenericSignatureParser(this.getDeclaringClass().getClassLoader());
        if (this instanceof Method) {
            parser.parseForMethod(this, signatureAttribute, exceptionTypes);
        } else {
            parser.parseForConstructor(this, signatureAttribute, exceptionTypes);
        }
        return new GenericInfo(parser.exceptionTypes, parser.parameterTypes, parser.returnType, parser.formalTypeParameters);
    }

    private String getSignatureAttribute() {
        String[] annotation = this.getSignatureAnnotation();
        if (annotation == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        for (String s : annotation) {
            result.append(s);
        }
        return result.toString();
    }

    @FastNative
    private native String[] getSignatureAnnotation();

    final boolean equalNameAndParametersInternal(Method m) {
        return this.getName().equals(m.getName()) && this.compareMethodParametersInternal(m) == 0;
    }

    @FastNative
    native int compareMethodParametersInternal(Method var1);

    @FastNative
    final native String getMethodNameInternal();

    @FastNative
    final native Class<?> getMethodReturnTypeInternal();

    final boolean isDefaultMethodInternal() {
        return (this.accessFlags & 0x400000) != 0;
    }

    final boolean isBridgeMethodInternal() {
        return (this.accessFlags & 0x40) != 0;
    }

    static final class GenericInfo {
        final ListOfTypes genericExceptionTypes;
        final ListOfTypes genericParameterTypes;
        final Type genericReturnType;
        final TypeVariable<?>[] formalTypeParameters;

        GenericInfo(ListOfTypes exceptions, ListOfTypes parameters, Type ret, TypeVariable<?>[] formal) {
            this.genericExceptionTypes = exceptions;
            this.genericParameterTypes = parameters;
            this.genericReturnType = ret;
            this.formalTypeParameters = formal;
        }
    }
}

