/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class AccessibleObject
implements AnnotatedElement {
    boolean override;

    public static void setAccessible(AccessibleObject[] array, boolean flag) throws SecurityException {
        for (int i = 0; i < array.length; ++i) {
            AccessibleObject.setAccessible0(array[i], flag);
        }
    }

    public void setAccessible(boolean flag) throws SecurityException {
        AccessibleObject.setAccessible0(this, flag);
    }

    private static void setAccessible0(AccessibleObject obj, boolean flag) throws SecurityException {
        if (obj instanceof Constructor && flag) {
            Constructor c = (Constructor)obj;
            Class clazz = c.getDeclaringClass();
            if (c.getDeclaringClass() == Class.class) {
                throw new SecurityException("Can not make a java.lang.Class constructor accessible");
            }
            if (clazz == Method.class) {
                throw new SecurityException("Can not make a java.lang.reflect.Method constructor accessible");
            }
            if (clazz == Field.class) {
                throw new SecurityException("Can not make a java.lang.reflect.Field constructor accessible");
            }
        }
        obj.override = flag;
    }

    public boolean isAccessible() {
        return this.override;
    }

    protected AccessibleObject() {
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        throw new AssertionError((Object)"All subclasses should override this method");
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        return AnnotatedElement.super.isAnnotationPresent(annotationClass);
    }

    @Override
    public <T extends Annotation> T[] getAnnotationsByType(Class<T> annotationClass) {
        throw new AssertionError((Object)"All subclasses should override this method");
    }

    @Override
    public Annotation[] getAnnotations() {
        return this.getDeclaredAnnotations();
    }

    @Override
    public <T extends Annotation> T getDeclaredAnnotation(Class<T> annotationClass) {
        return this.getAnnotation(annotationClass);
    }

    @Override
    public <T extends Annotation> T[] getDeclaredAnnotationsByType(Class<T> annotationClass) {
        return this.getAnnotationsByType(annotationClass);
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        throw new AssertionError((Object)"All subclasses should override this method");
    }
}

