/*
 * Decompiled with CFR 0.152.
 */
package java.lang.ref;

import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import sun.misc.Cleaner;

public class ReferenceQueue<T> {
    private static final Reference sQueueNextUnenqueued = new PhantomReference<Object>(null, null);
    private Reference<? extends T> head = null;
    private Reference<? extends T> tail = null;
    private final Object lock = new Object();
    public static Reference<?> unenqueued = null;

    private boolean enqueueLocked(Reference<? extends T> r) {
        if (r.queueNext != null) {
            return false;
        }
        if (r instanceof Cleaner) {
            Cleaner cl = (Cleaner)r;
            cl.clean();
            r.queueNext = sQueueNextUnenqueued;
            return true;
        }
        if (this.tail == null) {
            this.head = r;
        } else {
            this.tail.queueNext = r;
        }
        this.tail = r;
        this.tail.queueNext = r;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isEnqueued(Reference<? extends T> reference) {
        Object object = this.lock;
        synchronized (object) {
            return reference.queueNext != null && reference.queueNext != sQueueNextUnenqueued;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean enqueue(Reference<? extends T> reference) {
        Object object = this.lock;
        synchronized (object) {
            if (this.enqueueLocked(reference)) {
                this.lock.notifyAll();
                return true;
            }
            return false;
        }
    }

    private Reference<? extends T> reallyPollLocked() {
        if (this.head != null) {
            Reference<? extends T> r = this.head;
            if (this.head == this.tail) {
                this.tail = null;
                this.head = null;
            } else {
                this.head = this.head.queueNext;
            }
            r.queueNext = sQueueNextUnenqueued;
            return r;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reference<? extends T> poll() {
        Object object = this.lock;
        synchronized (object) {
            if (this.head == null) {
                return null;
            }
            return this.reallyPollLocked();
        }
    }

    public Reference<? extends T> remove(long timeout) throws IllegalArgumentException, InterruptedException {
        if (timeout < 0L) {
            throw new IllegalArgumentException("Negative timeout value");
        }
        Object object = this.lock;
        synchronized (object) {
            Reference<T> r = this.reallyPollLocked();
            if (r != null) {
                return r;
            }
            long start = timeout == 0L ? 0L : System.nanoTime();
            while (true) {
                this.lock.wait(timeout);
                r = this.reallyPollLocked();
                if (r != null) {
                    return r;
                }
                if (timeout == 0L) continue;
                long end = System.nanoTime();
                if ((timeout -= (end - start) / 1000000L) <= 0L) {
                    return null;
                }
                start = end;
            }
        }
    }

    public Reference<? extends T> remove() throws InterruptedException {
        return this.remove(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void enqueuePending(Reference<?> list) {
        Reference<?> start = list;
        do {
            ReferenceQueue queue;
            if ((queue = list.queue) == null) {
                Reference<?> next = list.pendingNext;
                list.pendingNext = list;
                list = next;
                continue;
            }
            Object object = queue.lock;
            synchronized (object) {
                Reference<?> next;
                do {
                    next = list.pendingNext;
                    list.pendingNext = list;
                    super.enqueueLocked(list);
                } while ((list = next) != start && list.queue == queue);
                queue.lock.notifyAll();
            }
        } while (list != start);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void add(Reference<?> list) {
        Class<ReferenceQueue> clazz = ReferenceQueue.class;
        synchronized (ReferenceQueue.class) {
            if (unenqueued == null) {
                unenqueued = list;
            } else {
                Reference<?> last = unenqueued;
                while (last.pendingNext != unenqueued) {
                    last = last.pendingNext;
                }
                last.pendingNext = list;
                last = list;
                while (last.pendingNext != list) {
                    last = last.pendingNext;
                }
                last.pendingNext = unenqueued;
            }
            ReferenceQueue.class.notifyAll();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }
}

