/*
 * Decompiled with CFR 0.152.
 */
package java.lang.ref;

import dalvik.annotation.optimization.FastNative;
import java.lang.ref.ReferenceQueue;

public abstract class Reference<T> {
    private static boolean disableIntrinsic = false;
    private static boolean slowPathEnabled = false;
    volatile T referent;
    final ReferenceQueue<? super T> queue;
    Reference queueNext;
    Reference<?> pendingNext;

    public T get() {
        return this.getReferent();
    }

    @FastNative
    private final native T getReferent();

    public void clear() {
        this.clearReferent();
    }

    @FastNative
    native void clearReferent();

    public boolean isEnqueued() {
        return this.queue != null && this.queue.isEnqueued(this);
    }

    public boolean enqueue() {
        return this.queue != null && this.queue.enqueue(this);
    }

    Reference(T referent) {
        this(referent, null);
    }

    Reference(T referent, ReferenceQueue<? super T> queue) {
        this.referent = referent;
        this.queue = queue;
    }

    public static void reachabilityFence(Object ref) {
        SinkHolder.sink = ref;
        if (SinkHolder.finalize_count == 0) {
            SinkHolder.sink = null;
        }
    }

    private static class SinkHolder {
        static volatile Object sink;
        private static volatile int finalize_count;
        private static Object sinkUser;

        private SinkHolder() {
        }

        static {
            finalize_count = 0;
            sinkUser = new Object(){

                protected void finalize() {
                    if (sink == null && finalize_count > 0) {
                        throw new AssertionError((Object)"Can't get here");
                    }
                    finalize_count++;
                }
            };
        }
    }
}

