/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import sun.misc.Unsafe;

public abstract class VarHandle {
    private static final Unsafe UNSAFE = Unsafe.getUnsafe();
    private final Class<?> varType;
    private final Class<?> coordinateType0;
    private final Class<?> coordinateType1;
    private final int accessModesBitMask;
    private static final int READ_ACCESS_MODES_BIT_MASK;
    private static final int WRITE_ACCESS_MODES_BIT_MASK;
    private static final int ATOMIC_UPDATE_ACCESS_MODES_BIT_MASK;
    private static final int NUMERIC_ATOMIC_UPDATE_ACCESS_MODES_BIT_MASK;
    private static final int BITWISE_ATOMIC_UPDATE_ACCESS_MODES_BIT_MASK;
    private static final int ALL_MODES_BIT_MASK;

    @MethodHandle.PolymorphicSignature
    public final native Object get(Object ... var1);

    @MethodHandle.PolymorphicSignature
    public final native void set(Object ... var1);

    @MethodHandle.PolymorphicSignature
    public final native Object getVolatile(Object ... var1);

    @MethodHandle.PolymorphicSignature
    public final native void setVolatile(Object ... var1);

    @MethodHandle.PolymorphicSignature
    public final native Object getOpaque(Object ... var1);

    @MethodHandle.PolymorphicSignature
    public final native void setOpaque(Object ... var1);

    @MethodHandle.PolymorphicSignature
    public final native Object getAcquire(Object ... var1);

    @MethodHandle.PolymorphicSignature
    public final native void setRelease(Object ... var1);

    @MethodHandle.PolymorphicSignature
    public final native boolean compareAndSet(Object ... var1);

    @MethodHandle.PolymorphicSignature
    public final native Object compareAndExchange(Object ... var1);

    @MethodHandle.PolymorphicSignature
    public final native Object compareAndExchangeAcquire(Object ... var1);

    @MethodHandle.PolymorphicSignature
    public final native Object compareAndExchangeRelease(Object ... var1);

    @MethodHandle.PolymorphicSignature
    public final native boolean weakCompareAndSetPlain(Object ... var1);

    @MethodHandle.PolymorphicSignature
    public final native boolean weakCompareAndSet(Object ... var1);

    @MethodHandle.PolymorphicSignature
    public final native boolean weakCompareAndSetAcquire(Object ... var1);

    @MethodHandle.PolymorphicSignature
    public final native boolean weakCompareAndSetRelease(Object ... var1);

    @MethodHandle.PolymorphicSignature
    public final native Object getAndSet(Object ... var1);

    @MethodHandle.PolymorphicSignature
    public final native Object getAndSetAcquire(Object ... var1);

    @MethodHandle.PolymorphicSignature
    public final native Object getAndSetRelease(Object ... var1);

    @MethodHandle.PolymorphicSignature
    public final native Object getAndAdd(Object ... var1);

    @MethodHandle.PolymorphicSignature
    public final native Object getAndAddAcquire(Object ... var1);

    @MethodHandle.PolymorphicSignature
    public final native Object getAndAddRelease(Object ... var1);

    @MethodHandle.PolymorphicSignature
    public final native Object getAndBitwiseOr(Object ... var1);

    @MethodHandle.PolymorphicSignature
    public final native Object getAndBitwiseOrAcquire(Object ... var1);

    @MethodHandle.PolymorphicSignature
    public final native Object getAndBitwiseOrRelease(Object ... var1);

    @MethodHandle.PolymorphicSignature
    public final native Object getAndBitwiseAnd(Object ... var1);

    @MethodHandle.PolymorphicSignature
    public final native Object getAndBitwiseAndAcquire(Object ... var1);

    @MethodHandle.PolymorphicSignature
    public final native Object getAndBitwiseAndRelease(Object ... var1);

    @MethodHandle.PolymorphicSignature
    public final native Object getAndBitwiseXor(Object ... var1);

    @MethodHandle.PolymorphicSignature
    public final native Object getAndBitwiseXorAcquire(Object ... var1);

    @MethodHandle.PolymorphicSignature
    public final native Object getAndBitwiseXorRelease(Object ... var1);

    public final Class<?> varType() {
        return this.varType;
    }

    public final List<Class<?>> coordinateTypes() {
        if (this.coordinateType0 == null) {
            return Collections.EMPTY_LIST;
        }
        if (this.coordinateType1 == null) {
            return Collections.singletonList(this.coordinateType0);
        }
        return Collections.unmodifiableList(Arrays.asList(this.coordinateType0, this.coordinateType1));
    }

    public final MethodType accessModeType(AccessMode accessMode) {
        if (this.coordinateType1 == null) {
            return accessMode.at.accessModeType(this.coordinateType0, this.varType, new Class[0]);
        }
        return accessMode.at.accessModeType(this.coordinateType0, this.varType, this.coordinateType1);
    }

    public final boolean isAccessModeSupported(AccessMode accessMode) {
        int testBit = 1 << accessMode.ordinal();
        return (this.accessModesBitMask & testBit) == testBit;
    }

    public final MethodHandle toMethodHandle(AccessMode accessMode) {
        MethodType type = this.accessModeType(accessMode);
        return MethodHandles.varHandleExactInvoker(accessMode, type).bindTo(this);
    }

    public static void fullFence() {
        UNSAFE.fullFence();
    }

    public static void acquireFence() {
        UNSAFE.loadFence();
    }

    public static void releaseFence() {
        UNSAFE.storeFence();
    }

    public static void loadLoadFence() {
        UNSAFE.loadFence();
    }

    public static void storeStoreFence() {
        UNSAFE.storeFence();
    }

    VarHandle(Class<?> varType, boolean isFinal) {
        this.varType = Objects.requireNonNull(varType);
        this.coordinateType0 = null;
        this.coordinateType1 = null;
        this.accessModesBitMask = VarHandle.alignedAccessModesBitMask(varType, isFinal);
    }

    VarHandle(Class<?> varType, boolean isFinal, Class<?> coordinateType) {
        this.varType = Objects.requireNonNull(varType);
        this.coordinateType0 = Objects.requireNonNull(coordinateType);
        this.coordinateType1 = null;
        this.accessModesBitMask = VarHandle.alignedAccessModesBitMask(varType, isFinal);
    }

    VarHandle(Class<?> varType, Class<?> backingArrayType, boolean isFinal, Class<?> coordinateType0, Class<?> coordinateType1) {
        this.varType = Objects.requireNonNull(varType);
        this.coordinateType0 = Objects.requireNonNull(coordinateType0);
        this.coordinateType1 = Objects.requireNonNull(coordinateType1);
        Objects.requireNonNull(backingArrayType);
        Class<?> backingArrayComponentType = backingArrayType.getComponentType();
        if (backingArrayComponentType != varType && backingArrayComponentType != Byte.TYPE) {
            throw new InternalError("Unsupported backingArrayType: " + backingArrayType);
        }
        this.accessModesBitMask = backingArrayType.getComponentType() == varType ? VarHandle.alignedAccessModesBitMask(varType, isFinal) : VarHandle.unalignedAccessModesBitMask(varType);
    }

    static int accessTypesToBitMask(EnumSet<AccessType> accessTypes) {
        int m = 0;
        for (AccessMode accessMode : AccessMode.values()) {
            if (!accessTypes.contains((Object)accessMode.at)) continue;
            m |= 1 << accessMode.ordinal();
        }
        return m;
    }

    static int alignedAccessModesBitMask(Class<?> varType, boolean isFinal) {
        int bitMask = ALL_MODES_BIT_MASK;
        if (isFinal) {
            bitMask &= READ_ACCESS_MODES_BIT_MASK;
        }
        if (varType != Byte.TYPE && varType != Short.TYPE && varType != Character.TYPE && varType != Integer.TYPE && varType != Long.TYPE && varType != Float.TYPE && varType != Double.TYPE) {
            bitMask &= ~NUMERIC_ATOMIC_UPDATE_ACCESS_MODES_BIT_MASK;
        }
        if (varType != Boolean.TYPE && varType != Byte.TYPE && varType != Short.TYPE && varType != Character.TYPE && varType != Integer.TYPE && varType != Long.TYPE) {
            bitMask &= ~BITWISE_ATOMIC_UPDATE_ACCESS_MODES_BIT_MASK;
        }
        return bitMask;
    }

    static int unalignedAccessModesBitMask(Class<?> varType) {
        int bitMask = READ_ACCESS_MODES_BIT_MASK | WRITE_ACCESS_MODES_BIT_MASK;
        if (varType == Integer.TYPE || varType == Long.TYPE || varType == Float.TYPE || varType == Double.TYPE) {
            bitMask |= ATOMIC_UPDATE_ACCESS_MODES_BIT_MASK;
        }
        if (varType == Integer.TYPE || varType == Long.TYPE) {
            bitMask |= NUMERIC_ATOMIC_UPDATE_ACCESS_MODES_BIT_MASK;
        }
        if (varType == Integer.TYPE || varType == Long.TYPE) {
            bitMask |= BITWISE_ATOMIC_UPDATE_ACCESS_MODES_BIT_MASK;
        }
        return bitMask;
    }

    static {
        if (AccessMode.values().length > 32) {
            throw new InternalError("accessModes overflow");
        }
        READ_ACCESS_MODES_BIT_MASK = VarHandle.accessTypesToBitMask(EnumSet.of(AccessType.GET));
        WRITE_ACCESS_MODES_BIT_MASK = VarHandle.accessTypesToBitMask(EnumSet.of(AccessType.SET));
        ATOMIC_UPDATE_ACCESS_MODES_BIT_MASK = VarHandle.accessTypesToBitMask(EnumSet.of(AccessType.COMPARE_AND_EXCHANGE, AccessType.COMPARE_AND_SWAP, AccessType.GET_AND_UPDATE));
        NUMERIC_ATOMIC_UPDATE_ACCESS_MODES_BIT_MASK = VarHandle.accessTypesToBitMask(EnumSet.of(AccessType.GET_AND_UPDATE_NUMERIC));
        BITWISE_ATOMIC_UPDATE_ACCESS_MODES_BIT_MASK = VarHandle.accessTypesToBitMask(EnumSet.of(AccessType.GET_AND_UPDATE_BITWISE));
        ALL_MODES_BIT_MASK = READ_ACCESS_MODES_BIT_MASK | WRITE_ACCESS_MODES_BIT_MASK | ATOMIC_UPDATE_ACCESS_MODES_BIT_MASK | NUMERIC_ATOMIC_UPDATE_ACCESS_MODES_BIT_MASK | BITWISE_ATOMIC_UPDATE_ACCESS_MODES_BIT_MASK;
    }

    public static enum AccessMode {
        GET("get", AccessType.GET),
        SET("set", AccessType.SET),
        GET_VOLATILE("getVolatile", AccessType.GET),
        SET_VOLATILE("setVolatile", AccessType.SET),
        GET_ACQUIRE("getAcquire", AccessType.GET),
        SET_RELEASE("setRelease", AccessType.SET),
        GET_OPAQUE("getOpaque", AccessType.GET),
        SET_OPAQUE("setOpaque", AccessType.SET),
        COMPARE_AND_SET("compareAndSet", AccessType.COMPARE_AND_SWAP),
        COMPARE_AND_EXCHANGE("compareAndExchange", AccessType.COMPARE_AND_EXCHANGE),
        COMPARE_AND_EXCHANGE_ACQUIRE("compareAndExchangeAcquire", AccessType.COMPARE_AND_EXCHANGE),
        COMPARE_AND_EXCHANGE_RELEASE("compareAndExchangeRelease", AccessType.COMPARE_AND_EXCHANGE),
        WEAK_COMPARE_AND_SET_PLAIN("weakCompareAndSetPlain", AccessType.COMPARE_AND_SWAP),
        WEAK_COMPARE_AND_SET("weakCompareAndSet", AccessType.COMPARE_AND_SWAP),
        WEAK_COMPARE_AND_SET_ACQUIRE("weakCompareAndSetAcquire", AccessType.COMPARE_AND_SWAP),
        WEAK_COMPARE_AND_SET_RELEASE("weakCompareAndSetRelease", AccessType.COMPARE_AND_SWAP),
        GET_AND_SET("getAndSet", AccessType.GET_AND_UPDATE),
        GET_AND_SET_ACQUIRE("getAndSetAcquire", AccessType.GET_AND_UPDATE),
        GET_AND_SET_RELEASE("getAndSetRelease", AccessType.GET_AND_UPDATE),
        GET_AND_ADD("getAndAdd", AccessType.GET_AND_UPDATE_NUMERIC),
        GET_AND_ADD_ACQUIRE("getAndAddAcquire", AccessType.GET_AND_UPDATE_NUMERIC),
        GET_AND_ADD_RELEASE("getAndAddRelease", AccessType.GET_AND_UPDATE_NUMERIC),
        GET_AND_BITWISE_OR("getAndBitwiseOr", AccessType.GET_AND_UPDATE_BITWISE),
        GET_AND_BITWISE_OR_RELEASE("getAndBitwiseOrRelease", AccessType.GET_AND_UPDATE_BITWISE),
        GET_AND_BITWISE_OR_ACQUIRE("getAndBitwiseOrAcquire", AccessType.GET_AND_UPDATE_BITWISE),
        GET_AND_BITWISE_AND("getAndBitwiseAnd", AccessType.GET_AND_UPDATE_BITWISE),
        GET_AND_BITWISE_AND_RELEASE("getAndBitwiseAndRelease", AccessType.GET_AND_UPDATE_BITWISE),
        GET_AND_BITWISE_AND_ACQUIRE("getAndBitwiseAndAcquire", AccessType.GET_AND_UPDATE_BITWISE),
        GET_AND_BITWISE_XOR("getAndBitwiseXor", AccessType.GET_AND_UPDATE_BITWISE),
        GET_AND_BITWISE_XOR_RELEASE("getAndBitwiseXorRelease", AccessType.GET_AND_UPDATE_BITWISE),
        GET_AND_BITWISE_XOR_ACQUIRE("getAndBitwiseXorAcquire", AccessType.GET_AND_UPDATE_BITWISE);

        static final Map<String, AccessMode> methodNameToAccessMode;
        final String methodName;
        final AccessType at;

        private AccessMode(String methodName, AccessType at) {
            this.methodName = methodName;
            this.at = at;
        }

        public String methodName() {
            return this.methodName;
        }

        public static AccessMode valueFromMethodName(String methodName) {
            AccessMode am = methodNameToAccessMode.get(methodName);
            if (am != null) {
                return am;
            }
            throw new IllegalArgumentException("No AccessMode value for method name " + methodName);
        }

        static {
            methodNameToAccessMode = new HashMap<String, AccessMode>(AccessMode.values().length);
            for (AccessMode am : AccessMode.values()) {
                methodNameToAccessMode.put(am.methodName, am);
            }
        }
    }

    static enum AccessType {
        GET,
        SET,
        COMPARE_AND_SWAP,
        COMPARE_AND_EXCHANGE,
        GET_AND_UPDATE,
        GET_AND_UPDATE_BITWISE,
        GET_AND_UPDATE_NUMERIC;


        MethodType accessModeType(Class<?> receiver, Class<?> value, Class<?> ... intermediate) {
            switch (this) {
                case GET: {
                    Class<?>[] ps = AccessType.allocateParameters(0, receiver, intermediate);
                    AccessType.fillParameters(ps, receiver, intermediate);
                    return MethodType.methodType(value, ps);
                }
                case SET: {
                    Class<?>[] ps = AccessType.allocateParameters(1, receiver, intermediate);
                    int i = AccessType.fillParameters(ps, receiver, intermediate);
                    ps[i] = value;
                    return MethodType.methodType(Void.TYPE, ps);
                }
                case COMPARE_AND_SWAP: {
                    Class<?>[] ps = AccessType.allocateParameters(2, receiver, intermediate);
                    int i = AccessType.fillParameters(ps, receiver, intermediate);
                    ps[i++] = value;
                    ps[i] = value;
                    return MethodType.methodType(Boolean.TYPE, ps);
                }
                case COMPARE_AND_EXCHANGE: {
                    Class<?>[] ps = AccessType.allocateParameters(2, receiver, intermediate);
                    int i = AccessType.fillParameters(ps, receiver, intermediate);
                    ps[i++] = value;
                    ps[i] = value;
                    return MethodType.methodType(value, ps);
                }
                case GET_AND_UPDATE: 
                case GET_AND_UPDATE_BITWISE: 
                case GET_AND_UPDATE_NUMERIC: {
                    Class<?>[] ps = AccessType.allocateParameters(1, receiver, intermediate);
                    int i = AccessType.fillParameters(ps, receiver, intermediate);
                    ps[i] = value;
                    return MethodType.methodType(value, ps);
                }
            }
            throw new InternalError("Unknown AccessType");
        }

        private static Class<?>[] allocateParameters(int values, Class<?> receiver, Class<?> ... intermediate) {
            int size = (receiver != null ? 1 : 0) + intermediate.length + values;
            return new Class[size];
        }

        private static int fillParameters(Class<?>[] ps, Class<?> receiver, Class<?> ... intermediate) {
            int i = 0;
            if (receiver != null) {
                ps[i++] = receiver;
            }
            for (int j = 0; j < intermediate.length; ++j) {
                ps[i++] = intermediate[j];
            }
            return i;
        }
    }
}

