/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import dalvik.system.EmulatedStackFrame;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.lang.invoke.WrongMethodTypeException;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import sun.invoke.util.Wrapper;
import sun.misc.Unsafe;

public class Transformers {
    private static final Method TRANSFORM_INTERNAL;

    private Transformers() {
    }

    static {
        try {
            TRANSFORM_INTERNAL = MethodHandle.class.getDeclaredMethod("transformInternal", EmulatedStackFrame.class);
        }
        catch (NoSuchMethodException nsme) {
            throw new AssertionError();
        }
    }

    public static class ExplicitCastArguments
    extends Transformer {
        private final MethodHandle target;

        public ExplicitCastArguments(MethodHandle target, MethodType type) {
            super(type);
            this.target = target;
        }

        @Override
        public void transform(EmulatedStackFrame callerFrame) throws Throwable {
            EmulatedStackFrame targetFrame = EmulatedStackFrame.create(this.target.type());
            this.explicitCastArguments(callerFrame, targetFrame);
            this.target.invoke(targetFrame);
            this.explicitCastReturnValue(callerFrame, targetFrame);
        }

        private void explicitCastArguments(EmulatedStackFrame callerFrame, EmulatedStackFrame targetFrame) {
            EmulatedStackFrame.StackFrameReader reader = new EmulatedStackFrame.StackFrameReader();
            reader.attach(callerFrame);
            EmulatedStackFrame.StackFrameWriter writer = new EmulatedStackFrame.StackFrameWriter();
            writer.attach(targetFrame);
            Class<?>[] fromTypes = this.type().ptypes();
            Class<?>[] toTypes = this.target.type().ptypes();
            for (int i = 0; i < fromTypes.length; ++i) {
                ExplicitCastArguments.explicitCast(reader, fromTypes[i], writer, toTypes[i]);
            }
        }

        private void explicitCastReturnValue(EmulatedStackFrame callerFrame, EmulatedStackFrame targetFrame) {
            Class<?> from = this.target.type().rtype();
            Class<?> to = this.type().rtype();
            if (to != Void.TYPE) {
                EmulatedStackFrame.StackFrameWriter writer = new EmulatedStackFrame.StackFrameWriter();
                writer.attach(callerFrame);
                writer.makeReturnValueAccessor();
                if (from == Void.TYPE) {
                    if (to.isPrimitive()) {
                        ExplicitCastArguments.unboxNull(writer, to);
                    } else {
                        writer.putNextReference(null, to);
                    }
                } else {
                    EmulatedStackFrame.StackFrameReader reader = new EmulatedStackFrame.StackFrameReader();
                    reader.attach(targetFrame);
                    reader.makeReturnValueAccessor();
                    ExplicitCastArguments.explicitCast(reader, this.target.type().rtype(), writer, this.type().rtype());
                }
            }
        }

        private static void throwUnexpectedType(Class<?> unexpectedType) {
            throw new InternalError("Unexpected type: " + unexpectedType);
        }

        private static void explicitCastFromBoolean(boolean fromValue, EmulatedStackFrame.StackFrameWriter writer, Class<?> to) {
            int value;
            int n = value = fromValue ? 1 : 0;
            if (to == Byte.TYPE) {
                writer.putNextByte((byte)value);
            } else if (to == Character.TYPE) {
                writer.putNextChar((char)value);
            } else if (to == Short.TYPE) {
                writer.putNextShort((short)value);
            } else if (to == Integer.TYPE) {
                writer.putNextInt(value);
            } else if (to == Long.TYPE) {
                writer.putNextLong(value);
            } else if (to == Float.TYPE) {
                writer.putNextFloat(value);
            } else if (to == Double.TYPE) {
                writer.putNextDouble(value);
            } else {
                ExplicitCastArguments.throwUnexpectedType(to);
            }
        }

        private static boolean toBoolean(byte value) {
            return (value & 1) == 1;
        }

        private static byte readPrimitiveAsByte(EmulatedStackFrame.StackFrameReader reader, Class<?> from) {
            if (from == Byte.TYPE) {
                return reader.nextByte();
            }
            if (from == Character.TYPE) {
                return (byte)reader.nextChar();
            }
            if (from == Short.TYPE) {
                return (byte)reader.nextShort();
            }
            if (from == Integer.TYPE) {
                return (byte)reader.nextInt();
            }
            if (from == Long.TYPE) {
                return (byte)reader.nextLong();
            }
            if (from == Float.TYPE) {
                return (byte)reader.nextFloat();
            }
            if (from == Double.TYPE) {
                return (byte)reader.nextDouble();
            }
            ExplicitCastArguments.throwUnexpectedType(from);
            return 0;
        }

        private static char readPrimitiveAsChar(EmulatedStackFrame.StackFrameReader reader, Class<?> from) {
            if (from == Byte.TYPE) {
                return (char)reader.nextByte();
            }
            if (from == Character.TYPE) {
                return reader.nextChar();
            }
            if (from == Short.TYPE) {
                return (char)reader.nextShort();
            }
            if (from == Integer.TYPE) {
                return (char)reader.nextInt();
            }
            if (from == Long.TYPE) {
                return (char)reader.nextLong();
            }
            if (from == Float.TYPE) {
                return (char)reader.nextFloat();
            }
            if (from == Double.TYPE) {
                return (char)reader.nextDouble();
            }
            ExplicitCastArguments.throwUnexpectedType(from);
            return '\u0000';
        }

        private static short readPrimitiveAsShort(EmulatedStackFrame.StackFrameReader reader, Class<?> from) {
            if (from == Byte.TYPE) {
                return reader.nextByte();
            }
            if (from == Character.TYPE) {
                return (short)reader.nextChar();
            }
            if (from == Short.TYPE) {
                return reader.nextShort();
            }
            if (from == Integer.TYPE) {
                return (short)reader.nextInt();
            }
            if (from == Long.TYPE) {
                return (short)reader.nextLong();
            }
            if (from == Float.TYPE) {
                return (short)reader.nextFloat();
            }
            if (from == Double.TYPE) {
                return (short)reader.nextDouble();
            }
            ExplicitCastArguments.throwUnexpectedType(from);
            return 0;
        }

        private static int readPrimitiveAsInt(EmulatedStackFrame.StackFrameReader reader, Class<?> from) {
            if (from == Byte.TYPE) {
                return reader.nextByte();
            }
            if (from == Character.TYPE) {
                return reader.nextChar();
            }
            if (from == Short.TYPE) {
                return reader.nextShort();
            }
            if (from == Integer.TYPE) {
                return reader.nextInt();
            }
            if (from == Long.TYPE) {
                return (int)reader.nextLong();
            }
            if (from == Float.TYPE) {
                return (int)reader.nextFloat();
            }
            if (from == Double.TYPE) {
                return (int)reader.nextDouble();
            }
            ExplicitCastArguments.throwUnexpectedType(from);
            return 0;
        }

        private static long readPrimitiveAsLong(EmulatedStackFrame.StackFrameReader reader, Class<?> from) {
            if (from == Byte.TYPE) {
                return reader.nextByte();
            }
            if (from == Character.TYPE) {
                return reader.nextChar();
            }
            if (from == Short.TYPE) {
                return reader.nextShort();
            }
            if (from == Integer.TYPE) {
                return reader.nextInt();
            }
            if (from == Long.TYPE) {
                return reader.nextLong();
            }
            if (from == Float.TYPE) {
                return (long)reader.nextFloat();
            }
            if (from == Double.TYPE) {
                return (long)reader.nextDouble();
            }
            ExplicitCastArguments.throwUnexpectedType(from);
            return 0L;
        }

        private static float readPrimitiveAsFloat(EmulatedStackFrame.StackFrameReader reader, Class<?> from) {
            if (from == Byte.TYPE) {
                return reader.nextByte();
            }
            if (from == Character.TYPE) {
                return reader.nextChar();
            }
            if (from == Short.TYPE) {
                return reader.nextShort();
            }
            if (from == Integer.TYPE) {
                return reader.nextInt();
            }
            if (from == Long.TYPE) {
                return reader.nextLong();
            }
            if (from == Float.TYPE) {
                return reader.nextFloat();
            }
            if (from == Double.TYPE) {
                return (float)reader.nextDouble();
            }
            ExplicitCastArguments.throwUnexpectedType(from);
            return 0.0f;
        }

        private static double readPrimitiveAsDouble(EmulatedStackFrame.StackFrameReader reader, Class<?> from) {
            if (from == Byte.TYPE) {
                return reader.nextByte();
            }
            if (from == Character.TYPE) {
                return reader.nextChar();
            }
            if (from == Short.TYPE) {
                return reader.nextShort();
            }
            if (from == Integer.TYPE) {
                return reader.nextInt();
            }
            if (from == Long.TYPE) {
                return reader.nextLong();
            }
            if (from == Float.TYPE) {
                return reader.nextFloat();
            }
            if (from == Double.TYPE) {
                return reader.nextDouble();
            }
            ExplicitCastArguments.throwUnexpectedType(from);
            return 0.0;
        }

        private static void explicitCastToBoolean(EmulatedStackFrame.StackFrameReader reader, Class<?> from, EmulatedStackFrame.StackFrameWriter writer) {
            byte byteValue = ExplicitCastArguments.readPrimitiveAsByte(reader, from);
            writer.putNextBoolean(ExplicitCastArguments.toBoolean(byteValue));
        }

        private static void explicitCastPrimitives(EmulatedStackFrame.StackFrameReader reader, Class<?> from, EmulatedStackFrame.StackFrameWriter writer, Class<?> to) {
            if (to == Byte.TYPE) {
                byte value = ExplicitCastArguments.readPrimitiveAsByte(reader, from);
                writer.putNextByte(value);
            } else if (to == Character.TYPE) {
                char value = ExplicitCastArguments.readPrimitiveAsChar(reader, from);
                writer.putNextChar(value);
            } else if (to == Short.TYPE) {
                short value = ExplicitCastArguments.readPrimitiveAsShort(reader, from);
                writer.putNextShort(value);
            } else if (to == Integer.TYPE) {
                int value = ExplicitCastArguments.readPrimitiveAsInt(reader, from);
                writer.putNextInt(value);
            } else if (to == Long.TYPE) {
                long value = ExplicitCastArguments.readPrimitiveAsLong(reader, from);
                writer.putNextLong(value);
            } else if (to == Float.TYPE) {
                float value = ExplicitCastArguments.readPrimitiveAsFloat(reader, from);
                writer.putNextFloat(value);
            } else if (to == Double.TYPE) {
                double value = ExplicitCastArguments.readPrimitiveAsDouble(reader, from);
                writer.putNextDouble(value);
            } else {
                ExplicitCastArguments.throwUnexpectedType(to);
            }
        }

        private static void unboxNull(EmulatedStackFrame.StackFrameWriter writer, Class<?> to) {
            if (to == Boolean.TYPE) {
                writer.putNextBoolean(false);
            } else if (to == Byte.TYPE) {
                writer.putNextByte((byte)0);
            } else if (to == Character.TYPE) {
                writer.putNextChar('\u0000');
            } else if (to == Short.TYPE) {
                writer.putNextShort((short)0);
            } else if (to == Integer.TYPE) {
                writer.putNextInt(0);
            } else if (to == Long.TYPE) {
                writer.putNextLong(0L);
            } else if (to == Float.TYPE) {
                writer.putNextFloat(0.0f);
            } else if (to == Double.TYPE) {
                writer.putNextDouble(0.0);
            } else {
                ExplicitCastArguments.throwUnexpectedType(to);
            }
        }

        private static void unboxNonNull(Object ref, Class<?> from, EmulatedStackFrame.StackFrameWriter writer, Class<?> to) {
            if (to == Boolean.TYPE) {
                if (from == Boolean.class) {
                    writer.putNextBoolean((Boolean)ref);
                } else if (from == Float.class || from == Double.class) {
                    byte b = (byte)((Double)ref).doubleValue();
                    writer.putNextBoolean(ExplicitCastArguments.toBoolean(b));
                } else {
                    byte b = (byte)((Long)ref).longValue();
                    writer.putNextBoolean(ExplicitCastArguments.toBoolean(b));
                }
            } else if (to == Byte.TYPE) {
                writer.putNextByte((Byte)ref);
            } else if (to == Character.TYPE) {
                writer.putNextChar(((Character)ref).charValue());
            } else if (to == Short.TYPE) {
                writer.putNextShort((Short)ref);
            } else if (to == Integer.TYPE) {
                writer.putNextInt((Integer)ref);
            } else if (to == Long.TYPE) {
                writer.putNextLong((Long)ref);
            } else if (to == Float.TYPE) {
                writer.putNextFloat(((Float)ref).floatValue());
            } else if (to == Double.TYPE) {
                writer.putNextDouble((Double)ref);
            } else {
                ExplicitCastArguments.throwUnexpectedType(to);
            }
        }

        private static void unbox(Object ref, Class<?> from, EmulatedStackFrame.StackFrameWriter writer, Class<?> to) {
            if (ref == null) {
                ExplicitCastArguments.unboxNull(writer, to);
            } else {
                ExplicitCastArguments.unboxNonNull(ref, from, writer, to);
            }
        }

        private static void box(EmulatedStackFrame.StackFrameReader reader, Class<?> from, EmulatedStackFrame.StackFrameWriter writer, Class<?> to) {
            Comparable<Boolean> boxed = null;
            if (from == Boolean.TYPE) {
                boxed = reader.nextBoolean();
            } else if (from == Byte.TYPE) {
                boxed = reader.nextByte();
            } else if (from == Character.TYPE) {
                boxed = Character.valueOf(reader.nextChar());
            } else if (from == Short.TYPE) {
                boxed = reader.nextShort();
            } else if (from == Integer.TYPE) {
                boxed = reader.nextInt();
            } else if (from == Long.TYPE) {
                boxed = reader.nextLong();
            } else if (from == Float.TYPE) {
                boxed = Float.valueOf(reader.nextFloat());
            } else if (from == Double.TYPE) {
                boxed = reader.nextDouble();
            } else {
                ExplicitCastArguments.throwUnexpectedType(from);
            }
            writer.putNextReference(to.cast(boxed), to);
        }

        private static void explicitCast(EmulatedStackFrame.StackFrameReader reader, Class<?> from, EmulatedStackFrame.StackFrameWriter writer, Class<?> to) {
            if (from.equals(to)) {
                EmulatedStackFrame.StackFrameAccessor.copyNext(reader, writer, from);
            } else if (!from.isPrimitive()) {
                Object ref = reader.nextReference(from);
                if (to.isInterface()) {
                    writer.putNextReference(ref, to);
                } else if (!to.isPrimitive()) {
                    writer.putNextReference(to.cast(ref), to);
                } else {
                    ExplicitCastArguments.unbox(ref, from, writer, to);
                }
            } else if (to.isPrimitive()) {
                if (from == Boolean.TYPE) {
                    ExplicitCastArguments.explicitCastFromBoolean(reader.nextBoolean(), writer, to);
                } else if (to == Boolean.TYPE) {
                    ExplicitCastArguments.explicitCastToBoolean(reader, from, writer);
                } else {
                    ExplicitCastArguments.explicitCastPrimitives(reader, from, writer, to);
                }
            } else {
                ExplicitCastArguments.box(reader, from, writer, to);
            }
        }
    }

    static class InsertArguments
    extends Transformer {
        private final MethodHandle target;
        private final int pos;
        private final Object[] values;
        private final EmulatedStackFrame.Range range1;
        private final EmulatedStackFrame.Range range2;

        InsertArguments(MethodHandle target, int pos, Object[] values) {
            super(target.type().dropParameterTypes(pos, pos + values.length));
            this.target = target;
            this.pos = pos;
            this.values = values;
            MethodType type = this.type();
            this.range1 = EmulatedStackFrame.Range.of(type, 0, pos);
            this.range2 = EmulatedStackFrame.Range.of(type, pos, type.parameterCount());
        }

        @Override
        public void transform(EmulatedStackFrame stackFrame) throws Throwable {
            EmulatedStackFrame calleeFrame = EmulatedStackFrame.create(this.target.type());
            stackFrame.copyRangeTo(calleeFrame, this.range1, 0, 0);
            EmulatedStackFrame.StackFrameWriter writer = new EmulatedStackFrame.StackFrameWriter();
            writer.attach(calleeFrame, this.pos, this.range1.numReferences, this.range1.numBytes);
            int referencesCopied = 0;
            int bytesCopied = 0;
            Class<?>[] ptypes = this.target.type().ptypes();
            for (int i = 0; i < this.values.length; ++i) {
                Class<?> ptype = ptypes[i + this.pos];
                if (ptype.isPrimitive()) {
                    if (ptype == Boolean.TYPE) {
                        writer.putNextBoolean((Boolean)this.values[i]);
                    } else if (ptype == Byte.TYPE) {
                        writer.putNextByte((Byte)this.values[i]);
                    } else if (ptype == Character.TYPE) {
                        writer.putNextChar(((Character)this.values[i]).charValue());
                    } else if (ptype == Short.TYPE) {
                        writer.putNextShort((Short)this.values[i]);
                    } else if (ptype == Integer.TYPE) {
                        writer.putNextInt((Integer)this.values[i]);
                    } else if (ptype == Long.TYPE) {
                        writer.putNextLong((Long)this.values[i]);
                    } else if (ptype == Float.TYPE) {
                        writer.putNextFloat(((Float)this.values[i]).floatValue());
                    } else if (ptype == Double.TYPE) {
                        writer.putNextDouble((Double)this.values[i]);
                    }
                    bytesCopied += EmulatedStackFrame.getSize(ptype);
                    continue;
                }
                writer.putNextReference(this.values[i], ptype);
                ++referencesCopied;
            }
            if (this.range2 != null) {
                stackFrame.copyRangeTo(calleeFrame, this.range2, this.range1.numReferences + referencesCopied, this.range1.numBytes + bytesCopied);
            }
            this.target.invoke(calleeFrame);
            calleeFrame.copyReturnValueTo(stackFrame);
        }
    }

    static class FoldArguments
    extends Transformer {
        private final MethodHandle target;
        private final MethodHandle combiner;
        private final EmulatedStackFrame.Range combinerArgs;
        private final EmulatedStackFrame.Range targetArgs;
        private final int referencesOffset;
        private final int stackFrameOffset;

        FoldArguments(MethodHandle target, MethodHandle combiner) {
            super(FoldArguments.deriveType(target, combiner));
            this.target = target;
            this.combiner = combiner;
            this.combinerArgs = EmulatedStackFrame.Range.all(combiner.type());
            this.targetArgs = EmulatedStackFrame.Range.all(this.type());
            Class<?> combinerRType = combiner.type().rtype();
            if (combinerRType == Void.TYPE) {
                this.stackFrameOffset = 0;
                this.referencesOffset = 0;
            } else if (combinerRType.isPrimitive()) {
                this.stackFrameOffset = EmulatedStackFrame.getSize(combinerRType);
                this.referencesOffset = 0;
            } else {
                this.stackFrameOffset = 0;
                this.referencesOffset = 1;
            }
        }

        @Override
        public void transform(EmulatedStackFrame stackFrame) throws Throwable {
            EmulatedStackFrame combinerFrame = EmulatedStackFrame.create(this.combiner.type());
            stackFrame.copyRangeTo(combinerFrame, this.combinerArgs, 0, 0);
            this.combiner.invoke(combinerFrame);
            EmulatedStackFrame targetFrame = EmulatedStackFrame.create(this.target.type());
            if (this.referencesOffset != 0 || this.stackFrameOffset != 0) {
                EmulatedStackFrame.StackFrameReader reader = new EmulatedStackFrame.StackFrameReader();
                reader.attach(combinerFrame).makeReturnValueAccessor();
                EmulatedStackFrame.StackFrameWriter writer = new EmulatedStackFrame.StackFrameWriter();
                writer.attach(targetFrame);
                EmulatedStackFrame.StackFrameAccessor.copyNext(reader, writer, this.target.type().ptypes()[0]);
            }
            stackFrame.copyRangeTo(targetFrame, this.targetArgs, this.referencesOffset, this.stackFrameOffset);
            this.target.invoke(targetFrame);
            targetFrame.copyReturnValueTo(stackFrame);
        }

        private static MethodType deriveType(MethodHandle target, MethodHandle combiner) {
            if (combiner.type().rtype() == Void.TYPE) {
                return target.type();
            }
            return target.type().dropParameterTypes(0, 1);
        }
    }

    static class CollectArguments
    extends Transformer {
        private final MethodHandle target;
        private final MethodHandle collector;
        private final int pos;
        private final EmulatedStackFrame.Range collectorRange;
        private final EmulatedStackFrame.Range range1;
        private final EmulatedStackFrame.Range range2;
        private final int referencesOffset;
        private final int stackFrameOffset;

        CollectArguments(MethodHandle target, MethodHandle collector, int pos, MethodType adapterType) {
            super(adapterType);
            this.target = target;
            this.collector = collector;
            this.pos = pos;
            int numFilterArgs = collector.type().parameterCount();
            int numAdapterArgs = this.type().parameterCount();
            this.collectorRange = EmulatedStackFrame.Range.of(this.type(), pos, pos + numFilterArgs);
            this.range1 = EmulatedStackFrame.Range.of(this.type(), 0, pos);
            this.range2 = pos + numFilterArgs < numAdapterArgs ? EmulatedStackFrame.Range.of(this.type(), pos + numFilterArgs, numAdapterArgs) : null;
            Class<?> collectorRType = collector.type().rtype();
            if (collectorRType == Void.TYPE) {
                this.stackFrameOffset = 0;
                this.referencesOffset = 0;
            } else if (collectorRType.isPrimitive()) {
                this.stackFrameOffset = EmulatedStackFrame.getSize(collectorRType);
                this.referencesOffset = 0;
            } else {
                this.stackFrameOffset = 0;
                this.referencesOffset = 1;
            }
        }

        @Override
        public void transform(EmulatedStackFrame stackFrame) throws Throwable {
            EmulatedStackFrame filterFrame = EmulatedStackFrame.create(this.collector.type());
            stackFrame.copyRangeTo(filterFrame, this.collectorRange, 0, 0);
            this.collector.invoke(filterFrame);
            EmulatedStackFrame targetFrame = EmulatedStackFrame.create(this.target.type());
            stackFrame.copyRangeTo(targetFrame, this.range1, 0, 0);
            if (this.referencesOffset != 0 || this.stackFrameOffset != 0) {
                EmulatedStackFrame.StackFrameReader reader = new EmulatedStackFrame.StackFrameReader();
                reader.attach(filterFrame).makeReturnValueAccessor();
                EmulatedStackFrame.StackFrameWriter writer = new EmulatedStackFrame.StackFrameWriter();
                writer.attach(targetFrame, this.pos, this.range1.numReferences, this.range1.numBytes);
                EmulatedStackFrame.StackFrameAccessor.copyNext(reader, writer, this.target.type().ptypes()[0]);
            }
            if (this.range2 != null) {
                stackFrame.copyRangeTo(targetFrame, this.range2, this.range1.numReferences + this.referencesOffset, this.range2.numBytes + this.stackFrameOffset);
            }
            this.target.invoke(targetFrame);
            targetFrame.copyReturnValueTo(stackFrame);
        }
    }

    static class FilterArguments
    extends Transformer {
        private final MethodHandle target;
        private final int pos;
        private final MethodHandle[] filters;

        FilterArguments(MethodHandle target, int pos, MethodHandle[] filters) {
            super(FilterArguments.deriveType(target, pos, filters));
            this.target = target;
            this.pos = pos;
            this.filters = filters;
        }

        private static MethodType deriveType(MethodHandle target, int pos, MethodHandle[] filters) {
            Class[] filterArgs = new Class[filters.length];
            for (int i = 0; i < filters.length; ++i) {
                filterArgs[i] = filters[i].type().parameterType(0);
            }
            return target.type().replaceParameterTypes(pos, pos + filters.length, filterArgs);
        }

        @Override
        public void transform(EmulatedStackFrame stackFrame) throws Throwable {
            EmulatedStackFrame.StackFrameReader reader = new EmulatedStackFrame.StackFrameReader();
            reader.attach(stackFrame);
            EmulatedStackFrame transformedFrame = EmulatedStackFrame.create(this.target.type());
            EmulatedStackFrame.StackFrameWriter writer = new EmulatedStackFrame.StackFrameWriter();
            writer.attach(transformedFrame);
            Class<?>[] ptypes = this.target.type().ptypes();
            for (int i = 0; i < ptypes.length; ++i) {
                Class<?> ptype = ptypes[i];
                Object filter = i < this.pos ? null : (i >= this.pos + this.filters.length ? null : this.filters[i - this.pos]);
                if (filter != null) {
                    EmulatedStackFrame filterFrame = EmulatedStackFrame.create(((MethodHandle)filter).type());
                    EmulatedStackFrame.StackFrameWriter filterWriter = new EmulatedStackFrame.StackFrameWriter();
                    filterWriter.attach(filterFrame);
                    EmulatedStackFrame.StackFrameAccessor.copyNext(reader, filterWriter, ((MethodHandle)filter).type().ptypes()[0]);
                    filter.invoke(filterFrame);
                    EmulatedStackFrame.StackFrameReader filterReader = new EmulatedStackFrame.StackFrameReader();
                    filterReader.attach(filterFrame);
                    filterReader.makeReturnValueAccessor();
                    EmulatedStackFrame.StackFrameAccessor.copyNext(filterReader, writer, ptype);
                    continue;
                }
                EmulatedStackFrame.StackFrameAccessor.copyNext(reader, writer, ptype);
            }
            this.target.invoke(transformedFrame);
            transformedFrame.copyReturnValueTo(stackFrame);
        }
    }

    static class Collector
    extends Transformer {
        private final MethodHandle target;
        private final int arrayOffset;
        private final int numArrayArgs;
        private final char arrayTypeChar;
        private final EmulatedStackFrame.Range copyRange;

        Collector(MethodHandle delegate, Class<?> arrayType, int length) {
            super(delegate.type().asCollectorType(arrayType, length));
            this.target = delegate;
            this.arrayOffset = delegate.type().parameterCount() - 1;
            this.arrayTypeChar = Wrapper.basicTypeChar(arrayType.getComponentType());
            this.numArrayArgs = length;
            this.copyRange = EmulatedStackFrame.Range.of(delegate.type(), 0, this.arrayOffset);
        }

        @Override
        public void transform(EmulatedStackFrame callerFrame) throws Throwable {
            EmulatedStackFrame targetFrame = EmulatedStackFrame.create(this.target.type());
            callerFrame.copyRangeTo(targetFrame, this.copyRange, 0, 0);
            EmulatedStackFrame.StackFrameWriter writer = new EmulatedStackFrame.StackFrameWriter();
            writer.attach(targetFrame, this.arrayOffset, this.copyRange.numReferences, this.copyRange.numBytes);
            EmulatedStackFrame.StackFrameReader reader = new EmulatedStackFrame.StackFrameReader();
            reader.attach(callerFrame, this.arrayOffset, this.copyRange.numReferences, this.copyRange.numBytes);
            switch (this.arrayTypeChar) {
                case 'L': {
                    Class<?> targetType = this.target.type().ptypes()[this.arrayOffset];
                    Class<?> targetComponentType = targetType.getComponentType();
                    Class<?> adapterComponentType = this.type().lastParameterType();
                    Object[] arr = (Object[])Array.newInstance(targetComponentType, this.numArrayArgs);
                    for (int i = 0; i < this.numArrayArgs; ++i) {
                        arr[i] = reader.nextReference(adapterComponentType);
                    }
                    writer.putNextReference(arr, targetType);
                    break;
                }
                case 'I': {
                    int[] array = new int[this.numArrayArgs];
                    for (int i = 0; i < this.numArrayArgs; ++i) {
                        array[i] = reader.nextInt();
                    }
                    writer.putNextReference(array, int[].class);
                    break;
                }
                case 'J': {
                    long[] array = new long[this.numArrayArgs];
                    for (int i = 0; i < this.numArrayArgs; ++i) {
                        array[i] = reader.nextLong();
                    }
                    writer.putNextReference(array, long[].class);
                    break;
                }
                case 'B': {
                    byte[] array = new byte[this.numArrayArgs];
                    for (int i = 0; i < this.numArrayArgs; ++i) {
                        array[i] = reader.nextByte();
                    }
                    writer.putNextReference(array, byte[].class);
                    break;
                }
                case 'S': {
                    short[] array = new short[this.numArrayArgs];
                    for (int i = 0; i < this.numArrayArgs; ++i) {
                        array[i] = reader.nextShort();
                    }
                    writer.putNextReference(array, short[].class);
                    break;
                }
                case 'C': {
                    char[] array = new char[this.numArrayArgs];
                    for (int i = 0; i < this.numArrayArgs; ++i) {
                        array[i] = reader.nextChar();
                    }
                    writer.putNextReference(array, char[].class);
                    break;
                }
                case 'Z': {
                    boolean[] array = new boolean[this.numArrayArgs];
                    for (int i = 0; i < this.numArrayArgs; ++i) {
                        array[i] = reader.nextBoolean();
                    }
                    writer.putNextReference(array, boolean[].class);
                    break;
                }
                case 'F': {
                    float[] array = new float[this.numArrayArgs];
                    for (int i = 0; i < this.numArrayArgs; ++i) {
                        array[i] = reader.nextFloat();
                    }
                    writer.putNextReference(array, float[].class);
                    break;
                }
                case 'D': {
                    double[] array = new double[this.numArrayArgs];
                    for (int i = 0; i < this.numArrayArgs; ++i) {
                        array[i] = reader.nextDouble();
                    }
                    writer.putNextReference(array, double[].class);
                    break;
                }
            }
            this.target.invoke(targetFrame);
            targetFrame.copyReturnValueTo(callerFrame);
        }
    }

    static class Spreader
    extends Transformer {
        private final MethodHandle target;
        private final int arrayOffset;
        private final char arrayTypeChar;
        private final int numArrayArgs;
        private final EmulatedStackFrame.Range copyRange;

        Spreader(MethodHandle target, MethodType spreaderType, int numArrayArgs) {
            super(spreaderType);
            this.target = target;
            this.arrayOffset = spreaderType.parameterCount() - 1;
            Class<?> componentType = spreaderType.ptypes()[this.arrayOffset].getComponentType();
            if (componentType == null) {
                throw new AssertionError((Object)"Trailing argument must be an array.");
            }
            this.arrayTypeChar = Wrapper.basicTypeChar(componentType);
            this.numArrayArgs = numArrayArgs;
            this.copyRange = EmulatedStackFrame.Range.of(spreaderType, 0, this.arrayOffset);
        }

        @Override
        public void transform(EmulatedStackFrame callerFrame) throws Throwable {
            EmulatedStackFrame targetFrame = EmulatedStackFrame.create(this.target.type());
            callerFrame.copyRangeTo(targetFrame, this.copyRange, 0, 0);
            EmulatedStackFrame.StackFrameWriter writer = new EmulatedStackFrame.StackFrameWriter();
            writer.attach(targetFrame, this.arrayOffset, this.copyRange.numReferences, this.copyRange.numBytes);
            Object arrayObj = callerFrame.getReference(this.copyRange.numReferences, this.type().ptypes()[this.arrayOffset]);
            int arrayLength = Array.getLength(arrayObj);
            if (arrayLength != this.numArrayArgs) {
                throw new IllegalArgumentException("Invalid array length: " + arrayLength);
            }
            MethodType type = this.target.type();
            switch (this.arrayTypeChar) {
                case 'L': {
                    Spreader.spreadArray((Object[])arrayObj, writer, type, this.numArrayArgs, this.arrayOffset);
                    break;
                }
                case 'I': {
                    Spreader.spreadArray((int[])arrayObj, writer, type, this.numArrayArgs, this.arrayOffset);
                    break;
                }
                case 'J': {
                    Spreader.spreadArray((long[])arrayObj, writer, type, this.numArrayArgs, this.arrayOffset);
                    break;
                }
                case 'B': {
                    Spreader.spreadArray((byte[])arrayObj, writer, type, this.numArrayArgs, this.arrayOffset);
                    break;
                }
                case 'S': {
                    Spreader.spreadArray((short[])arrayObj, writer, type, this.numArrayArgs, this.arrayOffset);
                    break;
                }
                case 'C': {
                    Spreader.spreadArray((char[])arrayObj, writer, type, this.numArrayArgs, this.arrayOffset);
                    break;
                }
                case 'Z': {
                    Spreader.spreadArray((boolean[])arrayObj, writer, type, this.numArrayArgs, this.arrayOffset);
                    break;
                }
                case 'F': {
                    Spreader.spreadArray((float[])arrayObj, writer, type, this.numArrayArgs, this.arrayOffset);
                    break;
                }
                case 'D': {
                    Spreader.spreadArray((double[])arrayObj, writer, type, this.numArrayArgs, this.arrayOffset);
                }
            }
            this.target.invoke(targetFrame);
            targetFrame.copyReturnValueTo(callerFrame);
        }

        public static void spreadArray(Object[] array, EmulatedStackFrame.StackFrameWriter writer, MethodType type, int numArgs, int offset) {
            Class<?>[] ptypes = type.ptypes();
            block11: for (int i = 0; i < numArgs; ++i) {
                Class<?> argumentType = ptypes[i + offset];
                Object o = array[i];
                switch (Wrapper.basicTypeChar(argumentType)) {
                    case 'L': {
                        writer.putNextReference(o, argumentType);
                        continue block11;
                    }
                    case 'I': {
                        writer.putNextInt((Integer)o);
                        continue block11;
                    }
                    case 'J': {
                        writer.putNextLong((Long)o);
                        continue block11;
                    }
                    case 'B': {
                        writer.putNextByte((Byte)o);
                        continue block11;
                    }
                    case 'S': {
                        writer.putNextShort((Short)o);
                        continue block11;
                    }
                    case 'C': {
                        writer.putNextChar(((Character)o).charValue());
                        continue block11;
                    }
                    case 'Z': {
                        writer.putNextBoolean((Boolean)o);
                        continue block11;
                    }
                    case 'F': {
                        writer.putNextFloat(((Float)o).floatValue());
                        continue block11;
                    }
                    case 'D': {
                        writer.putNextDouble((Double)o);
                    }
                }
            }
        }

        public static void spreadArray(int[] array, EmulatedStackFrame.StackFrameWriter writer, MethodType type, int numArgs, int offset) {
            Class<?>[] ptypes = type.ptypes();
            block7: for (int i = 0; i < numArgs; ++i) {
                Class<?> argumentType = ptypes[i + offset];
                int j = array[i];
                switch (Wrapper.basicTypeChar(argumentType)) {
                    case 'L': {
                        writer.putNextReference(j, argumentType);
                        continue block7;
                    }
                    case 'I': {
                        writer.putNextInt(j);
                        continue block7;
                    }
                    case 'J': {
                        writer.putNextLong(j);
                        continue block7;
                    }
                    case 'F': {
                        writer.putNextFloat(j);
                        continue block7;
                    }
                    case 'D': {
                        writer.putNextDouble(j);
                        continue block7;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
            }
        }

        public static void spreadArray(long[] array, EmulatedStackFrame.StackFrameWriter writer, MethodType type, int numArgs, int offset) {
            Class<?>[] ptypes = type.ptypes();
            block6: for (int i = 0; i < numArgs; ++i) {
                Class<?> argumentType = ptypes[i + offset];
                long l = array[i];
                switch (Wrapper.basicTypeChar(argumentType)) {
                    case 'L': {
                        writer.putNextReference(l, argumentType);
                        continue block6;
                    }
                    case 'J': {
                        writer.putNextLong(l);
                        continue block6;
                    }
                    case 'F': {
                        writer.putNextFloat(l);
                        continue block6;
                    }
                    case 'D': {
                        writer.putNextDouble(l);
                        continue block6;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
            }
        }

        public static void spreadArray(byte[] array, EmulatedStackFrame.StackFrameWriter writer, MethodType type, int numArgs, int offset) {
            Class<?>[] ptypes = type.ptypes();
            block9: for (int i = 0; i < numArgs; ++i) {
                Class<?> argumentType = ptypes[i + offset];
                byte b = array[i];
                switch (Wrapper.basicTypeChar(argumentType)) {
                    case 'L': {
                        writer.putNextReference(b, argumentType);
                        continue block9;
                    }
                    case 'I': {
                        writer.putNextInt(b);
                        continue block9;
                    }
                    case 'J': {
                        writer.putNextLong(b);
                        continue block9;
                    }
                    case 'B': {
                        writer.putNextByte(b);
                        continue block9;
                    }
                    case 'S': {
                        writer.putNextShort(b);
                        continue block9;
                    }
                    case 'F': {
                        writer.putNextFloat(b);
                        continue block9;
                    }
                    case 'D': {
                        writer.putNextDouble(b);
                        continue block9;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
            }
        }

        public static void spreadArray(short[] array, EmulatedStackFrame.StackFrameWriter writer, MethodType type, int numArgs, int offset) {
            Class<?>[] ptypes = type.ptypes();
            block8: for (int i = 0; i < numArgs; ++i) {
                Class<?> argumentType = ptypes[i + offset];
                short s = array[i];
                switch (Wrapper.basicTypeChar(argumentType)) {
                    case 'L': {
                        writer.putNextReference(s, argumentType);
                        continue block8;
                    }
                    case 'I': {
                        writer.putNextInt(s);
                        continue block8;
                    }
                    case 'J': {
                        writer.putNextLong(s);
                        continue block8;
                    }
                    case 'S': {
                        writer.putNextShort(s);
                        continue block8;
                    }
                    case 'F': {
                        writer.putNextFloat(s);
                        continue block8;
                    }
                    case 'D': {
                        writer.putNextDouble(s);
                        continue block8;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
            }
        }

        public static void spreadArray(char[] array, EmulatedStackFrame.StackFrameWriter writer, MethodType type, int numArgs, int offset) {
            Class<?>[] ptypes = type.ptypes();
            block8: for (int i = 0; i < numArgs; ++i) {
                Class<?> argumentType = ptypes[i + offset];
                char c = array[i];
                switch (Wrapper.basicTypeChar(argumentType)) {
                    case 'L': {
                        writer.putNextReference(Character.valueOf(c), argumentType);
                        continue block8;
                    }
                    case 'I': {
                        writer.putNextInt(c);
                        continue block8;
                    }
                    case 'J': {
                        writer.putNextLong(c);
                        continue block8;
                    }
                    case 'C': {
                        writer.putNextChar(c);
                        continue block8;
                    }
                    case 'F': {
                        writer.putNextFloat(c);
                        continue block8;
                    }
                    case 'D': {
                        writer.putNextDouble(c);
                        continue block8;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
            }
        }

        public static void spreadArray(boolean[] array, EmulatedStackFrame.StackFrameWriter writer, MethodType type, int numArgs, int offset) {
            Class<?>[] ptypes = type.ptypes();
            block4: for (int i = 0; i < numArgs; ++i) {
                Class<?> argumentType = ptypes[i + offset];
                boolean z = array[i];
                switch (Wrapper.basicTypeChar(argumentType)) {
                    case 'L': {
                        writer.putNextReference(z, argumentType);
                        continue block4;
                    }
                    case 'Z': {
                        writer.putNextBoolean(z);
                        continue block4;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
            }
        }

        public static void spreadArray(double[] array, EmulatedStackFrame.StackFrameWriter writer, MethodType type, int numArgs, int offset) {
            Class<?>[] ptypes = type.ptypes();
            block4: for (int i = 0; i < numArgs; ++i) {
                Class<?> argumentType = ptypes[i + offset];
                double d = array[i];
                switch (Wrapper.basicTypeChar(argumentType)) {
                    case 'L': {
                        writer.putNextReference(d, argumentType);
                        continue block4;
                    }
                    case 'D': {
                        writer.putNextDouble(d);
                        continue block4;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
            }
        }

        public static void spreadArray(float[] array, EmulatedStackFrame.StackFrameWriter writer, MethodType type, int numArgs, int offset) {
            Class<?>[] ptypes = type.ptypes();
            block5: for (int i = 0; i < numArgs; ++i) {
                Class<?> argumentType = ptypes[i + offset];
                float f = array[i];
                switch (Wrapper.basicTypeChar(argumentType)) {
                    case 'L': {
                        writer.putNextReference(Float.valueOf(f), argumentType);
                        continue block5;
                    }
                    case 'D': {
                        writer.putNextDouble(f);
                        continue block5;
                    }
                    case 'F': {
                        writer.putNextFloat(f);
                        continue block5;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
            }
        }
    }

    static class Invoker
    extends Transformer {
        private final MethodType targetType;
        private final boolean isExactInvoker;
        private final EmulatedStackFrame.Range copyRange;

        Invoker(MethodType targetType, boolean isExactInvoker) {
            super(targetType.insertParameterTypes(0, MethodHandle.class));
            this.targetType = targetType;
            this.isExactInvoker = isExactInvoker;
            this.copyRange = EmulatedStackFrame.Range.of(this.type(), 1, this.type().parameterCount());
        }

        @Override
        public void transform(EmulatedStackFrame emulatedStackFrame) throws Throwable {
            MethodType callType;
            if (this.isExactInvoker && !this.targetType.equals((Object)(callType = emulatedStackFrame.getCallsiteType().dropParameterTypes(0, 1)))) {
                throw new WrongMethodTypeException("Wrong type, Expected: " + this.targetType + " was: " + callType);
            }
            MethodHandle target = emulatedStackFrame.getReference(0, MethodHandle.class);
            EmulatedStackFrame targetFrame = EmulatedStackFrame.create(this.targetType);
            emulatedStackFrame.copyRangeTo(targetFrame, this.copyRange, 0, 0);
            target.invoke(targetFrame);
            targetFrame.copyReturnValueTo(emulatedStackFrame);
        }
    }

    static class VarargsCollector
    extends Transformer {
        final MethodHandle target;

        VarargsCollector(MethodHandle target) {
            super(target.type(), 6);
            if (!VarargsCollector.lastParameterTypeIsAnArray(target.type().ptypes())) {
                throw new IllegalArgumentException("target does not have array as last parameter");
            }
            this.target = target;
        }

        private static boolean lastParameterTypeIsAnArray(Class<?>[] parameterTypes) {
            if (parameterTypes.length == 0) {
                return false;
            }
            return parameterTypes[parameterTypes.length - 1].isArray();
        }

        @Override
        public boolean isVarargsCollector() {
            return true;
        }

        @Override
        public MethodHandle asFixedArity() {
            return this.target;
        }

        @Override
        public void transform(EmulatedStackFrame callerFrame) throws Throwable {
            Class<?> elementType;
            MethodType callerFrameType = callerFrame.getMethodType();
            Class<?>[] callerPTypes = callerFrameType.ptypes();
            Class<?>[] targetPTypes = this.type().ptypes();
            int lastTargetIndex = targetPTypes.length - 1;
            if (callerPTypes.length == targetPTypes.length && targetPTypes[lastTargetIndex].isAssignableFrom(callerPTypes[lastTargetIndex])) {
                this.target.invoke(callerFrame);
                return;
            }
            if (callerPTypes.length < targetPTypes.length - 1) {
                VarargsCollector.throwWrongMethodTypeException(callerFrameType, this.type());
            }
            if (!MethodType.canConvert(this.type().rtype(), callerFrameType.rtype())) {
                VarargsCollector.throwWrongMethodTypeException(callerFrameType, this.type());
            }
            if (!VarargsCollector.arityArgumentsConvertible(callerPTypes, lastTargetIndex, elementType = targetPTypes[lastTargetIndex].getComponentType())) {
                VarargsCollector.throwWrongMethodTypeException(callerFrameType, this.type());
            }
            MethodType targetFrameType = VarargsCollector.makeTargetFrameType(callerFrameType, this.type());
            EmulatedStackFrame targetFrame = EmulatedStackFrame.create(targetFrameType);
            VarargsCollector.prepareFrame(callerFrame, targetFrame);
            this.target.invoke(targetFrame);
            targetFrame.copyReturnValueTo(callerFrame);
        }

        private static void throwWrongMethodTypeException(MethodType from, MethodType to) {
            throw new WrongMethodTypeException("Cannot convert " + from + " to " + to);
        }

        private static boolean arityArgumentsConvertible(Class<?>[] ptypes, int arityStart, Class<?> elementType) {
            if (ptypes.length - 1 == arityStart && ptypes[arityStart].isArray() && ptypes[arityStart].getComponentType() == elementType) {
                return true;
            }
            for (int i = arityStart; i < ptypes.length; ++i) {
                if (MethodType.canConvert(ptypes[i], elementType)) continue;
                return false;
            }
            return true;
        }

        private static Object referenceArray(EmulatedStackFrame.StackFrameReader reader, Class<?>[] ptypes, Class<?> elementType, int offset, int length) {
            Object arityArray = Array.newInstance(elementType, length);
            for (int i = 0; i < length; ++i) {
                Class<?> argumentType = ptypes[i + offset];
                Comparable<Integer> o = null;
                switch (Wrapper.basicTypeChar(argumentType)) {
                    case 'L': {
                        o = (Comparable<Integer>)reader.nextReference(argumentType);
                        break;
                    }
                    case 'I': {
                        o = reader.nextInt();
                        break;
                    }
                    case 'J': {
                        o = reader.nextLong();
                        break;
                    }
                    case 'B': {
                        o = reader.nextByte();
                        break;
                    }
                    case 'S': {
                        o = reader.nextShort();
                        break;
                    }
                    case 'C': {
                        o = Character.valueOf(reader.nextChar());
                        break;
                    }
                    case 'Z': {
                        o = reader.nextBoolean();
                        break;
                    }
                    case 'F': {
                        o = Float.valueOf(reader.nextFloat());
                        break;
                    }
                    case 'D': {
                        o = reader.nextDouble();
                    }
                }
                Array.set(arityArray, i, elementType.cast(o));
            }
            return arityArray;
        }

        private static Object intArray(EmulatedStackFrame.StackFrameReader reader, Class<?>[] ptypes, int offset, int length) {
            int[] arityArray = new int[length];
            block5: for (int i = 0; i < length; ++i) {
                Class<?> argumentType = ptypes[i + offset];
                switch (Wrapper.basicTypeChar(argumentType)) {
                    case 'I': {
                        arityArray[i] = reader.nextInt();
                        continue block5;
                    }
                    case 'S': {
                        arityArray[i] = reader.nextShort();
                        continue block5;
                    }
                    case 'B': {
                        arityArray[i] = reader.nextByte();
                        continue block5;
                    }
                    default: {
                        arityArray[i] = (Integer)reader.nextReference(argumentType);
                    }
                }
            }
            return arityArray;
        }

        private static Object longArray(EmulatedStackFrame.StackFrameReader reader, Class<?>[] ptypes, int offset, int length) {
            long[] arityArray = new long[length];
            block6: for (int i = 0; i < length; ++i) {
                Class<?> argumentType = ptypes[i + offset];
                switch (Wrapper.basicTypeChar(argumentType)) {
                    case 'J': {
                        arityArray[i] = reader.nextLong();
                        continue block6;
                    }
                    case 'I': {
                        arityArray[i] = reader.nextInt();
                        continue block6;
                    }
                    case 'S': {
                        arityArray[i] = reader.nextShort();
                        continue block6;
                    }
                    case 'B': {
                        arityArray[i] = reader.nextByte();
                        continue block6;
                    }
                    default: {
                        arityArray[i] = (Long)reader.nextReference(argumentType);
                    }
                }
            }
            return arityArray;
        }

        private static Object byteArray(EmulatedStackFrame.StackFrameReader reader, Class<?>[] ptypes, int offset, int length) {
            byte[] arityArray = new byte[length];
            block3: for (int i = 0; i < length; ++i) {
                Class<?> argumentType = ptypes[i + offset];
                switch (Wrapper.basicTypeChar(argumentType)) {
                    case 'B': {
                        arityArray[i] = reader.nextByte();
                        continue block3;
                    }
                    default: {
                        arityArray[i] = (Byte)reader.nextReference(argumentType);
                    }
                }
            }
            return arityArray;
        }

        private static Object shortArray(EmulatedStackFrame.StackFrameReader reader, Class<?>[] ptypes, int offset, int length) {
            short[] arityArray = new short[length];
            block4: for (int i = 0; i < length; ++i) {
                Class<?> argumentType = ptypes[i + offset];
                switch (Wrapper.basicTypeChar(argumentType)) {
                    case 'S': {
                        arityArray[i] = reader.nextShort();
                        continue block4;
                    }
                    case 'B': {
                        arityArray[i] = reader.nextByte();
                        continue block4;
                    }
                    default: {
                        arityArray[i] = (Short)reader.nextReference(argumentType);
                    }
                }
            }
            return arityArray;
        }

        private static Object charArray(EmulatedStackFrame.StackFrameReader reader, Class<?>[] ptypes, int offset, int length) {
            char[] arityArray = new char[length];
            block3: for (int i = 0; i < length; ++i) {
                Class<?> argumentType = ptypes[i + offset];
                switch (Wrapper.basicTypeChar(argumentType)) {
                    case 'C': {
                        arityArray[i] = reader.nextChar();
                        continue block3;
                    }
                    default: {
                        arityArray[i] = ((Character)reader.nextReference(argumentType)).charValue();
                    }
                }
            }
            return arityArray;
        }

        private static Object booleanArray(EmulatedStackFrame.StackFrameReader reader, Class<?>[] ptypes, int offset, int length) {
            boolean[] arityArray = new boolean[length];
            block3: for (int i = 0; i < length; ++i) {
                Class<?> argumentType = ptypes[i + offset];
                switch (Wrapper.basicTypeChar(argumentType)) {
                    case 'Z': {
                        arityArray[i] = reader.nextBoolean();
                        continue block3;
                    }
                    default: {
                        arityArray[i] = (Boolean)reader.nextReference(argumentType);
                    }
                }
            }
            return arityArray;
        }

        private static Object floatArray(EmulatedStackFrame.StackFrameReader reader, Class<?>[] ptypes, int offset, int length) {
            float[] arityArray = new float[length];
            block7: for (int i = 0; i < length; ++i) {
                Class<?> argumentType = ptypes[i + offset];
                switch (Wrapper.basicTypeChar(argumentType)) {
                    case 'F': {
                        arityArray[i] = reader.nextFloat();
                        continue block7;
                    }
                    case 'J': {
                        arityArray[i] = reader.nextLong();
                        continue block7;
                    }
                    case 'I': {
                        arityArray[i] = reader.nextInt();
                        continue block7;
                    }
                    case 'S': {
                        arityArray[i] = reader.nextShort();
                        continue block7;
                    }
                    case 'B': {
                        arityArray[i] = reader.nextByte();
                        continue block7;
                    }
                    default: {
                        arityArray[i] = ((Float)reader.nextReference(argumentType)).floatValue();
                    }
                }
            }
            return arityArray;
        }

        private static Object doubleArray(EmulatedStackFrame.StackFrameReader reader, Class<?>[] ptypes, int offset, int length) {
            double[] arityArray = new double[length];
            block8: for (int i = 0; i < length; ++i) {
                Class<?> argumentType = ptypes[i + offset];
                switch (Wrapper.basicTypeChar(argumentType)) {
                    case 'D': {
                        arityArray[i] = reader.nextDouble();
                        continue block8;
                    }
                    case 'F': {
                        arityArray[i] = reader.nextFloat();
                        continue block8;
                    }
                    case 'J': {
                        arityArray[i] = reader.nextLong();
                        continue block8;
                    }
                    case 'I': {
                        arityArray[i] = reader.nextInt();
                        continue block8;
                    }
                    case 'S': {
                        arityArray[i] = reader.nextShort();
                        continue block8;
                    }
                    case 'B': {
                        arityArray[i] = reader.nextByte();
                        continue block8;
                    }
                    default: {
                        arityArray[i] = (Double)reader.nextReference(argumentType);
                    }
                }
            }
            return arityArray;
        }

        private static Object makeArityArray(MethodType callerFrameType, EmulatedStackFrame.StackFrameReader callerFrameReader, int indexOfArityArray, Class<?> arityArrayType) {
            int arityArrayLength = callerFrameType.ptypes().length - indexOfArityArray;
            Class<?> elementType = arityArrayType.getComponentType();
            Class<?>[] callerPTypes = callerFrameType.ptypes();
            char elementBasicType = Wrapper.basicTypeChar(elementType);
            switch (elementBasicType) {
                case 'L': {
                    return VarargsCollector.referenceArray(callerFrameReader, callerPTypes, elementType, indexOfArityArray, arityArrayLength);
                }
                case 'I': {
                    return VarargsCollector.intArray(callerFrameReader, callerPTypes, indexOfArityArray, arityArrayLength);
                }
                case 'J': {
                    return VarargsCollector.longArray(callerFrameReader, callerPTypes, indexOfArityArray, arityArrayLength);
                }
                case 'B': {
                    return VarargsCollector.byteArray(callerFrameReader, callerPTypes, indexOfArityArray, arityArrayLength);
                }
                case 'S': {
                    return VarargsCollector.shortArray(callerFrameReader, callerPTypes, indexOfArityArray, arityArrayLength);
                }
                case 'C': {
                    return VarargsCollector.charArray(callerFrameReader, callerPTypes, indexOfArityArray, arityArrayLength);
                }
                case 'Z': {
                    return VarargsCollector.booleanArray(callerFrameReader, callerPTypes, indexOfArityArray, arityArrayLength);
                }
                case 'F': {
                    return VarargsCollector.floatArray(callerFrameReader, callerPTypes, indexOfArityArray, arityArrayLength);
                }
                case 'D': {
                    return VarargsCollector.doubleArray(callerFrameReader, callerPTypes, indexOfArityArray, arityArrayLength);
                }
            }
            throw new InternalError("Unexpected type: " + elementType);
        }

        public static Object collectArguments(char basicComponentType, Class<?> componentType, EmulatedStackFrame.StackFrameReader reader, Class<?>[] types, int startIdx, int length) {
            switch (basicComponentType) {
                case 'L': {
                    return VarargsCollector.referenceArray(reader, types, componentType, startIdx, length);
                }
                case 'I': {
                    return VarargsCollector.intArray(reader, types, startIdx, length);
                }
                case 'J': {
                    return VarargsCollector.longArray(reader, types, startIdx, length);
                }
                case 'B': {
                    return VarargsCollector.byteArray(reader, types, startIdx, length);
                }
                case 'S': {
                    return VarargsCollector.shortArray(reader, types, startIdx, length);
                }
                case 'C': {
                    return VarargsCollector.charArray(reader, types, startIdx, length);
                }
                case 'Z': {
                    return VarargsCollector.booleanArray(reader, types, startIdx, length);
                }
                case 'F': {
                    return VarargsCollector.floatArray(reader, types, startIdx, length);
                }
                case 'D': {
                    return VarargsCollector.doubleArray(reader, types, startIdx, length);
                }
            }
            throw new InternalError("Unexpected type: " + basicComponentType);
        }

        private static void copyParameter(EmulatedStackFrame.StackFrameReader reader, EmulatedStackFrame.StackFrameWriter writer, Class<?> ptype) {
            switch (Wrapper.basicTypeChar(ptype)) {
                case 'L': {
                    writer.putNextReference(reader.nextReference(ptype), ptype);
                    break;
                }
                case 'I': {
                    writer.putNextInt(reader.nextInt());
                    break;
                }
                case 'J': {
                    writer.putNextLong(reader.nextLong());
                    break;
                }
                case 'B': {
                    writer.putNextByte(reader.nextByte());
                    break;
                }
                case 'S': {
                    writer.putNextShort(reader.nextShort());
                    break;
                }
                case 'C': {
                    writer.putNextChar(reader.nextChar());
                    break;
                }
                case 'Z': {
                    writer.putNextBoolean(reader.nextBoolean());
                    break;
                }
                case 'F': {
                    writer.putNextFloat(reader.nextFloat());
                    break;
                }
                case 'D': {
                    writer.putNextDouble(reader.nextDouble());
                    break;
                }
                default: {
                    throw new InternalError("Unexpected type: " + ptype);
                }
            }
        }

        private static void prepareFrame(EmulatedStackFrame callerFrame, EmulatedStackFrame targetFrame) {
            EmulatedStackFrame.StackFrameWriter targetWriter = new EmulatedStackFrame.StackFrameWriter();
            targetWriter.attach(targetFrame);
            EmulatedStackFrame.StackFrameReader callerReader = new EmulatedStackFrame.StackFrameReader();
            callerReader.attach(callerFrame);
            MethodType targetMethodType = targetFrame.getMethodType();
            int indexOfArityArray = targetMethodType.ptypes().length - 1;
            for (int i = 0; i < indexOfArityArray; ++i) {
                Class<?> ptype = targetMethodType.ptypes()[i];
                VarargsCollector.copyParameter(callerReader, targetWriter, ptype);
            }
            Class<?> arityArrayType = targetMethodType.ptypes()[indexOfArityArray];
            Object arityArray = VarargsCollector.makeArityArray(callerFrame.getMethodType(), callerReader, indexOfArityArray, arityArrayType);
            targetWriter.putNextReference(arityArray, arityArrayType);
        }

        private static MethodType makeTargetFrameType(MethodType callerType, MethodType targetType) {
            int ptypesLength = targetType.ptypes().length;
            Class[] ptypes = new Class[ptypesLength];
            System.arraycopy(callerType.ptypes(), 0, ptypes, 0, ptypesLength - 1);
            ptypes[ptypesLength - 1] = targetType.ptypes()[ptypesLength - 1];
            return MethodType.methodType(callerType.rtype(), ptypes);
        }
    }

    public static class PermuteArguments
    extends Transformer {
        private final MethodHandle target;
        private final int[] reorder;

        public PermuteArguments(MethodType type, MethodHandle target, int[] reorder) {
            super(type);
            this.target = target;
            this.reorder = reorder;
        }

        @Override
        public void transform(EmulatedStackFrame emulatedStackFrame) throws Throwable {
            EmulatedStackFrame.StackFrameReader reader = new EmulatedStackFrame.StackFrameReader();
            reader.attach(emulatedStackFrame);
            Object[] arguments = new Object[this.reorder.length];
            Class<?>[] ptypes = this.type().ptypes();
            for (int i = 0; i < ptypes.length; ++i) {
                Class<?> ptype = ptypes[i];
                if (!ptype.isPrimitive()) {
                    arguments[i] = reader.nextReference(ptype);
                    continue;
                }
                if (ptype == Boolean.TYPE) {
                    arguments[i] = reader.nextBoolean();
                    continue;
                }
                if (ptype == Byte.TYPE) {
                    arguments[i] = reader.nextByte();
                    continue;
                }
                if (ptype == Character.TYPE) {
                    arguments[i] = Character.valueOf(reader.nextChar());
                    continue;
                }
                if (ptype == Short.TYPE) {
                    arguments[i] = reader.nextShort();
                    continue;
                }
                if (ptype == Integer.TYPE) {
                    arguments[i] = reader.nextInt();
                    continue;
                }
                if (ptype == Long.TYPE) {
                    arguments[i] = reader.nextLong();
                    continue;
                }
                if (ptype == Float.TYPE) {
                    arguments[i] = Float.valueOf(reader.nextFloat());
                    continue;
                }
                if (ptype == Double.TYPE) {
                    arguments[i] = reader.nextDouble();
                    continue;
                }
                throw new AssertionError((Object)("Unexpected type: " + ptype));
            }
            EmulatedStackFrame calleeFrame = EmulatedStackFrame.create(this.target.type());
            EmulatedStackFrame.StackFrameWriter writer = new EmulatedStackFrame.StackFrameWriter();
            writer.attach(calleeFrame);
            for (int i = 0; i < ptypes.length; ++i) {
                int idx = this.reorder[i];
                Class<?> ptype = ptypes[idx];
                Object argument = arguments[idx];
                if (!ptype.isPrimitive()) {
                    writer.putNextReference(argument, ptype);
                    continue;
                }
                if (ptype == Boolean.TYPE) {
                    writer.putNextBoolean((Boolean)argument);
                    continue;
                }
                if (ptype == Byte.TYPE) {
                    writer.putNextByte((Byte)argument);
                    continue;
                }
                if (ptype == Character.TYPE) {
                    writer.putNextChar(((Character)argument).charValue());
                    continue;
                }
                if (ptype == Short.TYPE) {
                    writer.putNextShort((Short)argument);
                    continue;
                }
                if (ptype == Integer.TYPE) {
                    writer.putNextInt((Integer)argument);
                    continue;
                }
                if (ptype == Long.TYPE) {
                    writer.putNextLong((Long)argument);
                    continue;
                }
                if (ptype == Float.TYPE) {
                    writer.putNextFloat(((Float)argument).floatValue());
                    continue;
                }
                if (ptype == Double.TYPE) {
                    writer.putNextDouble((Double)argument);
                    continue;
                }
                throw new AssertionError((Object)("Unexpected type: " + ptype));
            }
            this.target.invoke(calleeFrame);
            calleeFrame.copyReturnValueTo(emulatedStackFrame);
        }
    }

    public static class FilterReturnValue
    extends Transformer {
        private final MethodHandle target;
        private final MethodHandle filter;
        private final EmulatedStackFrame.Range allArgs;

        public FilterReturnValue(MethodHandle target, MethodHandle filter) {
            super(MethodType.methodType(filter.type().rtype(), target.type().ptypes()));
            this.target = target;
            this.filter = filter;
            this.allArgs = EmulatedStackFrame.Range.all(this.type());
        }

        @Override
        public void transform(EmulatedStackFrame emulatedStackFrame) throws Throwable {
            EmulatedStackFrame targetFrame = EmulatedStackFrame.create(this.target.type());
            emulatedStackFrame.copyRangeTo(targetFrame, this.allArgs, 0, 0);
            this.target.invoke(targetFrame);
            EmulatedStackFrame.StackFrameReader returnValueReader = new EmulatedStackFrame.StackFrameReader();
            returnValueReader.attach(targetFrame);
            returnValueReader.makeReturnValueAccessor();
            EmulatedStackFrame filterFrame = EmulatedStackFrame.create(this.filter.type());
            EmulatedStackFrame.StackFrameWriter filterWriter = new EmulatedStackFrame.StackFrameWriter();
            filterWriter.attach(filterFrame);
            Class<?> returnType = this.target.type().rtype();
            if (!returnType.isPrimitive()) {
                filterWriter.putNextReference(returnValueReader.nextReference(returnType), returnType);
            } else if (returnType == Boolean.TYPE) {
                filterWriter.putNextBoolean(returnValueReader.nextBoolean());
            } else if (returnType == Byte.TYPE) {
                filterWriter.putNextByte(returnValueReader.nextByte());
            } else if (returnType == Character.TYPE) {
                filterWriter.putNextChar(returnValueReader.nextChar());
            } else if (returnType == Short.TYPE) {
                filterWriter.putNextShort(returnValueReader.nextShort());
            } else if (returnType == Integer.TYPE) {
                filterWriter.putNextInt(returnValueReader.nextInt());
            } else if (returnType == Long.TYPE) {
                filterWriter.putNextLong(returnValueReader.nextLong());
            } else if (returnType == Float.TYPE) {
                filterWriter.putNextFloat(returnValueReader.nextFloat());
            } else if (returnType == Double.TYPE) {
                filterWriter.putNextDouble(returnValueReader.nextDouble());
            }
            this.filter.invoke(filterFrame);
            filterFrame.copyReturnValueTo(emulatedStackFrame);
        }
    }

    public static class BindTo
    extends Transformer {
        private final MethodHandle delegate;
        private final Object receiver;
        private final EmulatedStackFrame.Range range;

        public BindTo(MethodHandle delegate, Object receiver) {
            super(delegate.type().dropParameterTypes(0, 1));
            this.delegate = delegate;
            this.receiver = receiver;
            this.range = EmulatedStackFrame.Range.all(this.type());
        }

        @Override
        public void transform(EmulatedStackFrame emulatedStackFrame) throws Throwable {
            EmulatedStackFrame stackFrame = EmulatedStackFrame.create(this.delegate.type());
            stackFrame.setReference(0, this.receiver);
            emulatedStackFrame.copyRangeTo(stackFrame, this.range, 1, 0);
            this.delegate.invoke(stackFrame);
            stackFrame.copyReturnValueTo(emulatedStackFrame);
        }
    }

    static class Construct
    extends Transformer {
        private final MethodHandle constructorHandle;
        private final EmulatedStackFrame.Range callerRange;

        Construct(MethodHandle constructorHandle, MethodType returnedType) {
            super(returnedType);
            this.constructorHandle = constructorHandle;
            this.callerRange = EmulatedStackFrame.Range.all(this.type());
        }

        MethodHandle getConstructorHandle() {
            return this.constructorHandle;
        }

        private static boolean isAbstract(Class<?> klass) {
            return (klass.getModifiers() & 0x400) == 1024;
        }

        private static void checkInstantiable(Class<?> klass) throws InstantiationException {
            if (Construct.isAbstract(klass)) {
                String s = klass.isInterface() ? "interface " : "abstract class ";
                throw new InstantiationException("Can't instantiate " + s + klass);
            }
        }

        @Override
        public void transform(EmulatedStackFrame emulatedStackFrame) throws Throwable {
            Class<?> receiverType = this.type().rtype();
            Construct.checkInstantiable(receiverType);
            Object receiver = Unsafe.getUnsafe().allocateInstance(receiverType);
            EmulatedStackFrame constructorFrame = EmulatedStackFrame.create(this.constructorHandle.type());
            constructorFrame.setReference(0, receiver);
            emulatedStackFrame.copyRangeTo(constructorFrame, this.callerRange, 1, 0);
            this.constructorHandle.invoke(constructorFrame);
            emulatedStackFrame.setReturnValueTo(receiver);
        }
    }

    public static class Constant
    extends Transformer {
        private final Class<?> type;
        private int asInt;
        private long asLong;
        private float asFloat;
        private double asDouble;
        private Object asReference;
        private char typeChar;

        public Constant(Class<?> type, Object value) {
            super(MethodType.methodType(type));
            this.type = type;
            if (!type.isPrimitive()) {
                this.asReference = value;
                this.typeChar = (char)76;
            } else if (type == Integer.TYPE) {
                this.asInt = (Integer)value;
                this.typeChar = (char)73;
            } else if (type == Character.TYPE) {
                this.asInt = ((Character)value).charValue();
                this.typeChar = (char)67;
            } else if (type == Short.TYPE) {
                this.asInt = ((Short)value).shortValue();
                this.typeChar = (char)83;
            } else if (type == Byte.TYPE) {
                this.asInt = ((Byte)value).byteValue();
                this.typeChar = (char)66;
            } else if (type == Boolean.TYPE) {
                this.asInt = (Boolean)value != false ? 1 : 0;
                this.typeChar = (char)90;
            } else if (type == Long.TYPE) {
                this.asLong = (Long)value;
                this.typeChar = (char)74;
            } else if (type == Float.TYPE) {
                this.asFloat = ((Float)value).floatValue();
                this.typeChar = (char)70;
            } else if (type == Double.TYPE) {
                this.asDouble = (Double)value;
                this.typeChar = (char)68;
            } else {
                throw new AssertionError((Object)("unknown type: " + this.typeChar));
            }
        }

        @Override
        public void transform(EmulatedStackFrame emulatedStackFrame) throws Throwable {
            EmulatedStackFrame.StackFrameWriter writer = new EmulatedStackFrame.StackFrameWriter();
            writer.attach(emulatedStackFrame);
            writer.makeReturnValueAccessor();
            switch (this.typeChar) {
                case 'L': {
                    writer.putNextReference(this.asReference, this.type);
                    break;
                }
                case 'I': {
                    writer.putNextInt(this.asInt);
                    break;
                }
                case 'C': {
                    writer.putNextChar((char)this.asInt);
                    break;
                }
                case 'S': {
                    writer.putNextShort((short)this.asInt);
                    break;
                }
                case 'B': {
                    writer.putNextByte((byte)this.asInt);
                    break;
                }
                case 'Z': {
                    writer.putNextBoolean(this.asInt == 1);
                    break;
                }
                case 'J': {
                    writer.putNextLong(this.asLong);
                    break;
                }
                case 'F': {
                    writer.putNextFloat(this.asFloat);
                    break;
                }
                case 'D': {
                    writer.putNextDouble(this.asDouble);
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unexpected typeChar: " + this.typeChar));
                }
            }
        }
    }

    public static class ReferenceIdentity
    extends Transformer {
        private final Class<?> type;

        public ReferenceIdentity(Class<?> type) {
            super(MethodType.methodType(type, type));
            this.type = type;
        }

        @Override
        public void transform(EmulatedStackFrame emulatedStackFrame) throws Throwable {
            EmulatedStackFrame.StackFrameReader reader = new EmulatedStackFrame.StackFrameReader();
            reader.attach(emulatedStackFrame);
            EmulatedStackFrame.StackFrameWriter writer = new EmulatedStackFrame.StackFrameWriter();
            writer.attach(emulatedStackFrame);
            writer.makeReturnValueAccessor();
            writer.putNextReference(reader.nextReference(this.type), this.type);
        }
    }

    public static class ReferenceArrayElementSetter
    extends Transformer {
        private final Class<?> arrayClass;

        public ReferenceArrayElementSetter(Class<?> arrayClass) {
            super(MethodType.methodType(Void.TYPE, new Class[]{arrayClass, Integer.TYPE, arrayClass.getComponentType()}));
            this.arrayClass = arrayClass;
        }

        @Override
        public void transform(EmulatedStackFrame emulatedStackFrame) throws Throwable {
            EmulatedStackFrame.StackFrameReader reader = new EmulatedStackFrame.StackFrameReader();
            reader.attach(emulatedStackFrame);
            Object[] array = (Object[])reader.nextReference(this.arrayClass);
            int index = reader.nextInt();
            Object value = reader.nextReference(this.arrayClass.getComponentType());
            array[index] = value;
        }
    }

    public static class ReferenceArrayElementGetter
    extends Transformer {
        private final Class<?> arrayClass;

        public ReferenceArrayElementGetter(Class<?> arrayClass) {
            super(MethodType.methodType(arrayClass.getComponentType(), new Class[]{arrayClass, Integer.TYPE}));
            this.arrayClass = arrayClass;
        }

        @Override
        public void transform(EmulatedStackFrame emulatedStackFrame) throws Throwable {
            EmulatedStackFrame.StackFrameReader reader = new EmulatedStackFrame.StackFrameReader();
            reader.attach(emulatedStackFrame);
            Object[] array = (Object[])reader.nextReference(this.arrayClass);
            int index = reader.nextInt();
            EmulatedStackFrame.StackFrameWriter writer = new EmulatedStackFrame.StackFrameWriter();
            writer.attach(emulatedStackFrame);
            writer.makeReturnValueAccessor();
            writer.putNextReference(array[index], this.arrayClass.getComponentType());
        }
    }

    public static class GuardWithTest
    extends Transformer {
        private final MethodHandle test;
        private final MethodHandle target;
        private final MethodHandle fallback;
        private final EmulatedStackFrame.Range testArgsRange;

        public GuardWithTest(MethodHandle test, MethodHandle target, MethodHandle fallback) {
            super(target.type());
            this.test = test;
            this.target = target;
            this.fallback = fallback;
            this.testArgsRange = EmulatedStackFrame.Range.of(target.type(), 0, test.type().parameterCount());
        }

        @Override
        public void transform(EmulatedStackFrame emulatedStackFrame) throws Throwable {
            EmulatedStackFrame testFrame = EmulatedStackFrame.create(this.test.type());
            emulatedStackFrame.copyRangeTo(testFrame, this.testArgsRange, 0, 0);
            boolean value = this.test.invoke(testFrame);
            if (value) {
                this.target.invoke(emulatedStackFrame);
            } else {
                this.fallback.invoke(emulatedStackFrame);
            }
        }
    }

    public static class CatchException
    extends Transformer {
        private final MethodHandle target;
        private final MethodHandle handler;
        private final Class<?> exType;
        private final EmulatedStackFrame.Range handlerArgsRange;

        public CatchException(MethodHandle target, MethodHandle handler, Class<?> exType) {
            super(target.type());
            this.target = target;
            this.handler = handler;
            this.exType = exType;
            this.handlerArgsRange = EmulatedStackFrame.Range.of(target.type(), 0, handler.type().parameterCount() - 1);
        }

        @Override
        public void transform(EmulatedStackFrame emulatedStackFrame) throws Throwable {
            try {
                this.target.invoke(emulatedStackFrame);
            }
            catch (Throwable th) {
                if (th.getClass() == this.exType) {
                    EmulatedStackFrame fallback = EmulatedStackFrame.create(this.handler.type());
                    fallback.setReference(0, th);
                    emulatedStackFrame.copyRangeTo(fallback, this.handlerArgsRange, 1, 0);
                    this.handler.invoke(fallback);
                    fallback.copyReturnValueTo(emulatedStackFrame);
                }
                throw th;
            }
        }
    }

    public static class DropArguments
    extends Transformer {
        private final MethodHandle delegate;
        private final EmulatedStackFrame.Range range1;
        private final EmulatedStackFrame.Range range2;

        public DropArguments(MethodType type, MethodHandle delegate, int startPos, int numDropped) {
            super(type);
            this.delegate = delegate;
            this.range1 = EmulatedStackFrame.Range.of(type, 0, startPos);
            int numArgs = type.ptypes().length;
            this.range2 = startPos + numDropped < numArgs ? EmulatedStackFrame.Range.of(type, startPos + numDropped, numArgs) : null;
        }

        @Override
        public void transform(EmulatedStackFrame emulatedStackFrame) throws Throwable {
            EmulatedStackFrame calleeFrame = EmulatedStackFrame.create(this.delegate.type());
            emulatedStackFrame.copyRangeTo(calleeFrame, this.range1, 0, 0);
            if (this.range2 != null) {
                int referencesStart = this.range1.numReferences;
                int stackFrameStart = this.range1.numBytes;
                emulatedStackFrame.copyRangeTo(calleeFrame, this.range2, referencesStart, stackFrameStart);
            }
            this.delegate.invoke(calleeFrame);
            calleeFrame.copyReturnValueTo(emulatedStackFrame);
        }
    }

    public static class AlwaysThrow
    extends Transformer {
        private final Class<? extends Throwable> exceptionType;

        public AlwaysThrow(Class<?> nominalReturnType, Class<? extends Throwable> exType) {
            super(MethodType.methodType(nominalReturnType, exType));
            this.exceptionType = exType;
        }

        @Override
        public void transform(EmulatedStackFrame emulatedStackFrame) throws Throwable {
            throw emulatedStackFrame.getReference(0, this.exceptionType);
        }
    }

    public static abstract class Transformer
    extends MethodHandle
    implements Cloneable {
        protected Transformer(MethodType type) {
            super(TRANSFORM_INTERNAL.getArtMethod(), 5, type);
        }

        protected Transformer(MethodType type, int invokeKind) {
            super(TRANSFORM_INTERNAL.getArtMethod(), invokeKind, type);
        }

        public Object clone() throws CloneNotSupportedException {
            return super.clone();
        }
    }
}

