/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.MethodHandleStatics;
import java.lang.invoke.MethodType;
import sun.invoke.util.Wrapper;

final class MethodTypeForm {
    final int[] argToSlotTable;
    final int[] slotToArgTable;
    final long argCounts;
    final long primCounts;
    final MethodType erasedType;
    final MethodType basicType;
    public static final int NO_CHANGE = 0;
    public static final int ERASE = 1;
    public static final int WRAP = 2;
    public static final int UNWRAP = 3;
    public static final int INTS = 4;
    public static final int LONGS = 5;
    public static final int RAW_RETURN = 6;

    public MethodType erasedType() {
        return this.erasedType;
    }

    public MethodType basicType() {
        return this.basicType;
    }

    private boolean assertIsBasicType() {
        assert (this.erasedType == this.basicType) : "erasedType: " + this.erasedType + " != basicType: " + this.basicType;
        return true;
    }

    protected MethodTypeForm(MethodType erasedType) {
        MethodTypeForm that;
        Class<?> rt;
        Wrapper w;
        Class<?>[] epts;
        int ptypeCount;
        this.erasedType = erasedType;
        Class<?>[] ptypes = erasedType.ptypes();
        int pslotCount = ptypeCount = ptypes.length;
        int rtypeCount = 1;
        int rslotCount = 1;
        int[] argToSlotTab = null;
        int[] slotToArgTab = null;
        int pac = 0;
        int lac = 0;
        int prc = 0;
        int lrc = 0;
        Class<?>[] bpts = epts = ptypes;
        for (int i = 0; i < epts.length; ++i) {
            Class<?> pt = epts[i];
            if (pt == Object.class) continue;
            ++pac;
            w = Wrapper.forPrimitiveType(pt);
            if (w.isDoubleWord()) {
                ++lac;
            }
            if (!w.isSubwordOrInt() || pt == Integer.TYPE) continue;
            if (bpts == epts) {
                bpts = (Class[])bpts.clone();
            }
            bpts[i] = Integer.TYPE;
        }
        pslotCount += lac;
        Class<Object> bt = rt = erasedType.returnType();
        if (rt != Object.class) {
            ++prc;
            w = Wrapper.forPrimitiveType(rt);
            if (w.isDoubleWord()) {
                ++lrc;
            }
            if (w.isSubwordOrInt() && rt != Integer.TYPE) {
                bt = Integer.TYPE;
            }
            if (rt == Void.TYPE) {
                rslotCount = 0;
                rtypeCount = 0;
            } else {
                rslotCount += lrc;
            }
        }
        if (epts != bpts || bt != rt) {
            this.basicType = MethodType.makeImpl(bt, bpts, true);
            that = this.basicType.form();
            assert (this != that);
            this.primCounts = that.primCounts;
            this.argCounts = that.argCounts;
            this.argToSlotTable = that.argToSlotTable;
            this.slotToArgTable = that.slotToArgTable;
            return;
        }
        this.basicType = erasedType;
        if (lac != 0) {
            int slot = ptypeCount + lac;
            slotToArgTab = new int[slot + 1];
            argToSlotTab = new int[1 + ptypeCount];
            argToSlotTab[0] = slot;
            for (int i = 0; i < epts.length; ++i) {
                Class<?> pt = epts[i];
                Wrapper w2 = Wrapper.forBasicType(pt);
                if (w2.isDoubleWord()) {
                    --slot;
                }
                slotToArgTab[--slot] = i + 1;
                argToSlotTab[1 + i] = slot;
            }
            assert (slot == 0);
        } else if (pac != 0) {
            assert (ptypeCount == pslotCount);
            that = MethodType.genericMethodType(ptypeCount).form();
            assert (this != that);
            slotToArgTab = that.slotToArgTable;
            argToSlotTab = that.argToSlotTable;
        } else {
            int slot = ptypeCount;
            slotToArgTab = new int[slot + 1];
            argToSlotTab = new int[1 + ptypeCount];
            argToSlotTab[0] = slot;
            for (int i = 0; i < ptypeCount; ++i) {
                slotToArgTab[--slot] = i + 1;
                argToSlotTab[1 + i] = slot;
            }
        }
        this.primCounts = MethodTypeForm.pack(lrc, prc, lac, pac);
        this.argCounts = MethodTypeForm.pack(rslotCount, rtypeCount, pslotCount, ptypeCount);
        this.argToSlotTable = argToSlotTab;
        this.slotToArgTable = slotToArgTab;
        if (pslotCount >= 256) {
            throw MethodHandleStatics.newIllegalArgumentException("too many arguments");
        }
        assert (this.basicType == erasedType);
    }

    private static long pack(int a, int b, int c, int d) {
        assert (((a | b | c | d) & 0xFFFF0000) == 0);
        long hw = a << 16 | b;
        long lw = c << 16 | d;
        return hw << 32 | lw;
    }

    private static char unpack(long packed, int word) {
        assert (word <= 3);
        return (char)(packed >> (3 - word) * 16);
    }

    public int parameterCount() {
        return MethodTypeForm.unpack(this.argCounts, 3);
    }

    public int parameterSlotCount() {
        return MethodTypeForm.unpack(this.argCounts, 2);
    }

    public int returnCount() {
        return MethodTypeForm.unpack(this.argCounts, 1);
    }

    public int returnSlotCount() {
        return MethodTypeForm.unpack(this.argCounts, 0);
    }

    public int primitiveParameterCount() {
        return MethodTypeForm.unpack(this.primCounts, 3);
    }

    public int longPrimitiveParameterCount() {
        return MethodTypeForm.unpack(this.primCounts, 2);
    }

    public int primitiveReturnCount() {
        return MethodTypeForm.unpack(this.primCounts, 1);
    }

    public int longPrimitiveReturnCount() {
        return MethodTypeForm.unpack(this.primCounts, 0);
    }

    public boolean hasPrimitives() {
        return this.primCounts != 0L;
    }

    public boolean hasNonVoidPrimitives() {
        if (this.primCounts == 0L) {
            return false;
        }
        if (this.primitiveParameterCount() != 0) {
            return true;
        }
        return this.primitiveReturnCount() != 0 && this.returnCount() != 0;
    }

    public boolean hasLongPrimitives() {
        return (this.longPrimitiveParameterCount() | this.longPrimitiveReturnCount()) != 0;
    }

    public int parameterToArgSlot(int i) {
        return this.argToSlotTable[1 + i];
    }

    public int argSlotToParameter(int argSlot) {
        return this.slotToArgTable[argSlot] - 1;
    }

    static MethodTypeForm findForm(MethodType mt) {
        MethodType erased = MethodTypeForm.canonicalize(mt, 1, 1);
        if (erased == null) {
            return new MethodTypeForm(mt);
        }
        return erased.form();
    }

    public static MethodType canonicalize(MethodType mt, int howRet, int howArgs) {
        Class<?>[] ptypes = mt.ptypes();
        Class<?>[] ptc = MethodTypeForm.canonicalizeAll(ptypes, howArgs);
        Class<?> rtype = mt.returnType();
        Class<?> rtc = MethodTypeForm.canonicalize(rtype, howRet);
        if (ptc == null && rtc == null) {
            return null;
        }
        if (rtc == null) {
            rtc = rtype;
        }
        if (ptc == null) {
            ptc = ptypes;
        }
        return MethodType.makeImpl(rtc, ptc, true);
    }

    static Class<?> canonicalize(Class<?> t, int how) {
        if (t != Object.class) {
            if (!t.isPrimitive()) {
                switch (how) {
                    case 3: {
                        Class<?> ct = Wrapper.asPrimitiveType(t);
                        if (ct == t) break;
                        return ct;
                    }
                    case 1: 
                    case 6: {
                        return Object.class;
                    }
                }
            } else if (t == Void.TYPE) {
                switch (how) {
                    case 6: {
                        return Integer.TYPE;
                    }
                    case 2: {
                        return Void.class;
                    }
                }
            } else {
                switch (how) {
                    case 2: {
                        return Wrapper.asWrapperType(t);
                    }
                    case 4: {
                        if (t == Integer.TYPE || t == Long.TYPE) {
                            return null;
                        }
                        if (t == Double.TYPE) {
                            return Long.TYPE;
                        }
                        return Integer.TYPE;
                    }
                    case 5: {
                        if (t == Long.TYPE) {
                            return null;
                        }
                        return Long.TYPE;
                    }
                    case 6: {
                        if (t == Integer.TYPE || t == Long.TYPE || t == Float.TYPE || t == Double.TYPE) {
                            return null;
                        }
                        return Integer.TYPE;
                    }
                }
            }
        }
        return null;
    }

    static Class<?>[] canonicalizeAll(Class<?>[] ts, int how) {
        Class[] cs = null;
        int imax = ts.length;
        for (int i = 0; i < imax; ++i) {
            Class<?> c = MethodTypeForm.canonicalize(ts[i], how);
            if (c == Void.TYPE) {
                c = null;
            }
            if (c == null) continue;
            if (cs == null) {
                cs = (Class[])ts.clone();
            }
            cs[i] = c;
        }
        return cs;
    }

    public String toString() {
        return "Form" + this.erasedType;
    }
}

