/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import dalvik.system.VMStack;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandleImpl;
import java.lang.invoke.MethodHandleInfo;
import java.lang.invoke.MethodHandleStatics;
import java.lang.invoke.MethodType;
import java.lang.invoke.Transformers;
import java.lang.invoke.VarHandle;
import java.lang.invoke.WrongMethodTypeException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import sun.invoke.util.VerifyAccess;
import sun.invoke.util.Wrapper;

public class MethodHandles {
    private MethodHandles() {
    }

    public static Lookup lookup() {
        return new Lookup(VMStack.getStackClass1());
    }

    public static Lookup publicLookup() {
        return Lookup.PUBLIC_LOOKUP;
    }

    public static <T extends Member> T reflectAs(Class<T> expected, MethodHandle target) {
        MethodHandleImpl directTarget = MethodHandles.getMethodHandleImpl(target);
        return (T)((Member)expected.cast(directTarget.getMemberInternal()));
    }

    private static MethodHandleImpl getMethodHandleImpl(MethodHandle target) {
        if (target instanceof Transformers.Construct) {
            target = ((Transformers.Construct)target).getConstructorHandle();
        }
        if (target instanceof Transformers.VarargsCollector) {
            target = target.asFixedArity();
        }
        if (target instanceof MethodHandleImpl) {
            return (MethodHandleImpl)target;
        }
        throw new IllegalArgumentException(target + " is not a direct handle");
    }

    public static MethodHandle arrayElementGetter(Class<?> arrayClass) throws IllegalArgumentException {
        Class<?> componentType = arrayClass.getComponentType();
        if (componentType == null) {
            throw new IllegalArgumentException("Not an array type: " + arrayClass);
        }
        if (componentType.isPrimitive()) {
            try {
                return Lookup.PUBLIC_LOOKUP.findStatic(MethodHandles.class, "arrayElementGetter", MethodType.methodType(componentType, arrayClass, Integer.TYPE));
            }
            catch (IllegalAccessException | NoSuchMethodException exception) {
                throw new AssertionError((Object)exception);
            }
        }
        return new Transformers.ReferenceArrayElementGetter(arrayClass);
    }

    public static byte arrayElementGetter(byte[] array, int i) {
        return array[i];
    }

    public static boolean arrayElementGetter(boolean[] array, int i) {
        return array[i];
    }

    public static char arrayElementGetter(char[] array, int i) {
        return array[i];
    }

    public static short arrayElementGetter(short[] array, int i) {
        return array[i];
    }

    public static int arrayElementGetter(int[] array, int i) {
        return array[i];
    }

    public static long arrayElementGetter(long[] array, int i) {
        return array[i];
    }

    public static float arrayElementGetter(float[] array, int i) {
        return array[i];
    }

    public static double arrayElementGetter(double[] array, int i) {
        return array[i];
    }

    public static MethodHandle arrayElementSetter(Class<?> arrayClass) throws IllegalArgumentException {
        Class<?> componentType = arrayClass.getComponentType();
        if (componentType == null) {
            throw new IllegalArgumentException("Not an array type: " + arrayClass);
        }
        if (componentType.isPrimitive()) {
            try {
                return Lookup.PUBLIC_LOOKUP.findStatic(MethodHandles.class, "arrayElementSetter", MethodType.methodType(Void.TYPE, arrayClass, Integer.TYPE, componentType));
            }
            catch (IllegalAccessException | NoSuchMethodException exception) {
                throw new AssertionError((Object)exception);
            }
        }
        return new Transformers.ReferenceArrayElementSetter(arrayClass);
    }

    public static void arrayElementSetter(byte[] array, int i, byte val) {
        array[i] = val;
    }

    public static void arrayElementSetter(boolean[] array, int i, boolean val) {
        array[i] = val;
    }

    public static void arrayElementSetter(char[] array, int i, char val) {
        array[i] = val;
    }

    public static void arrayElementSetter(short[] array, int i, short val) {
        array[i] = val;
    }

    public static void arrayElementSetter(int[] array, int i, int val) {
        array[i] = val;
    }

    public static void arrayElementSetter(long[] array, int i, long val) {
        array[i] = val;
    }

    public static void arrayElementSetter(float[] array, int i, float val) {
        array[i] = val;
    }

    public static void arrayElementSetter(double[] array, int i, double val) {
        array[i] = val;
    }

    public static MethodHandle spreadInvoker(MethodType type, int leadingArgCount) {
        if (leadingArgCount < 0 || leadingArgCount > type.parameterCount()) {
            throw MethodHandleStatics.newIllegalArgumentException("bad argument count", leadingArgCount);
        }
        MethodHandle invoker = MethodHandles.invoker(type);
        int spreadArgCount = type.parameterCount() - leadingArgCount;
        invoker = invoker.asSpreader(Object[].class, spreadArgCount);
        return invoker;
    }

    public static MethodHandle exactInvoker(MethodType type) {
        return new Transformers.Invoker(type, true);
    }

    public static MethodHandle invoker(MethodType type) {
        return new Transformers.Invoker(type, false);
    }

    private static MethodHandle methodHandleForVarHandleAccessor(VarHandle.AccessMode accessMode, MethodType type, boolean isExactInvoker) {
        Method method;
        Class<VarHandle> refc = VarHandle.class;
        try {
            method = refc.getDeclaredMethod(accessMode.methodName(), Object[].class);
        }
        catch (NoSuchMethodException e) {
            throw new InternalError("No method for AccessMode " + (Object)((Object)accessMode), e);
        }
        MethodType methodType = type.insertParameterTypes(0, VarHandle.class);
        int kind = isExactInvoker ? 8 : 7;
        return new MethodHandleImpl(method.getArtMethod(), kind, methodType);
    }

    public static MethodHandle varHandleExactInvoker(VarHandle.AccessMode accessMode, MethodType type) {
        return MethodHandles.methodHandleForVarHandleAccessor(accessMode, type, true);
    }

    public static MethodHandle varHandleInvoker(VarHandle.AccessMode accessMode, MethodType type) {
        return MethodHandles.methodHandleForVarHandleAccessor(accessMode, type, false);
    }

    public static MethodHandle explicitCastArguments(MethodHandle target, MethodType newType) {
        MethodHandles.explicitCastArgumentsChecks(target, newType);
        MethodType oldType = target.type();
        if (oldType == newType) {
            return target;
        }
        if (oldType.explicitCastEquivalentToAsType(newType)) {
            return target.asFixedArity().asType(newType);
        }
        return new Transformers.ExplicitCastArguments(target, newType);
    }

    private static void explicitCastArgumentsChecks(MethodHandle target, MethodType newType) {
        if (target.type().parameterCount() != newType.parameterCount()) {
            throw new WrongMethodTypeException("cannot explicitly cast " + target + " to " + newType);
        }
    }

    public static MethodHandle permuteArguments(MethodHandle target, MethodType newType, int ... reorder) {
        reorder = (int[])reorder.clone();
        MethodType oldType = target.type();
        MethodHandles.permuteArgumentChecks(reorder, newType, oldType);
        return new Transformers.PermuteArguments(newType, target, reorder);
    }

    private static boolean permuteArgumentChecks(int[] reorder, MethodType newType, MethodType oldType) {
        if (newType.returnType() != oldType.returnType()) {
            throw MethodHandleStatics.newIllegalArgumentException("return types do not match", oldType, newType);
        }
        if (reorder.length == oldType.parameterCount()) {
            int limit = newType.parameterCount();
            boolean bad = false;
            for (int j = 0; j < reorder.length; ++j) {
                Class<?> dst;
                int i = reorder[j];
                if (i < 0 || i >= limit) {
                    bad = true;
                    break;
                }
                Class<?> src = newType.parameterType(i);
                if (src == (dst = oldType.parameterType(j))) continue;
                throw MethodHandleStatics.newIllegalArgumentException("parameter types do not match after reorder", oldType, newType);
            }
            if (!bad) {
                return true;
            }
        }
        throw MethodHandleStatics.newIllegalArgumentException("bad reorder array: " + Arrays.toString(reorder));
    }

    public static MethodHandle constant(Class<?> type, Object value) {
        if (type.isPrimitive()) {
            if (type == Void.TYPE) {
                throw MethodHandleStatics.newIllegalArgumentException("void type");
            }
            Wrapper w = Wrapper.forPrimitiveType(type);
            value = w.convert(value, type);
        }
        return new Transformers.Constant(type, value);
    }

    public static MethodHandle identity(Class<?> type) {
        if (type == null) {
            throw new NullPointerException("type == null");
        }
        if (type.isPrimitive()) {
            try {
                return Lookup.PUBLIC_LOOKUP.findStatic(MethodHandles.class, "identity", MethodType.methodType(type, type));
            }
            catch (IllegalAccessException | NoSuchMethodException e) {
                throw new AssertionError((Object)e);
            }
        }
        return new Transformers.ReferenceIdentity(type);
    }

    public static byte identity(byte val) {
        return val;
    }

    public static boolean identity(boolean val) {
        return val;
    }

    public static char identity(char val) {
        return val;
    }

    public static short identity(short val) {
        return val;
    }

    public static int identity(int val) {
        return val;
    }

    public static long identity(long val) {
        return val;
    }

    public static float identity(float val) {
        return val;
    }

    public static double identity(double val) {
        return val;
    }

    public static MethodHandle insertArguments(MethodHandle target, int pos, Object ... values) {
        int insCount = values.length;
        Class<?>[] ptypes = MethodHandles.insertArgumentsChecks(target, insCount, pos);
        if (insCount == 0) {
            return target;
        }
        for (int i = 0; i < insCount; ++i) {
            Class<?> ptype = ptypes[pos + i];
            if (!ptype.isPrimitive()) {
                ptypes[pos + i].cast(values[i]);
                continue;
            }
            values[i] = Wrapper.forPrimitiveType(ptype).convert(values[i], ptype);
        }
        return new Transformers.InsertArguments(target, pos, values);
    }

    private static Class<?>[] insertArgumentsChecks(MethodHandle target, int insCount, int pos) throws RuntimeException {
        MethodType oldType = target.type();
        int outargs = oldType.parameterCount();
        int inargs = outargs - insCount;
        if (inargs < 0) {
            throw MethodHandleStatics.newIllegalArgumentException("too many values to insert");
        }
        if (pos < 0 || pos > inargs) {
            throw MethodHandleStatics.newIllegalArgumentException("no argument type to append");
        }
        return oldType.ptypes();
    }

    public static MethodHandle dropArguments(MethodHandle target, int pos, List<Class<?>> valueTypes) {
        valueTypes = MethodHandles.copyTypes(valueTypes);
        MethodType oldType = target.type();
        int dropped = MethodHandles.dropArgumentChecks(oldType, pos, valueTypes);
        MethodType newType = oldType.insertParameterTypes(pos, valueTypes);
        if (dropped == 0) {
            return target;
        }
        return new Transformers.DropArguments(newType, target, pos, valueTypes.size());
    }

    private static List<Class<?>> copyTypes(List<Class<?>> types) {
        Object[] a = types.toArray();
        return Arrays.asList(Arrays.copyOf(a, a.length, Class[].class));
    }

    private static int dropArgumentChecks(MethodType oldType, int pos, List<Class<?>> valueTypes) {
        int dropped = valueTypes.size();
        MethodType.checkSlotCount(dropped);
        int outargs = oldType.parameterCount();
        int inargs = outargs + dropped;
        if (pos < 0 || pos > outargs) {
            throw MethodHandleStatics.newIllegalArgumentException("no argument type to remove" + Arrays.asList(oldType, pos, valueTypes, inargs, outargs));
        }
        return dropped;
    }

    public static MethodHandle dropArguments(MethodHandle target, int pos, Class<?> ... valueTypes) {
        return MethodHandles.dropArguments(target, pos, Arrays.asList(valueTypes));
    }

    public static MethodHandle filterArguments(MethodHandle target, int pos, MethodHandle ... filters) {
        MethodHandles.filterArgumentsCheckArity(target, pos, filters);
        for (int i = 0; i < filters.length; ++i) {
            MethodHandles.filterArgumentChecks(target, i + pos, filters[i]);
        }
        return new Transformers.FilterArguments(target, pos, filters);
    }

    private static void filterArgumentsCheckArity(MethodHandle target, int pos, MethodHandle[] filters) {
        MethodType targetType = target.type();
        int maxPos = targetType.parameterCount();
        if (pos + filters.length > maxPos) {
            throw MethodHandleStatics.newIllegalArgumentException("too many filters");
        }
    }

    private static void filterArgumentChecks(MethodHandle target, int pos, MethodHandle filter) throws RuntimeException {
        MethodType targetType = target.type();
        MethodType filterType = filter.type();
        if (filterType.parameterCount() != 1 || filterType.returnType() != targetType.parameterType(pos)) {
            throw MethodHandleStatics.newIllegalArgumentException("target and filter types do not match", targetType, filterType);
        }
    }

    public static MethodHandle collectArguments(MethodHandle target, int pos, MethodHandle filter) {
        MethodType newType = MethodHandles.collectArgumentsChecks(target, pos, filter);
        return new Transformers.CollectArguments(target, filter, pos, newType);
    }

    private static MethodType collectArgumentsChecks(MethodHandle target, int pos, MethodHandle filter) throws RuntimeException {
        MethodType targetType = target.type();
        MethodType filterType = filter.type();
        Class<?> rtype = filterType.returnType();
        List<Class<?>> filterArgs = filterType.parameterList();
        if (rtype == Void.TYPE) {
            return targetType.insertParameterTypes(pos, filterArgs);
        }
        if (rtype != targetType.parameterType(pos)) {
            throw MethodHandleStatics.newIllegalArgumentException("target and filter types do not match", targetType, filterType);
        }
        return targetType.dropParameterTypes(pos, pos + 1).insertParameterTypes(pos, filterArgs);
    }

    public static MethodHandle filterReturnValue(MethodHandle target, MethodHandle filter) {
        MethodType targetType = target.type();
        MethodType filterType = filter.type();
        MethodHandles.filterReturnValueChecks(targetType, filterType);
        return new Transformers.FilterReturnValue(target, filter);
    }

    private static void filterReturnValueChecks(MethodType targetType, MethodType filterType) throws RuntimeException {
        Class<?> rtype = targetType.returnType();
        int filterValues = filterType.parameterCount();
        if (filterValues == 0 ? rtype != Void.TYPE : rtype != filterType.parameterType(0) || filterValues != 1) {
            throw MethodHandleStatics.newIllegalArgumentException("target and filter types do not match", targetType, filterType);
        }
    }

    public static MethodHandle foldArguments(MethodHandle target, MethodHandle combiner) {
        int foldPos = 0;
        MethodType targetType = target.type();
        MethodType combinerType = combiner.type();
        Class<?> rtype = MethodHandles.foldArgumentChecks(foldPos, targetType, combinerType);
        return new Transformers.FoldArguments(target, combiner);
    }

    private static Class<?> foldArgumentChecks(int foldPos, MethodType targetType, MethodType combinerType) {
        boolean ok;
        int foldArgs = combinerType.parameterCount();
        Class<?> rtype = combinerType.returnType();
        int foldVals = rtype == Void.TYPE ? 0 : 1;
        int afterInsertPos = foldPos + foldVals;
        boolean bl = ok = targetType.parameterCount() >= afterInsertPos + foldArgs;
        if (ok && !combinerType.parameterList().equals(targetType.parameterList().subList(afterInsertPos, afterInsertPos + foldArgs))) {
            ok = false;
        }
        if (ok && foldVals != 0 && combinerType.returnType() != targetType.parameterType(0)) {
            ok = false;
        }
        if (!ok) {
            throw MethodHandles.misMatchedTypes("target and combiner types", targetType, combinerType);
        }
        return rtype;
    }

    public static MethodHandle guardWithTest(MethodHandle test, MethodHandle target, MethodHandle fallback) {
        List<Class<?>> gargs;
        MethodType ftype;
        MethodType gtype = test.type();
        MethodType ttype = target.type();
        if (!ttype.equals((Object)(ftype = fallback.type()))) {
            throw MethodHandles.misMatchedTypes("target and fallback types", ttype, ftype);
        }
        if (gtype.returnType() != Boolean.TYPE) {
            throw MethodHandleStatics.newIllegalArgumentException("guard type is not a predicate " + gtype);
        }
        List<Class<?>> targs = ttype.parameterList();
        if (!targs.equals(gargs = gtype.parameterList())) {
            int tpc;
            int gpc = gargs.size();
            if (gpc >= (tpc = targs.size()) || !targs.subList(0, gpc).equals(gargs)) {
                throw MethodHandles.misMatchedTypes("target and test types", ttype, gtype);
            }
            test = MethodHandles.dropArguments(test, gpc, targs.subList(gpc, tpc));
            gtype = test.type();
        }
        return new Transformers.GuardWithTest(test, target, fallback);
    }

    static RuntimeException misMatchedTypes(String what, MethodType t1, MethodType t2) {
        return MethodHandleStatics.newIllegalArgumentException(what + " must match: " + t1 + " != " + t2);
    }

    public static MethodHandle catchException(MethodHandle target, Class<? extends Throwable> exType, MethodHandle handler) {
        int tpc;
        int hpc;
        MethodType ttype = target.type();
        MethodType htype = handler.type();
        if (htype.parameterCount() < 1 || !htype.parameterType(0).isAssignableFrom(exType)) {
            throw MethodHandleStatics.newIllegalArgumentException("handler does not accept exception type " + exType);
        }
        if (htype.returnType() != ttype.returnType()) {
            throw MethodHandles.misMatchedTypes("target and handler return types", ttype, htype);
        }
        List<Class<?>> targs = ttype.parameterList();
        List<Class<?>> hargs = htype.parameterList();
        if (!(targs.equals(hargs = hargs.subList(1, hargs.size())) || (hpc = hargs.size()) < (tpc = targs.size()) && targs.subList(0, hpc).equals(hargs))) {
            throw MethodHandles.misMatchedTypes("target and handler types", ttype, htype);
        }
        return new Transformers.CatchException(target, handler, exType);
    }

    public static MethodHandle throwException(Class<?> returnType, Class<? extends Throwable> exType) {
        if (!Throwable.class.isAssignableFrom(exType)) {
            throw new ClassCastException(exType.getName());
        }
        return new Transformers.AlwaysThrow(returnType, exType);
    }

    public static final class Lookup {
        private final Class<?> lookupClass;
        private final int allowedModes;
        public static final int PUBLIC = 1;
        public static final int PRIVATE = 2;
        public static final int PROTECTED = 4;
        public static final int PACKAGE = 8;
        private static final int ALL_MODES = 15;
        static final Lookup PUBLIC_LOOKUP = new Lookup(Object.class, 1);
        static final Lookup IMPL_LOOKUP = new Lookup(Object.class, 15);

        private static int fixmods(int mods) {
            return (mods &= 7) != 0 ? mods : 8;
        }

        public Class<?> lookupClass() {
            return this.lookupClass;
        }

        public int lookupModes() {
            return this.allowedModes & 0xF;
        }

        Lookup(Class<?> lookupClass) {
            this(lookupClass, 15);
            Lookup.checkUnprivilegedlookupClass(lookupClass, 15);
        }

        private Lookup(Class<?> lookupClass, int allowedModes) {
            this.lookupClass = lookupClass;
            this.allowedModes = allowedModes;
        }

        public Lookup in(Class<?> requestedLookupClass) {
            requestedLookupClass.getClass();
            if (requestedLookupClass == this.lookupClass) {
                return this;
            }
            int newModes = this.allowedModes & 0xB;
            if ((newModes & 8) != 0 && !VerifyAccess.isSamePackage(this.lookupClass, requestedLookupClass)) {
                newModes &= 0xFFFFFFF5;
            }
            if ((newModes & 2) != 0 && !VerifyAccess.isSamePackageMember(this.lookupClass, requestedLookupClass)) {
                newModes &= 0xFFFFFFFD;
            }
            if ((newModes & 1) != 0 && !VerifyAccess.isClassAccessible(requestedLookupClass, this.lookupClass, this.allowedModes)) {
                newModes = 0;
            }
            Lookup.checkUnprivilegedlookupClass(requestedLookupClass, newModes);
            return new Lookup(requestedLookupClass, newModes);
        }

        private static void checkUnprivilegedlookupClass(Class<?> lookupClass, int allowedModes) {
            String name = lookupClass.getName();
            if (name.startsWith("java.lang.invoke.")) {
                throw MethodHandleStatics.newIllegalArgumentException("illegal lookupClass: " + lookupClass);
            }
            if (allowedModes == 15 && lookupClass.getClassLoader() == Object.class.getClassLoader() && (name.startsWith("java.") || name.startsWith("sun.") && !name.startsWith("sun.invoke.") && !name.equals("sun.reflect.ReflectionFactory"))) {
                throw MethodHandleStatics.newIllegalArgumentException("illegal lookupClass: " + lookupClass);
            }
        }

        public String toString() {
            String cname = this.lookupClass.getName();
            switch (this.allowedModes) {
                case 0: {
                    return cname + "/noaccess";
                }
                case 1: {
                    return cname + "/public";
                }
                case 9: {
                    return cname + "/package";
                }
                case 11: {
                    return cname + "/private";
                }
                case 15: {
                    return cname;
                }
            }
            cname = cname + "/" + Integer.toHexString(this.allowedModes);
            assert (false) : cname;
            return cname;
        }

        public MethodHandle findStatic(Class<?> refc, String name, MethodType type) throws NoSuchMethodException, IllegalAccessException {
            Method method = refc.getDeclaredMethod(name, type.ptypes());
            int modifiers = method.getModifiers();
            if (!Modifier.isStatic(modifiers)) {
                throw new IllegalAccessException("Method" + method + " is not static");
            }
            this.checkReturnType(method, type);
            this.checkAccess(refc, method.getDeclaringClass(), modifiers, method.getName());
            return Lookup.createMethodHandle(method, 3, type);
        }

        private MethodHandle findVirtualForMH(String name, MethodType type) {
            if ("invoke".equals(name)) {
                return MethodHandles.invoker(type);
            }
            if ("invokeExact".equals(name)) {
                return MethodHandles.exactInvoker(type);
            }
            return null;
        }

        private static MethodHandle createMethodHandle(Method method, int handleKind, MethodType methodType) {
            MethodHandleImpl mh = new MethodHandleImpl(method.getArtMethod(), handleKind, methodType);
            if (method.isVarArgs()) {
                return new Transformers.VarargsCollector(mh);
            }
            return mh;
        }

        public MethodHandle findVirtual(Class<?> refc, String name, MethodType type) throws NoSuchMethodException, IllegalAccessException {
            MethodHandle mh;
            if (refc == MethodHandle.class && (mh = this.findVirtualForMH(name, type)) != null) {
                return mh;
            }
            Method method = refc.getInstanceMethod(name, type.ptypes());
            if (method == null) {
                try {
                    Method m = refc.getDeclaredMethod(name, type.ptypes());
                    if (Modifier.isStatic(m.getModifiers())) {
                        throw new IllegalAccessException("Method" + m + " is static");
                    }
                }
                catch (NoSuchMethodException m) {
                    // empty catch block
                }
                throw new NoSuchMethodException(name + " " + Arrays.toString(type.ptypes()));
            }
            this.checkReturnType(method, type);
            this.checkAccess(refc, method.getDeclaringClass(), method.getModifiers(), method.getName());
            MethodType handleType = type.insertParameterTypes(0, refc);
            return Lookup.createMethodHandle(method, 0, handleType);
        }

        public MethodHandle findConstructor(Class<?> refc, MethodType type) throws NoSuchMethodException, IllegalAccessException {
            if (refc.isArray()) {
                throw new NoSuchMethodException("no constructor for array class: " + refc.getName());
            }
            Constructor<?> constructor = refc.getDeclaredConstructor(type.ptypes());
            if (constructor == null) {
                throw new NoSuchMethodException("No constructor for " + constructor.getDeclaringClass() + " matching " + type);
            }
            this.checkAccess(refc, constructor.getDeclaringClass(), constructor.getModifiers(), constructor.getName());
            return this.createMethodHandleForConstructor(constructor);
        }

        private MethodHandle createMethodHandleForConstructor(Constructor constructor) {
            MethodHandle mh;
            Class refc = constructor.getDeclaringClass();
            MethodType constructorType = MethodType.methodType(refc, constructor.getParameterTypes());
            if (refc == String.class) {
                mh = new MethodHandleImpl(constructor.getArtMethod(), 2, constructorType);
            } else {
                MethodType initType = Lookup.initMethodType(constructorType);
                MethodHandleImpl initHandle = new MethodHandleImpl(constructor.getArtMethod(), 2, initType);
                mh = new Transformers.Construct(initHandle, constructorType);
            }
            if (constructor.isVarArgs()) {
                mh = new Transformers.VarargsCollector(mh);
            }
            return mh;
        }

        private static MethodType initMethodType(MethodType constructorType) {
            assert (constructorType.rtype() != Void.TYPE);
            Class[] initPtypes = new Class[constructorType.ptypes().length + 1];
            initPtypes[0] = constructorType.rtype();
            System.arraycopy(constructorType.ptypes(), 0, initPtypes, 1, constructorType.ptypes().length);
            return MethodType.methodType(Void.TYPE, initPtypes);
        }

        public MethodHandle findSpecial(Class<?> refc, String name, MethodType type, Class<?> specialCaller) throws NoSuchMethodException, IllegalAccessException {
            if (specialCaller == null) {
                throw new NullPointerException("specialCaller == null");
            }
            if (type == null) {
                throw new NullPointerException("type == null");
            }
            if (name == null) {
                throw new NullPointerException("name == null");
            }
            if (refc == null) {
                throw new NullPointerException("ref == null");
            }
            this.checkSpecialCaller(specialCaller);
            if (name.startsWith("<")) {
                throw new NoSuchMethodException(name + " is not a valid method name.");
            }
            Method method = refc.getDeclaredMethod(name, type.ptypes());
            this.checkReturnType(method, type);
            return this.findSpecial(method, type, refc, specialCaller);
        }

        private MethodHandle findSpecial(Method method, MethodType type, Class<?> refc, Class<?> specialCaller) throws IllegalAccessException {
            if (Modifier.isStatic(method.getModifiers())) {
                throw new IllegalAccessException("expected a non-static method:" + method);
            }
            if (Modifier.isPrivate(method.getModifiers())) {
                if (refc != this.lookupClass()) {
                    throw new IllegalAccessException("no private access for invokespecial : " + refc + ", from" + this);
                }
                MethodType handleType = type.insertParameterTypes(0, refc);
                return Lookup.createMethodHandle(method, 2, handleType);
            }
            if (!method.getDeclaringClass().isAssignableFrom(specialCaller)) {
                throw new IllegalAccessException(refc + "is not assignable from " + specialCaller);
            }
            MethodType handleType = type.insertParameterTypes(0, specialCaller);
            return Lookup.createMethodHandle(method, 1, handleType);
        }

        public MethodHandle findGetter(Class<?> refc, String name, Class<?> type) throws NoSuchFieldException, IllegalAccessException {
            return this.findAccessor(refc, name, type, 9);
        }

        private MethodHandle findAccessor(Class<?> refc, String name, Class<?> type, int kind) throws NoSuchFieldException, IllegalAccessException {
            Field field = refc.getDeclaredField(name);
            Class<?> fieldType = field.getType();
            if (fieldType != type) {
                throw new NoSuchFieldException("Field has wrong type: " + fieldType + " != " + type);
            }
            return this.findAccessor(field, refc, type, kind, true);
        }

        private MethodHandle findAccessor(Field field, Class<?> refc, Class<?> fieldType, int kind, boolean performAccessChecks) throws IllegalAccessException {
            MethodType methodType;
            boolean isSetterKind;
            if (!performAccessChecks) {
                this.checkAccess(refc, field.getDeclaringClass(), field.getModifiers(), field.getName());
            }
            boolean isStaticKind = kind == 11 || kind == 12;
            int modifiers = field.getModifiers();
            if (Modifier.isStatic(modifiers) != isStaticKind) {
                String reason = "Field " + field + " is " + (isStaticKind ? "not " : "") + "static";
                throw new IllegalAccessException(reason);
            }
            boolean bl = isSetterKind = kind == 10 || kind == 12;
            if (Modifier.isFinal(modifiers) && isSetterKind) {
                throw new IllegalAccessException("Field " + field + " is final");
            }
            switch (kind) {
                case 11: {
                    methodType = MethodType.methodType(fieldType);
                    break;
                }
                case 12: {
                    methodType = MethodType.methodType(Void.TYPE, fieldType);
                    break;
                }
                case 9: {
                    methodType = MethodType.methodType(fieldType, refc);
                    break;
                }
                case 10: {
                    methodType = MethodType.methodType(Void.TYPE, refc, fieldType);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid kind " + kind);
                }
            }
            return new MethodHandleImpl(field.getArtField(), kind, methodType);
        }

        public MethodHandle findSetter(Class<?> refc, String name, Class<?> type) throws NoSuchFieldException, IllegalAccessException {
            return this.findAccessor(refc, name, type, 10);
        }

        public MethodHandle findStaticGetter(Class<?> refc, String name, Class<?> type) throws NoSuchFieldException, IllegalAccessException {
            return this.findAccessor(refc, name, type, 11);
        }

        public MethodHandle findStaticSetter(Class<?> refc, String name, Class<?> type) throws NoSuchFieldException, IllegalAccessException {
            return this.findAccessor(refc, name, type, 12);
        }

        public MethodHandle bind(Object receiver, String name, MethodType type) throws NoSuchMethodException, IllegalAccessException {
            MethodHandle handle = this.findVirtual(receiver.getClass(), name, type);
            MethodHandle adapter = handle.bindTo(receiver);
            MethodType adapterType = adapter.type();
            if (handle.isVarargsCollector()) {
                adapter = adapter.asVarargsCollector(adapterType.parameterType(adapterType.parameterCount() - 1));
            }
            return adapter;
        }

        public MethodHandle unreflect(Method m) throws IllegalAccessException {
            if (m == null) {
                throw new NullPointerException("m == null");
            }
            MethodType methodType = MethodType.methodType(m.getReturnType(), m.getParameterTypes());
            if (!m.isAccessible()) {
                this.checkAccess(m.getDeclaringClass(), m.getDeclaringClass(), m.getModifiers(), m.getName());
            }
            if (Modifier.isStatic(m.getModifiers())) {
                return Lookup.createMethodHandle(m, 3, methodType);
            }
            methodType = methodType.insertParameterTypes(0, m.getDeclaringClass());
            return Lookup.createMethodHandle(m, 0, methodType);
        }

        public MethodHandle unreflectSpecial(Method m, Class<?> specialCaller) throws IllegalAccessException {
            if (m == null) {
                throw new NullPointerException("m == null");
            }
            if (specialCaller == null) {
                throw new NullPointerException("specialCaller == null");
            }
            if (!m.isAccessible()) {
                this.checkSpecialCaller(specialCaller);
            }
            MethodType methodType = MethodType.methodType(m.getReturnType(), m.getParameterTypes());
            return this.findSpecial(m, methodType, m.getDeclaringClass(), specialCaller);
        }

        public MethodHandle unreflectConstructor(Constructor<?> c) throws IllegalAccessException {
            if (c == null) {
                throw new NullPointerException("c == null");
            }
            if (!c.isAccessible()) {
                this.checkAccess(c.getDeclaringClass(), c.getDeclaringClass(), c.getModifiers(), c.getName());
            }
            return this.createMethodHandleForConstructor(c);
        }

        public MethodHandle unreflectGetter(Field f) throws IllegalAccessException {
            return this.findAccessor(f, f.getDeclaringClass(), f.getType(), Modifier.isStatic(f.getModifiers()) ? 11 : 9, f.isAccessible());
        }

        public MethodHandle unreflectSetter(Field f) throws IllegalAccessException {
            return this.findAccessor(f, f.getDeclaringClass(), f.getType(), Modifier.isStatic(f.getModifiers()) ? 12 : 10, f.isAccessible());
        }

        public MethodHandleInfo revealDirect(MethodHandle target) {
            MethodHandleImpl directTarget = MethodHandles.getMethodHandleImpl(target);
            MethodHandleInfo info = directTarget.reveal();
            try {
                this.checkAccess(this.lookupClass(), info.getDeclaringClass(), info.getModifiers(), info.getName());
            }
            catch (IllegalAccessException exception) {
                throw new IllegalArgumentException("Unable to access memeber.", exception);
            }
            return info;
        }

        private boolean hasPrivateAccess() {
            return (this.allowedModes & 2) != 0;
        }

        void checkAccess(Class<?> refc, Class<?> defc, int mods, String methName) throws IllegalAccessException {
            int allowedModes = this.allowedModes;
            if (Modifier.isProtected(mods) && defc == Object.class && "clone".equals(methName) && refc.isArray()) {
                mods ^= 5;
            }
            if (Modifier.isProtected(mods) && Modifier.isConstructor(mods)) {
                mods ^= 4;
            }
            if (Modifier.isPublic(mods) && Modifier.isPublic(refc.getModifiers()) && allowedModes != 0) {
                return;
            }
            int requestedModes = Lookup.fixmods(mods);
            if ((requestedModes & allowedModes) != 0 ? VerifyAccess.isMemberAccessible(refc, defc, mods, this.lookupClass(), allowedModes) : (requestedModes & 4) != 0 && (allowedModes & 8) != 0 && VerifyAccess.isSamePackage(defc, this.lookupClass())) {
                return;
            }
            this.throwMakeAccessException(this.accessFailedMessage(refc, defc, mods), this);
        }

        String accessFailedMessage(Class<?> refc, Class<?> defc, int mods) {
            boolean classOK;
            boolean bl = classOK = Modifier.isPublic(defc.getModifiers()) && (defc == refc || Modifier.isPublic(refc.getModifiers()));
            if (!classOK && (this.allowedModes & 8) != 0) {
                boolean bl2 = classOK = VerifyAccess.isClassAccessible(defc, this.lookupClass(), 15) && (defc == refc || VerifyAccess.isClassAccessible(refc, this.lookupClass(), 15));
            }
            if (!classOK) {
                return "class is not public";
            }
            if (Modifier.isPublic(mods)) {
                return "access to public member failed";
            }
            if (Modifier.isPrivate(mods)) {
                return "member is private";
            }
            if (Modifier.isProtected(mods)) {
                return "member is protected";
            }
            return "member is private to package";
        }

        private void checkSpecialCaller(Class<?> specialCaller) throws IllegalAccessException {
            if (!this.hasPrivateAccess() || specialCaller != this.lookupClass()) {
                throw new IllegalAccessException("no private access for invokespecial : " + specialCaller + ", from" + this);
            }
        }

        private void throwMakeAccessException(String message, Object from) throws IllegalAccessException {
            message = message + ": " + this.toString();
            if (from != null) {
                message = message + ", from " + from;
            }
            throw new IllegalAccessException(message);
        }

        private void checkReturnType(Method method, MethodType methodType) throws NoSuchMethodException {
            if (method.getReturnType() != methodType.rtype()) {
                throw new NoSuchMethodException(method.getName() + methodType);
            }
        }
    }
}

