/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.MethodHandleStatics;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.util.Objects;

public interface MethodHandleInfo {
    public static final int REF_getField = 1;
    public static final int REF_getStatic = 2;
    public static final int REF_putField = 3;
    public static final int REF_putStatic = 4;
    public static final int REF_invokeVirtual = 5;
    public static final int REF_invokeStatic = 6;
    public static final int REF_invokeSpecial = 7;
    public static final int REF_newInvokeSpecial = 8;
    public static final int REF_invokeInterface = 9;

    public int getReferenceKind();

    public Class<?> getDeclaringClass();

    public String getName();

    public MethodType getMethodType();

    public <T extends Member> T reflectAs(Class<T> var1, MethodHandles.Lookup var2);

    public int getModifiers();

    default public boolean isVarArgs() {
        if (MethodHandleInfo.refKindIsField(this.getReferenceKind())) {
            return false;
        }
        int ACC_VARARGS = 128;
        return Modifier.isTransient(this.getModifiers());
    }

    public static String referenceKindToString(int referenceKind) {
        if (!MethodHandleInfo.refKindIsValid(referenceKind)) {
            throw MethodHandleStatics.newIllegalArgumentException("invalid reference kind", referenceKind);
        }
        return MethodHandleInfo.refKindName(referenceKind);
    }

    public static String toString(int kind, Class<?> defc, String name, MethodType type) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(type);
        return String.format("%s %s.%s:%s", MethodHandleInfo.referenceKindToString(kind), defc.getName(), name, type);
    }

    public static boolean refKindIsValid(int refKind) {
        return refKind >= 1 && refKind <= 9;
    }

    public static boolean refKindIsField(int refKind) {
        return refKind <= 4;
    }

    public static String refKindName(int refKind) {
        switch (refKind) {
            case 1: {
                return "getField";
            }
            case 2: {
                return "getStatic";
            }
            case 3: {
                return "putField";
            }
            case 4: {
                return "putStatic";
            }
            case 5: {
                return "invokeVirtual";
            }
            case 6: {
                return "invokeStatic";
            }
            case 7: {
                return "invokeSpecial";
            }
            case 8: {
                return "newInvokeSpecial";
            }
            case 9: {
                return "invokeInterface";
            }
        }
        return "REF_???";
    }
}

