/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandleInfo;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;

public class MethodHandleImpl
extends MethodHandle
implements Cloneable {
    private HandleInfo info;

    MethodHandleImpl(long artFieldOrMethod, int handleKind, MethodType type) {
        super(artFieldOrMethod, handleKind, type);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    MethodHandleInfo reveal() {
        if (this.info == null) {
            Member member = this.getMemberInternal();
            this.info = new HandleInfo(member, this);
        }
        return this.info;
    }

    public native Member getMemberInternal();

    static class HandleInfo
    implements MethodHandleInfo {
        private final Member member;
        private final MethodHandle handle;

        HandleInfo(Member member, MethodHandle handle) {
            this.member = member;
            this.handle = handle;
        }

        @Override
        public int getReferenceKind() {
            switch (this.handle.getHandleKind()) {
                case 0: {
                    if (this.member.getDeclaringClass().isInterface()) {
                        return 9;
                    }
                    return 5;
                }
                case 2: {
                    if (this.member instanceof Constructor) {
                        return 8;
                    }
                    return 7;
                }
                case 1: {
                    return 7;
                }
                case 3: {
                    return 6;
                }
                case 9: {
                    return 1;
                }
                case 10: {
                    return 3;
                }
                case 11: {
                    return 2;
                }
                case 12: {
                    return 4;
                }
            }
            throw new AssertionError((Object)("Unexpected handle kind: " + this.handle.getHandleKind()));
        }

        @Override
        public Class<?> getDeclaringClass() {
            return this.member.getDeclaringClass();
        }

        @Override
        public String getName() {
            if (this.member instanceof Constructor) {
                return "<init>";
            }
            return this.member.getName();
        }

        @Override
        public MethodType getMethodType() {
            MethodType handleType = this.handle.type();
            boolean omitLeadingParam = false;
            if (this.member instanceof Constructor) {
                handleType = handleType.changeReturnType(Void.TYPE);
                omitLeadingParam = true;
            }
            switch (this.handle.getHandleKind()) {
                case 0: 
                case 1: 
                case 2: 
                case 4: 
                case 9: 
                case 10: {
                    omitLeadingParam = true;
                }
            }
            return omitLeadingParam ? handleType.dropParameterTypes(0, 1) : handleType;
        }

        @Override
        public <T extends Member> T reflectAs(Class<T> expected, MethodHandles.Lookup lookup) {
            try {
                lookup.checkAccess(this.member.getDeclaringClass(), this.member.getDeclaringClass(), this.member.getModifiers(), this.member.getName());
            }
            catch (IllegalAccessException exception) {
                throw new IllegalArgumentException("Unable to access member.", exception);
            }
            return (T)this.member;
        }

        @Override
        public int getModifiers() {
            return this.member.getModifiers();
        }
    }
}

