/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import dalvik.system.EmulatedStackFrame;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.invoke.MethodHandleStatics;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.Transformers;
import java.lang.invoke.WrongMethodTypeException;
import java.util.List;

public abstract class MethodHandle {
    private final MethodType type;
    private MethodType nominalType;
    private MethodHandle cachedSpreadInvoker;
    public static final int INVOKE_VIRTUAL = 0;
    public static final int INVOKE_SUPER = 1;
    public static final int INVOKE_DIRECT = 2;
    public static final int INVOKE_STATIC = 3;
    public static final int INVOKE_INTERFACE = 4;
    public static final int INVOKE_TRANSFORM = 5;
    public static final int INVOKE_CALLSITE_TRANSFORM = 6;
    public static final int INVOKE_VAR_HANDLE = 7;
    public static final int INVOKE_VAR_HANDLE_EXACT = 8;
    public static final int IGET = 9;
    public static final int IPUT = 10;
    public static final int SGET = 11;
    public static final int SPUT = 12;
    protected final int handleKind;
    protected final long artFieldOrMethod;

    protected MethodHandle(long artFieldOrMethod, int handleKind, MethodType type) {
        this.artFieldOrMethod = artFieldOrMethod;
        this.handleKind = handleKind;
        this.type = type;
    }

    public MethodType type() {
        if (this.nominalType != null) {
            return this.nominalType;
        }
        return this.type;
    }

    @PolymorphicSignature
    public final native Object invokeExact(Object ... var1) throws Throwable;

    @PolymorphicSignature
    public final native Object invoke(Object ... var1) throws Throwable;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invokeWithArguments(Object ... arguments) throws Throwable {
        MethodHandle invoker = null;
        MethodHandle methodHandle = this;
        synchronized (methodHandle) {
            if (this.cachedSpreadInvoker == null) {
                this.cachedSpreadInvoker = MethodHandles.spreadInvoker(this.type(), 0);
            }
            invoker = this.cachedSpreadInvoker;
        }
        return invoker.invoke(this, arguments);
    }

    public Object invokeWithArguments(List<?> arguments) throws Throwable {
        return this.invokeWithArguments(arguments.toArray());
    }

    public MethodHandle asType(MethodType newType) {
        if (newType == this.type) {
            return this;
        }
        if (!this.type.isConvertibleTo(newType)) {
            throw new WrongMethodTypeException("cannot convert " + this + " to " + newType);
        }
        MethodHandle mh = this.duplicate();
        mh.nominalType = newType;
        return mh;
    }

    public MethodHandle asSpreader(Class<?> arrayType, int arrayLength) {
        MethodType postSpreadType = this.asSpreaderChecks(arrayType, arrayLength);
        int targetParamCount = postSpreadType.parameterCount();
        MethodType dropArrayArgs = postSpreadType.dropParameterTypes(targetParamCount - arrayLength, targetParamCount);
        MethodType adapterType = dropArrayArgs.appendParameterTypes(arrayType);
        return new Transformers.Spreader(this, adapterType, arrayLength);
    }

    private MethodType asSpreaderChecks(Class<?> arrayType, int arrayLength) {
        this.spreadArrayChecks(arrayType, arrayLength);
        int nargs = this.type().parameterCount();
        if (nargs < arrayLength || arrayLength < 0) {
            throw MethodHandleStatics.newIllegalArgumentException("bad spread array length");
        }
        Class<?> arrayElement = arrayType.getComponentType();
        MethodType mtype = this.type();
        boolean match = true;
        boolean fail = false;
        for (int i = nargs - arrayLength; i < nargs; ++i) {
            Class<?> ptype = mtype.parameterType(i);
            if (ptype == arrayElement) continue;
            match = false;
            if (MethodType.canConvert(arrayElement, ptype)) continue;
            fail = true;
            break;
        }
        if (match) {
            return mtype;
        }
        MethodType needType = mtype.asSpreaderType(arrayType, arrayLength);
        if (!fail) {
            return needType;
        }
        this.asType(needType);
        throw MethodHandleStatics.newInternalError("should not return", null);
    }

    private void spreadArrayChecks(Class<?> arrayType, int arrayLength) {
        Class<?> arrayElement = arrayType.getComponentType();
        if (arrayElement == null) {
            throw MethodHandleStatics.newIllegalArgumentException("not an array type", arrayType);
        }
        if ((arrayLength & 0x7F) != arrayLength) {
            if ((arrayLength & 0xFF) != arrayLength) {
                throw MethodHandleStatics.newIllegalArgumentException("array length is not legal", arrayLength);
            }
            assert (arrayLength >= 128);
            if (arrayElement == Long.TYPE || arrayElement == Double.TYPE) {
                throw MethodHandleStatics.newIllegalArgumentException("array length is not legal for long[] or double[]", arrayLength);
            }
        }
    }

    public MethodHandle asCollector(Class<?> arrayType, int arrayLength) {
        this.asCollectorChecks(arrayType, arrayLength);
        return new Transformers.Collector(this, arrayType, arrayLength);
    }

    boolean asCollectorChecks(Class<?> arrayType, int arrayLength) {
        this.spreadArrayChecks(arrayType, arrayLength);
        int nargs = this.type().parameterCount();
        if (nargs != 0) {
            Class<?> lastParam = this.type().parameterType(nargs - 1);
            if (lastParam == arrayType) {
                return true;
            }
            if (lastParam.isAssignableFrom(arrayType)) {
                return false;
            }
        }
        throw MethodHandleStatics.newIllegalArgumentException("array type not assignable to trailing argument", this, arrayType);
    }

    public MethodHandle asVarargsCollector(Class<?> arrayType) {
        arrayType.getClass();
        boolean lastMatch = this.asCollectorChecks(arrayType, 0);
        if (this.isVarargsCollector() && lastMatch) {
            return this;
        }
        return new Transformers.VarargsCollector(this);
    }

    public boolean isVarargsCollector() {
        return false;
    }

    public MethodHandle asFixedArity() {
        MethodHandle mh = this;
        if (mh.isVarargsCollector()) {
            mh = ((Transformers.VarargsCollector)mh).asFixedArity();
        }
        assert (!mh.isVarargsCollector());
        return mh;
    }

    public MethodHandle bindTo(Object x) {
        x = this.type.leadingReferenceParameter().cast(x);
        return new Transformers.BindTo(this, x);
    }

    public String toString() {
        return "MethodHandle" + this.type;
    }

    public int getHandleKind() {
        return this.handleKind;
    }

    protected void transform(EmulatedStackFrame arguments) throws Throwable {
        throw new AssertionError((Object)"MethodHandle.transform should never be called.");
    }

    protected MethodHandle duplicate() {
        try {
            return (MethodHandle)this.clone();
        }
        catch (CloneNotSupportedException cnse) {
            throw new AssertionError((Object)"Subclass of Transformer is not cloneable");
        }
    }

    private void transformInternal(EmulatedStackFrame arguments) throws Throwable {
        this.transform(arguments);
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface PolymorphicSignature {
    }
}

