/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.ConstantCallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandleStatics;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.WrongMethodTypeException;

public abstract class CallSite {
    MethodHandle target;
    private static MethodHandle GET_TARGET = null;
    private static final long TARGET_OFFSET;

    CallSite(MethodType type) {
        this.target = MethodHandles.throwException(type.returnType(), IllegalStateException.class);
        this.target = MethodHandles.insertArguments(this.target, 0, new IllegalStateException("uninitialized call site"));
        if (type.parameterCount() > 0) {
            this.target = MethodHandles.dropArguments(this.target, 0, type.ptypes());
        }
        this.initializeGetTarget();
    }

    CallSite(MethodHandle target) {
        target.type();
        this.target = target;
        this.initializeGetTarget();
    }

    CallSite(MethodType targetType, MethodHandle createTargetHook) throws Throwable {
        this(targetType);
        ConstantCallSite selfCCS = (ConstantCallSite)this;
        MethodHandle boundTarget = (MethodHandle)createTargetHook.invokeWithArguments(selfCCS);
        this.checkTargetChange(this.target, boundTarget);
        this.target = boundTarget;
        this.initializeGetTarget();
    }

    public MethodType type() {
        return this.target.type();
    }

    public abstract MethodHandle getTarget();

    public abstract void setTarget(MethodHandle var1);

    void checkTargetChange(MethodHandle oldTarget, MethodHandle newTarget) {
        MethodType oldType = oldTarget.type();
        MethodType newType = newTarget.type();
        if (!newType.equals((Object)oldType)) {
            throw CallSite.wrongTargetType(newTarget, oldType);
        }
    }

    private static WrongMethodTypeException wrongTargetType(MethodHandle target, MethodType type) {
        return new WrongMethodTypeException(String.valueOf(target) + " should be of type " + type);
    }

    public abstract MethodHandle dynamicInvoker();

    MethodHandle makeDynamicInvoker() {
        MethodHandle getTarget = GET_TARGET.bindTo(this);
        MethodHandle invoker = MethodHandles.exactInvoker(this.type());
        return MethodHandles.foldArguments(invoker, getTarget);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeGetTarget() {
        Class<CallSite> clazz = CallSite.class;
        synchronized (CallSite.class) {
            if (GET_TARGET == null) {
                try {
                    GET_TARGET = MethodHandles.Lookup.IMPL_LOOKUP.findVirtual(CallSite.class, "getTarget", MethodType.methodType(MethodHandle.class));
                }
                catch (ReflectiveOperationException e) {
                    throw new InternalError(e);
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    void setTargetNormal(MethodHandle newTarget) {
        this.target = newTarget;
    }

    MethodHandle getTargetVolatile() {
        return (MethodHandle)MethodHandleStatics.UNSAFE.getObjectVolatile(this, TARGET_OFFSET);
    }

    void setTargetVolatile(MethodHandle newTarget) {
        MethodHandleStatics.UNSAFE.putObjectVolatile(this, TARGET_OFFSET, newTarget);
    }

    static {
        try {
            TARGET_OFFSET = MethodHandleStatics.UNSAFE.objectFieldOffset(CallSite.class.getDeclaredField("target"));
        }
        catch (Exception ex) {
            throw new Error(ex);
        }
    }
}

