/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import dalvik.annotation.optimization.FastNative;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import libcore.io.ClassPathURLStreamHandler;

class VMClassLoader {
    private static final ClassPathURLStreamHandler[] bootClassPathUrlHandlers = VMClassLoader.createBootClassPathUrlHandlers();

    VMClassLoader() {
    }

    private static ClassPathURLStreamHandler[] createBootClassPathUrlHandlers() {
        String[] bootClassPathEntries = VMClassLoader.getBootClassPathEntries();
        ArrayList<ClassPathURLStreamHandler> urlStreamHandlers = new ArrayList<ClassPathURLStreamHandler>(bootClassPathEntries.length);
        for (String bootClassPathEntry : bootClassPathEntries) {
            try {
                String entryUri = new File(bootClassPathEntry).toURI().toString();
                ClassPathURLStreamHandler urlStreamHandler = new ClassPathURLStreamHandler(bootClassPathEntry);
                urlStreamHandlers.add(urlStreamHandler);
            }
            catch (IOException e) {
                System.logE("Unable to open boot classpath entry: " + bootClassPathEntry, e);
            }
        }
        return urlStreamHandlers.toArray(new ClassPathURLStreamHandler[urlStreamHandlers.size()]);
    }

    static URL getResource(String name) {
        for (ClassPathURLStreamHandler urlHandler : bootClassPathUrlHandlers) {
            URL url = urlHandler.getEntryUrlOrNull(name);
            if (url == null) continue;
            return url;
        }
        return null;
    }

    static List<URL> getResources(String name) {
        ArrayList<URL> list = new ArrayList<URL>();
        for (ClassPathURLStreamHandler urlHandler : bootClassPathUrlHandlers) {
            URL url = urlHandler.getEntryUrlOrNull(name);
            if (url == null) continue;
            list.add(url);
        }
        return list;
    }

    @FastNative
    static native Class findLoadedClass(ClassLoader var0, String var1);

    private static native String[] getBootClassPathEntries();
}

